/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouterOutputProtocol {
    RTP("RTP"),
    RIST("RIST"),
    SRT_CALLER("SRT_CALLER"),
    SRT_LISTENER("SRT_LISTENER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouterOutputProtocol> VALUE_MAP;
    private final String value;

    private RouterOutputProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouterOutputProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouterOutputProtocol> knownValues() {
        EnumSet<RouterOutputProtocol> knownValues = EnumSet.allOf(RouterOutputProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouterOutputProtocol.class, RouterOutputProtocol::toString);
    }
}

