/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconnect.model.RistRouterOutputConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.RtpRouterOutputConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.SrtCallerRouterOutputConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.SrtListenerRouterOutputConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouterOutputProtocolConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouterOutputProtocolConfiguration> {
    private static final SdkField<RtpRouterOutputConfiguration> RTP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Rtp").getter(RouterOutputProtocolConfiguration.getter(RouterOutputProtocolConfiguration::rtp)).setter(RouterOutputProtocolConfiguration.setter(Builder::rtp)).constructor(RtpRouterOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rtp").build()}).build();
    private static final SdkField<RistRouterOutputConfiguration> RIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Rist").getter(RouterOutputProtocolConfiguration.getter(RouterOutputProtocolConfiguration::rist)).setter(RouterOutputProtocolConfiguration.setter(Builder::rist)).constructor(RistRouterOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rist").build()}).build();
    private static final SdkField<SrtListenerRouterOutputConfiguration> SRT_LISTENER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SrtListener").getter(RouterOutputProtocolConfiguration.getter(RouterOutputProtocolConfiguration::srtListener)).setter(RouterOutputProtocolConfiguration.setter(Builder::srtListener)).constructor(SrtListenerRouterOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srtListener").build()}).build();
    private static final SdkField<SrtCallerRouterOutputConfiguration> SRT_CALLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SrtCaller").getter(RouterOutputProtocolConfiguration.getter(RouterOutputProtocolConfiguration::srtCaller)).setter(RouterOutputProtocolConfiguration.setter(Builder::srtCaller)).constructor(SrtCallerRouterOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srtCaller").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RTP_FIELD, RIST_FIELD, SRT_LISTENER_FIELD, SRT_CALLER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouterOutputProtocolConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RtpRouterOutputConfiguration rtp;
    private final RistRouterOutputConfiguration rist;
    private final SrtListenerRouterOutputConfiguration srtListener;
    private final SrtCallerRouterOutputConfiguration srtCaller;
    private final Type type;

    private RouterOutputProtocolConfiguration(BuilderImpl builder) {
        this.rtp = builder.rtp;
        this.rist = builder.rist;
        this.srtListener = builder.srtListener;
        this.srtCaller = builder.srtCaller;
        this.type = builder.type;
    }

    public final RtpRouterOutputConfiguration rtp() {
        return this.rtp;
    }

    public final RistRouterOutputConfiguration rist() {
        return this.rist;
    }

    public final SrtListenerRouterOutputConfiguration srtListener() {
        return this.srtListener;
    }

    public final SrtCallerRouterOutputConfiguration srtCaller() {
        return this.srtCaller;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rtp());
        hashCode = 31 * hashCode + Objects.hashCode(this.rist());
        hashCode = 31 * hashCode + Objects.hashCode(this.srtListener());
        hashCode = 31 * hashCode + Objects.hashCode(this.srtCaller());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterOutputProtocolConfiguration)) {
            return false;
        }
        RouterOutputProtocolConfiguration other = (RouterOutputProtocolConfiguration)obj;
        return Objects.equals(this.rtp(), other.rtp()) && Objects.equals(this.rist(), other.rist()) && Objects.equals(this.srtListener(), other.srtListener()) && Objects.equals(this.srtCaller(), other.srtCaller());
    }

    public final String toString() {
        return ToString.builder((String)"RouterOutputProtocolConfiguration").add("Rtp", (Object)this.rtp()).add("Rist", (Object)this.rist()).add("SrtListener", (Object)this.srtListener()).add("SrtCaller", (Object)this.srtCaller()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rtp": {
                return Optional.ofNullable(clazz.cast(this.rtp()));
            }
            case "Rist": {
                return Optional.ofNullable(clazz.cast(this.rist()));
            }
            case "SrtListener": {
                return Optional.ofNullable(clazz.cast(this.srtListener()));
            }
            case "SrtCaller": {
                return Optional.ofNullable(clazz.cast(this.srtCaller()));
            }
        }
        return Optional.empty();
    }

    public static RouterOutputProtocolConfiguration fromRtp(RtpRouterOutputConfiguration rtp) {
        return (RouterOutputProtocolConfiguration)RouterOutputProtocolConfiguration.builder().rtp(rtp).build();
    }

    public static RouterOutputProtocolConfiguration fromRtp(Consumer<RtpRouterOutputConfiguration.Builder> rtp) {
        RtpRouterOutputConfiguration.Builder builder = RtpRouterOutputConfiguration.builder();
        rtp.accept(builder);
        return RouterOutputProtocolConfiguration.fromRtp((RtpRouterOutputConfiguration)builder.build());
    }

    public static RouterOutputProtocolConfiguration fromRist(RistRouterOutputConfiguration rist) {
        return (RouterOutputProtocolConfiguration)RouterOutputProtocolConfiguration.builder().rist(rist).build();
    }

    public static RouterOutputProtocolConfiguration fromRist(Consumer<RistRouterOutputConfiguration.Builder> rist) {
        RistRouterOutputConfiguration.Builder builder = RistRouterOutputConfiguration.builder();
        rist.accept(builder);
        return RouterOutputProtocolConfiguration.fromRist((RistRouterOutputConfiguration)builder.build());
    }

    public static RouterOutputProtocolConfiguration fromSrtListener(SrtListenerRouterOutputConfiguration srtListener) {
        return (RouterOutputProtocolConfiguration)RouterOutputProtocolConfiguration.builder().srtListener(srtListener).build();
    }

    public static RouterOutputProtocolConfiguration fromSrtListener(Consumer<SrtListenerRouterOutputConfiguration.Builder> srtListener) {
        SrtListenerRouterOutputConfiguration.Builder builder = SrtListenerRouterOutputConfiguration.builder();
        srtListener.accept(builder);
        return RouterOutputProtocolConfiguration.fromSrtListener((SrtListenerRouterOutputConfiguration)builder.build());
    }

    public static RouterOutputProtocolConfiguration fromSrtCaller(SrtCallerRouterOutputConfiguration srtCaller) {
        return (RouterOutputProtocolConfiguration)RouterOutputProtocolConfiguration.builder().srtCaller(srtCaller).build();
    }

    public static RouterOutputProtocolConfiguration fromSrtCaller(Consumer<SrtCallerRouterOutputConfiguration.Builder> srtCaller) {
        SrtCallerRouterOutputConfiguration.Builder builder = SrtCallerRouterOutputConfiguration.builder();
        srtCaller.accept(builder);
        return RouterOutputProtocolConfiguration.fromSrtCaller((SrtCallerRouterOutputConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rtp", RTP_FIELD);
        map.put("rist", RIST_FIELD);
        map.put("srtListener", SRT_LISTENER_FIELD);
        map.put("srtCaller", SRT_CALLER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterOutputProtocolConfiguration, T> g) {
        return obj -> g.apply((RouterOutputProtocolConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        RTP,
        RIST,
        SRT_LISTENER,
        SRT_CALLER,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private RtpRouterOutputConfiguration rtp;
        private RistRouterOutputConfiguration rist;
        private SrtListenerRouterOutputConfiguration srtListener;
        private SrtCallerRouterOutputConfiguration srtCaller;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RouterOutputProtocolConfiguration model) {
            this.rtp(model.rtp);
            this.rist(model.rist);
            this.srtListener(model.srtListener);
            this.srtCaller(model.srtCaller);
        }

        public final RtpRouterOutputConfiguration.Builder getRtp() {
            return this.rtp != null ? this.rtp.toBuilder() : null;
        }

        public final void setRtp(RtpRouterOutputConfiguration.BuilderImpl rtp) {
            RtpRouterOutputConfiguration oldValue = this.rtp;
            this.rtp = rtp != null ? rtp.build() : null;
            this.handleUnionValueChange(Type.RTP, oldValue, this.rtp);
        }

        @Override
        public final Builder rtp(RtpRouterOutputConfiguration rtp) {
            RtpRouterOutputConfiguration oldValue = this.rtp;
            this.rtp = rtp;
            this.handleUnionValueChange(Type.RTP, oldValue, this.rtp);
            return this;
        }

        public final RistRouterOutputConfiguration.Builder getRist() {
            return this.rist != null ? this.rist.toBuilder() : null;
        }

        public final void setRist(RistRouterOutputConfiguration.BuilderImpl rist) {
            RistRouterOutputConfiguration oldValue = this.rist;
            this.rist = rist != null ? rist.build() : null;
            this.handleUnionValueChange(Type.RIST, oldValue, this.rist);
        }

        @Override
        public final Builder rist(RistRouterOutputConfiguration rist) {
            RistRouterOutputConfiguration oldValue = this.rist;
            this.rist = rist;
            this.handleUnionValueChange(Type.RIST, oldValue, this.rist);
            return this;
        }

        public final SrtListenerRouterOutputConfiguration.Builder getSrtListener() {
            return this.srtListener != null ? this.srtListener.toBuilder() : null;
        }

        public final void setSrtListener(SrtListenerRouterOutputConfiguration.BuilderImpl srtListener) {
            SrtListenerRouterOutputConfiguration oldValue = this.srtListener;
            this.srtListener = srtListener != null ? srtListener.build() : null;
            this.handleUnionValueChange(Type.SRT_LISTENER, oldValue, this.srtListener);
        }

        @Override
        public final Builder srtListener(SrtListenerRouterOutputConfiguration srtListener) {
            SrtListenerRouterOutputConfiguration oldValue = this.srtListener;
            this.srtListener = srtListener;
            this.handleUnionValueChange(Type.SRT_LISTENER, oldValue, this.srtListener);
            return this;
        }

        public final SrtCallerRouterOutputConfiguration.Builder getSrtCaller() {
            return this.srtCaller != null ? this.srtCaller.toBuilder() : null;
        }

        public final void setSrtCaller(SrtCallerRouterOutputConfiguration.BuilderImpl srtCaller) {
            SrtCallerRouterOutputConfiguration oldValue = this.srtCaller;
            this.srtCaller = srtCaller != null ? srtCaller.build() : null;
            this.handleUnionValueChange(Type.SRT_CALLER, oldValue, this.srtCaller);
        }

        @Override
        public final Builder srtCaller(SrtCallerRouterOutputConfiguration srtCaller) {
            SrtCallerRouterOutputConfiguration oldValue = this.srtCaller;
            this.srtCaller = srtCaller;
            this.handleUnionValueChange(Type.SRT_CALLER, oldValue, this.srtCaller);
            return this;
        }

        public RouterOutputProtocolConfiguration build() {
            return new RouterOutputProtocolConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouterOutputProtocolConfiguration> {
        public Builder rtp(RtpRouterOutputConfiguration var1);

        default public Builder rtp(Consumer<RtpRouterOutputConfiguration.Builder> rtp) {
            return this.rtp((RtpRouterOutputConfiguration)((RtpRouterOutputConfiguration.Builder)RtpRouterOutputConfiguration.builder().applyMutation(rtp)).build());
        }

        public Builder rist(RistRouterOutputConfiguration var1);

        default public Builder rist(Consumer<RistRouterOutputConfiguration.Builder> rist) {
            return this.rist((RistRouterOutputConfiguration)((RistRouterOutputConfiguration.Builder)RistRouterOutputConfiguration.builder().applyMutation(rist)).build());
        }

        public Builder srtListener(SrtListenerRouterOutputConfiguration var1);

        default public Builder srtListener(Consumer<SrtListenerRouterOutputConfiguration.Builder> srtListener) {
            return this.srtListener((SrtListenerRouterOutputConfiguration)((SrtListenerRouterOutputConfiguration.Builder)SrtListenerRouterOutputConfiguration.builder().applyMutation(srtListener)).build());
        }

        public Builder srtCaller(SrtCallerRouterOutputConfiguration var1);

        default public Builder srtCaller(Consumer<SrtCallerRouterOutputConfiguration.Builder> srtCaller) {
            return this.srtCaller((SrtCallerRouterOutputConfiguration)((SrtCallerRouterOutputConfiguration.Builder)SrtCallerRouterOutputConfiguration.builder().applyMutation(srtCaller)).build());
        }
    }
}

