/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.BurnInSubtitleStylePassthrough;
import software.amazon.awssdk.services.mediaconvert.model.BurninSubtitleAlignment;
import software.amazon.awssdk.services.mediaconvert.model.BurninSubtitleApplyFontColor;
import software.amazon.awssdk.services.mediaconvert.model.BurninSubtitleBackgroundColor;
import software.amazon.awssdk.services.mediaconvert.model.BurninSubtitleFallbackFont;
import software.amazon.awssdk.services.mediaconvert.model.BurninSubtitleFontColor;
import software.amazon.awssdk.services.mediaconvert.model.BurninSubtitleOutlineColor;
import software.amazon.awssdk.services.mediaconvert.model.BurninSubtitleShadowColor;
import software.amazon.awssdk.services.mediaconvert.model.BurninSubtitleTeletextSpacing;
import software.amazon.awssdk.services.mediaconvert.model.FontScript;
import software.amazon.awssdk.services.mediaconvert.model.RemoveRubyReserveAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BurninDestinationSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BurninDestinationSettings> {
    private static final SdkField<String> ALIGNMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alignment").getter(BurninDestinationSettings.getter(BurninDestinationSettings::alignmentAsString)).setter(BurninDestinationSettings.setter(Builder::alignment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alignment").build()}).build();
    private static final SdkField<String> APPLY_FONT_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplyFontColor").getter(BurninDestinationSettings.getter(BurninDestinationSettings::applyFontColorAsString)).setter(BurninDestinationSettings.setter(Builder::applyFontColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyFontColor").build()}).build();
    private static final SdkField<String> BACKGROUND_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackgroundColor").getter(BurninDestinationSettings.getter(BurninDestinationSettings::backgroundColorAsString)).setter(BurninDestinationSettings.setter(Builder::backgroundColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backgroundColor").build()}).build();
    private static final SdkField<Integer> BACKGROUND_OPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BackgroundOpacity").getter(BurninDestinationSettings.getter(BurninDestinationSettings::backgroundOpacity)).setter(BurninDestinationSettings.setter(Builder::backgroundOpacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backgroundOpacity").build()}).build();
    private static final SdkField<String> FALLBACK_FONT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FallbackFont").getter(BurninDestinationSettings.getter(BurninDestinationSettings::fallbackFontAsString)).setter(BurninDestinationSettings.setter(Builder::fallbackFont)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fallbackFont").build()}).build();
    private static final SdkField<String> FONT_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FontColor").getter(BurninDestinationSettings.getter(BurninDestinationSettings::fontColorAsString)).setter(BurninDestinationSettings.setter(Builder::fontColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontColor").build()}).build();
    private static final SdkField<String> FONT_FILE_BOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FontFileBold").getter(BurninDestinationSettings.getter(BurninDestinationSettings::fontFileBold)).setter(BurninDestinationSettings.setter(Builder::fontFileBold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontFileBold").build()}).build();
    private static final SdkField<String> FONT_FILE_BOLD_ITALIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FontFileBoldItalic").getter(BurninDestinationSettings.getter(BurninDestinationSettings::fontFileBoldItalic)).setter(BurninDestinationSettings.setter(Builder::fontFileBoldItalic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontFileBoldItalic").build()}).build();
    private static final SdkField<String> FONT_FILE_ITALIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FontFileItalic").getter(BurninDestinationSettings.getter(BurninDestinationSettings::fontFileItalic)).setter(BurninDestinationSettings.setter(Builder::fontFileItalic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontFileItalic").build()}).build();
    private static final SdkField<String> FONT_FILE_REGULAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FontFileRegular").getter(BurninDestinationSettings.getter(BurninDestinationSettings::fontFileRegular)).setter(BurninDestinationSettings.setter(Builder::fontFileRegular)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontFileRegular").build()}).build();
    private static final SdkField<Integer> FONT_OPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FontOpacity").getter(BurninDestinationSettings.getter(BurninDestinationSettings::fontOpacity)).setter(BurninDestinationSettings.setter(Builder::fontOpacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontOpacity").build()}).build();
    private static final SdkField<Integer> FONT_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FontResolution").getter(BurninDestinationSettings.getter(BurninDestinationSettings::fontResolution)).setter(BurninDestinationSettings.setter(Builder::fontResolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontResolution").build()}).build();
    private static final SdkField<String> FONT_SCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FontScript").getter(BurninDestinationSettings.getter(BurninDestinationSettings::fontScriptAsString)).setter(BurninDestinationSettings.setter(Builder::fontScript)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontScript").build()}).build();
    private static final SdkField<Integer> FONT_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FontSize").getter(BurninDestinationSettings.getter(BurninDestinationSettings::fontSize)).setter(BurninDestinationSettings.setter(Builder::fontSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontSize").build()}).build();
    private static final SdkField<String> HEX_FONT_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HexFontColor").getter(BurninDestinationSettings.getter(BurninDestinationSettings::hexFontColor)).setter(BurninDestinationSettings.setter(Builder::hexFontColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hexFontColor").build()}).build();
    private static final SdkField<String> OUTLINE_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutlineColor").getter(BurninDestinationSettings.getter(BurninDestinationSettings::outlineColorAsString)).setter(BurninDestinationSettings.setter(Builder::outlineColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outlineColor").build()}).build();
    private static final SdkField<Integer> OUTLINE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OutlineSize").getter(BurninDestinationSettings.getter(BurninDestinationSettings::outlineSize)).setter(BurninDestinationSettings.setter(Builder::outlineSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outlineSize").build()}).build();
    private static final SdkField<String> REMOVE_RUBY_RESERVE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemoveRubyReserveAttributes").getter(BurninDestinationSettings.getter(BurninDestinationSettings::removeRubyReserveAttributesAsString)).setter(BurninDestinationSettings.setter(Builder::removeRubyReserveAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeRubyReserveAttributes").build()}).build();
    private static final SdkField<String> SHADOW_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShadowColor").getter(BurninDestinationSettings.getter(BurninDestinationSettings::shadowColorAsString)).setter(BurninDestinationSettings.setter(Builder::shadowColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadowColor").build()}).build();
    private static final SdkField<Integer> SHADOW_OPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ShadowOpacity").getter(BurninDestinationSettings.getter(BurninDestinationSettings::shadowOpacity)).setter(BurninDestinationSettings.setter(Builder::shadowOpacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadowOpacity").build()}).build();
    private static final SdkField<Integer> SHADOW_X_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ShadowXOffset").getter(BurninDestinationSettings.getter(BurninDestinationSettings::shadowXOffset)).setter(BurninDestinationSettings.setter(Builder::shadowXOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadowXOffset").build()}).build();
    private static final SdkField<Integer> SHADOW_Y_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ShadowYOffset").getter(BurninDestinationSettings.getter(BurninDestinationSettings::shadowYOffset)).setter(BurninDestinationSettings.setter(Builder::shadowYOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadowYOffset").build()}).build();
    private static final SdkField<String> STYLE_PASSTHROUGH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StylePassthrough").getter(BurninDestinationSettings.getter(BurninDestinationSettings::stylePassthroughAsString)).setter(BurninDestinationSettings.setter(Builder::stylePassthrough)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stylePassthrough").build()}).build();
    private static final SdkField<String> TELETEXT_SPACING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TeletextSpacing").getter(BurninDestinationSettings.getter(BurninDestinationSettings::teletextSpacingAsString)).setter(BurninDestinationSettings.setter(Builder::teletextSpacing)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teletextSpacing").build()}).build();
    private static final SdkField<Integer> X_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("XPosition").getter(BurninDestinationSettings.getter(BurninDestinationSettings::xPosition)).setter(BurninDestinationSettings.setter(Builder::xPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xPosition").build()}).build();
    private static final SdkField<Integer> Y_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("YPosition").getter(BurninDestinationSettings.getter(BurninDestinationSettings::yPosition)).setter(BurninDestinationSettings.setter(Builder::yPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("yPosition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIGNMENT_FIELD, APPLY_FONT_COLOR_FIELD, BACKGROUND_COLOR_FIELD, BACKGROUND_OPACITY_FIELD, FALLBACK_FONT_FIELD, FONT_COLOR_FIELD, FONT_FILE_BOLD_FIELD, FONT_FILE_BOLD_ITALIC_FIELD, FONT_FILE_ITALIC_FIELD, FONT_FILE_REGULAR_FIELD, FONT_OPACITY_FIELD, FONT_RESOLUTION_FIELD, FONT_SCRIPT_FIELD, FONT_SIZE_FIELD, HEX_FONT_COLOR_FIELD, OUTLINE_COLOR_FIELD, OUTLINE_SIZE_FIELD, REMOVE_RUBY_RESERVE_ATTRIBUTES_FIELD, SHADOW_COLOR_FIELD, SHADOW_OPACITY_FIELD, SHADOW_X_OFFSET_FIELD, SHADOW_Y_OFFSET_FIELD, STYLE_PASSTHROUGH_FIELD, TELETEXT_SPACING_FIELD, X_POSITION_FIELD, Y_POSITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BurninDestinationSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String alignment;
    private final String applyFontColor;
    private final String backgroundColor;
    private final Integer backgroundOpacity;
    private final String fallbackFont;
    private final String fontColor;
    private final String fontFileBold;
    private final String fontFileBoldItalic;
    private final String fontFileItalic;
    private final String fontFileRegular;
    private final Integer fontOpacity;
    private final Integer fontResolution;
    private final String fontScript;
    private final Integer fontSize;
    private final String hexFontColor;
    private final String outlineColor;
    private final Integer outlineSize;
    private final String removeRubyReserveAttributes;
    private final String shadowColor;
    private final Integer shadowOpacity;
    private final Integer shadowXOffset;
    private final Integer shadowYOffset;
    private final String stylePassthrough;
    private final String teletextSpacing;
    private final Integer xPosition;
    private final Integer yPosition;

    private BurninDestinationSettings(BuilderImpl builder) {
        this.alignment = builder.alignment;
        this.applyFontColor = builder.applyFontColor;
        this.backgroundColor = builder.backgroundColor;
        this.backgroundOpacity = builder.backgroundOpacity;
        this.fallbackFont = builder.fallbackFont;
        this.fontColor = builder.fontColor;
        this.fontFileBold = builder.fontFileBold;
        this.fontFileBoldItalic = builder.fontFileBoldItalic;
        this.fontFileItalic = builder.fontFileItalic;
        this.fontFileRegular = builder.fontFileRegular;
        this.fontOpacity = builder.fontOpacity;
        this.fontResolution = builder.fontResolution;
        this.fontScript = builder.fontScript;
        this.fontSize = builder.fontSize;
        this.hexFontColor = builder.hexFontColor;
        this.outlineColor = builder.outlineColor;
        this.outlineSize = builder.outlineSize;
        this.removeRubyReserveAttributes = builder.removeRubyReserveAttributes;
        this.shadowColor = builder.shadowColor;
        this.shadowOpacity = builder.shadowOpacity;
        this.shadowXOffset = builder.shadowXOffset;
        this.shadowYOffset = builder.shadowYOffset;
        this.stylePassthrough = builder.stylePassthrough;
        this.teletextSpacing = builder.teletextSpacing;
        this.xPosition = builder.xPosition;
        this.yPosition = builder.yPosition;
    }

    public final BurninSubtitleAlignment alignment() {
        return BurninSubtitleAlignment.fromValue(this.alignment);
    }

    public final String alignmentAsString() {
        return this.alignment;
    }

    public final BurninSubtitleApplyFontColor applyFontColor() {
        return BurninSubtitleApplyFontColor.fromValue(this.applyFontColor);
    }

    public final String applyFontColorAsString() {
        return this.applyFontColor;
    }

    public final BurninSubtitleBackgroundColor backgroundColor() {
        return BurninSubtitleBackgroundColor.fromValue(this.backgroundColor);
    }

    public final String backgroundColorAsString() {
        return this.backgroundColor;
    }

    public final Integer backgroundOpacity() {
        return this.backgroundOpacity;
    }

    public final BurninSubtitleFallbackFont fallbackFont() {
        return BurninSubtitleFallbackFont.fromValue(this.fallbackFont);
    }

    public final String fallbackFontAsString() {
        return this.fallbackFont;
    }

    public final BurninSubtitleFontColor fontColor() {
        return BurninSubtitleFontColor.fromValue(this.fontColor);
    }

    public final String fontColorAsString() {
        return this.fontColor;
    }

    public final String fontFileBold() {
        return this.fontFileBold;
    }

    public final String fontFileBoldItalic() {
        return this.fontFileBoldItalic;
    }

    public final String fontFileItalic() {
        return this.fontFileItalic;
    }

    public final String fontFileRegular() {
        return this.fontFileRegular;
    }

    public final Integer fontOpacity() {
        return this.fontOpacity;
    }

    public final Integer fontResolution() {
        return this.fontResolution;
    }

    public final FontScript fontScript() {
        return FontScript.fromValue(this.fontScript);
    }

    public final String fontScriptAsString() {
        return this.fontScript;
    }

    public final Integer fontSize() {
        return this.fontSize;
    }

    public final String hexFontColor() {
        return this.hexFontColor;
    }

    public final BurninSubtitleOutlineColor outlineColor() {
        return BurninSubtitleOutlineColor.fromValue(this.outlineColor);
    }

    public final String outlineColorAsString() {
        return this.outlineColor;
    }

    public final Integer outlineSize() {
        return this.outlineSize;
    }

    public final RemoveRubyReserveAttributes removeRubyReserveAttributes() {
        return RemoveRubyReserveAttributes.fromValue(this.removeRubyReserveAttributes);
    }

    public final String removeRubyReserveAttributesAsString() {
        return this.removeRubyReserveAttributes;
    }

    public final BurninSubtitleShadowColor shadowColor() {
        return BurninSubtitleShadowColor.fromValue(this.shadowColor);
    }

    public final String shadowColorAsString() {
        return this.shadowColor;
    }

    public final Integer shadowOpacity() {
        return this.shadowOpacity;
    }

    public final Integer shadowXOffset() {
        return this.shadowXOffset;
    }

    public final Integer shadowYOffset() {
        return this.shadowYOffset;
    }

    public final BurnInSubtitleStylePassthrough stylePassthrough() {
        return BurnInSubtitleStylePassthrough.fromValue(this.stylePassthrough);
    }

    public final String stylePassthroughAsString() {
        return this.stylePassthrough;
    }

    public final BurninSubtitleTeletextSpacing teletextSpacing() {
        return BurninSubtitleTeletextSpacing.fromValue(this.teletextSpacing);
    }

    public final String teletextSpacingAsString() {
        return this.teletextSpacing;
    }

    public final Integer xPosition() {
        return this.xPosition;
    }

    public final Integer yPosition() {
        return this.yPosition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alignmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyFontColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backgroundColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backgroundOpacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.fallbackFontAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontFileBold());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontFileBoldItalic());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontFileItalic());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontFileRegular());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontOpacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontResolution());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontScriptAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.hexFontColor());
        hashCode = 31 * hashCode + Objects.hashCode(this.outlineColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outlineSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeRubyReserveAttributesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowOpacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowXOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowYOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.stylePassthroughAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.teletextSpacingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.xPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.yPosition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BurninDestinationSettings)) {
            return false;
        }
        BurninDestinationSettings other = (BurninDestinationSettings)obj;
        return Objects.equals(this.alignmentAsString(), other.alignmentAsString()) && Objects.equals(this.applyFontColorAsString(), other.applyFontColorAsString()) && Objects.equals(this.backgroundColorAsString(), other.backgroundColorAsString()) && Objects.equals(this.backgroundOpacity(), other.backgroundOpacity()) && Objects.equals(this.fallbackFontAsString(), other.fallbackFontAsString()) && Objects.equals(this.fontColorAsString(), other.fontColorAsString()) && Objects.equals(this.fontFileBold(), other.fontFileBold()) && Objects.equals(this.fontFileBoldItalic(), other.fontFileBoldItalic()) && Objects.equals(this.fontFileItalic(), other.fontFileItalic()) && Objects.equals(this.fontFileRegular(), other.fontFileRegular()) && Objects.equals(this.fontOpacity(), other.fontOpacity()) && Objects.equals(this.fontResolution(), other.fontResolution()) && Objects.equals(this.fontScriptAsString(), other.fontScriptAsString()) && Objects.equals(this.fontSize(), other.fontSize()) && Objects.equals(this.hexFontColor(), other.hexFontColor()) && Objects.equals(this.outlineColorAsString(), other.outlineColorAsString()) && Objects.equals(this.outlineSize(), other.outlineSize()) && Objects.equals(this.removeRubyReserveAttributesAsString(), other.removeRubyReserveAttributesAsString()) && Objects.equals(this.shadowColorAsString(), other.shadowColorAsString()) && Objects.equals(this.shadowOpacity(), other.shadowOpacity()) && Objects.equals(this.shadowXOffset(), other.shadowXOffset()) && Objects.equals(this.shadowYOffset(), other.shadowYOffset()) && Objects.equals(this.stylePassthroughAsString(), other.stylePassthroughAsString()) && Objects.equals(this.teletextSpacingAsString(), other.teletextSpacingAsString()) && Objects.equals(this.xPosition(), other.xPosition()) && Objects.equals(this.yPosition(), other.yPosition());
    }

    public final String toString() {
        return ToString.builder((String)"BurninDestinationSettings").add("Alignment", (Object)this.alignmentAsString()).add("ApplyFontColor", (Object)this.applyFontColorAsString()).add("BackgroundColor", (Object)this.backgroundColorAsString()).add("BackgroundOpacity", (Object)this.backgroundOpacity()).add("FallbackFont", (Object)this.fallbackFontAsString()).add("FontColor", (Object)this.fontColorAsString()).add("FontFileBold", (Object)this.fontFileBold()).add("FontFileBoldItalic", (Object)this.fontFileBoldItalic()).add("FontFileItalic", (Object)this.fontFileItalic()).add("FontFileRegular", (Object)this.fontFileRegular()).add("FontOpacity", (Object)this.fontOpacity()).add("FontResolution", (Object)this.fontResolution()).add("FontScript", (Object)this.fontScriptAsString()).add("FontSize", (Object)this.fontSize()).add("HexFontColor", (Object)this.hexFontColor()).add("OutlineColor", (Object)this.outlineColorAsString()).add("OutlineSize", (Object)this.outlineSize()).add("RemoveRubyReserveAttributes", (Object)this.removeRubyReserveAttributesAsString()).add("ShadowColor", (Object)this.shadowColorAsString()).add("ShadowOpacity", (Object)this.shadowOpacity()).add("ShadowXOffset", (Object)this.shadowXOffset()).add("ShadowYOffset", (Object)this.shadowYOffset()).add("StylePassthrough", (Object)this.stylePassthroughAsString()).add("TeletextSpacing", (Object)this.teletextSpacingAsString()).add("XPosition", (Object)this.xPosition()).add("YPosition", (Object)this.yPosition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alignment": {
                return Optional.ofNullable(clazz.cast(this.alignmentAsString()));
            }
            case "ApplyFontColor": {
                return Optional.ofNullable(clazz.cast(this.applyFontColorAsString()));
            }
            case "BackgroundColor": {
                return Optional.ofNullable(clazz.cast(this.backgroundColorAsString()));
            }
            case "BackgroundOpacity": {
                return Optional.ofNullable(clazz.cast(this.backgroundOpacity()));
            }
            case "FallbackFont": {
                return Optional.ofNullable(clazz.cast(this.fallbackFontAsString()));
            }
            case "FontColor": {
                return Optional.ofNullable(clazz.cast(this.fontColorAsString()));
            }
            case "FontFileBold": {
                return Optional.ofNullable(clazz.cast(this.fontFileBold()));
            }
            case "FontFileBoldItalic": {
                return Optional.ofNullable(clazz.cast(this.fontFileBoldItalic()));
            }
            case "FontFileItalic": {
                return Optional.ofNullable(clazz.cast(this.fontFileItalic()));
            }
            case "FontFileRegular": {
                return Optional.ofNullable(clazz.cast(this.fontFileRegular()));
            }
            case "FontOpacity": {
                return Optional.ofNullable(clazz.cast(this.fontOpacity()));
            }
            case "FontResolution": {
                return Optional.ofNullable(clazz.cast(this.fontResolution()));
            }
            case "FontScript": {
                return Optional.ofNullable(clazz.cast(this.fontScriptAsString()));
            }
            case "FontSize": {
                return Optional.ofNullable(clazz.cast(this.fontSize()));
            }
            case "HexFontColor": {
                return Optional.ofNullable(clazz.cast(this.hexFontColor()));
            }
            case "OutlineColor": {
                return Optional.ofNullable(clazz.cast(this.outlineColorAsString()));
            }
            case "OutlineSize": {
                return Optional.ofNullable(clazz.cast(this.outlineSize()));
            }
            case "RemoveRubyReserveAttributes": {
                return Optional.ofNullable(clazz.cast(this.removeRubyReserveAttributesAsString()));
            }
            case "ShadowColor": {
                return Optional.ofNullable(clazz.cast(this.shadowColorAsString()));
            }
            case "ShadowOpacity": {
                return Optional.ofNullable(clazz.cast(this.shadowOpacity()));
            }
            case "ShadowXOffset": {
                return Optional.ofNullable(clazz.cast(this.shadowXOffset()));
            }
            case "ShadowYOffset": {
                return Optional.ofNullable(clazz.cast(this.shadowYOffset()));
            }
            case "StylePassthrough": {
                return Optional.ofNullable(clazz.cast(this.stylePassthroughAsString()));
            }
            case "TeletextSpacing": {
                return Optional.ofNullable(clazz.cast(this.teletextSpacingAsString()));
            }
            case "XPosition": {
                return Optional.ofNullable(clazz.cast(this.xPosition()));
            }
            case "YPosition": {
                return Optional.ofNullable(clazz.cast(this.yPosition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("alignment", ALIGNMENT_FIELD);
        map.put("applyFontColor", APPLY_FONT_COLOR_FIELD);
        map.put("backgroundColor", BACKGROUND_COLOR_FIELD);
        map.put("backgroundOpacity", BACKGROUND_OPACITY_FIELD);
        map.put("fallbackFont", FALLBACK_FONT_FIELD);
        map.put("fontColor", FONT_COLOR_FIELD);
        map.put("fontFileBold", FONT_FILE_BOLD_FIELD);
        map.put("fontFileBoldItalic", FONT_FILE_BOLD_ITALIC_FIELD);
        map.put("fontFileItalic", FONT_FILE_ITALIC_FIELD);
        map.put("fontFileRegular", FONT_FILE_REGULAR_FIELD);
        map.put("fontOpacity", FONT_OPACITY_FIELD);
        map.put("fontResolution", FONT_RESOLUTION_FIELD);
        map.put("fontScript", FONT_SCRIPT_FIELD);
        map.put("fontSize", FONT_SIZE_FIELD);
        map.put("hexFontColor", HEX_FONT_COLOR_FIELD);
        map.put("outlineColor", OUTLINE_COLOR_FIELD);
        map.put("outlineSize", OUTLINE_SIZE_FIELD);
        map.put("removeRubyReserveAttributes", REMOVE_RUBY_RESERVE_ATTRIBUTES_FIELD);
        map.put("shadowColor", SHADOW_COLOR_FIELD);
        map.put("shadowOpacity", SHADOW_OPACITY_FIELD);
        map.put("shadowXOffset", SHADOW_X_OFFSET_FIELD);
        map.put("shadowYOffset", SHADOW_Y_OFFSET_FIELD);
        map.put("stylePassthrough", STYLE_PASSTHROUGH_FIELD);
        map.put("teletextSpacing", TELETEXT_SPACING_FIELD);
        map.put("xPosition", X_POSITION_FIELD);
        map.put("yPosition", Y_POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BurninDestinationSettings, T> g) {
        return obj -> g.apply((BurninDestinationSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alignment;
        private String applyFontColor;
        private String backgroundColor;
        private Integer backgroundOpacity;
        private String fallbackFont;
        private String fontColor;
        private String fontFileBold;
        private String fontFileBoldItalic;
        private String fontFileItalic;
        private String fontFileRegular;
        private Integer fontOpacity;
        private Integer fontResolution;
        private String fontScript;
        private Integer fontSize;
        private String hexFontColor;
        private String outlineColor;
        private Integer outlineSize;
        private String removeRubyReserveAttributes;
        private String shadowColor;
        private Integer shadowOpacity;
        private Integer shadowXOffset;
        private Integer shadowYOffset;
        private String stylePassthrough;
        private String teletextSpacing;
        private Integer xPosition;
        private Integer yPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(BurninDestinationSettings model) {
            this.alignment(model.alignment);
            this.applyFontColor(model.applyFontColor);
            this.backgroundColor(model.backgroundColor);
            this.backgroundOpacity(model.backgroundOpacity);
            this.fallbackFont(model.fallbackFont);
            this.fontColor(model.fontColor);
            this.fontFileBold(model.fontFileBold);
            this.fontFileBoldItalic(model.fontFileBoldItalic);
            this.fontFileItalic(model.fontFileItalic);
            this.fontFileRegular(model.fontFileRegular);
            this.fontOpacity(model.fontOpacity);
            this.fontResolution(model.fontResolution);
            this.fontScript(model.fontScript);
            this.fontSize(model.fontSize);
            this.hexFontColor(model.hexFontColor);
            this.outlineColor(model.outlineColor);
            this.outlineSize(model.outlineSize);
            this.removeRubyReserveAttributes(model.removeRubyReserveAttributes);
            this.shadowColor(model.shadowColor);
            this.shadowOpacity(model.shadowOpacity);
            this.shadowXOffset(model.shadowXOffset);
            this.shadowYOffset(model.shadowYOffset);
            this.stylePassthrough(model.stylePassthrough);
            this.teletextSpacing(model.teletextSpacing);
            this.xPosition(model.xPosition);
            this.yPosition(model.yPosition);
        }

        public final String getAlignment() {
            return this.alignment;
        }

        public final void setAlignment(String alignment) {
            this.alignment = alignment;
        }

        @Override
        public final Builder alignment(String alignment) {
            this.alignment = alignment;
            return this;
        }

        @Override
        public final Builder alignment(BurninSubtitleAlignment alignment) {
            this.alignment(alignment == null ? null : alignment.toString());
            return this;
        }

        public final String getApplyFontColor() {
            return this.applyFontColor;
        }

        public final void setApplyFontColor(String applyFontColor) {
            this.applyFontColor = applyFontColor;
        }

        @Override
        public final Builder applyFontColor(String applyFontColor) {
            this.applyFontColor = applyFontColor;
            return this;
        }

        @Override
        public final Builder applyFontColor(BurninSubtitleApplyFontColor applyFontColor) {
            this.applyFontColor(applyFontColor == null ? null : applyFontColor.toString());
            return this;
        }

        public final String getBackgroundColor() {
            return this.backgroundColor;
        }

        public final void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        @Override
        public final Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        @Override
        public final Builder backgroundColor(BurninSubtitleBackgroundColor backgroundColor) {
            this.backgroundColor(backgroundColor == null ? null : backgroundColor.toString());
            return this;
        }

        public final Integer getBackgroundOpacity() {
            return this.backgroundOpacity;
        }

        public final void setBackgroundOpacity(Integer backgroundOpacity) {
            this.backgroundOpacity = backgroundOpacity;
        }

        @Override
        public final Builder backgroundOpacity(Integer backgroundOpacity) {
            this.backgroundOpacity = backgroundOpacity;
            return this;
        }

        public final String getFallbackFont() {
            return this.fallbackFont;
        }

        public final void setFallbackFont(String fallbackFont) {
            this.fallbackFont = fallbackFont;
        }

        @Override
        public final Builder fallbackFont(String fallbackFont) {
            this.fallbackFont = fallbackFont;
            return this;
        }

        @Override
        public final Builder fallbackFont(BurninSubtitleFallbackFont fallbackFont) {
            this.fallbackFont(fallbackFont == null ? null : fallbackFont.toString());
            return this;
        }

        public final String getFontColor() {
            return this.fontColor;
        }

        public final void setFontColor(String fontColor) {
            this.fontColor = fontColor;
        }

        @Override
        public final Builder fontColor(String fontColor) {
            this.fontColor = fontColor;
            return this;
        }

        @Override
        public final Builder fontColor(BurninSubtitleFontColor fontColor) {
            this.fontColor(fontColor == null ? null : fontColor.toString());
            return this;
        }

        public final String getFontFileBold() {
            return this.fontFileBold;
        }

        public final void setFontFileBold(String fontFileBold) {
            this.fontFileBold = fontFileBold;
        }

        @Override
        public final Builder fontFileBold(String fontFileBold) {
            this.fontFileBold = fontFileBold;
            return this;
        }

        public final String getFontFileBoldItalic() {
            return this.fontFileBoldItalic;
        }

        public final void setFontFileBoldItalic(String fontFileBoldItalic) {
            this.fontFileBoldItalic = fontFileBoldItalic;
        }

        @Override
        public final Builder fontFileBoldItalic(String fontFileBoldItalic) {
            this.fontFileBoldItalic = fontFileBoldItalic;
            return this;
        }

        public final String getFontFileItalic() {
            return this.fontFileItalic;
        }

        public final void setFontFileItalic(String fontFileItalic) {
            this.fontFileItalic = fontFileItalic;
        }

        @Override
        public final Builder fontFileItalic(String fontFileItalic) {
            this.fontFileItalic = fontFileItalic;
            return this;
        }

        public final String getFontFileRegular() {
            return this.fontFileRegular;
        }

        public final void setFontFileRegular(String fontFileRegular) {
            this.fontFileRegular = fontFileRegular;
        }

        @Override
        public final Builder fontFileRegular(String fontFileRegular) {
            this.fontFileRegular = fontFileRegular;
            return this;
        }

        public final Integer getFontOpacity() {
            return this.fontOpacity;
        }

        public final void setFontOpacity(Integer fontOpacity) {
            this.fontOpacity = fontOpacity;
        }

        @Override
        public final Builder fontOpacity(Integer fontOpacity) {
            this.fontOpacity = fontOpacity;
            return this;
        }

        public final Integer getFontResolution() {
            return this.fontResolution;
        }

        public final void setFontResolution(Integer fontResolution) {
            this.fontResolution = fontResolution;
        }

        @Override
        public final Builder fontResolution(Integer fontResolution) {
            this.fontResolution = fontResolution;
            return this;
        }

        public final String getFontScript() {
            return this.fontScript;
        }

        public final void setFontScript(String fontScript) {
            this.fontScript = fontScript;
        }

        @Override
        public final Builder fontScript(String fontScript) {
            this.fontScript = fontScript;
            return this;
        }

        @Override
        public final Builder fontScript(FontScript fontScript) {
            this.fontScript(fontScript == null ? null : fontScript.toString());
            return this;
        }

        public final Integer getFontSize() {
            return this.fontSize;
        }

        public final void setFontSize(Integer fontSize) {
            this.fontSize = fontSize;
        }

        @Override
        public final Builder fontSize(Integer fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public final String getHexFontColor() {
            return this.hexFontColor;
        }

        public final void setHexFontColor(String hexFontColor) {
            this.hexFontColor = hexFontColor;
        }

        @Override
        public final Builder hexFontColor(String hexFontColor) {
            this.hexFontColor = hexFontColor;
            return this;
        }

        public final String getOutlineColor() {
            return this.outlineColor;
        }

        public final void setOutlineColor(String outlineColor) {
            this.outlineColor = outlineColor;
        }

        @Override
        public final Builder outlineColor(String outlineColor) {
            this.outlineColor = outlineColor;
            return this;
        }

        @Override
        public final Builder outlineColor(BurninSubtitleOutlineColor outlineColor) {
            this.outlineColor(outlineColor == null ? null : outlineColor.toString());
            return this;
        }

        public final Integer getOutlineSize() {
            return this.outlineSize;
        }

        public final void setOutlineSize(Integer outlineSize) {
            this.outlineSize = outlineSize;
        }

        @Override
        public final Builder outlineSize(Integer outlineSize) {
            this.outlineSize = outlineSize;
            return this;
        }

        public final String getRemoveRubyReserveAttributes() {
            return this.removeRubyReserveAttributes;
        }

        public final void setRemoveRubyReserveAttributes(String removeRubyReserveAttributes) {
            this.removeRubyReserveAttributes = removeRubyReserveAttributes;
        }

        @Override
        public final Builder removeRubyReserveAttributes(String removeRubyReserveAttributes) {
            this.removeRubyReserveAttributes = removeRubyReserveAttributes;
            return this;
        }

        @Override
        public final Builder removeRubyReserveAttributes(RemoveRubyReserveAttributes removeRubyReserveAttributes) {
            this.removeRubyReserveAttributes(removeRubyReserveAttributes == null ? null : removeRubyReserveAttributes.toString());
            return this;
        }

        public final String getShadowColor() {
            return this.shadowColor;
        }

        public final void setShadowColor(String shadowColor) {
            this.shadowColor = shadowColor;
        }

        @Override
        public final Builder shadowColor(String shadowColor) {
            this.shadowColor = shadowColor;
            return this;
        }

        @Override
        public final Builder shadowColor(BurninSubtitleShadowColor shadowColor) {
            this.shadowColor(shadowColor == null ? null : shadowColor.toString());
            return this;
        }

        public final Integer getShadowOpacity() {
            return this.shadowOpacity;
        }

        public final void setShadowOpacity(Integer shadowOpacity) {
            this.shadowOpacity = shadowOpacity;
        }

        @Override
        public final Builder shadowOpacity(Integer shadowOpacity) {
            this.shadowOpacity = shadowOpacity;
            return this;
        }

        public final Integer getShadowXOffset() {
            return this.shadowXOffset;
        }

        public final void setShadowXOffset(Integer shadowXOffset) {
            this.shadowXOffset = shadowXOffset;
        }

        @Override
        public final Builder shadowXOffset(Integer shadowXOffset) {
            this.shadowXOffset = shadowXOffset;
            return this;
        }

        public final Integer getShadowYOffset() {
            return this.shadowYOffset;
        }

        public final void setShadowYOffset(Integer shadowYOffset) {
            this.shadowYOffset = shadowYOffset;
        }

        @Override
        public final Builder shadowYOffset(Integer shadowYOffset) {
            this.shadowYOffset = shadowYOffset;
            return this;
        }

        public final String getStylePassthrough() {
            return this.stylePassthrough;
        }

        public final void setStylePassthrough(String stylePassthrough) {
            this.stylePassthrough = stylePassthrough;
        }

        @Override
        public final Builder stylePassthrough(String stylePassthrough) {
            this.stylePassthrough = stylePassthrough;
            return this;
        }

        @Override
        public final Builder stylePassthrough(BurnInSubtitleStylePassthrough stylePassthrough) {
            this.stylePassthrough(stylePassthrough == null ? null : stylePassthrough.toString());
            return this;
        }

        public final String getTeletextSpacing() {
            return this.teletextSpacing;
        }

        public final void setTeletextSpacing(String teletextSpacing) {
            this.teletextSpacing = teletextSpacing;
        }

        @Override
        public final Builder teletextSpacing(String teletextSpacing) {
            this.teletextSpacing = teletextSpacing;
            return this;
        }

        @Override
        public final Builder teletextSpacing(BurninSubtitleTeletextSpacing teletextSpacing) {
            this.teletextSpacing(teletextSpacing == null ? null : teletextSpacing.toString());
            return this;
        }

        public final Integer getXPosition() {
            return this.xPosition;
        }

        public final void setXPosition(Integer xPosition) {
            this.xPosition = xPosition;
        }

        @Override
        public final Builder xPosition(Integer xPosition) {
            this.xPosition = xPosition;
            return this;
        }

        public final Integer getYPosition() {
            return this.yPosition;
        }

        public final void setYPosition(Integer yPosition) {
            this.yPosition = yPosition;
        }

        @Override
        public final Builder yPosition(Integer yPosition) {
            this.yPosition = yPosition;
            return this;
        }

        public BurninDestinationSettings build() {
            return new BurninDestinationSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BurninDestinationSettings> {
        public Builder alignment(String var1);

        public Builder alignment(BurninSubtitleAlignment var1);

        public Builder applyFontColor(String var1);

        public Builder applyFontColor(BurninSubtitleApplyFontColor var1);

        public Builder backgroundColor(String var1);

        public Builder backgroundColor(BurninSubtitleBackgroundColor var1);

        public Builder backgroundOpacity(Integer var1);

        public Builder fallbackFont(String var1);

        public Builder fallbackFont(BurninSubtitleFallbackFont var1);

        public Builder fontColor(String var1);

        public Builder fontColor(BurninSubtitleFontColor var1);

        public Builder fontFileBold(String var1);

        public Builder fontFileBoldItalic(String var1);

        public Builder fontFileItalic(String var1);

        public Builder fontFileRegular(String var1);

        public Builder fontOpacity(Integer var1);

        public Builder fontResolution(Integer var1);

        public Builder fontScript(String var1);

        public Builder fontScript(FontScript var1);

        public Builder fontSize(Integer var1);

        public Builder hexFontColor(String var1);

        public Builder outlineColor(String var1);

        public Builder outlineColor(BurninSubtitleOutlineColor var1);

        public Builder outlineSize(Integer var1);

        public Builder removeRubyReserveAttributes(String var1);

        public Builder removeRubyReserveAttributes(RemoveRubyReserveAttributes var1);

        public Builder shadowColor(String var1);

        public Builder shadowColor(BurninSubtitleShadowColor var1);

        public Builder shadowOpacity(Integer var1);

        public Builder shadowXOffset(Integer var1);

        public Builder shadowYOffset(Integer var1);

        public Builder stylePassthrough(String var1);

        public Builder stylePassthrough(BurnInSubtitleStylePassthrough var1);

        public Builder teletextSpacing(String var1);

        public Builder teletextSpacing(BurninSubtitleTeletextSpacing var1);

        public Builder xPosition(Integer var1);

        public Builder yPosition(Integer var1);
    }
}

