/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.ColorPrimaries;
import software.amazon.awssdk.services.mediaconvert.model.FrameRate;
import software.amazon.awssdk.services.mediaconvert.model.MatrixCoefficients;
import software.amazon.awssdk.services.mediaconvert.model.TransferCharacteristics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VideoProperties> {
    private static final SdkField<Integer> BIT_DEPTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BitDepth").getter(VideoProperties.getter(VideoProperties::bitDepth)).setter(VideoProperties.setter(Builder::bitDepth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitDepth").build()}).build();
    private static final SdkField<Integer> BIT_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BitRate").getter(VideoProperties.getter(VideoProperties::bitRate)).setter(VideoProperties.setter(Builder::bitRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitRate").build()}).build();
    private static final SdkField<String> COLOR_PRIMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColorPrimaries").getter(VideoProperties.getter(VideoProperties::colorPrimariesAsString)).setter(VideoProperties.setter(Builder::colorPrimaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorPrimaries").build()}).build();
    private static final SdkField<FrameRate> FRAME_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FrameRate").getter(VideoProperties.getter(VideoProperties::frameRate)).setter(VideoProperties.setter(Builder::frameRate)).constructor(FrameRate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameRate").build()}).build();
    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Height").getter(VideoProperties.getter(VideoProperties::height)).setter(VideoProperties.setter(Builder::height)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()}).build();
    private static final SdkField<String> MATRIX_COEFFICIENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MatrixCoefficients").getter(VideoProperties.getter(VideoProperties::matrixCoefficientsAsString)).setter(VideoProperties.setter(Builder::matrixCoefficients)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matrixCoefficients").build()}).build();
    private static final SdkField<String> TRANSFER_CHARACTERISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransferCharacteristics").getter(VideoProperties.getter(VideoProperties::transferCharacteristicsAsString)).setter(VideoProperties.setter(Builder::transferCharacteristics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transferCharacteristics").build()}).build();
    private static final SdkField<Integer> WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Width").getter(VideoProperties.getter(VideoProperties::width)).setter(VideoProperties.setter(Builder::width)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIT_DEPTH_FIELD, BIT_RATE_FIELD, COLOR_PRIMARIES_FIELD, FRAME_RATE_FIELD, HEIGHT_FIELD, MATRIX_COEFFICIENTS_FIELD, TRANSFER_CHARACTERISTICS_FIELD, WIDTH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VideoProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer bitDepth;
    private final Integer bitRate;
    private final String colorPrimaries;
    private final FrameRate frameRate;
    private final Integer height;
    private final String matrixCoefficients;
    private final String transferCharacteristics;
    private final Integer width;

    private VideoProperties(BuilderImpl builder) {
        this.bitDepth = builder.bitDepth;
        this.bitRate = builder.bitRate;
        this.colorPrimaries = builder.colorPrimaries;
        this.frameRate = builder.frameRate;
        this.height = builder.height;
        this.matrixCoefficients = builder.matrixCoefficients;
        this.transferCharacteristics = builder.transferCharacteristics;
        this.width = builder.width;
    }

    public final Integer bitDepth() {
        return this.bitDepth;
    }

    public final Integer bitRate() {
        return this.bitRate;
    }

    public final ColorPrimaries colorPrimaries() {
        return ColorPrimaries.fromValue(this.colorPrimaries);
    }

    public final String colorPrimariesAsString() {
        return this.colorPrimaries;
    }

    public final FrameRate frameRate() {
        return this.frameRate;
    }

    public final Integer height() {
        return this.height;
    }

    public final MatrixCoefficients matrixCoefficients() {
        return MatrixCoefficients.fromValue(this.matrixCoefficients);
    }

    public final String matrixCoefficientsAsString() {
        return this.matrixCoefficients;
    }

    public final TransferCharacteristics transferCharacteristics() {
        return TransferCharacteristics.fromValue(this.transferCharacteristics);
    }

    public final String transferCharacteristicsAsString() {
        return this.transferCharacteristics;
    }

    public final Integer width() {
        return this.width;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitDepth());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorPrimariesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.height());
        hashCode = 31 * hashCode + Objects.hashCode(this.matrixCoefficientsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferCharacteristicsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.width());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoProperties)) {
            return false;
        }
        VideoProperties other = (VideoProperties)obj;
        return Objects.equals(this.bitDepth(), other.bitDepth()) && Objects.equals(this.bitRate(), other.bitRate()) && Objects.equals(this.colorPrimariesAsString(), other.colorPrimariesAsString()) && Objects.equals(this.frameRate(), other.frameRate()) && Objects.equals(this.height(), other.height()) && Objects.equals(this.matrixCoefficientsAsString(), other.matrixCoefficientsAsString()) && Objects.equals(this.transferCharacteristicsAsString(), other.transferCharacteristicsAsString()) && Objects.equals(this.width(), other.width());
    }

    public final String toString() {
        return ToString.builder((String)"VideoProperties").add("BitDepth", (Object)this.bitDepth()).add("BitRate", (Object)this.bitRate()).add("ColorPrimaries", (Object)this.colorPrimariesAsString()).add("FrameRate", (Object)this.frameRate()).add("Height", (Object)this.height()).add("MatrixCoefficients", (Object)this.matrixCoefficientsAsString()).add("TransferCharacteristics", (Object)this.transferCharacteristicsAsString()).add("Width", (Object)this.width()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BitDepth": {
                return Optional.ofNullable(clazz.cast(this.bitDepth()));
            }
            case "BitRate": {
                return Optional.ofNullable(clazz.cast(this.bitRate()));
            }
            case "ColorPrimaries": {
                return Optional.ofNullable(clazz.cast(this.colorPrimariesAsString()));
            }
            case "FrameRate": {
                return Optional.ofNullable(clazz.cast(this.frameRate()));
            }
            case "Height": {
                return Optional.ofNullable(clazz.cast(this.height()));
            }
            case "MatrixCoefficients": {
                return Optional.ofNullable(clazz.cast(this.matrixCoefficientsAsString()));
            }
            case "TransferCharacteristics": {
                return Optional.ofNullable(clazz.cast(this.transferCharacteristicsAsString()));
            }
            case "Width": {
                return Optional.ofNullable(clazz.cast(this.width()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bitDepth", BIT_DEPTH_FIELD);
        map.put("bitRate", BIT_RATE_FIELD);
        map.put("colorPrimaries", COLOR_PRIMARIES_FIELD);
        map.put("frameRate", FRAME_RATE_FIELD);
        map.put("height", HEIGHT_FIELD);
        map.put("matrixCoefficients", MATRIX_COEFFICIENTS_FIELD);
        map.put("transferCharacteristics", TRANSFER_CHARACTERISTICS_FIELD);
        map.put("width", WIDTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoProperties, T> g) {
        return obj -> g.apply((VideoProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer bitDepth;
        private Integer bitRate;
        private String colorPrimaries;
        private FrameRate frameRate;
        private Integer height;
        private String matrixCoefficients;
        private String transferCharacteristics;
        private Integer width;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoProperties model) {
            this.bitDepth(model.bitDepth);
            this.bitRate(model.bitRate);
            this.colorPrimaries(model.colorPrimaries);
            this.frameRate(model.frameRate);
            this.height(model.height);
            this.matrixCoefficients(model.matrixCoefficients);
            this.transferCharacteristics(model.transferCharacteristics);
            this.width(model.width);
        }

        public final Integer getBitDepth() {
            return this.bitDepth;
        }

        public final void setBitDepth(Integer bitDepth) {
            this.bitDepth = bitDepth;
        }

        @Override
        public final Builder bitDepth(Integer bitDepth) {
            this.bitDepth = bitDepth;
            return this;
        }

        public final Integer getBitRate() {
            return this.bitRate;
        }

        public final void setBitRate(Integer bitRate) {
            this.bitRate = bitRate;
        }

        @Override
        public final Builder bitRate(Integer bitRate) {
            this.bitRate = bitRate;
            return this;
        }

        public final String getColorPrimaries() {
            return this.colorPrimaries;
        }

        public final void setColorPrimaries(String colorPrimaries) {
            this.colorPrimaries = colorPrimaries;
        }

        @Override
        public final Builder colorPrimaries(String colorPrimaries) {
            this.colorPrimaries = colorPrimaries;
            return this;
        }

        @Override
        public final Builder colorPrimaries(ColorPrimaries colorPrimaries) {
            this.colorPrimaries(colorPrimaries == null ? null : colorPrimaries.toString());
            return this;
        }

        public final FrameRate.Builder getFrameRate() {
            return this.frameRate != null ? this.frameRate.toBuilder() : null;
        }

        public final void setFrameRate(FrameRate.BuilderImpl frameRate) {
            this.frameRate = frameRate != null ? frameRate.build() : null;
        }

        @Override
        public final Builder frameRate(FrameRate frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        public final Integer getHeight() {
            return this.height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final String getMatrixCoefficients() {
            return this.matrixCoefficients;
        }

        public final void setMatrixCoefficients(String matrixCoefficients) {
            this.matrixCoefficients = matrixCoefficients;
        }

        @Override
        public final Builder matrixCoefficients(String matrixCoefficients) {
            this.matrixCoefficients = matrixCoefficients;
            return this;
        }

        @Override
        public final Builder matrixCoefficients(MatrixCoefficients matrixCoefficients) {
            this.matrixCoefficients(matrixCoefficients == null ? null : matrixCoefficients.toString());
            return this;
        }

        public final String getTransferCharacteristics() {
            return this.transferCharacteristics;
        }

        public final void setTransferCharacteristics(String transferCharacteristics) {
            this.transferCharacteristics = transferCharacteristics;
        }

        @Override
        public final Builder transferCharacteristics(String transferCharacteristics) {
            this.transferCharacteristics = transferCharacteristics;
            return this;
        }

        @Override
        public final Builder transferCharacteristics(TransferCharacteristics transferCharacteristics) {
            this.transferCharacteristics(transferCharacteristics == null ? null : transferCharacteristics.toString());
            return this;
        }

        public final Integer getWidth() {
            return this.width;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public VideoProperties build() {
            return new VideoProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VideoProperties> {
        public Builder bitDepth(Integer var1);

        public Builder bitRate(Integer var1);

        public Builder colorPrimaries(String var1);

        public Builder colorPrimaries(ColorPrimaries var1);

        public Builder frameRate(FrameRate var1);

        default public Builder frameRate(Consumer<FrameRate.Builder> frameRate) {
            return this.frameRate((FrameRate)((FrameRate.Builder)FrameRate.builder().applyMutation(frameRate)).build());
        }

        public Builder height(Integer var1);

        public Builder matrixCoefficients(String var1);

        public Builder matrixCoefficients(MatrixCoefficients var1);

        public Builder transferCharacteristics(String var1);

        public Builder transferCharacteristics(TransferCharacteristics var1);

        public Builder width(Integer var1);
    }
}

