/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.Format;
import software.amazon.awssdk.services.mediaconvert.model.Track;
import software.amazon.awssdk.services.mediaconvert.model.___listOfTrackCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Container
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Container> {
    private static final SdkField<Double> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Duration").getter(Container.getter(Container::duration)).setter(Container.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(Container.getter(Container::formatAsString)).setter(Container.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<List<Track>> TRACKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tracks").getter(Container.getter(Container::tracks)).setter(Container.setter(Builder::tracks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Track::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_FIELD, FORMAT_FIELD, TRACKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Container.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double duration;
    private final String format;
    private final List<Track> tracks;

    private Container(BuilderImpl builder) {
        this.duration = builder.duration;
        this.format = builder.format;
        this.tracks = builder.tracks;
    }

    public final Double duration() {
        return this.duration;
    }

    public final Format format() {
        return Format.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final boolean hasTracks() {
        return this.tracks != null && !(this.tracks instanceof SdkAutoConstructList);
    }

    public final List<Track> tracks() {
        return this.tracks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTracks() ? this.tracks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Container)) {
            return false;
        }
        Container other = (Container)obj;
        return Objects.equals(this.duration(), other.duration()) && Objects.equals(this.formatAsString(), other.formatAsString()) && this.hasTracks() == other.hasTracks() && Objects.equals(this.tracks(), other.tracks());
    }

    public final String toString() {
        return ToString.builder((String)"Container").add("Duration", (Object)this.duration()).add("Format", (Object)this.formatAsString()).add("Tracks", this.hasTracks() ? this.tracks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "Tracks": {
                return Optional.ofNullable(clazz.cast(this.tracks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("duration", DURATION_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("tracks", TRACKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Container, T> g) {
        return obj -> g.apply((Container)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double duration;
        private String format;
        private List<Track> tracks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Container model) {
            this.duration(model.duration);
            this.format(model.format);
            this.tracks(model.tracks);
        }

        public final Double getDuration() {
            return this.duration;
        }

        public final void setDuration(Double duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Double duration) {
            this.duration = duration;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final List<Track.Builder> getTracks() {
            List<Track.Builder> result = ___listOfTrackCopier.copyToBuilder(this.tracks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTracks(Collection<Track.BuilderImpl> tracks) {
            this.tracks = ___listOfTrackCopier.copyFromBuilder(tracks);
        }

        @Override
        public final Builder tracks(Collection<Track> tracks) {
            this.tracks = ___listOfTrackCopier.copy(tracks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tracks(Track ... tracks) {
            this.tracks(Arrays.asList(tracks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tracks(Consumer<Track.Builder> ... tracks) {
            this.tracks(Stream.of(tracks).map(c -> (Track)((Track.Builder)Track.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Container build() {
            return new Container(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Container> {
        public Builder duration(Double var1);

        public Builder format(String var1);

        public Builder format(Format var1);

        public Builder tracks(Collection<Track> var1);

        public Builder tracks(Track ... var1);

        public Builder tracks(Consumer<Track.Builder> ... var1);
    }
}

