/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.AllowedRenditionSize;
import software.amazon.awssdk.services.mediaconvert.model.ForceIncludeRenditionSize;
import software.amazon.awssdk.services.mediaconvert.model.MinBottomRenditionSize;
import software.amazon.awssdk.services.mediaconvert.model.MinTopRenditionSize;
import software.amazon.awssdk.services.mediaconvert.model.RuleType;
import software.amazon.awssdk.services.mediaconvert.model.___listOfAllowedRenditionSizeCopier;
import software.amazon.awssdk.services.mediaconvert.model.___listOfForceIncludeRenditionSizeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedAbrRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedAbrRule> {
    private static final SdkField<List<AllowedRenditionSize>> ALLOWED_RENDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedRenditions").getter(AutomatedAbrRule.getter(AutomatedAbrRule::allowedRenditions)).setter(AutomatedAbrRule.setter(Builder::allowedRenditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedRenditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AllowedRenditionSize::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ForceIncludeRenditionSize>> FORCE_INCLUDE_RENDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ForceIncludeRenditions").getter(AutomatedAbrRule.getter(AutomatedAbrRule::forceIncludeRenditions)).setter(AutomatedAbrRule.setter(Builder::forceIncludeRenditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceIncludeRenditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ForceIncludeRenditionSize::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MinBottomRenditionSize> MIN_BOTTOM_RENDITION_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MinBottomRenditionSize").getter(AutomatedAbrRule.getter(AutomatedAbrRule::minBottomRenditionSize)).setter(AutomatedAbrRule.setter(Builder::minBottomRenditionSize)).constructor(MinBottomRenditionSize::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minBottomRenditionSize").build()}).build();
    private static final SdkField<MinTopRenditionSize> MIN_TOP_RENDITION_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MinTopRenditionSize").getter(AutomatedAbrRule.getter(AutomatedAbrRule::minTopRenditionSize)).setter(AutomatedAbrRule.setter(Builder::minTopRenditionSize)).constructor(MinTopRenditionSize::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minTopRenditionSize").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(AutomatedAbrRule.getter(AutomatedAbrRule::typeAsString)).setter(AutomatedAbrRule.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_RENDITIONS_FIELD, FORCE_INCLUDE_RENDITIONS_FIELD, MIN_BOTTOM_RENDITION_SIZE_FIELD, MIN_TOP_RENDITION_SIZE_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedAbrRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AllowedRenditionSize> allowedRenditions;
    private final List<ForceIncludeRenditionSize> forceIncludeRenditions;
    private final MinBottomRenditionSize minBottomRenditionSize;
    private final MinTopRenditionSize minTopRenditionSize;
    private final String type;

    private AutomatedAbrRule(BuilderImpl builder) {
        this.allowedRenditions = builder.allowedRenditions;
        this.forceIncludeRenditions = builder.forceIncludeRenditions;
        this.minBottomRenditionSize = builder.minBottomRenditionSize;
        this.minTopRenditionSize = builder.minTopRenditionSize;
        this.type = builder.type;
    }

    public final boolean hasAllowedRenditions() {
        return this.allowedRenditions != null && !(this.allowedRenditions instanceof SdkAutoConstructList);
    }

    public final List<AllowedRenditionSize> allowedRenditions() {
        return this.allowedRenditions;
    }

    public final boolean hasForceIncludeRenditions() {
        return this.forceIncludeRenditions != null && !(this.forceIncludeRenditions instanceof SdkAutoConstructList);
    }

    public final List<ForceIncludeRenditionSize> forceIncludeRenditions() {
        return this.forceIncludeRenditions;
    }

    public final MinBottomRenditionSize minBottomRenditionSize() {
        return this.minBottomRenditionSize;
    }

    public final MinTopRenditionSize minTopRenditionSize() {
        return this.minTopRenditionSize;
    }

    public final RuleType type() {
        return RuleType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedRenditions() ? this.allowedRenditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasForceIncludeRenditions() ? this.forceIncludeRenditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minBottomRenditionSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.minTopRenditionSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedAbrRule)) {
            return false;
        }
        AutomatedAbrRule other = (AutomatedAbrRule)obj;
        return this.hasAllowedRenditions() == other.hasAllowedRenditions() && Objects.equals(this.allowedRenditions(), other.allowedRenditions()) && this.hasForceIncludeRenditions() == other.hasForceIncludeRenditions() && Objects.equals(this.forceIncludeRenditions(), other.forceIncludeRenditions()) && Objects.equals(this.minBottomRenditionSize(), other.minBottomRenditionSize()) && Objects.equals(this.minTopRenditionSize(), other.minTopRenditionSize()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedAbrRule").add("AllowedRenditions", this.hasAllowedRenditions() ? this.allowedRenditions() : null).add("ForceIncludeRenditions", this.hasForceIncludeRenditions() ? this.forceIncludeRenditions() : null).add("MinBottomRenditionSize", (Object)this.minBottomRenditionSize()).add("MinTopRenditionSize", (Object)this.minTopRenditionSize()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowedRenditions": {
                return Optional.ofNullable(clazz.cast(this.allowedRenditions()));
            }
            case "ForceIncludeRenditions": {
                return Optional.ofNullable(clazz.cast(this.forceIncludeRenditions()));
            }
            case "MinBottomRenditionSize": {
                return Optional.ofNullable(clazz.cast(this.minBottomRenditionSize()));
            }
            case "MinTopRenditionSize": {
                return Optional.ofNullable(clazz.cast(this.minTopRenditionSize()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("allowedRenditions", ALLOWED_RENDITIONS_FIELD);
        map.put("forceIncludeRenditions", FORCE_INCLUDE_RENDITIONS_FIELD);
        map.put("minBottomRenditionSize", MIN_BOTTOM_RENDITION_SIZE_FIELD);
        map.put("minTopRenditionSize", MIN_TOP_RENDITION_SIZE_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedAbrRule, T> g) {
        return obj -> g.apply((AutomatedAbrRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AllowedRenditionSize> allowedRenditions = DefaultSdkAutoConstructList.getInstance();
        private List<ForceIncludeRenditionSize> forceIncludeRenditions = DefaultSdkAutoConstructList.getInstance();
        private MinBottomRenditionSize minBottomRenditionSize;
        private MinTopRenditionSize minTopRenditionSize;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedAbrRule model) {
            this.allowedRenditions(model.allowedRenditions);
            this.forceIncludeRenditions(model.forceIncludeRenditions);
            this.minBottomRenditionSize(model.minBottomRenditionSize);
            this.minTopRenditionSize(model.minTopRenditionSize);
            this.type(model.type);
        }

        public final List<AllowedRenditionSize.Builder> getAllowedRenditions() {
            List<AllowedRenditionSize.Builder> result = ___listOfAllowedRenditionSizeCopier.copyToBuilder(this.allowedRenditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllowedRenditions(Collection<AllowedRenditionSize.BuilderImpl> allowedRenditions) {
            this.allowedRenditions = ___listOfAllowedRenditionSizeCopier.copyFromBuilder(allowedRenditions);
        }

        @Override
        public final Builder allowedRenditions(Collection<AllowedRenditionSize> allowedRenditions) {
            this.allowedRenditions = ___listOfAllowedRenditionSizeCopier.copy(allowedRenditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedRenditions(AllowedRenditionSize ... allowedRenditions) {
            this.allowedRenditions(Arrays.asList(allowedRenditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedRenditions(Consumer<AllowedRenditionSize.Builder> ... allowedRenditions) {
            this.allowedRenditions(Stream.of(allowedRenditions).map(c -> (AllowedRenditionSize)((AllowedRenditionSize.Builder)AllowedRenditionSize.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ForceIncludeRenditionSize.Builder> getForceIncludeRenditions() {
            List<ForceIncludeRenditionSize.Builder> result = ___listOfForceIncludeRenditionSizeCopier.copyToBuilder(this.forceIncludeRenditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setForceIncludeRenditions(Collection<ForceIncludeRenditionSize.BuilderImpl> forceIncludeRenditions) {
            this.forceIncludeRenditions = ___listOfForceIncludeRenditionSizeCopier.copyFromBuilder(forceIncludeRenditions);
        }

        @Override
        public final Builder forceIncludeRenditions(Collection<ForceIncludeRenditionSize> forceIncludeRenditions) {
            this.forceIncludeRenditions = ___listOfForceIncludeRenditionSizeCopier.copy(forceIncludeRenditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forceIncludeRenditions(ForceIncludeRenditionSize ... forceIncludeRenditions) {
            this.forceIncludeRenditions(Arrays.asList(forceIncludeRenditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forceIncludeRenditions(Consumer<ForceIncludeRenditionSize.Builder> ... forceIncludeRenditions) {
            this.forceIncludeRenditions(Stream.of(forceIncludeRenditions).map(c -> (ForceIncludeRenditionSize)((ForceIncludeRenditionSize.Builder)ForceIncludeRenditionSize.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MinBottomRenditionSize.Builder getMinBottomRenditionSize() {
            return this.minBottomRenditionSize != null ? this.minBottomRenditionSize.toBuilder() : null;
        }

        public final void setMinBottomRenditionSize(MinBottomRenditionSize.BuilderImpl minBottomRenditionSize) {
            this.minBottomRenditionSize = minBottomRenditionSize != null ? minBottomRenditionSize.build() : null;
        }

        @Override
        public final Builder minBottomRenditionSize(MinBottomRenditionSize minBottomRenditionSize) {
            this.minBottomRenditionSize = minBottomRenditionSize;
            return this;
        }

        public final MinTopRenditionSize.Builder getMinTopRenditionSize() {
            return this.minTopRenditionSize != null ? this.minTopRenditionSize.toBuilder() : null;
        }

        public final void setMinTopRenditionSize(MinTopRenditionSize.BuilderImpl minTopRenditionSize) {
            this.minTopRenditionSize = minTopRenditionSize != null ? minTopRenditionSize.build() : null;
        }

        @Override
        public final Builder minTopRenditionSize(MinTopRenditionSize minTopRenditionSize) {
            this.minTopRenditionSize = minTopRenditionSize;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public AutomatedAbrRule build() {
            return new AutomatedAbrRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedAbrRule> {
        public Builder allowedRenditions(Collection<AllowedRenditionSize> var1);

        public Builder allowedRenditions(AllowedRenditionSize ... var1);

        public Builder allowedRenditions(Consumer<AllowedRenditionSize.Builder> ... var1);

        public Builder forceIncludeRenditions(Collection<ForceIncludeRenditionSize> var1);

        public Builder forceIncludeRenditions(ForceIncludeRenditionSize ... var1);

        public Builder forceIncludeRenditions(Consumer<ForceIncludeRenditionSize.Builder> ... var1);

        public Builder minBottomRenditionSize(MinBottomRenditionSize var1);

        default public Builder minBottomRenditionSize(Consumer<MinBottomRenditionSize.Builder> minBottomRenditionSize) {
            return this.minBottomRenditionSize((MinBottomRenditionSize)((MinBottomRenditionSize.Builder)MinBottomRenditionSize.builder().applyMutation(minBottomRenditionSize)).build());
        }

        public Builder minTopRenditionSize(MinTopRenditionSize var1);

        default public Builder minTopRenditionSize(Consumer<MinTopRenditionSize.Builder> minTopRenditionSize) {
            return this.minTopRenditionSize((MinTopRenditionSize)((MinTopRenditionSize.Builder)MinTopRenditionSize.builder().applyMutation(minTopRenditionSize)).build());
        }

        public Builder type(String var1);

        public Builder type(RuleType var1);
    }
}

