/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CaptionSourceType {
    ANCILLARY("ANCILLARY"),
    DVB_SUB("DVB_SUB"),
    EMBEDDED("EMBEDDED"),
    SCTE20("SCTE20"),
    SCC("SCC"),
    TTML("TTML"),
    STL("STL"),
    SRT("SRT"),
    SMI("SMI"),
    SMPTE_TT("SMPTE_TT"),
    TELETEXT("TELETEXT"),
    NULL_SOURCE("NULL_SOURCE"),
    IMSC("IMSC"),
    WEBVTT("WEBVTT"),
    TT_3_GPP("TT_3GPP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CaptionSourceType> VALUE_MAP;
    private final String value;

    private CaptionSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CaptionSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CaptionSourceType> knownValues() {
        EnumSet<CaptionSourceType> knownValues = EnumSet.allOf(CaptionSourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CaptionSourceType.class, CaptionSourceType::toString);
    }
}

