/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TamsGapHandling {
    SKIP_GAPS("SKIP_GAPS"),
    FILL_WITH_BLACK("FILL_WITH_BLACK"),
    HOLD_LAST_FRAME("HOLD_LAST_FRAME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TamsGapHandling> VALUE_MAP;
    private final String value;

    private TamsGapHandling(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TamsGapHandling fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TamsGapHandling> knownValues() {
        EnumSet<TamsGapHandling> knownValues = EnumSet.allOf(TamsGapHandling.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TamsGapHandling.class, TamsGapHandling::toString);
    }
}

