/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VideoSelectorType {
    AUTO("AUTO"),
    STREAM("STREAM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VideoSelectorType> VALUE_MAP;
    private final String value;

    private VideoSelectorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VideoSelectorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VideoSelectorType> knownValues() {
        EnumSet<VideoSelectorType> knownValues = EnumSet.allOf(VideoSelectorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VideoSelectorType.class, VideoSelectorType::toString);
    }
}

