/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.InputCodec;
import software.amazon.awssdk.services.medialive.model.InputMaximumBitrate;
import software.amazon.awssdk.services.medialive.model.InputResolution;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputSpecification> {
    private static final SdkField<String> CODEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Codec").getter(InputSpecification.getter(InputSpecification::codecAsString)).setter(InputSpecification.setter(Builder::codec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codec").build()}).build();
    private static final SdkField<String> MAXIMUM_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaximumBitrate").getter(InputSpecification.getter(InputSpecification::maximumBitrateAsString)).setter(InputSpecification.setter(Builder::maximumBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumBitrate").build()}).build();
    private static final SdkField<String> RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Resolution").getter(InputSpecification.getter(InputSpecification::resolutionAsString)).setter(InputSpecification.setter(Builder::resolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolution").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODEC_FIELD, MAXIMUM_BITRATE_FIELD, RESOLUTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InputSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String codec;
    private final String maximumBitrate;
    private final String resolution;

    private InputSpecification(BuilderImpl builder) {
        this.codec = builder.codec;
        this.maximumBitrate = builder.maximumBitrate;
        this.resolution = builder.resolution;
    }

    public final InputCodec codec() {
        return InputCodec.fromValue(this.codec);
    }

    public final String codecAsString() {
        return this.codec;
    }

    public final InputMaximumBitrate maximumBitrate() {
        return InputMaximumBitrate.fromValue(this.maximumBitrate);
    }

    public final String maximumBitrateAsString() {
        return this.maximumBitrate;
    }

    public final InputResolution resolution() {
        return InputResolution.fromValue(this.resolution);
    }

    public final String resolutionAsString() {
        return this.resolution;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBitrateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolutionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSpecification)) {
            return false;
        }
        InputSpecification other = (InputSpecification)obj;
        return Objects.equals(this.codecAsString(), other.codecAsString()) && Objects.equals(this.maximumBitrateAsString(), other.maximumBitrateAsString()) && Objects.equals(this.resolutionAsString(), other.resolutionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InputSpecification").add("Codec", (Object)this.codecAsString()).add("MaximumBitrate", (Object)this.maximumBitrateAsString()).add("Resolution", (Object)this.resolutionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Codec": {
                return Optional.ofNullable(clazz.cast(this.codecAsString()));
            }
            case "MaximumBitrate": {
                return Optional.ofNullable(clazz.cast(this.maximumBitrateAsString()));
            }
            case "Resolution": {
                return Optional.ofNullable(clazz.cast(this.resolutionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("codec", CODEC_FIELD);
        map.put("maximumBitrate", MAXIMUM_BITRATE_FIELD);
        map.put("resolution", RESOLUTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputSpecification, T> g) {
        return obj -> g.apply((InputSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String codec;
        private String maximumBitrate;
        private String resolution;

        private BuilderImpl() {
        }

        private BuilderImpl(InputSpecification model) {
            this.codec(model.codec);
            this.maximumBitrate(model.maximumBitrate);
            this.resolution(model.resolution);
        }

        public final String getCodec() {
            return this.codec;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        @Override
        public final Builder codec(InputCodec codec) {
            this.codec(codec == null ? null : codec.toString());
            return this;
        }

        public final String getMaximumBitrate() {
            return this.maximumBitrate;
        }

        public final void setMaximumBitrate(String maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
        }

        @Override
        public final Builder maximumBitrate(String maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
            return this;
        }

        @Override
        public final Builder maximumBitrate(InputMaximumBitrate maximumBitrate) {
            this.maximumBitrate(maximumBitrate == null ? null : maximumBitrate.toString());
            return this;
        }

        public final String getResolution() {
            return this.resolution;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        @Override
        public final Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        @Override
        public final Builder resolution(InputResolution resolution) {
            this.resolution(resolution == null ? null : resolution.toString());
            return this;
        }

        public InputSpecification build() {
            return new InputSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputSpecification> {
        public Builder codec(String var1);

        public Builder codec(InputCodec var1);

        public Builder maximumBitrate(String var1);

        public Builder maximumBitrate(InputMaximumBitrate var1);

        public Builder resolution(String var1);

        public Builder resolution(InputResolution var1);
    }
}

