/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.AudioOnlyHlsSegmentType;
import software.amazon.awssdk.services.medialive.model.AudioOnlyHlsTrackType;
import software.amazon.awssdk.services.medialive.model.InputLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioOnlyHlsSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioOnlyHlsSettings> {
    private static final SdkField<String> AUDIO_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioGroupId").getter(AudioOnlyHlsSettings.getter(AudioOnlyHlsSettings::audioGroupId)).setter(AudioOnlyHlsSettings.setter(Builder::audioGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioGroupId").build()}).build();
    private static final SdkField<InputLocation> AUDIO_ONLY_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AudioOnlyImage").getter(AudioOnlyHlsSettings.getter(AudioOnlyHlsSettings::audioOnlyImage)).setter(AudioOnlyHlsSettings.setter(Builder::audioOnlyImage)).constructor(InputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioOnlyImage").build()}).build();
    private static final SdkField<String> AUDIO_TRACK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioTrackType").getter(AudioOnlyHlsSettings.getter(AudioOnlyHlsSettings::audioTrackTypeAsString)).setter(AudioOnlyHlsSettings.setter(Builder::audioTrackType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioTrackType").build()}).build();
    private static final SdkField<String> SEGMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentType").getter(AudioOnlyHlsSettings.getter(AudioOnlyHlsSettings::segmentTypeAsString)).setter(AudioOnlyHlsSettings.setter(Builder::segmentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_GROUP_ID_FIELD, AUDIO_ONLY_IMAGE_FIELD, AUDIO_TRACK_TYPE_FIELD, SEGMENT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AudioOnlyHlsSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String audioGroupId;
    private final InputLocation audioOnlyImage;
    private final String audioTrackType;
    private final String segmentType;

    private AudioOnlyHlsSettings(BuilderImpl builder) {
        this.audioGroupId = builder.audioGroupId;
        this.audioOnlyImage = builder.audioOnlyImage;
        this.audioTrackType = builder.audioTrackType;
        this.segmentType = builder.segmentType;
    }

    public final String audioGroupId() {
        return this.audioGroupId;
    }

    public final InputLocation audioOnlyImage() {
        return this.audioOnlyImage;
    }

    public final AudioOnlyHlsTrackType audioTrackType() {
        return AudioOnlyHlsTrackType.fromValue(this.audioTrackType);
    }

    public final String audioTrackTypeAsString() {
        return this.audioTrackType;
    }

    public final AudioOnlyHlsSegmentType segmentType() {
        return AudioOnlyHlsSegmentType.fromValue(this.segmentType);
    }

    public final String segmentTypeAsString() {
        return this.segmentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioOnlyImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioTrackTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioOnlyHlsSettings)) {
            return false;
        }
        AudioOnlyHlsSettings other = (AudioOnlyHlsSettings)obj;
        return Objects.equals(this.audioGroupId(), other.audioGroupId()) && Objects.equals(this.audioOnlyImage(), other.audioOnlyImage()) && Objects.equals(this.audioTrackTypeAsString(), other.audioTrackTypeAsString()) && Objects.equals(this.segmentTypeAsString(), other.segmentTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AudioOnlyHlsSettings").add("AudioGroupId", (Object)this.audioGroupId()).add("AudioOnlyImage", (Object)this.audioOnlyImage()).add("AudioTrackType", (Object)this.audioTrackTypeAsString()).add("SegmentType", (Object)this.segmentTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioGroupId": {
                return Optional.ofNullable(clazz.cast(this.audioGroupId()));
            }
            case "AudioOnlyImage": {
                return Optional.ofNullable(clazz.cast(this.audioOnlyImage()));
            }
            case "AudioTrackType": {
                return Optional.ofNullable(clazz.cast(this.audioTrackTypeAsString()));
            }
            case "SegmentType": {
                return Optional.ofNullable(clazz.cast(this.segmentTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("audioGroupId", AUDIO_GROUP_ID_FIELD);
        map.put("audioOnlyImage", AUDIO_ONLY_IMAGE_FIELD);
        map.put("audioTrackType", AUDIO_TRACK_TYPE_FIELD);
        map.put("segmentType", SEGMENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudioOnlyHlsSettings, T> g) {
        return obj -> g.apply((AudioOnlyHlsSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String audioGroupId;
        private InputLocation audioOnlyImage;
        private String audioTrackType;
        private String segmentType;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioOnlyHlsSettings model) {
            this.audioGroupId(model.audioGroupId);
            this.audioOnlyImage(model.audioOnlyImage);
            this.audioTrackType(model.audioTrackType);
            this.segmentType(model.segmentType);
        }

        public final String getAudioGroupId() {
            return this.audioGroupId;
        }

        public final void setAudioGroupId(String audioGroupId) {
            this.audioGroupId = audioGroupId;
        }

        @Override
        public final Builder audioGroupId(String audioGroupId) {
            this.audioGroupId = audioGroupId;
            return this;
        }

        public final InputLocation.Builder getAudioOnlyImage() {
            return this.audioOnlyImage != null ? this.audioOnlyImage.toBuilder() : null;
        }

        public final void setAudioOnlyImage(InputLocation.BuilderImpl audioOnlyImage) {
            this.audioOnlyImage = audioOnlyImage != null ? audioOnlyImage.build() : null;
        }

        @Override
        public final Builder audioOnlyImage(InputLocation audioOnlyImage) {
            this.audioOnlyImage = audioOnlyImage;
            return this;
        }

        public final String getAudioTrackType() {
            return this.audioTrackType;
        }

        public final void setAudioTrackType(String audioTrackType) {
            this.audioTrackType = audioTrackType;
        }

        @Override
        public final Builder audioTrackType(String audioTrackType) {
            this.audioTrackType = audioTrackType;
            return this;
        }

        @Override
        public final Builder audioTrackType(AudioOnlyHlsTrackType audioTrackType) {
            this.audioTrackType(audioTrackType == null ? null : audioTrackType.toString());
            return this;
        }

        public final String getSegmentType() {
            return this.segmentType;
        }

        public final void setSegmentType(String segmentType) {
            this.segmentType = segmentType;
        }

        @Override
        public final Builder segmentType(String segmentType) {
            this.segmentType = segmentType;
            return this;
        }

        @Override
        public final Builder segmentType(AudioOnlyHlsSegmentType segmentType) {
            this.segmentType(segmentType == null ? null : segmentType.toString());
            return this;
        }

        public AudioOnlyHlsSettings build() {
            return new AudioOnlyHlsSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioOnlyHlsSettings> {
        public Builder audioGroupId(String var1);

        public Builder audioOnlyImage(InputLocation var1);

        default public Builder audioOnlyImage(Consumer<InputLocation.Builder> audioOnlyImage) {
            return this.audioOnlyImage((InputLocation)((InputLocation.Builder)InputLocation.builder().applyMutation(audioOnlyImage)).build());
        }

        public Builder audioTrackType(String var1);

        public Builder audioTrackType(AudioOnlyHlsTrackType var1);

        public Builder segmentType(String var1);

        public Builder segmentType(AudioOnlyHlsSegmentType var1);
    }
}

