/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.ClusterAlertState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterAlert
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterAlert> {
    private static final SdkField<String> ALERT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlertType").getter(ClusterAlert.getter(ClusterAlert::alertType)).setter(ClusterAlert.setter(Builder::alertType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alertType").build()}).build();
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelId").getter(ClusterAlert.getter(ClusterAlert::channelId)).setter(ClusterAlert.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelId").build()}).build();
    private static final SdkField<Instant> CLEARED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ClearedTimestamp").getter(ClusterAlert.getter(ClusterAlert::clearedTimestamp)).setter(ClusterAlert.setter(Builder::clearedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clearedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ClusterAlert.getter(ClusterAlert::id)).setter(ClusterAlert.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(ClusterAlert.getter(ClusterAlert::message)).setter(ClusterAlert.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<String> NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeId").getter(ClusterAlert.getter(ClusterAlert::nodeId)).setter(ClusterAlert.setter(Builder::nodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeId").build()}).build();
    private static final SdkField<Instant> SET_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SetTimestamp").getter(ClusterAlert.getter(ClusterAlert::setTimestamp)).setter(ClusterAlert.setter(Builder::setTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("setTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ClusterAlert.getter(ClusterAlert::stateAsString)).setter(ClusterAlert.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALERT_TYPE_FIELD, CHANNEL_ID_FIELD, CLEARED_TIMESTAMP_FIELD, ID_FIELD, MESSAGE_FIELD, NODE_ID_FIELD, SET_TIMESTAMP_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterAlert.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String alertType;
    private final String channelId;
    private final Instant clearedTimestamp;
    private final String id;
    private final String message;
    private final String nodeId;
    private final Instant setTimestamp;
    private final String state;

    private ClusterAlert(BuilderImpl builder) {
        this.alertType = builder.alertType;
        this.channelId = builder.channelId;
        this.clearedTimestamp = builder.clearedTimestamp;
        this.id = builder.id;
        this.message = builder.message;
        this.nodeId = builder.nodeId;
        this.setTimestamp = builder.setTimestamp;
        this.state = builder.state;
    }

    public final String alertType() {
        return this.alertType;
    }

    public final String channelId() {
        return this.channelId;
    }

    public final Instant clearedTimestamp() {
        return this.clearedTimestamp;
    }

    public final String id() {
        return this.id;
    }

    public final String message() {
        return this.message;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final Instant setTimestamp() {
        return this.setTimestamp;
    }

    public final ClusterAlertState state() {
        return ClusterAlertState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alertType());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clearedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.setTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterAlert)) {
            return false;
        }
        ClusterAlert other = (ClusterAlert)obj;
        return Objects.equals(this.alertType(), other.alertType()) && Objects.equals(this.channelId(), other.channelId()) && Objects.equals(this.clearedTimestamp(), other.clearedTimestamp()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.nodeId(), other.nodeId()) && Objects.equals(this.setTimestamp(), other.setTimestamp()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterAlert").add("AlertType", (Object)this.alertType()).add("ChannelId", (Object)this.channelId()).add("ClearedTimestamp", (Object)this.clearedTimestamp()).add("Id", (Object)this.id()).add("Message", (Object)this.message()).add("NodeId", (Object)this.nodeId()).add("SetTimestamp", (Object)this.setTimestamp()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlertType": {
                return Optional.ofNullable(clazz.cast(this.alertType()));
            }
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "ClearedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.clearedTimestamp()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "NodeId": {
                return Optional.ofNullable(clazz.cast(this.nodeId()));
            }
            case "SetTimestamp": {
                return Optional.ofNullable(clazz.cast(this.setTimestamp()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("alertType", ALERT_TYPE_FIELD);
        map.put("channelId", CHANNEL_ID_FIELD);
        map.put("clearedTimestamp", CLEARED_TIMESTAMP_FIELD);
        map.put("id", ID_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("nodeId", NODE_ID_FIELD);
        map.put("setTimestamp", SET_TIMESTAMP_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterAlert, T> g) {
        return obj -> g.apply((ClusterAlert)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alertType;
        private String channelId;
        private Instant clearedTimestamp;
        private String id;
        private String message;
        private String nodeId;
        private Instant setTimestamp;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterAlert model) {
            this.alertType(model.alertType);
            this.channelId(model.channelId);
            this.clearedTimestamp(model.clearedTimestamp);
            this.id(model.id);
            this.message(model.message);
            this.nodeId(model.nodeId);
            this.setTimestamp(model.setTimestamp);
            this.state(model.state);
        }

        public final String getAlertType() {
            return this.alertType;
        }

        public final void setAlertType(String alertType) {
            this.alertType = alertType;
        }

        @Override
        public final Builder alertType(String alertType) {
            this.alertType = alertType;
            return this;
        }

        public final String getChannelId() {
            return this.channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final Instant getClearedTimestamp() {
            return this.clearedTimestamp;
        }

        public final void setClearedTimestamp(Instant clearedTimestamp) {
            this.clearedTimestamp = clearedTimestamp;
        }

        @Override
        public final Builder clearedTimestamp(Instant clearedTimestamp) {
            this.clearedTimestamp = clearedTimestamp;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getNodeId() {
            return this.nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final Instant getSetTimestamp() {
            return this.setTimestamp;
        }

        public final void setSetTimestamp(Instant setTimestamp) {
            this.setTimestamp = setTimestamp;
        }

        @Override
        @Transient
        public final Builder setTimestamp(Instant setTimestamp) {
            this.setTimestamp = setTimestamp;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ClusterAlertState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public ClusterAlert build() {
            return new ClusterAlert(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterAlert> {
        public Builder alertType(String var1);

        public Builder channelId(String var1);

        public Builder clearedTimestamp(Instant var1);

        public Builder id(String var1);

        public Builder message(String var1);

        public Builder nodeId(String var1);

        public Builder setTimestamp(Instant var1);

        public Builder state(String var1);

        public Builder state(ClusterAlertState var1);
    }
}

