/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.LinkedChannelType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FollowerChannelSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FollowerChannelSettings> {
    private static final SdkField<String> LINKED_CHANNEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LinkedChannelType").getter(FollowerChannelSettings.getter(FollowerChannelSettings::linkedChannelTypeAsString)).setter(FollowerChannelSettings.setter(Builder::linkedChannelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkedChannelType").build()}).build();
    private static final SdkField<String> PRIMARY_CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryChannelArn").getter(FollowerChannelSettings.getter(FollowerChannelSettings::primaryChannelArn)).setter(FollowerChannelSettings.setter(Builder::primaryChannelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryChannelArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINKED_CHANNEL_TYPE_FIELD, PRIMARY_CHANNEL_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FollowerChannelSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String linkedChannelType;
    private final String primaryChannelArn;

    private FollowerChannelSettings(BuilderImpl builder) {
        this.linkedChannelType = builder.linkedChannelType;
        this.primaryChannelArn = builder.primaryChannelArn;
    }

    public final LinkedChannelType linkedChannelType() {
        return LinkedChannelType.fromValue(this.linkedChannelType);
    }

    public final String linkedChannelTypeAsString() {
        return this.linkedChannelType;
    }

    public final String primaryChannelArn() {
        return this.primaryChannelArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.linkedChannelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryChannelArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FollowerChannelSettings)) {
            return false;
        }
        FollowerChannelSettings other = (FollowerChannelSettings)obj;
        return Objects.equals(this.linkedChannelTypeAsString(), other.linkedChannelTypeAsString()) && Objects.equals(this.primaryChannelArn(), other.primaryChannelArn());
    }

    public final String toString() {
        return ToString.builder((String)"FollowerChannelSettings").add("LinkedChannelType", (Object)this.linkedChannelTypeAsString()).add("PrimaryChannelArn", (Object)this.primaryChannelArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LinkedChannelType": {
                return Optional.ofNullable(clazz.cast(this.linkedChannelTypeAsString()));
            }
            case "PrimaryChannelArn": {
                return Optional.ofNullable(clazz.cast(this.primaryChannelArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("linkedChannelType", LINKED_CHANNEL_TYPE_FIELD);
        map.put("primaryChannelArn", PRIMARY_CHANNEL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FollowerChannelSettings, T> g) {
        return obj -> g.apply((FollowerChannelSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String linkedChannelType;
        private String primaryChannelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(FollowerChannelSettings model) {
            this.linkedChannelType(model.linkedChannelType);
            this.primaryChannelArn(model.primaryChannelArn);
        }

        public final String getLinkedChannelType() {
            return this.linkedChannelType;
        }

        public final void setLinkedChannelType(String linkedChannelType) {
            this.linkedChannelType = linkedChannelType;
        }

        @Override
        public final Builder linkedChannelType(String linkedChannelType) {
            this.linkedChannelType = linkedChannelType;
            return this;
        }

        @Override
        public final Builder linkedChannelType(LinkedChannelType linkedChannelType) {
            this.linkedChannelType(linkedChannelType == null ? null : linkedChannelType.toString());
            return this;
        }

        public final String getPrimaryChannelArn() {
            return this.primaryChannelArn;
        }

        public final void setPrimaryChannelArn(String primaryChannelArn) {
            this.primaryChannelArn = primaryChannelArn;
        }

        @Override
        public final Builder primaryChannelArn(String primaryChannelArn) {
            this.primaryChannelArn = primaryChannelArn;
            return this;
        }

        public FollowerChannelSettings build() {
            return new FollowerChannelSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FollowerChannelSettings> {
        public Builder linkedChannelType(String var1);

        public Builder linkedChannelType(LinkedChannelType var1);

        public Builder primaryChannelArn(String var1);
    }
}

