/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.FollowerChannelSettings;
import software.amazon.awssdk.services.medialive.model.PrimaryChannelSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LinkedChannelSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LinkedChannelSettings> {
    private static final SdkField<FollowerChannelSettings> FOLLOWER_CHANNEL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FollowerChannelSettings").getter(LinkedChannelSettings.getter(LinkedChannelSettings::followerChannelSettings)).setter(LinkedChannelSettings.setter(Builder::followerChannelSettings)).constructor(FollowerChannelSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("followerChannelSettings").build()}).build();
    private static final SdkField<PrimaryChannelSettings> PRIMARY_CHANNEL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrimaryChannelSettings").getter(LinkedChannelSettings.getter(LinkedChannelSettings::primaryChannelSettings)).setter(LinkedChannelSettings.setter(Builder::primaryChannelSettings)).constructor(PrimaryChannelSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryChannelSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FOLLOWER_CHANNEL_SETTINGS_FIELD, PRIMARY_CHANNEL_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LinkedChannelSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final FollowerChannelSettings followerChannelSettings;
    private final PrimaryChannelSettings primaryChannelSettings;

    private LinkedChannelSettings(BuilderImpl builder) {
        this.followerChannelSettings = builder.followerChannelSettings;
        this.primaryChannelSettings = builder.primaryChannelSettings;
    }

    public final FollowerChannelSettings followerChannelSettings() {
        return this.followerChannelSettings;
    }

    public final PrimaryChannelSettings primaryChannelSettings() {
        return this.primaryChannelSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.followerChannelSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryChannelSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinkedChannelSettings)) {
            return false;
        }
        LinkedChannelSettings other = (LinkedChannelSettings)obj;
        return Objects.equals(this.followerChannelSettings(), other.followerChannelSettings()) && Objects.equals(this.primaryChannelSettings(), other.primaryChannelSettings());
    }

    public final String toString() {
        return ToString.builder((String)"LinkedChannelSettings").add("FollowerChannelSettings", (Object)this.followerChannelSettings()).add("PrimaryChannelSettings", (Object)this.primaryChannelSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FollowerChannelSettings": {
                return Optional.ofNullable(clazz.cast(this.followerChannelSettings()));
            }
            case "PrimaryChannelSettings": {
                return Optional.ofNullable(clazz.cast(this.primaryChannelSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("followerChannelSettings", FOLLOWER_CHANNEL_SETTINGS_FIELD);
        map.put("primaryChannelSettings", PRIMARY_CHANNEL_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LinkedChannelSettings, T> g) {
        return obj -> g.apply((LinkedChannelSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FollowerChannelSettings followerChannelSettings;
        private PrimaryChannelSettings primaryChannelSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(LinkedChannelSettings model) {
            this.followerChannelSettings(model.followerChannelSettings);
            this.primaryChannelSettings(model.primaryChannelSettings);
        }

        public final FollowerChannelSettings.Builder getFollowerChannelSettings() {
            return this.followerChannelSettings != null ? this.followerChannelSettings.toBuilder() : null;
        }

        public final void setFollowerChannelSettings(FollowerChannelSettings.BuilderImpl followerChannelSettings) {
            this.followerChannelSettings = followerChannelSettings != null ? followerChannelSettings.build() : null;
        }

        @Override
        public final Builder followerChannelSettings(FollowerChannelSettings followerChannelSettings) {
            this.followerChannelSettings = followerChannelSettings;
            return this;
        }

        public final PrimaryChannelSettings.Builder getPrimaryChannelSettings() {
            return this.primaryChannelSettings != null ? this.primaryChannelSettings.toBuilder() : null;
        }

        public final void setPrimaryChannelSettings(PrimaryChannelSettings.BuilderImpl primaryChannelSettings) {
            this.primaryChannelSettings = primaryChannelSettings != null ? primaryChannelSettings.build() : null;
        }

        @Override
        public final Builder primaryChannelSettings(PrimaryChannelSettings primaryChannelSettings) {
            this.primaryChannelSettings = primaryChannelSettings;
            return this;
        }

        public LinkedChannelSettings build() {
            return new LinkedChannelSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LinkedChannelSettings> {
        public Builder followerChannelSettings(FollowerChannelSettings var1);

        default public Builder followerChannelSettings(Consumer<FollowerChannelSettings.Builder> followerChannelSettings) {
            return this.followerChannelSettings((FollowerChannelSettings)((FollowerChannelSettings.Builder)FollowerChannelSettings.builder().applyMutation(followerChannelSettings)).build());
        }

        public Builder primaryChannelSettings(PrimaryChannelSettings var1);

        default public Builder primaryChannelSettings(Consumer<PrimaryChannelSettings.Builder> primaryChannelSettings) {
            return this.primaryChannelSettings((PrimaryChannelSettings)((PrimaryChannelSettings.Builder)PrimaryChannelSettings.builder().applyMutation(primaryChannelSettings)).build());
        }
    }
}

