/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.AfdSignaling;
import software.amazon.awssdk.services.medialive.model.FixedAfd;
import software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization;
import software.amazon.awssdk.services.medialive.model.H265AlternativeTransferFunction;
import software.amazon.awssdk.services.medialive.model.H265ColorMetadata;
import software.amazon.awssdk.services.medialive.model.H265ColorSpaceSettings;
import software.amazon.awssdk.services.medialive.model.H265Deblocking;
import software.amazon.awssdk.services.medialive.model.H265FilterSettings;
import software.amazon.awssdk.services.medialive.model.H265FlickerAq;
import software.amazon.awssdk.services.medialive.model.H265GopBReference;
import software.amazon.awssdk.services.medialive.model.H265GopSizeUnits;
import software.amazon.awssdk.services.medialive.model.H265Level;
import software.amazon.awssdk.services.medialive.model.H265LookAheadRateControl;
import software.amazon.awssdk.services.medialive.model.H265MvOverPictureBoundaries;
import software.amazon.awssdk.services.medialive.model.H265MvTemporalPredictor;
import software.amazon.awssdk.services.medialive.model.H265Profile;
import software.amazon.awssdk.services.medialive.model.H265RateControlMode;
import software.amazon.awssdk.services.medialive.model.H265ScanType;
import software.amazon.awssdk.services.medialive.model.H265SceneChangeDetect;
import software.amazon.awssdk.services.medialive.model.H265SubGopLength;
import software.amazon.awssdk.services.medialive.model.H265Tier;
import software.amazon.awssdk.services.medialive.model.H265TilePadding;
import software.amazon.awssdk.services.medialive.model.H265TimecodeInsertionBehavior;
import software.amazon.awssdk.services.medialive.model.H265TreeblockSize;
import software.amazon.awssdk.services.medialive.model.TimecodeBurninSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class H265Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, H265Settings> {
    private static final SdkField<String> ADAPTIVE_QUANTIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdaptiveQuantization").getter(H265Settings.getter(H265Settings::adaptiveQuantizationAsString)).setter(H265Settings.setter(Builder::adaptiveQuantization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adaptiveQuantization").build()}).build();
    private static final SdkField<String> AFD_SIGNALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AfdSignaling").getter(H265Settings.getter(H265Settings::afdSignalingAsString)).setter(H265Settings.setter(Builder::afdSignaling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afdSignaling").build()}).build();
    private static final SdkField<String> ALTERNATIVE_TRANSFER_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlternativeTransferFunction").getter(H265Settings.getter(H265Settings::alternativeTransferFunctionAsString)).setter(H265Settings.setter(Builder::alternativeTransferFunction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alternativeTransferFunction").build()}).build();
    private static final SdkField<Integer> BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Bitrate").getter(H265Settings.getter(H265Settings::bitrate)).setter(H265Settings.setter(Builder::bitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()}).build();
    private static final SdkField<Integer> BUF_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BufSize").getter(H265Settings.getter(H265Settings::bufSize)).setter(H265Settings.setter(Builder::bufSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bufSize").build()}).build();
    private static final SdkField<String> COLOR_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColorMetadata").getter(H265Settings.getter(H265Settings::colorMetadataAsString)).setter(H265Settings.setter(Builder::colorMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorMetadata").build()}).build();
    private static final SdkField<H265ColorSpaceSettings> COLOR_SPACE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ColorSpaceSettings").getter(H265Settings.getter(H265Settings::colorSpaceSettings)).setter(H265Settings.setter(Builder::colorSpaceSettings)).constructor(H265ColorSpaceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpaceSettings").build()}).build();
    private static final SdkField<H265FilterSettings> FILTER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterSettings").getter(H265Settings.getter(H265Settings::filterSettings)).setter(H265Settings.setter(Builder::filterSettings)).constructor(H265FilterSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterSettings").build()}).build();
    private static final SdkField<String> FIXED_AFD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FixedAfd").getter(H265Settings.getter(H265Settings::fixedAfdAsString)).setter(H265Settings.setter(Builder::fixedAfd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedAfd").build()}).build();
    private static final SdkField<String> FLICKER_AQ_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlickerAq").getter(H265Settings.getter(H265Settings::flickerAqAsString)).setter(H265Settings.setter(Builder::flickerAq)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flickerAq").build()}).build();
    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateDenominator").getter(H265Settings.getter(H265Settings::framerateDenominator)).setter(H265Settings.setter(Builder::framerateDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build()}).build();
    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateNumerator").getter(H265Settings.getter(H265Settings::framerateNumerator)).setter(H265Settings.setter(Builder::framerateNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build()}).build();
    private static final SdkField<Integer> GOP_CLOSED_CADENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GopClosedCadence").getter(H265Settings.getter(H265Settings::gopClosedCadence)).setter(H265Settings.setter(Builder::gopClosedCadence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopClosedCadence").build()}).build();
    private static final SdkField<Double> GOP_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("GopSize").getter(H265Settings.getter(H265Settings::gopSize)).setter(H265Settings.setter(Builder::gopSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSize").build()}).build();
    private static final SdkField<String> GOP_SIZE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GopSizeUnits").getter(H265Settings.getter(H265Settings::gopSizeUnitsAsString)).setter(H265Settings.setter(Builder::gopSizeUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSizeUnits").build()}).build();
    private static final SdkField<String> LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Level").getter(H265Settings.getter(H265Settings::levelAsString)).setter(H265Settings.setter(Builder::level)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()}).build();
    private static final SdkField<String> LOOK_AHEAD_RATE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LookAheadRateControl").getter(H265Settings.getter(H265Settings::lookAheadRateControlAsString)).setter(H265Settings.setter(Builder::lookAheadRateControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookAheadRateControl").build()}).build();
    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxBitrate").getter(H265Settings.getter(H265Settings::maxBitrate)).setter(H265Settings.setter(Builder::maxBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()}).build();
    private static final SdkField<Integer> MIN_I_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinIInterval").getter(H265Settings.getter(H265Settings::minIInterval)).setter(H265Settings.setter(Builder::minIInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minIInterval").build()}).build();
    private static final SdkField<Integer> PAR_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParDenominator").getter(H265Settings.getter(H265Settings::parDenominator)).setter(H265Settings.setter(Builder::parDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parDenominator").build()}).build();
    private static final SdkField<Integer> PAR_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParNumerator").getter(H265Settings.getter(H265Settings::parNumerator)).setter(H265Settings.setter(Builder::parNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parNumerator").build()}).build();
    private static final SdkField<String> PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Profile").getter(H265Settings.getter(H265Settings::profileAsString)).setter(H265Settings.setter(Builder::profile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()}).build();
    private static final SdkField<Integer> QVBR_QUALITY_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("QvbrQualityLevel").getter(H265Settings.getter(H265Settings::qvbrQualityLevel)).setter(H265Settings.setter(Builder::qvbrQualityLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qvbrQualityLevel").build()}).build();
    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RateControlMode").getter(H265Settings.getter(H265Settings::rateControlModeAsString)).setter(H265Settings.setter(Builder::rateControlMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()}).build();
    private static final SdkField<String> SCAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanType").getter(H265Settings.getter(H265Settings::scanTypeAsString)).setter(H265Settings.setter(Builder::scanType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build()}).build();
    private static final SdkField<String> SCENE_CHANGE_DETECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SceneChangeDetect").getter(H265Settings.getter(H265Settings::sceneChangeDetectAsString)).setter(H265Settings.setter(Builder::sceneChangeDetect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneChangeDetect").build()}).build();
    private static final SdkField<Integer> SLICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Slices").getter(H265Settings.getter(H265Settings::slices)).setter(H265Settings.setter(Builder::slices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slices").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tier").getter(H265Settings.getter(H265Settings::tierAsString)).setter(H265Settings.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()}).build();
    private static final SdkField<String> TIMECODE_INSERTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimecodeInsertion").getter(H265Settings.getter(H265Settings::timecodeInsertionAsString)).setter(H265Settings.setter(Builder::timecodeInsertion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeInsertion").build()}).build();
    private static final SdkField<TimecodeBurninSettings> TIMECODE_BURNIN_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimecodeBurninSettings").getter(H265Settings.getter(H265Settings::timecodeBurninSettings)).setter(H265Settings.setter(Builder::timecodeBurninSettings)).constructor(TimecodeBurninSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeBurninSettings").build()}).build();
    private static final SdkField<String> MV_OVER_PICTURE_BOUNDARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MvOverPictureBoundaries").getter(H265Settings.getter(H265Settings::mvOverPictureBoundariesAsString)).setter(H265Settings.setter(Builder::mvOverPictureBoundaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mvOverPictureBoundaries").build()}).build();
    private static final SdkField<String> MV_TEMPORAL_PREDICTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MvTemporalPredictor").getter(H265Settings.getter(H265Settings::mvTemporalPredictorAsString)).setter(H265Settings.setter(Builder::mvTemporalPredictor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mvTemporalPredictor").build()}).build();
    private static final SdkField<Integer> TILE_HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TileHeight").getter(H265Settings.getter(H265Settings::tileHeight)).setter(H265Settings.setter(Builder::tileHeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tileHeight").build()}).build();
    private static final SdkField<String> TILE_PADDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TilePadding").getter(H265Settings.getter(H265Settings::tilePaddingAsString)).setter(H265Settings.setter(Builder::tilePadding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tilePadding").build()}).build();
    private static final SdkField<Integer> TILE_WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TileWidth").getter(H265Settings.getter(H265Settings::tileWidth)).setter(H265Settings.setter(Builder::tileWidth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tileWidth").build()}).build();
    private static final SdkField<String> TREEBLOCK_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TreeblockSize").getter(H265Settings.getter(H265Settings::treeblockSizeAsString)).setter(H265Settings.setter(Builder::treeblockSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treeblockSize").build()}).build();
    private static final SdkField<Integer> MIN_QP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinQp").getter(H265Settings.getter(H265Settings::minQp)).setter(H265Settings.setter(Builder::minQp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minQp").build()}).build();
    private static final SdkField<String> DEBLOCKING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Deblocking").getter(H265Settings.getter(H265Settings::deblockingAsString)).setter(H265Settings.setter(Builder::deblocking)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deblocking").build()}).build();
    private static final SdkField<String> GOP_B_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GopBReference").getter(H265Settings.getter(H265Settings::gopBReferenceAsString)).setter(H265Settings.setter(Builder::gopBReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopBReference").build()}).build();
    private static final SdkField<Integer> GOP_NUM_B_FRAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GopNumBFrames").getter(H265Settings.getter(H265Settings::gopNumBFrames)).setter(H265Settings.setter(Builder::gopNumBFrames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopNumBFrames").build()}).build();
    private static final SdkField<Integer> MIN_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinBitrate").getter(H265Settings.getter(H265Settings::minBitrate)).setter(H265Settings.setter(Builder::minBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minBitrate").build()}).build();
    private static final SdkField<String> SUBGOP_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubgopLength").getter(H265Settings.getter(H265Settings::subgopLengthAsString)).setter(H265Settings.setter(Builder::subgopLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subgopLength").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTIVE_QUANTIZATION_FIELD, AFD_SIGNALING_FIELD, ALTERNATIVE_TRANSFER_FUNCTION_FIELD, BITRATE_FIELD, BUF_SIZE_FIELD, COLOR_METADATA_FIELD, COLOR_SPACE_SETTINGS_FIELD, FILTER_SETTINGS_FIELD, FIXED_AFD_FIELD, FLICKER_AQ_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD, GOP_CLOSED_CADENCE_FIELD, GOP_SIZE_FIELD, GOP_SIZE_UNITS_FIELD, LEVEL_FIELD, LOOK_AHEAD_RATE_CONTROL_FIELD, MAX_BITRATE_FIELD, MIN_I_INTERVAL_FIELD, PAR_DENOMINATOR_FIELD, PAR_NUMERATOR_FIELD, PROFILE_FIELD, QVBR_QUALITY_LEVEL_FIELD, RATE_CONTROL_MODE_FIELD, SCAN_TYPE_FIELD, SCENE_CHANGE_DETECT_FIELD, SLICES_FIELD, TIER_FIELD, TIMECODE_INSERTION_FIELD, TIMECODE_BURNIN_SETTINGS_FIELD, MV_OVER_PICTURE_BOUNDARIES_FIELD, MV_TEMPORAL_PREDICTOR_FIELD, TILE_HEIGHT_FIELD, TILE_PADDING_FIELD, TILE_WIDTH_FIELD, TREEBLOCK_SIZE_FIELD, MIN_QP_FIELD, DEBLOCKING_FIELD, GOP_B_REFERENCE_FIELD, GOP_NUM_B_FRAMES_FIELD, MIN_BITRATE_FIELD, SUBGOP_LENGTH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = H265Settings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String adaptiveQuantization;
    private final String afdSignaling;
    private final String alternativeTransferFunction;
    private final Integer bitrate;
    private final Integer bufSize;
    private final String colorMetadata;
    private final H265ColorSpaceSettings colorSpaceSettings;
    private final H265FilterSettings filterSettings;
    private final String fixedAfd;
    private final String flickerAq;
    private final Integer framerateDenominator;
    private final Integer framerateNumerator;
    private final Integer gopClosedCadence;
    private final Double gopSize;
    private final String gopSizeUnits;
    private final String level;
    private final String lookAheadRateControl;
    private final Integer maxBitrate;
    private final Integer minIInterval;
    private final Integer parDenominator;
    private final Integer parNumerator;
    private final String profile;
    private final Integer qvbrQualityLevel;
    private final String rateControlMode;
    private final String scanType;
    private final String sceneChangeDetect;
    private final Integer slices;
    private final String tier;
    private final String timecodeInsertion;
    private final TimecodeBurninSettings timecodeBurninSettings;
    private final String mvOverPictureBoundaries;
    private final String mvTemporalPredictor;
    private final Integer tileHeight;
    private final String tilePadding;
    private final Integer tileWidth;
    private final String treeblockSize;
    private final Integer minQp;
    private final String deblocking;
    private final String gopBReference;
    private final Integer gopNumBFrames;
    private final Integer minBitrate;
    private final String subgopLength;

    private H265Settings(BuilderImpl builder) {
        this.adaptiveQuantization = builder.adaptiveQuantization;
        this.afdSignaling = builder.afdSignaling;
        this.alternativeTransferFunction = builder.alternativeTransferFunction;
        this.bitrate = builder.bitrate;
        this.bufSize = builder.bufSize;
        this.colorMetadata = builder.colorMetadata;
        this.colorSpaceSettings = builder.colorSpaceSettings;
        this.filterSettings = builder.filterSettings;
        this.fixedAfd = builder.fixedAfd;
        this.flickerAq = builder.flickerAq;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopClosedCadence = builder.gopClosedCadence;
        this.gopSize = builder.gopSize;
        this.gopSizeUnits = builder.gopSizeUnits;
        this.level = builder.level;
        this.lookAheadRateControl = builder.lookAheadRateControl;
        this.maxBitrate = builder.maxBitrate;
        this.minIInterval = builder.minIInterval;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.profile = builder.profile;
        this.qvbrQualityLevel = builder.qvbrQualityLevel;
        this.rateControlMode = builder.rateControlMode;
        this.scanType = builder.scanType;
        this.sceneChangeDetect = builder.sceneChangeDetect;
        this.slices = builder.slices;
        this.tier = builder.tier;
        this.timecodeInsertion = builder.timecodeInsertion;
        this.timecodeBurninSettings = builder.timecodeBurninSettings;
        this.mvOverPictureBoundaries = builder.mvOverPictureBoundaries;
        this.mvTemporalPredictor = builder.mvTemporalPredictor;
        this.tileHeight = builder.tileHeight;
        this.tilePadding = builder.tilePadding;
        this.tileWidth = builder.tileWidth;
        this.treeblockSize = builder.treeblockSize;
        this.minQp = builder.minQp;
        this.deblocking = builder.deblocking;
        this.gopBReference = builder.gopBReference;
        this.gopNumBFrames = builder.gopNumBFrames;
        this.minBitrate = builder.minBitrate;
        this.subgopLength = builder.subgopLength;
    }

    public final H265AdaptiveQuantization adaptiveQuantization() {
        return H265AdaptiveQuantization.fromValue(this.adaptiveQuantization);
    }

    public final String adaptiveQuantizationAsString() {
        return this.adaptiveQuantization;
    }

    public final AfdSignaling afdSignaling() {
        return AfdSignaling.fromValue(this.afdSignaling);
    }

    public final String afdSignalingAsString() {
        return this.afdSignaling;
    }

    public final H265AlternativeTransferFunction alternativeTransferFunction() {
        return H265AlternativeTransferFunction.fromValue(this.alternativeTransferFunction);
    }

    public final String alternativeTransferFunctionAsString() {
        return this.alternativeTransferFunction;
    }

    public final Integer bitrate() {
        return this.bitrate;
    }

    public final Integer bufSize() {
        return this.bufSize;
    }

    public final H265ColorMetadata colorMetadata() {
        return H265ColorMetadata.fromValue(this.colorMetadata);
    }

    public final String colorMetadataAsString() {
        return this.colorMetadata;
    }

    public final H265ColorSpaceSettings colorSpaceSettings() {
        return this.colorSpaceSettings;
    }

    public final H265FilterSettings filterSettings() {
        return this.filterSettings;
    }

    public final FixedAfd fixedAfd() {
        return FixedAfd.fromValue(this.fixedAfd);
    }

    public final String fixedAfdAsString() {
        return this.fixedAfd;
    }

    public final H265FlickerAq flickerAq() {
        return H265FlickerAq.fromValue(this.flickerAq);
    }

    public final String flickerAqAsString() {
        return this.flickerAq;
    }

    public final Integer framerateDenominator() {
        return this.framerateDenominator;
    }

    public final Integer framerateNumerator() {
        return this.framerateNumerator;
    }

    public final Integer gopClosedCadence() {
        return this.gopClosedCadence;
    }

    public final Double gopSize() {
        return this.gopSize;
    }

    public final H265GopSizeUnits gopSizeUnits() {
        return H265GopSizeUnits.fromValue(this.gopSizeUnits);
    }

    public final String gopSizeUnitsAsString() {
        return this.gopSizeUnits;
    }

    public final H265Level level() {
        return H265Level.fromValue(this.level);
    }

    public final String levelAsString() {
        return this.level;
    }

    public final H265LookAheadRateControl lookAheadRateControl() {
        return H265LookAheadRateControl.fromValue(this.lookAheadRateControl);
    }

    public final String lookAheadRateControlAsString() {
        return this.lookAheadRateControl;
    }

    public final Integer maxBitrate() {
        return this.maxBitrate;
    }

    public final Integer minIInterval() {
        return this.minIInterval;
    }

    public final Integer parDenominator() {
        return this.parDenominator;
    }

    public final Integer parNumerator() {
        return this.parNumerator;
    }

    public final H265Profile profile() {
        return H265Profile.fromValue(this.profile);
    }

    public final String profileAsString() {
        return this.profile;
    }

    public final Integer qvbrQualityLevel() {
        return this.qvbrQualityLevel;
    }

    public final H265RateControlMode rateControlMode() {
        return H265RateControlMode.fromValue(this.rateControlMode);
    }

    public final String rateControlModeAsString() {
        return this.rateControlMode;
    }

    public final H265ScanType scanType() {
        return H265ScanType.fromValue(this.scanType);
    }

    public final String scanTypeAsString() {
        return this.scanType;
    }

    public final H265SceneChangeDetect sceneChangeDetect() {
        return H265SceneChangeDetect.fromValue(this.sceneChangeDetect);
    }

    public final String sceneChangeDetectAsString() {
        return this.sceneChangeDetect;
    }

    public final Integer slices() {
        return this.slices;
    }

    public final H265Tier tier() {
        return H265Tier.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    public final H265TimecodeInsertionBehavior timecodeInsertion() {
        return H265TimecodeInsertionBehavior.fromValue(this.timecodeInsertion);
    }

    public final String timecodeInsertionAsString() {
        return this.timecodeInsertion;
    }

    public final TimecodeBurninSettings timecodeBurninSettings() {
        return this.timecodeBurninSettings;
    }

    public final H265MvOverPictureBoundaries mvOverPictureBoundaries() {
        return H265MvOverPictureBoundaries.fromValue(this.mvOverPictureBoundaries);
    }

    public final String mvOverPictureBoundariesAsString() {
        return this.mvOverPictureBoundaries;
    }

    public final H265MvTemporalPredictor mvTemporalPredictor() {
        return H265MvTemporalPredictor.fromValue(this.mvTemporalPredictor);
    }

    public final String mvTemporalPredictorAsString() {
        return this.mvTemporalPredictor;
    }

    public final Integer tileHeight() {
        return this.tileHeight;
    }

    public final H265TilePadding tilePadding() {
        return H265TilePadding.fromValue(this.tilePadding);
    }

    public final String tilePaddingAsString() {
        return this.tilePadding;
    }

    public final Integer tileWidth() {
        return this.tileWidth;
    }

    public final H265TreeblockSize treeblockSize() {
        return H265TreeblockSize.fromValue(this.treeblockSize);
    }

    public final String treeblockSizeAsString() {
        return this.treeblockSize;
    }

    public final Integer minQp() {
        return this.minQp;
    }

    public final H265Deblocking deblocking() {
        return H265Deblocking.fromValue(this.deblocking);
    }

    public final String deblockingAsString() {
        return this.deblocking;
    }

    public final H265GopBReference gopBReference() {
        return H265GopBReference.fromValue(this.gopBReference);
    }

    public final String gopBReferenceAsString() {
        return this.gopBReference;
    }

    public final Integer gopNumBFrames() {
        return this.gopNumBFrames;
    }

    public final Integer minBitrate() {
        return this.minBitrate;
    }

    public final H265SubGopLength subgopLength() {
        return H265SubGopLength.fromValue(this.subgopLength);
    }

    public final String subgopLengthAsString() {
        return this.subgopLength;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.afdSignalingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.alternativeTransferFunctionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorMetadataAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSpaceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedAfdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.flickerAqAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopClosedCadence());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSizeUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookAheadRateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.minIInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.qvbrQualityLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sceneChangeDetectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slices());
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timecodeInsertionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timecodeBurninSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mvOverPictureBoundariesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mvTemporalPredictorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tileHeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.tilePaddingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tileWidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.treeblockSizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minQp());
        hashCode = 31 * hashCode + Objects.hashCode(this.deblockingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopBReferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopNumBFrames());
        hashCode = 31 * hashCode + Objects.hashCode(this.minBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.subgopLengthAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof H265Settings)) {
            return false;
        }
        H265Settings other = (H265Settings)obj;
        return Objects.equals(this.adaptiveQuantizationAsString(), other.adaptiveQuantizationAsString()) && Objects.equals(this.afdSignalingAsString(), other.afdSignalingAsString()) && Objects.equals(this.alternativeTransferFunctionAsString(), other.alternativeTransferFunctionAsString()) && Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.bufSize(), other.bufSize()) && Objects.equals(this.colorMetadataAsString(), other.colorMetadataAsString()) && Objects.equals(this.colorSpaceSettings(), other.colorSpaceSettings()) && Objects.equals(this.filterSettings(), other.filterSettings()) && Objects.equals(this.fixedAfdAsString(), other.fixedAfdAsString()) && Objects.equals(this.flickerAqAsString(), other.flickerAqAsString()) && Objects.equals(this.framerateDenominator(), other.framerateDenominator()) && Objects.equals(this.framerateNumerator(), other.framerateNumerator()) && Objects.equals(this.gopClosedCadence(), other.gopClosedCadence()) && Objects.equals(this.gopSize(), other.gopSize()) && Objects.equals(this.gopSizeUnitsAsString(), other.gopSizeUnitsAsString()) && Objects.equals(this.levelAsString(), other.levelAsString()) && Objects.equals(this.lookAheadRateControlAsString(), other.lookAheadRateControlAsString()) && Objects.equals(this.maxBitrate(), other.maxBitrate()) && Objects.equals(this.minIInterval(), other.minIInterval()) && Objects.equals(this.parDenominator(), other.parDenominator()) && Objects.equals(this.parNumerator(), other.parNumerator()) && Objects.equals(this.profileAsString(), other.profileAsString()) && Objects.equals(this.qvbrQualityLevel(), other.qvbrQualityLevel()) && Objects.equals(this.rateControlModeAsString(), other.rateControlModeAsString()) && Objects.equals(this.scanTypeAsString(), other.scanTypeAsString()) && Objects.equals(this.sceneChangeDetectAsString(), other.sceneChangeDetectAsString()) && Objects.equals(this.slices(), other.slices()) && Objects.equals(this.tierAsString(), other.tierAsString()) && Objects.equals(this.timecodeInsertionAsString(), other.timecodeInsertionAsString()) && Objects.equals(this.timecodeBurninSettings(), other.timecodeBurninSettings()) && Objects.equals(this.mvOverPictureBoundariesAsString(), other.mvOverPictureBoundariesAsString()) && Objects.equals(this.mvTemporalPredictorAsString(), other.mvTemporalPredictorAsString()) && Objects.equals(this.tileHeight(), other.tileHeight()) && Objects.equals(this.tilePaddingAsString(), other.tilePaddingAsString()) && Objects.equals(this.tileWidth(), other.tileWidth()) && Objects.equals(this.treeblockSizeAsString(), other.treeblockSizeAsString()) && Objects.equals(this.minQp(), other.minQp()) && Objects.equals(this.deblockingAsString(), other.deblockingAsString()) && Objects.equals(this.gopBReferenceAsString(), other.gopBReferenceAsString()) && Objects.equals(this.gopNumBFrames(), other.gopNumBFrames()) && Objects.equals(this.minBitrate(), other.minBitrate()) && Objects.equals(this.subgopLengthAsString(), other.subgopLengthAsString());
    }

    public final String toString() {
        return ToString.builder((String)"H265Settings").add("AdaptiveQuantization", (Object)this.adaptiveQuantizationAsString()).add("AfdSignaling", (Object)this.afdSignalingAsString()).add("AlternativeTransferFunction", (Object)this.alternativeTransferFunctionAsString()).add("Bitrate", (Object)this.bitrate()).add("BufSize", (Object)this.bufSize()).add("ColorMetadata", (Object)this.colorMetadataAsString()).add("ColorSpaceSettings", (Object)this.colorSpaceSettings()).add("FilterSettings", (Object)this.filterSettings()).add("FixedAfd", (Object)this.fixedAfdAsString()).add("FlickerAq", (Object)this.flickerAqAsString()).add("FramerateDenominator", (Object)this.framerateDenominator()).add("FramerateNumerator", (Object)this.framerateNumerator()).add("GopClosedCadence", (Object)this.gopClosedCadence()).add("GopSize", (Object)this.gopSize()).add("GopSizeUnits", (Object)this.gopSizeUnitsAsString()).add("Level", (Object)this.levelAsString()).add("LookAheadRateControl", (Object)this.lookAheadRateControlAsString()).add("MaxBitrate", (Object)this.maxBitrate()).add("MinIInterval", (Object)this.minIInterval()).add("ParDenominator", (Object)this.parDenominator()).add("ParNumerator", (Object)this.parNumerator()).add("Profile", (Object)this.profileAsString()).add("QvbrQualityLevel", (Object)this.qvbrQualityLevel()).add("RateControlMode", (Object)this.rateControlModeAsString()).add("ScanType", (Object)this.scanTypeAsString()).add("SceneChangeDetect", (Object)this.sceneChangeDetectAsString()).add("Slices", (Object)this.slices()).add("Tier", (Object)this.tierAsString()).add("TimecodeInsertion", (Object)this.timecodeInsertionAsString()).add("TimecodeBurninSettings", (Object)this.timecodeBurninSettings()).add("MvOverPictureBoundaries", (Object)this.mvOverPictureBoundariesAsString()).add("MvTemporalPredictor", (Object)this.mvTemporalPredictorAsString()).add("TileHeight", (Object)this.tileHeight()).add("TilePadding", (Object)this.tilePaddingAsString()).add("TileWidth", (Object)this.tileWidth()).add("TreeblockSize", (Object)this.treeblockSizeAsString()).add("MinQp", (Object)this.minQp()).add("Deblocking", (Object)this.deblockingAsString()).add("GopBReference", (Object)this.gopBReferenceAsString()).add("GopNumBFrames", (Object)this.gopNumBFrames()).add("MinBitrate", (Object)this.minBitrate()).add("SubgopLength", (Object)this.subgopLengthAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.adaptiveQuantizationAsString()));
            }
            case "AfdSignaling": {
                return Optional.ofNullable(clazz.cast(this.afdSignalingAsString()));
            }
            case "AlternativeTransferFunction": {
                return Optional.ofNullable(clazz.cast(this.alternativeTransferFunctionAsString()));
            }
            case "Bitrate": {
                return Optional.ofNullable(clazz.cast(this.bitrate()));
            }
            case "BufSize": {
                return Optional.ofNullable(clazz.cast(this.bufSize()));
            }
            case "ColorMetadata": {
                return Optional.ofNullable(clazz.cast(this.colorMetadataAsString()));
            }
            case "ColorSpaceSettings": {
                return Optional.ofNullable(clazz.cast(this.colorSpaceSettings()));
            }
            case "FilterSettings": {
                return Optional.ofNullable(clazz.cast(this.filterSettings()));
            }
            case "FixedAfd": {
                return Optional.ofNullable(clazz.cast(this.fixedAfdAsString()));
            }
            case "FlickerAq": {
                return Optional.ofNullable(clazz.cast(this.flickerAqAsString()));
            }
            case "FramerateDenominator": {
                return Optional.ofNullable(clazz.cast(this.framerateDenominator()));
            }
            case "FramerateNumerator": {
                return Optional.ofNullable(clazz.cast(this.framerateNumerator()));
            }
            case "GopClosedCadence": {
                return Optional.ofNullable(clazz.cast(this.gopClosedCadence()));
            }
            case "GopSize": {
                return Optional.ofNullable(clazz.cast(this.gopSize()));
            }
            case "GopSizeUnits": {
                return Optional.ofNullable(clazz.cast(this.gopSizeUnitsAsString()));
            }
            case "Level": {
                return Optional.ofNullable(clazz.cast(this.levelAsString()));
            }
            case "LookAheadRateControl": {
                return Optional.ofNullable(clazz.cast(this.lookAheadRateControlAsString()));
            }
            case "MaxBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxBitrate()));
            }
            case "MinIInterval": {
                return Optional.ofNullable(clazz.cast(this.minIInterval()));
            }
            case "ParDenominator": {
                return Optional.ofNullable(clazz.cast(this.parDenominator()));
            }
            case "ParNumerator": {
                return Optional.ofNullable(clazz.cast(this.parNumerator()));
            }
            case "Profile": {
                return Optional.ofNullable(clazz.cast(this.profileAsString()));
            }
            case "QvbrQualityLevel": {
                return Optional.ofNullable(clazz.cast(this.qvbrQualityLevel()));
            }
            case "RateControlMode": {
                return Optional.ofNullable(clazz.cast(this.rateControlModeAsString()));
            }
            case "ScanType": {
                return Optional.ofNullable(clazz.cast(this.scanTypeAsString()));
            }
            case "SceneChangeDetect": {
                return Optional.ofNullable(clazz.cast(this.sceneChangeDetectAsString()));
            }
            case "Slices": {
                return Optional.ofNullable(clazz.cast(this.slices()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "TimecodeInsertion": {
                return Optional.ofNullable(clazz.cast(this.timecodeInsertionAsString()));
            }
            case "TimecodeBurninSettings": {
                return Optional.ofNullable(clazz.cast(this.timecodeBurninSettings()));
            }
            case "MvOverPictureBoundaries": {
                return Optional.ofNullable(clazz.cast(this.mvOverPictureBoundariesAsString()));
            }
            case "MvTemporalPredictor": {
                return Optional.ofNullable(clazz.cast(this.mvTemporalPredictorAsString()));
            }
            case "TileHeight": {
                return Optional.ofNullable(clazz.cast(this.tileHeight()));
            }
            case "TilePadding": {
                return Optional.ofNullable(clazz.cast(this.tilePaddingAsString()));
            }
            case "TileWidth": {
                return Optional.ofNullable(clazz.cast(this.tileWidth()));
            }
            case "TreeblockSize": {
                return Optional.ofNullable(clazz.cast(this.treeblockSizeAsString()));
            }
            case "MinQp": {
                return Optional.ofNullable(clazz.cast(this.minQp()));
            }
            case "Deblocking": {
                return Optional.ofNullable(clazz.cast(this.deblockingAsString()));
            }
            case "GopBReference": {
                return Optional.ofNullable(clazz.cast(this.gopBReferenceAsString()));
            }
            case "GopNumBFrames": {
                return Optional.ofNullable(clazz.cast(this.gopNumBFrames()));
            }
            case "MinBitrate": {
                return Optional.ofNullable(clazz.cast(this.minBitrate()));
            }
            case "SubgopLength": {
                return Optional.ofNullable(clazz.cast(this.subgopLengthAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("adaptiveQuantization", ADAPTIVE_QUANTIZATION_FIELD);
        map.put("afdSignaling", AFD_SIGNALING_FIELD);
        map.put("alternativeTransferFunction", ALTERNATIVE_TRANSFER_FUNCTION_FIELD);
        map.put("bitrate", BITRATE_FIELD);
        map.put("bufSize", BUF_SIZE_FIELD);
        map.put("colorMetadata", COLOR_METADATA_FIELD);
        map.put("colorSpaceSettings", COLOR_SPACE_SETTINGS_FIELD);
        map.put("filterSettings", FILTER_SETTINGS_FIELD);
        map.put("fixedAfd", FIXED_AFD_FIELD);
        map.put("flickerAq", FLICKER_AQ_FIELD);
        map.put("framerateDenominator", FRAMERATE_DENOMINATOR_FIELD);
        map.put("framerateNumerator", FRAMERATE_NUMERATOR_FIELD);
        map.put("gopClosedCadence", GOP_CLOSED_CADENCE_FIELD);
        map.put("gopSize", GOP_SIZE_FIELD);
        map.put("gopSizeUnits", GOP_SIZE_UNITS_FIELD);
        map.put("level", LEVEL_FIELD);
        map.put("lookAheadRateControl", LOOK_AHEAD_RATE_CONTROL_FIELD);
        map.put("maxBitrate", MAX_BITRATE_FIELD);
        map.put("minIInterval", MIN_I_INTERVAL_FIELD);
        map.put("parDenominator", PAR_DENOMINATOR_FIELD);
        map.put("parNumerator", PAR_NUMERATOR_FIELD);
        map.put("profile", PROFILE_FIELD);
        map.put("qvbrQualityLevel", QVBR_QUALITY_LEVEL_FIELD);
        map.put("rateControlMode", RATE_CONTROL_MODE_FIELD);
        map.put("scanType", SCAN_TYPE_FIELD);
        map.put("sceneChangeDetect", SCENE_CHANGE_DETECT_FIELD);
        map.put("slices", SLICES_FIELD);
        map.put("tier", TIER_FIELD);
        map.put("timecodeInsertion", TIMECODE_INSERTION_FIELD);
        map.put("timecodeBurninSettings", TIMECODE_BURNIN_SETTINGS_FIELD);
        map.put("mvOverPictureBoundaries", MV_OVER_PICTURE_BOUNDARIES_FIELD);
        map.put("mvTemporalPredictor", MV_TEMPORAL_PREDICTOR_FIELD);
        map.put("tileHeight", TILE_HEIGHT_FIELD);
        map.put("tilePadding", TILE_PADDING_FIELD);
        map.put("tileWidth", TILE_WIDTH_FIELD);
        map.put("treeblockSize", TREEBLOCK_SIZE_FIELD);
        map.put("minQp", MIN_QP_FIELD);
        map.put("deblocking", DEBLOCKING_FIELD);
        map.put("gopBReference", GOP_B_REFERENCE_FIELD);
        map.put("gopNumBFrames", GOP_NUM_B_FRAMES_FIELD);
        map.put("minBitrate", MIN_BITRATE_FIELD);
        map.put("subgopLength", SUBGOP_LENGTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<H265Settings, T> g) {
        return obj -> g.apply((H265Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adaptiveQuantization;
        private String afdSignaling;
        private String alternativeTransferFunction;
        private Integer bitrate;
        private Integer bufSize;
        private String colorMetadata;
        private H265ColorSpaceSettings colorSpaceSettings;
        private H265FilterSettings filterSettings;
        private String fixedAfd;
        private String flickerAq;
        private Integer framerateDenominator;
        private Integer framerateNumerator;
        private Integer gopClosedCadence;
        private Double gopSize;
        private String gopSizeUnits;
        private String level;
        private String lookAheadRateControl;
        private Integer maxBitrate;
        private Integer minIInterval;
        private Integer parDenominator;
        private Integer parNumerator;
        private String profile;
        private Integer qvbrQualityLevel;
        private String rateControlMode;
        private String scanType;
        private String sceneChangeDetect;
        private Integer slices;
        private String tier;
        private String timecodeInsertion;
        private TimecodeBurninSettings timecodeBurninSettings;
        private String mvOverPictureBoundaries;
        private String mvTemporalPredictor;
        private Integer tileHeight;
        private String tilePadding;
        private Integer tileWidth;
        private String treeblockSize;
        private Integer minQp;
        private String deblocking;
        private String gopBReference;
        private Integer gopNumBFrames;
        private Integer minBitrate;
        private String subgopLength;

        private BuilderImpl() {
        }

        private BuilderImpl(H265Settings model) {
            this.adaptiveQuantization(model.adaptiveQuantization);
            this.afdSignaling(model.afdSignaling);
            this.alternativeTransferFunction(model.alternativeTransferFunction);
            this.bitrate(model.bitrate);
            this.bufSize(model.bufSize);
            this.colorMetadata(model.colorMetadata);
            this.colorSpaceSettings(model.colorSpaceSettings);
            this.filterSettings(model.filterSettings);
            this.fixedAfd(model.fixedAfd);
            this.flickerAq(model.flickerAq);
            this.framerateDenominator(model.framerateDenominator);
            this.framerateNumerator(model.framerateNumerator);
            this.gopClosedCadence(model.gopClosedCadence);
            this.gopSize(model.gopSize);
            this.gopSizeUnits(model.gopSizeUnits);
            this.level(model.level);
            this.lookAheadRateControl(model.lookAheadRateControl);
            this.maxBitrate(model.maxBitrate);
            this.minIInterval(model.minIInterval);
            this.parDenominator(model.parDenominator);
            this.parNumerator(model.parNumerator);
            this.profile(model.profile);
            this.qvbrQualityLevel(model.qvbrQualityLevel);
            this.rateControlMode(model.rateControlMode);
            this.scanType(model.scanType);
            this.sceneChangeDetect(model.sceneChangeDetect);
            this.slices(model.slices);
            this.tier(model.tier);
            this.timecodeInsertion(model.timecodeInsertion);
            this.timecodeBurninSettings(model.timecodeBurninSettings);
            this.mvOverPictureBoundaries(model.mvOverPictureBoundaries);
            this.mvTemporalPredictor(model.mvTemporalPredictor);
            this.tileHeight(model.tileHeight);
            this.tilePadding(model.tilePadding);
            this.tileWidth(model.tileWidth);
            this.treeblockSize(model.treeblockSize);
            this.minQp(model.minQp);
            this.deblocking(model.deblocking);
            this.gopBReference(model.gopBReference);
            this.gopNumBFrames(model.gopNumBFrames);
            this.minBitrate(model.minBitrate);
            this.subgopLength(model.subgopLength);
        }

        public final String getAdaptiveQuantization() {
            return this.adaptiveQuantization;
        }

        public final void setAdaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
        }

        @Override
        public final Builder adaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
            return this;
        }

        @Override
        public final Builder adaptiveQuantization(H265AdaptiveQuantization adaptiveQuantization) {
            this.adaptiveQuantization(adaptiveQuantization == null ? null : adaptiveQuantization.toString());
            return this;
        }

        public final String getAfdSignaling() {
            return this.afdSignaling;
        }

        public final void setAfdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
        }

        @Override
        public final Builder afdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
            return this;
        }

        @Override
        public final Builder afdSignaling(AfdSignaling afdSignaling) {
            this.afdSignaling(afdSignaling == null ? null : afdSignaling.toString());
            return this;
        }

        public final String getAlternativeTransferFunction() {
            return this.alternativeTransferFunction;
        }

        public final void setAlternativeTransferFunction(String alternativeTransferFunction) {
            this.alternativeTransferFunction = alternativeTransferFunction;
        }

        @Override
        public final Builder alternativeTransferFunction(String alternativeTransferFunction) {
            this.alternativeTransferFunction = alternativeTransferFunction;
            return this;
        }

        @Override
        public final Builder alternativeTransferFunction(H265AlternativeTransferFunction alternativeTransferFunction) {
            this.alternativeTransferFunction(alternativeTransferFunction == null ? null : alternativeTransferFunction.toString());
            return this;
        }

        public final Integer getBitrate() {
            return this.bitrate;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final Integer getBufSize() {
            return this.bufSize;
        }

        public final void setBufSize(Integer bufSize) {
            this.bufSize = bufSize;
        }

        @Override
        public final Builder bufSize(Integer bufSize) {
            this.bufSize = bufSize;
            return this;
        }

        public final String getColorMetadata() {
            return this.colorMetadata;
        }

        public final void setColorMetadata(String colorMetadata) {
            this.colorMetadata = colorMetadata;
        }

        @Override
        public final Builder colorMetadata(String colorMetadata) {
            this.colorMetadata = colorMetadata;
            return this;
        }

        @Override
        public final Builder colorMetadata(H265ColorMetadata colorMetadata) {
            this.colorMetadata(colorMetadata == null ? null : colorMetadata.toString());
            return this;
        }

        public final H265ColorSpaceSettings.Builder getColorSpaceSettings() {
            return this.colorSpaceSettings != null ? this.colorSpaceSettings.toBuilder() : null;
        }

        public final void setColorSpaceSettings(H265ColorSpaceSettings.BuilderImpl colorSpaceSettings) {
            this.colorSpaceSettings = colorSpaceSettings != null ? colorSpaceSettings.build() : null;
        }

        @Override
        public final Builder colorSpaceSettings(H265ColorSpaceSettings colorSpaceSettings) {
            this.colorSpaceSettings = colorSpaceSettings;
            return this;
        }

        public final H265FilterSettings.Builder getFilterSettings() {
            return this.filterSettings != null ? this.filterSettings.toBuilder() : null;
        }

        public final void setFilterSettings(H265FilterSettings.BuilderImpl filterSettings) {
            this.filterSettings = filterSettings != null ? filterSettings.build() : null;
        }

        @Override
        public final Builder filterSettings(H265FilterSettings filterSettings) {
            this.filterSettings = filterSettings;
            return this;
        }

        public final String getFixedAfd() {
            return this.fixedAfd;
        }

        public final void setFixedAfd(String fixedAfd) {
            this.fixedAfd = fixedAfd;
        }

        @Override
        public final Builder fixedAfd(String fixedAfd) {
            this.fixedAfd = fixedAfd;
            return this;
        }

        @Override
        public final Builder fixedAfd(FixedAfd fixedAfd) {
            this.fixedAfd(fixedAfd == null ? null : fixedAfd.toString());
            return this;
        }

        public final String getFlickerAq() {
            return this.flickerAq;
        }

        public final void setFlickerAq(String flickerAq) {
            this.flickerAq = flickerAq;
        }

        @Override
        public final Builder flickerAq(String flickerAq) {
            this.flickerAq = flickerAq;
            return this;
        }

        @Override
        public final Builder flickerAq(H265FlickerAq flickerAq) {
            this.flickerAq(flickerAq == null ? null : flickerAq.toString());
            return this;
        }

        public final Integer getFramerateDenominator() {
            return this.framerateDenominator;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final Integer getFramerateNumerator() {
            return this.framerateNumerator;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final Integer getGopClosedCadence() {
            return this.gopClosedCadence;
        }

        public final void setGopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
        }

        @Override
        public final Builder gopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
            return this;
        }

        public final Double getGopSize() {
            return this.gopSize;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        @Override
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final String getGopSizeUnits() {
            return this.gopSizeUnits;
        }

        public final void setGopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
        }

        @Override
        public final Builder gopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
            return this;
        }

        @Override
        public final Builder gopSizeUnits(H265GopSizeUnits gopSizeUnits) {
            this.gopSizeUnits(gopSizeUnits == null ? null : gopSizeUnits.toString());
            return this;
        }

        public final String getLevel() {
            return this.level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(H265Level level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public final String getLookAheadRateControl() {
            return this.lookAheadRateControl;
        }

        public final void setLookAheadRateControl(String lookAheadRateControl) {
            this.lookAheadRateControl = lookAheadRateControl;
        }

        @Override
        public final Builder lookAheadRateControl(String lookAheadRateControl) {
            this.lookAheadRateControl = lookAheadRateControl;
            return this;
        }

        @Override
        public final Builder lookAheadRateControl(H265LookAheadRateControl lookAheadRateControl) {
            this.lookAheadRateControl(lookAheadRateControl == null ? null : lookAheadRateControl.toString());
            return this;
        }

        public final Integer getMaxBitrate() {
            return this.maxBitrate;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final Integer getMinIInterval() {
            return this.minIInterval;
        }

        public final void setMinIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
        }

        @Override
        public final Builder minIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
            return this;
        }

        public final Integer getParDenominator() {
            return this.parDenominator;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        @Override
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final Integer getParNumerator() {
            return this.parNumerator;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        @Override
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final String getProfile() {
            return this.profile;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public final Builder profile(H265Profile profile) {
            this.profile(profile == null ? null : profile.toString());
            return this;
        }

        public final Integer getQvbrQualityLevel() {
            return this.qvbrQualityLevel;
        }

        public final void setQvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
        }

        @Override
        public final Builder qvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
            return this;
        }

        public final String getRateControlMode() {
            return this.rateControlMode;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(H265RateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode == null ? null : rateControlMode.toString());
            return this;
        }

        public final String getScanType() {
            return this.scanType;
        }

        public final void setScanType(String scanType) {
            this.scanType = scanType;
        }

        @Override
        public final Builder scanType(String scanType) {
            this.scanType = scanType;
            return this;
        }

        @Override
        public final Builder scanType(H265ScanType scanType) {
            this.scanType(scanType == null ? null : scanType.toString());
            return this;
        }

        public final String getSceneChangeDetect() {
            return this.sceneChangeDetect;
        }

        public final void setSceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
        }

        @Override
        public final Builder sceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
            return this;
        }

        @Override
        public final Builder sceneChangeDetect(H265SceneChangeDetect sceneChangeDetect) {
            this.sceneChangeDetect(sceneChangeDetect == null ? null : sceneChangeDetect.toString());
            return this;
        }

        public final Integer getSlices() {
            return this.slices;
        }

        public final void setSlices(Integer slices) {
            this.slices = slices;
        }

        @Override
        public final Builder slices(Integer slices) {
            this.slices = slices;
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(H265Tier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final String getTimecodeInsertion() {
            return this.timecodeInsertion;
        }

        public final void setTimecodeInsertion(String timecodeInsertion) {
            this.timecodeInsertion = timecodeInsertion;
        }

        @Override
        public final Builder timecodeInsertion(String timecodeInsertion) {
            this.timecodeInsertion = timecodeInsertion;
            return this;
        }

        @Override
        public final Builder timecodeInsertion(H265TimecodeInsertionBehavior timecodeInsertion) {
            this.timecodeInsertion(timecodeInsertion == null ? null : timecodeInsertion.toString());
            return this;
        }

        public final TimecodeBurninSettings.Builder getTimecodeBurninSettings() {
            return this.timecodeBurninSettings != null ? this.timecodeBurninSettings.toBuilder() : null;
        }

        public final void setTimecodeBurninSettings(TimecodeBurninSettings.BuilderImpl timecodeBurninSettings) {
            this.timecodeBurninSettings = timecodeBurninSettings != null ? timecodeBurninSettings.build() : null;
        }

        @Override
        public final Builder timecodeBurninSettings(TimecodeBurninSettings timecodeBurninSettings) {
            this.timecodeBurninSettings = timecodeBurninSettings;
            return this;
        }

        public final String getMvOverPictureBoundaries() {
            return this.mvOverPictureBoundaries;
        }

        public final void setMvOverPictureBoundaries(String mvOverPictureBoundaries) {
            this.mvOverPictureBoundaries = mvOverPictureBoundaries;
        }

        @Override
        public final Builder mvOverPictureBoundaries(String mvOverPictureBoundaries) {
            this.mvOverPictureBoundaries = mvOverPictureBoundaries;
            return this;
        }

        @Override
        public final Builder mvOverPictureBoundaries(H265MvOverPictureBoundaries mvOverPictureBoundaries) {
            this.mvOverPictureBoundaries(mvOverPictureBoundaries == null ? null : mvOverPictureBoundaries.toString());
            return this;
        }

        public final String getMvTemporalPredictor() {
            return this.mvTemporalPredictor;
        }

        public final void setMvTemporalPredictor(String mvTemporalPredictor) {
            this.mvTemporalPredictor = mvTemporalPredictor;
        }

        @Override
        public final Builder mvTemporalPredictor(String mvTemporalPredictor) {
            this.mvTemporalPredictor = mvTemporalPredictor;
            return this;
        }

        @Override
        public final Builder mvTemporalPredictor(H265MvTemporalPredictor mvTemporalPredictor) {
            this.mvTemporalPredictor(mvTemporalPredictor == null ? null : mvTemporalPredictor.toString());
            return this;
        }

        public final Integer getTileHeight() {
            return this.tileHeight;
        }

        public final void setTileHeight(Integer tileHeight) {
            this.tileHeight = tileHeight;
        }

        @Override
        public final Builder tileHeight(Integer tileHeight) {
            this.tileHeight = tileHeight;
            return this;
        }

        public final String getTilePadding() {
            return this.tilePadding;
        }

        public final void setTilePadding(String tilePadding) {
            this.tilePadding = tilePadding;
        }

        @Override
        public final Builder tilePadding(String tilePadding) {
            this.tilePadding = tilePadding;
            return this;
        }

        @Override
        public final Builder tilePadding(H265TilePadding tilePadding) {
            this.tilePadding(tilePadding == null ? null : tilePadding.toString());
            return this;
        }

        public final Integer getTileWidth() {
            return this.tileWidth;
        }

        public final void setTileWidth(Integer tileWidth) {
            this.tileWidth = tileWidth;
        }

        @Override
        public final Builder tileWidth(Integer tileWidth) {
            this.tileWidth = tileWidth;
            return this;
        }

        public final String getTreeblockSize() {
            return this.treeblockSize;
        }

        public final void setTreeblockSize(String treeblockSize) {
            this.treeblockSize = treeblockSize;
        }

        @Override
        public final Builder treeblockSize(String treeblockSize) {
            this.treeblockSize = treeblockSize;
            return this;
        }

        @Override
        public final Builder treeblockSize(H265TreeblockSize treeblockSize) {
            this.treeblockSize(treeblockSize == null ? null : treeblockSize.toString());
            return this;
        }

        public final Integer getMinQp() {
            return this.minQp;
        }

        public final void setMinQp(Integer minQp) {
            this.minQp = minQp;
        }

        @Override
        public final Builder minQp(Integer minQp) {
            this.minQp = minQp;
            return this;
        }

        public final String getDeblocking() {
            return this.deblocking;
        }

        public final void setDeblocking(String deblocking) {
            this.deblocking = deblocking;
        }

        @Override
        public final Builder deblocking(String deblocking) {
            this.deblocking = deblocking;
            return this;
        }

        @Override
        public final Builder deblocking(H265Deblocking deblocking) {
            this.deblocking(deblocking == null ? null : deblocking.toString());
            return this;
        }

        public final String getGopBReference() {
            return this.gopBReference;
        }

        public final void setGopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
        }

        @Override
        public final Builder gopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
            return this;
        }

        @Override
        public final Builder gopBReference(H265GopBReference gopBReference) {
            this.gopBReference(gopBReference == null ? null : gopBReference.toString());
            return this;
        }

        public final Integer getGopNumBFrames() {
            return this.gopNumBFrames;
        }

        public final void setGopNumBFrames(Integer gopNumBFrames) {
            this.gopNumBFrames = gopNumBFrames;
        }

        @Override
        public final Builder gopNumBFrames(Integer gopNumBFrames) {
            this.gopNumBFrames = gopNumBFrames;
            return this;
        }

        public final Integer getMinBitrate() {
            return this.minBitrate;
        }

        public final void setMinBitrate(Integer minBitrate) {
            this.minBitrate = minBitrate;
        }

        @Override
        public final Builder minBitrate(Integer minBitrate) {
            this.minBitrate = minBitrate;
            return this;
        }

        public final String getSubgopLength() {
            return this.subgopLength;
        }

        public final void setSubgopLength(String subgopLength) {
            this.subgopLength = subgopLength;
        }

        @Override
        public final Builder subgopLength(String subgopLength) {
            this.subgopLength = subgopLength;
            return this;
        }

        @Override
        public final Builder subgopLength(H265SubGopLength subgopLength) {
            this.subgopLength(subgopLength == null ? null : subgopLength.toString());
            return this;
        }

        public H265Settings build() {
            return new H265Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, H265Settings> {
        public Builder adaptiveQuantization(String var1);

        public Builder adaptiveQuantization(H265AdaptiveQuantization var1);

        public Builder afdSignaling(String var1);

        public Builder afdSignaling(AfdSignaling var1);

        public Builder alternativeTransferFunction(String var1);

        public Builder alternativeTransferFunction(H265AlternativeTransferFunction var1);

        public Builder bitrate(Integer var1);

        public Builder bufSize(Integer var1);

        public Builder colorMetadata(String var1);

        public Builder colorMetadata(H265ColorMetadata var1);

        public Builder colorSpaceSettings(H265ColorSpaceSettings var1);

        default public Builder colorSpaceSettings(Consumer<H265ColorSpaceSettings.Builder> colorSpaceSettings) {
            return this.colorSpaceSettings((H265ColorSpaceSettings)((H265ColorSpaceSettings.Builder)H265ColorSpaceSettings.builder().applyMutation(colorSpaceSettings)).build());
        }

        public Builder filterSettings(H265FilterSettings var1);

        default public Builder filterSettings(Consumer<H265FilterSettings.Builder> filterSettings) {
            return this.filterSettings((H265FilterSettings)((H265FilterSettings.Builder)H265FilterSettings.builder().applyMutation(filterSettings)).build());
        }

        public Builder fixedAfd(String var1);

        public Builder fixedAfd(FixedAfd var1);

        public Builder flickerAq(String var1);

        public Builder flickerAq(H265FlickerAq var1);

        public Builder framerateDenominator(Integer var1);

        public Builder framerateNumerator(Integer var1);

        public Builder gopClosedCadence(Integer var1);

        public Builder gopSize(Double var1);

        public Builder gopSizeUnits(String var1);

        public Builder gopSizeUnits(H265GopSizeUnits var1);

        public Builder level(String var1);

        public Builder level(H265Level var1);

        public Builder lookAheadRateControl(String var1);

        public Builder lookAheadRateControl(H265LookAheadRateControl var1);

        public Builder maxBitrate(Integer var1);

        public Builder minIInterval(Integer var1);

        public Builder parDenominator(Integer var1);

        public Builder parNumerator(Integer var1);

        public Builder profile(String var1);

        public Builder profile(H265Profile var1);

        public Builder qvbrQualityLevel(Integer var1);

        public Builder rateControlMode(String var1);

        public Builder rateControlMode(H265RateControlMode var1);

        public Builder scanType(String var1);

        public Builder scanType(H265ScanType var1);

        public Builder sceneChangeDetect(String var1);

        public Builder sceneChangeDetect(H265SceneChangeDetect var1);

        public Builder slices(Integer var1);

        public Builder tier(String var1);

        public Builder tier(H265Tier var1);

        public Builder timecodeInsertion(String var1);

        public Builder timecodeInsertion(H265TimecodeInsertionBehavior var1);

        public Builder timecodeBurninSettings(TimecodeBurninSettings var1);

        default public Builder timecodeBurninSettings(Consumer<TimecodeBurninSettings.Builder> timecodeBurninSettings) {
            return this.timecodeBurninSettings((TimecodeBurninSettings)((TimecodeBurninSettings.Builder)TimecodeBurninSettings.builder().applyMutation(timecodeBurninSettings)).build());
        }

        public Builder mvOverPictureBoundaries(String var1);

        public Builder mvOverPictureBoundaries(H265MvOverPictureBoundaries var1);

        public Builder mvTemporalPredictor(String var1);

        public Builder mvTemporalPredictor(H265MvTemporalPredictor var1);

        public Builder tileHeight(Integer var1);

        public Builder tilePadding(String var1);

        public Builder tilePadding(H265TilePadding var1);

        public Builder tileWidth(Integer var1);

        public Builder treeblockSize(String var1);

        public Builder treeblockSize(H265TreeblockSize var1);

        public Builder minQp(Integer var1);

        public Builder deblocking(String var1);

        public Builder deblocking(H265Deblocking var1);

        public Builder gopBReference(String var1);

        public Builder gopBReference(H265GopBReference var1);

        public Builder gopNumBFrames(Integer var1);

        public Builder minBitrate(Integer var1);

        public Builder subgopLength(String var1);

        public Builder subgopLength(H265SubGopLength var1);
    }
}

