/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.ListMultiplexAlertsRequest;
import software.amazon.awssdk.services.medialive.model.ListMultiplexAlertsResponse;
import software.amazon.awssdk.services.medialive.model.MultiplexAlert;

public class ListMultiplexAlertsIterable
implements SdkIterable<ListMultiplexAlertsResponse> {
    private final MediaLiveClient client;
    private final ListMultiplexAlertsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMultiplexAlertsIterable(MediaLiveClient client, ListMultiplexAlertsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMultiplexAlertsResponseFetcher();
    }

    public Iterator<ListMultiplexAlertsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MultiplexAlert> alerts() {
        Function<ListMultiplexAlertsResponse, Iterator> getIterator = response -> {
            if (response != null && response.alerts() != null) {
                return response.alerts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMultiplexAlertsResponseFetcher
    implements SyncPageFetcher<ListMultiplexAlertsResponse> {
        private ListMultiplexAlertsResponseFetcher() {
        }

        public boolean hasNextPage(ListMultiplexAlertsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMultiplexAlertsResponse nextPage(ListMultiplexAlertsResponse previousPage) {
            if (previousPage == null) {
                return ListMultiplexAlertsIterable.this.client.listMultiplexAlerts(ListMultiplexAlertsIterable.this.firstRequest);
            }
            return ListMultiplexAlertsIterable.this.client.listMultiplexAlerts((ListMultiplexAlertsRequest)((Object)ListMultiplexAlertsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

