/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.mediatailor.model.BadRequestException;
import software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationRequest;
import software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse;
import software.amazon.awssdk.services.mediatailor.model.CreateChannelRequest;
import software.amazon.awssdk.services.mediatailor.model.CreateChannelResponse;
import software.amazon.awssdk.services.mediatailor.model.CreatePrefetchScheduleRequest;
import software.amazon.awssdk.services.mediatailor.model.CreatePrefetchScheduleResponse;
import software.amazon.awssdk.services.mediatailor.model.CreateProgramRequest;
import software.amazon.awssdk.services.mediatailor.model.CreateProgramResponse;
import software.amazon.awssdk.services.mediatailor.model.CreateSourceLocationRequest;
import software.amazon.awssdk.services.mediatailor.model.CreateSourceLocationResponse;
import software.amazon.awssdk.services.mediatailor.model.CreateVodSourceRequest;
import software.amazon.awssdk.services.mediatailor.model.CreateVodSourceResponse;
import software.amazon.awssdk.services.mediatailor.model.DeleteChannelPolicyRequest;
import software.amazon.awssdk.services.mediatailor.model.DeleteChannelPolicyResponse;
import software.amazon.awssdk.services.mediatailor.model.DeleteChannelRequest;
import software.amazon.awssdk.services.mediatailor.model.DeleteChannelResponse;
import software.amazon.awssdk.services.mediatailor.model.DeletePlaybackConfigurationRequest;
import software.amazon.awssdk.services.mediatailor.model.DeletePlaybackConfigurationResponse;
import software.amazon.awssdk.services.mediatailor.model.DeletePrefetchScheduleRequest;
import software.amazon.awssdk.services.mediatailor.model.DeletePrefetchScheduleResponse;
import software.amazon.awssdk.services.mediatailor.model.DeleteProgramRequest;
import software.amazon.awssdk.services.mediatailor.model.DeleteProgramResponse;
import software.amazon.awssdk.services.mediatailor.model.DeleteSourceLocationRequest;
import software.amazon.awssdk.services.mediatailor.model.DeleteSourceLocationResponse;
import software.amazon.awssdk.services.mediatailor.model.DeleteVodSourceRequest;
import software.amazon.awssdk.services.mediatailor.model.DeleteVodSourceResponse;
import software.amazon.awssdk.services.mediatailor.model.DescribeChannelRequest;
import software.amazon.awssdk.services.mediatailor.model.DescribeChannelResponse;
import software.amazon.awssdk.services.mediatailor.model.DescribeProgramRequest;
import software.amazon.awssdk.services.mediatailor.model.DescribeProgramResponse;
import software.amazon.awssdk.services.mediatailor.model.DescribeSourceLocationRequest;
import software.amazon.awssdk.services.mediatailor.model.DescribeSourceLocationResponse;
import software.amazon.awssdk.services.mediatailor.model.DescribeVodSourceRequest;
import software.amazon.awssdk.services.mediatailor.model.DescribeVodSourceResponse;
import software.amazon.awssdk.services.mediatailor.model.GetChannelPolicyRequest;
import software.amazon.awssdk.services.mediatailor.model.GetChannelPolicyResponse;
import software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest;
import software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleResponse;
import software.amazon.awssdk.services.mediatailor.model.GetPlaybackConfigurationRequest;
import software.amazon.awssdk.services.mediatailor.model.GetPlaybackConfigurationResponse;
import software.amazon.awssdk.services.mediatailor.model.GetPrefetchScheduleRequest;
import software.amazon.awssdk.services.mediatailor.model.GetPrefetchScheduleResponse;
import software.amazon.awssdk.services.mediatailor.model.ListAlertsRequest;
import software.amazon.awssdk.services.mediatailor.model.ListAlertsResponse;
import software.amazon.awssdk.services.mediatailor.model.ListChannelsRequest;
import software.amazon.awssdk.services.mediatailor.model.ListChannelsResponse;
import software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsRequest;
import software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsResponse;
import software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest;
import software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesResponse;
import software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsRequest;
import software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsResponse;
import software.amazon.awssdk.services.mediatailor.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mediatailor.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest;
import software.amazon.awssdk.services.mediatailor.model.ListVodSourcesResponse;
import software.amazon.awssdk.services.mediatailor.model.MediaTailorException;
import software.amazon.awssdk.services.mediatailor.model.PutChannelPolicyRequest;
import software.amazon.awssdk.services.mediatailor.model.PutChannelPolicyResponse;
import software.amazon.awssdk.services.mediatailor.model.PutPlaybackConfigurationRequest;
import software.amazon.awssdk.services.mediatailor.model.PutPlaybackConfigurationResponse;
import software.amazon.awssdk.services.mediatailor.model.StartChannelRequest;
import software.amazon.awssdk.services.mediatailor.model.StartChannelResponse;
import software.amazon.awssdk.services.mediatailor.model.StopChannelRequest;
import software.amazon.awssdk.services.mediatailor.model.StopChannelResponse;
import software.amazon.awssdk.services.mediatailor.model.TagResourceRequest;
import software.amazon.awssdk.services.mediatailor.model.TagResourceResponse;
import software.amazon.awssdk.services.mediatailor.model.UntagResourceRequest;
import software.amazon.awssdk.services.mediatailor.model.UntagResourceResponse;
import software.amazon.awssdk.services.mediatailor.model.UpdateChannelRequest;
import software.amazon.awssdk.services.mediatailor.model.UpdateChannelResponse;
import software.amazon.awssdk.services.mediatailor.model.UpdateSourceLocationRequest;
import software.amazon.awssdk.services.mediatailor.model.UpdateSourceLocationResponse;
import software.amazon.awssdk.services.mediatailor.model.UpdateVodSourceRequest;
import software.amazon.awssdk.services.mediatailor.model.UpdateVodSourceResponse;
import software.amazon.awssdk.services.mediatailor.paginators.GetChannelScheduleIterable;
import software.amazon.awssdk.services.mediatailor.paginators.ListAlertsIterable;
import software.amazon.awssdk.services.mediatailor.paginators.ListChannelsIterable;
import software.amazon.awssdk.services.mediatailor.paginators.ListPlaybackConfigurationsIterable;
import software.amazon.awssdk.services.mediatailor.paginators.ListPrefetchSchedulesIterable;
import software.amazon.awssdk.services.mediatailor.paginators.ListSourceLocationsIterable;
import software.amazon.awssdk.services.mediatailor.paginators.ListVodSourcesIterable;

/**
 * Service client for accessing MediaTailor. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Use the AWS Elemental MediaTailor SDKs and CLI to configure scalable ad insertion and linear channels. With
 * MediaTailor, you can assemble existing content into a linear stream and serve targeted ads to viewers while
 * maintaining broadcast quality in over-the-top (OTT) video applications. For information about using the service,
 * including detailed information about the settings covered in this guide, see the <a
 * href="https://docs.aws.amazon.com/mediatailor/latest/ug/">AWS Elemental MediaTailor User Guide</a>.
 * </p>
 * <p>
 * Through the SDKs and the CLI you manage AWS Elemental MediaTailor configurations and channels the same as you do
 * through the console. For example, you specify ad insertion behavior and mapping information for the origin server and
 * the ad decision server (ADS).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MediaTailorClient extends SdkClient {
    String SERVICE_NAME = "mediatailor";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "api.mediatailor";

    /**
     * Create a {@link MediaTailorClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MediaTailorClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MediaTailorClient}.
     */
    static MediaTailorClientBuilder builder() {
        return new DefaultMediaTailorClientBuilder();
    }

    /**
     * <p>
     * Configures Amazon CloudWatch log settings for a playback configuration.
     * </p>
     *
     * @param configureLogsForPlaybackConfigurationRequest
     *        Configures Amazon CloudWatch log settings for a playback configuration.
     * @return Result of the ConfigureLogsForPlaybackConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ConfigureLogsForPlaybackConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ConfigureLogsForPlaybackConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfigureLogsForPlaybackConfigurationResponse configureLogsForPlaybackConfiguration(
            ConfigureLogsForPlaybackConfigurationRequest configureLogsForPlaybackConfigurationRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures Amazon CloudWatch log settings for a playback configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ConfigureLogsForPlaybackConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link ConfigureLogsForPlaybackConfigurationRequest#builder()}
     * </p>
     *
     * @param configureLogsForPlaybackConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link ConfigureLogsForPlaybackConfigurationRequest.Builder}
     *        to create a request. Configures Amazon CloudWatch log settings for a playback configuration.
     * @return Result of the ConfigureLogsForPlaybackConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ConfigureLogsForPlaybackConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ConfigureLogsForPlaybackConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfigureLogsForPlaybackConfigurationResponse configureLogsForPlaybackConfiguration(
            Consumer<ConfigureLogsForPlaybackConfigurationRequest.Builder> configureLogsForPlaybackConfigurationRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return configureLogsForPlaybackConfiguration(ConfigureLogsForPlaybackConfigurationRequest.builder()
                .applyMutation(configureLogsForPlaybackConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a channel.
     * </p>
     *
     * @param createChannelRequest
     * @return Result of the CreateChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateChannelResponse createChannel(CreateChannelRequest createChannelRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateChannelRequest#builder()}
     * </p>
     *
     * @param createChannelRequest
     *        A {@link Consumer} that will call methods on {@link CreateChannelRequest.Builder} to create a request.
     * @return Result of the CreateChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateChannelResponse createChannel(Consumer<CreateChannelRequest.Builder> createChannelRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return createChannel(CreateChannelRequest.builder().applyMutation(createChannelRequest).build());
    }

    /**
     * <p>
     * Creates a new prefetch schedule for the specified playback configuration.
     * </p>
     *
     * @param createPrefetchScheduleRequest
     * @return Result of the CreatePrefetchSchedule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreatePrefetchSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreatePrefetchSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePrefetchScheduleResponse createPrefetchSchedule(CreatePrefetchScheduleRequest createPrefetchScheduleRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new prefetch schedule for the specified playback configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePrefetchScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePrefetchScheduleRequest#builder()}
     * </p>
     *
     * @param createPrefetchScheduleRequest
     *        A {@link Consumer} that will call methods on {@link CreatePrefetchScheduleRequest.Builder} to create a
     *        request.
     * @return Result of the CreatePrefetchSchedule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreatePrefetchSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreatePrefetchSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePrefetchScheduleResponse createPrefetchSchedule(
            Consumer<CreatePrefetchScheduleRequest.Builder> createPrefetchScheduleRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return createPrefetchSchedule(CreatePrefetchScheduleRequest.builder().applyMutation(createPrefetchScheduleRequest)
                .build());
    }

    /**
     * <p>
     * Creates a program.
     * </p>
     *
     * @param createProgramRequest
     * @return Result of the CreateProgram operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreateProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateProgram" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProgramResponse createProgram(CreateProgramRequest createProgramRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a program.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProgramRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProgramRequest#builder()}
     * </p>
     *
     * @param createProgramRequest
     *        A {@link Consumer} that will call methods on {@link CreateProgramRequest.Builder} to create a request.
     * @return Result of the CreateProgram operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreateProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateProgram" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProgramResponse createProgram(Consumer<CreateProgramRequest.Builder> createProgramRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return createProgram(CreateProgramRequest.builder().applyMutation(createProgramRequest).build());
    }

    /**
     * <p>
     * Creates a source location on a specific channel.
     * </p>
     *
     * @param createSourceLocationRequest
     * @return Result of the CreateSourceLocation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreateSourceLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateSourceLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSourceLocationResponse createSourceLocation(CreateSourceLocationRequest createSourceLocationRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a source location on a specific channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSourceLocationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSourceLocationRequest#builder()}
     * </p>
     *
     * @param createSourceLocationRequest
     *        A {@link Consumer} that will call methods on {@link CreateSourceLocationRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSourceLocation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreateSourceLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateSourceLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSourceLocationResponse createSourceLocation(
            Consumer<CreateSourceLocationRequest.Builder> createSourceLocationRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return createSourceLocation(CreateSourceLocationRequest.builder().applyMutation(createSourceLocationRequest).build());
    }

    /**
     * <p>
     * Creates name for a specific VOD source in a source location.
     * </p>
     *
     * @param createVodSourceRequest
     * @return Result of the CreateVodSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreateVodSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateVodSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateVodSourceResponse createVodSource(CreateVodSourceRequest createVodSourceRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates name for a specific VOD source in a source location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVodSourceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateVodSourceRequest#builder()}
     * </p>
     *
     * @param createVodSourceRequest
     *        A {@link Consumer} that will call methods on {@link CreateVodSourceRequest.Builder} to create a request.
     * @return Result of the CreateVodSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.CreateVodSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateVodSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateVodSourceResponse createVodSource(Consumer<CreateVodSourceRequest.Builder> createVodSourceRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return createVodSource(CreateVodSourceRequest.builder().applyMutation(createVodSourceRequest).build());
    }

    /**
     * <p>
     * Deletes a channel. You must stop the channel before it can be deleted.
     * </p>
     *
     * @param deleteChannelRequest
     * @return Result of the DeleteChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteChannelResponse deleteChannel(DeleteChannelRequest deleteChannelRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a channel. You must stop the channel before it can be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChannelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteChannelRequest#builder()}
     * </p>
     *
     * @param deleteChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteChannelRequest.Builder} to create a request.
     * @return Result of the DeleteChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteChannelResponse deleteChannel(Consumer<DeleteChannelRequest.Builder> deleteChannelRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return deleteChannel(DeleteChannelRequest.builder().applyMutation(deleteChannelRequest).build());
    }

    /**
     * <p>
     * Deletes a channel's IAM policy.
     * </p>
     *
     * @param deleteChannelPolicyRequest
     * @return Result of the DeleteChannelPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteChannelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteChannelPolicyResponse deleteChannelPolicy(DeleteChannelPolicyRequest deleteChannelPolicyRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a channel's IAM policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChannelPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteChannelPolicyRequest#builder()}
     * </p>
     *
     * @param deleteChannelPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteChannelPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteChannelPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteChannelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteChannelPolicyResponse deleteChannelPolicy(
            Consumer<DeleteChannelPolicyRequest.Builder> deleteChannelPolicyRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return deleteChannelPolicy(DeleteChannelPolicyRequest.builder().applyMutation(deleteChannelPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the playback configuration for the specified name.
     * </p>
     *
     * @param deletePlaybackConfigurationRequest
     * @return Result of the DeletePlaybackConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeletePlaybackConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeletePlaybackConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePlaybackConfigurationResponse deletePlaybackConfiguration(
            DeletePlaybackConfigurationRequest deletePlaybackConfigurationRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the playback configuration for the specified name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePlaybackConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeletePlaybackConfigurationRequest#builder()}
     * </p>
     *
     * @param deletePlaybackConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeletePlaybackConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the DeletePlaybackConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeletePlaybackConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeletePlaybackConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePlaybackConfigurationResponse deletePlaybackConfiguration(
            Consumer<DeletePlaybackConfigurationRequest.Builder> deletePlaybackConfigurationRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return deletePlaybackConfiguration(DeletePlaybackConfigurationRequest.builder()
                .applyMutation(deletePlaybackConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a prefetch schedule for a specific playback configuration. If you call DeletePrefetchSchedule on an
     * expired prefetch schedule, MediaTailor returns an HTTP 404 status code.
     * </p>
     *
     * @param deletePrefetchScheduleRequest
     * @return Result of the DeletePrefetchSchedule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeletePrefetchSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeletePrefetchSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePrefetchScheduleResponse deletePrefetchSchedule(DeletePrefetchScheduleRequest deletePrefetchScheduleRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a prefetch schedule for a specific playback configuration. If you call DeletePrefetchSchedule on an
     * expired prefetch schedule, MediaTailor returns an HTTP 404 status code.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePrefetchScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePrefetchScheduleRequest#builder()}
     * </p>
     *
     * @param deletePrefetchScheduleRequest
     *        A {@link Consumer} that will call methods on {@link DeletePrefetchScheduleRequest.Builder} to create a
     *        request.
     * @return Result of the DeletePrefetchSchedule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeletePrefetchSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeletePrefetchSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePrefetchScheduleResponse deletePrefetchSchedule(
            Consumer<DeletePrefetchScheduleRequest.Builder> deletePrefetchScheduleRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return deletePrefetchSchedule(DeletePrefetchScheduleRequest.builder().applyMutation(deletePrefetchScheduleRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a specific program on a specific channel.
     * </p>
     *
     * @param deleteProgramRequest
     * @return Result of the DeleteProgram operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteProgram" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProgramResponse deleteProgram(DeleteProgramRequest deleteProgramRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific program on a specific channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProgramRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProgramRequest#builder()}
     * </p>
     *
     * @param deleteProgramRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProgramRequest.Builder} to create a request.
     * @return Result of the DeleteProgram operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteProgram" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProgramResponse deleteProgram(Consumer<DeleteProgramRequest.Builder> deleteProgramRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return deleteProgram(DeleteProgramRequest.builder().applyMutation(deleteProgramRequest).build());
    }

    /**
     * <p>
     * Deletes a source location on a specific channel.
     * </p>
     *
     * @param deleteSourceLocationRequest
     * @return Result of the DeleteSourceLocation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteSourceLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteSourceLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSourceLocationResponse deleteSourceLocation(DeleteSourceLocationRequest deleteSourceLocationRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a source location on a specific channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSourceLocationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSourceLocationRequest#builder()}
     * </p>
     *
     * @param deleteSourceLocationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSourceLocationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSourceLocation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteSourceLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteSourceLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSourceLocationResponse deleteSourceLocation(
            Consumer<DeleteSourceLocationRequest.Builder> deleteSourceLocationRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return deleteSourceLocation(DeleteSourceLocationRequest.builder().applyMutation(deleteSourceLocationRequest).build());
    }

    /**
     * <p>
     * Deletes a specific VOD source in a specific source location.
     * </p>
     *
     * @param deleteVodSourceRequest
     * @return Result of the DeleteVodSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteVodSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteVodSource" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVodSourceResponse deleteVodSource(DeleteVodSourceRequest deleteVodSourceRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific VOD source in a specific source location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVodSourceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteVodSourceRequest#builder()}
     * </p>
     *
     * @param deleteVodSourceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVodSourceRequest.Builder} to create a request.
     * @return Result of the DeleteVodSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DeleteVodSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeleteVodSource" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVodSourceResponse deleteVodSource(Consumer<DeleteVodSourceRequest.Builder> deleteVodSourceRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return deleteVodSource(DeleteVodSourceRequest.builder().applyMutation(deleteVodSourceRequest).build());
    }

    /**
     * <p>
     * Describes the properties of a specific channel.
     * </p>
     *
     * @param describeChannelRequest
     * @return Result of the DescribeChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DescribeChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeChannelResponse describeChannel(DescribeChannelRequest describeChannelRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the properties of a specific channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChannelRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeChannelRequest#builder()}
     * </p>
     *
     * @param describeChannelRequest
     *        A {@link Consumer} that will call methods on {@link DescribeChannelRequest.Builder} to create a request.
     * @return Result of the DescribeChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DescribeChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeChannelResponse describeChannel(Consumer<DescribeChannelRequest.Builder> describeChannelRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return describeChannel(DescribeChannelRequest.builder().applyMutation(describeChannelRequest).build());
    }

    /**
     * <p>
     * Retrieves the properties of the requested program.
     * </p>
     *
     * @param describeProgramRequest
     * @return Result of the DescribeProgram operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DescribeProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeProgram" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeProgramResponse describeProgram(DescribeProgramRequest describeProgramRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the properties of the requested program.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProgramRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProgramRequest#builder()}
     * </p>
     *
     * @param describeProgramRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProgramRequest.Builder} to create a request.
     * @return Result of the DescribeProgram operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DescribeProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeProgram" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeProgramResponse describeProgram(Consumer<DescribeProgramRequest.Builder> describeProgramRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return describeProgram(DescribeProgramRequest.builder().applyMutation(describeProgramRequest).build());
    }

    /**
     * <p>
     * Retrieves the properties of the requested source location.
     * </p>
     *
     * @param describeSourceLocationRequest
     * @return Result of the DescribeSourceLocation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DescribeSourceLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeSourceLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSourceLocationResponse describeSourceLocation(DescribeSourceLocationRequest describeSourceLocationRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the properties of the requested source location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSourceLocationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSourceLocationRequest#builder()}
     * </p>
     *
     * @param describeSourceLocationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSourceLocationRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeSourceLocation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DescribeSourceLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeSourceLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSourceLocationResponse describeSourceLocation(
            Consumer<DescribeSourceLocationRequest.Builder> describeSourceLocationRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return describeSourceLocation(DescribeSourceLocationRequest.builder().applyMutation(describeSourceLocationRequest)
                .build());
    }

    /**
     * <p>
     * Provides details about a specific VOD source in a specific source location.
     * </p>
     *
     * @param describeVodSourceRequest
     * @return Result of the DescribeVodSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DescribeVodSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeVodSource" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeVodSourceResponse describeVodSource(DescribeVodSourceRequest describeVodSourceRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about a specific VOD source in a specific source location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVodSourceRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeVodSourceRequest#builder()}
     * </p>
     *
     * @param describeVodSourceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeVodSourceRequest.Builder} to create a request.
     * @return Result of the DescribeVodSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.DescribeVodSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DescribeVodSource" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeVodSourceResponse describeVodSource(Consumer<DescribeVodSourceRequest.Builder> describeVodSourceRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return describeVodSource(DescribeVodSourceRequest.builder().applyMutation(describeVodSourceRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a channel's IAM policy.
     * </p>
     *
     * @param getChannelPolicyRequest
     * @return Result of the GetChannelPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.GetChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetChannelPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetChannelPolicyResponse getChannelPolicy(GetChannelPolicyRequest getChannelPolicyRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a channel's IAM policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChannelPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetChannelPolicyRequest#builder()}
     * </p>
     *
     * @param getChannelPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetChannelPolicyRequest.Builder} to create a request.
     * @return Result of the GetChannelPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.GetChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetChannelPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetChannelPolicyResponse getChannelPolicy(Consumer<GetChannelPolicyRequest.Builder> getChannelPolicyRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return getChannelPolicy(GetChannelPolicyRequest.builder().applyMutation(getChannelPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves information about your channel's schedule.
     * </p>
     *
     * @param getChannelScheduleRequest
     * @return Result of the GetChannelSchedule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.GetChannelSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetChannelSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetChannelScheduleResponse getChannelSchedule(GetChannelScheduleRequest getChannelScheduleRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about your channel's schedule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChannelScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link GetChannelScheduleRequest#builder()}
     * </p>
     *
     * @param getChannelScheduleRequest
     *        A {@link Consumer} that will call methods on {@link GetChannelScheduleRequest.Builder} to create a
     *        request.
     * @return Result of the GetChannelSchedule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.GetChannelSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetChannelSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetChannelScheduleResponse getChannelSchedule(Consumer<GetChannelScheduleRequest.Builder> getChannelScheduleRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return getChannelSchedule(GetChannelScheduleRequest.builder().applyMutation(getChannelScheduleRequest).build());
    }

    /**
     * <p>
     * Retrieves information about your channel's schedule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getChannelSchedule(software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.GetChannelScheduleIterable responses = client.getChannelSchedulePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.GetChannelScheduleIterable responses = client
     *             .getChannelSchedulePaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.GetChannelScheduleIterable responses = client.getChannelSchedulePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getChannelSchedule(software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest)}
     * operation.</b>
     * </p>
     *
     * @param getChannelScheduleRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.GetChannelSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetChannelSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetChannelScheduleIterable getChannelSchedulePaginator(GetChannelScheduleRequest getChannelScheduleRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about your channel's schedule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getChannelSchedule(software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.GetChannelScheduleIterable responses = client.getChannelSchedulePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.GetChannelScheduleIterable responses = client
     *             .getChannelSchedulePaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.GetChannelScheduleIterable responses = client.getChannelSchedulePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getChannelSchedule(software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChannelScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link GetChannelScheduleRequest#builder()}
     * </p>
     *
     * @param getChannelScheduleRequest
     *        A {@link Consumer} that will call methods on {@link GetChannelScheduleRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.GetChannelSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetChannelSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetChannelScheduleIterable getChannelSchedulePaginator(
            Consumer<GetChannelScheduleRequest.Builder> getChannelScheduleRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return getChannelSchedulePaginator(GetChannelScheduleRequest.builder().applyMutation(getChannelScheduleRequest).build());
    }

    /**
     * <p>
     * Returns the playback configuration for the specified name.
     * </p>
     *
     * @param getPlaybackConfigurationRequest
     * @return Result of the GetPlaybackConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.GetPlaybackConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetPlaybackConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPlaybackConfigurationResponse getPlaybackConfiguration(
            GetPlaybackConfigurationRequest getPlaybackConfigurationRequest) throws AwsServiceException, SdkClientException,
            MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the playback configuration for the specified name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPlaybackConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetPlaybackConfigurationRequest#builder()}
     * </p>
     *
     * @param getPlaybackConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetPlaybackConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the GetPlaybackConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.GetPlaybackConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetPlaybackConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPlaybackConfigurationResponse getPlaybackConfiguration(
            Consumer<GetPlaybackConfigurationRequest.Builder> getPlaybackConfigurationRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return getPlaybackConfiguration(GetPlaybackConfigurationRequest.builder().applyMutation(getPlaybackConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the prefetch schedule for a specific playback configuration. If you call
     * GetPrefetchSchedule on an expired prefetch schedule, MediaTailor returns an HTTP 404 status code.
     * </p>
     *
     * @param getPrefetchScheduleRequest
     * @return Result of the GetPrefetchSchedule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.GetPrefetchSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetPrefetchSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPrefetchScheduleResponse getPrefetchSchedule(GetPrefetchScheduleRequest getPrefetchScheduleRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the prefetch schedule for a specific playback configuration. If you call
     * GetPrefetchSchedule on an expired prefetch schedule, MediaTailor returns an HTTP 404 status code.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPrefetchScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link GetPrefetchScheduleRequest#builder()}
     * </p>
     *
     * @param getPrefetchScheduleRequest
     *        A {@link Consumer} that will call methods on {@link GetPrefetchScheduleRequest.Builder} to create a
     *        request.
     * @return Result of the GetPrefetchSchedule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.GetPrefetchSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/GetPrefetchSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPrefetchScheduleResponse getPrefetchSchedule(
            Consumer<GetPrefetchScheduleRequest.Builder> getPrefetchScheduleRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return getPrefetchSchedule(GetPrefetchScheduleRequest.builder().applyMutation(getPrefetchScheduleRequest).build());
    }

    /**
     * <p>
     * Returns a list of alerts for the given resource.
     * </p>
     *
     * @param listAlertsRequest
     * @return Result of the ListAlerts operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListAlerts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListAlerts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlertsResponse listAlerts(ListAlertsRequest listAlertsRequest) throws AwsServiceException, SdkClientException,
            MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of alerts for the given resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAlertsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAlertsRequest#builder()}
     * </p>
     *
     * @param listAlertsRequest
     *        A {@link Consumer} that will call methods on {@link ListAlertsRequest.Builder} to create a request.
     * @return Result of the ListAlerts operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListAlerts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListAlerts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlertsResponse listAlerts(Consumer<ListAlertsRequest.Builder> listAlertsRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return listAlerts(ListAlertsRequest.builder().applyMutation(listAlertsRequest).build());
    }

    /**
     * <p>
     * Returns a list of alerts for the given resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAlerts(software.amazon.awssdk.services.mediatailor.model.ListAlertsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListAlertsIterable responses = client.listAlertsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListAlertsIterable responses = client.listAlertsPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListAlertsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListAlertsIterable responses = client.listAlertsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAlerts(software.amazon.awssdk.services.mediatailor.model.ListAlertsRequest)} operation.</b>
     * </p>
     *
     * @param listAlertsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListAlerts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListAlerts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlertsIterable listAlertsPaginator(ListAlertsRequest listAlertsRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of alerts for the given resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAlerts(software.amazon.awssdk.services.mediatailor.model.ListAlertsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListAlertsIterable responses = client.listAlertsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListAlertsIterable responses = client.listAlertsPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListAlertsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListAlertsIterable responses = client.listAlertsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAlerts(software.amazon.awssdk.services.mediatailor.model.ListAlertsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAlertsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAlertsRequest#builder()}
     * </p>
     *
     * @param listAlertsRequest
     *        A {@link Consumer} that will call methods on {@link ListAlertsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListAlerts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListAlerts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlertsIterable listAlertsPaginator(Consumer<ListAlertsRequest.Builder> listAlertsRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return listAlertsPaginator(ListAlertsRequest.builder().applyMutation(listAlertsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of channels that are associated with this account.
     * </p>
     *
     * @param listChannelsRequest
     * @return Result of the ListChannels operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsResponse listChannels(ListChannelsRequest listChannelsRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of channels that are associated with this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on {@link ListChannelsRequest.Builder} to create a request.
     * @return Result of the ListChannels operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsResponse listChannels(Consumer<ListChannelsRequest.Builder> listChannelsRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return listChannels(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of channels that are associated with this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.mediatailor.model.ListChannelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.mediatailor.model.ListChannelsRequest)} operation.</b>
     * </p>
     *
     * @param listChannelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsIterable listChannelsPaginator(ListChannelsRequest listChannelsRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of channels that are associated with this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.mediatailor.model.ListChannelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.mediatailor.model.ListChannelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on {@link ListChannelsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsIterable listChannelsPaginator(Consumer<ListChannelsRequest.Builder> listChannelsRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return listChannelsPaginator(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the playback configurations defined in AWS Elemental MediaTailor. You can specify a maximum
     * number of configurations to return at a time. The default maximum is 50. Results are returned in pagefuls. If
     * MediaTailor has more configurations than the specified maximum, it provides parameters in the response that you
     * can use to retrieve the next pageful.
     * </p>
     *
     * @return Result of the ListPlaybackConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListPlaybackConfigurations
     * @see #listPlaybackConfigurations(ListPlaybackConfigurationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPlaybackConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlaybackConfigurationsResponse listPlaybackConfigurations() throws AwsServiceException, SdkClientException,
            MediaTailorException {
        return listPlaybackConfigurations(ListPlaybackConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the playback configurations defined in AWS Elemental MediaTailor. You can specify a maximum
     * number of configurations to return at a time. The default maximum is 50. Results are returned in pagefuls. If
     * MediaTailor has more configurations than the specified maximum, it provides parameters in the response that you
     * can use to retrieve the next pageful.
     * </p>
     *
     * @param listPlaybackConfigurationsRequest
     * @return Result of the ListPlaybackConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListPlaybackConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPlaybackConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlaybackConfigurationsResponse listPlaybackConfigurations(
            ListPlaybackConfigurationsRequest listPlaybackConfigurationsRequest) throws AwsServiceException, SdkClientException,
            MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the playback configurations defined in AWS Elemental MediaTailor. You can specify a maximum
     * number of configurations to return at a time. The default maximum is 50. Results are returned in pagefuls. If
     * MediaTailor has more configurations than the specified maximum, it provides parameters in the response that you
     * can use to retrieve the next pageful.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlaybackConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPlaybackConfigurationsRequest#builder()}
     * </p>
     *
     * @param listPlaybackConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListPlaybackConfigurationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListPlaybackConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListPlaybackConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPlaybackConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlaybackConfigurationsResponse listPlaybackConfigurations(
            Consumer<ListPlaybackConfigurationsRequest.Builder> listPlaybackConfigurationsRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return listPlaybackConfigurations(ListPlaybackConfigurationsRequest.builder()
                .applyMutation(listPlaybackConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the playback configurations defined in AWS Elemental MediaTailor. You can specify a maximum
     * number of configurations to return at a time. The default maximum is 50. Results are returned in pagefuls. If
     * MediaTailor has more configurations than the specified maximum, it provides parameters in the response that you
     * can use to retrieve the next pageful.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlaybackConfigurations(software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListPlaybackConfigurationsIterable responses = client.listPlaybackConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListPlaybackConfigurationsIterable responses = client
     *             .listPlaybackConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListPlaybackConfigurationsIterable responses = client.listPlaybackConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlaybackConfigurations(software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListPlaybackConfigurations
     * @see #listPlaybackConfigurationsPaginator(ListPlaybackConfigurationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPlaybackConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlaybackConfigurationsIterable listPlaybackConfigurationsPaginator() throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return listPlaybackConfigurationsPaginator(ListPlaybackConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the playback configurations defined in AWS Elemental MediaTailor. You can specify a maximum
     * number of configurations to return at a time. The default maximum is 50. Results are returned in pagefuls. If
     * MediaTailor has more configurations than the specified maximum, it provides parameters in the response that you
     * can use to retrieve the next pageful.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlaybackConfigurations(software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListPlaybackConfigurationsIterable responses = client.listPlaybackConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListPlaybackConfigurationsIterable responses = client
     *             .listPlaybackConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListPlaybackConfigurationsIterable responses = client.listPlaybackConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlaybackConfigurations(software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPlaybackConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListPlaybackConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPlaybackConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlaybackConfigurationsIterable listPlaybackConfigurationsPaginator(
            ListPlaybackConfigurationsRequest listPlaybackConfigurationsRequest) throws AwsServiceException, SdkClientException,
            MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the playback configurations defined in AWS Elemental MediaTailor. You can specify a maximum
     * number of configurations to return at a time. The default maximum is 50. Results are returned in pagefuls. If
     * MediaTailor has more configurations than the specified maximum, it provides parameters in the response that you
     * can use to retrieve the next pageful.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlaybackConfigurations(software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListPlaybackConfigurationsIterable responses = client.listPlaybackConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListPlaybackConfigurationsIterable responses = client
     *             .listPlaybackConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListPlaybackConfigurationsIterable responses = client.listPlaybackConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlaybackConfigurations(software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlaybackConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPlaybackConfigurationsRequest#builder()}
     * </p>
     *
     * @param listPlaybackConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListPlaybackConfigurationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListPlaybackConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPlaybackConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlaybackConfigurationsIterable listPlaybackConfigurationsPaginator(
            Consumer<ListPlaybackConfigurationsRequest.Builder> listPlaybackConfigurationsRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return listPlaybackConfigurationsPaginator(ListPlaybackConfigurationsRequest.builder()
                .applyMutation(listPlaybackConfigurationsRequest).build());
    }

    /**
     * <p>
     * Creates a new prefetch schedule.
     * </p>
     *
     * @param listPrefetchSchedulesRequest
     * @return Result of the ListPrefetchSchedules operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListPrefetchSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPrefetchSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPrefetchSchedulesResponse listPrefetchSchedules(ListPrefetchSchedulesRequest listPrefetchSchedulesRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new prefetch schedule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPrefetchSchedulesRequest.Builder} avoiding the
     * need to create one manually via {@link ListPrefetchSchedulesRequest#builder()}
     * </p>
     *
     * @param listPrefetchSchedulesRequest
     *        A {@link Consumer} that will call methods on {@link ListPrefetchSchedulesRequest.Builder} to create a
     *        request.
     * @return Result of the ListPrefetchSchedules operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListPrefetchSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPrefetchSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPrefetchSchedulesResponse listPrefetchSchedules(
            Consumer<ListPrefetchSchedulesRequest.Builder> listPrefetchSchedulesRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return listPrefetchSchedules(ListPrefetchSchedulesRequest.builder().applyMutation(listPrefetchSchedulesRequest).build());
    }

    /**
     * <p>
     * Creates a new prefetch schedule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPrefetchSchedules(software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListPrefetchSchedulesIterable responses = client.listPrefetchSchedulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListPrefetchSchedulesIterable responses = client
     *             .listPrefetchSchedulesPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListPrefetchSchedulesIterable responses = client.listPrefetchSchedulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrefetchSchedules(software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPrefetchSchedulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListPrefetchSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPrefetchSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPrefetchSchedulesIterable listPrefetchSchedulesPaginator(ListPrefetchSchedulesRequest listPrefetchSchedulesRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new prefetch schedule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPrefetchSchedules(software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListPrefetchSchedulesIterable responses = client.listPrefetchSchedulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListPrefetchSchedulesIterable responses = client
     *             .listPrefetchSchedulesPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListPrefetchSchedulesIterable responses = client.listPrefetchSchedulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrefetchSchedules(software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPrefetchSchedulesRequest.Builder} avoiding the
     * need to create one manually via {@link ListPrefetchSchedulesRequest#builder()}
     * </p>
     *
     * @param listPrefetchSchedulesRequest
     *        A {@link Consumer} that will call methods on {@link ListPrefetchSchedulesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListPrefetchSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListPrefetchSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPrefetchSchedulesIterable listPrefetchSchedulesPaginator(
            Consumer<ListPrefetchSchedulesRequest.Builder> listPrefetchSchedulesRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return listPrefetchSchedulesPaginator(ListPrefetchSchedulesRequest.builder().applyMutation(listPrefetchSchedulesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of source locations.
     * </p>
     *
     * @param listSourceLocationsRequest
     * @return Result of the ListSourceLocations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListSourceLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListSourceLocations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSourceLocationsResponse listSourceLocations(ListSourceLocationsRequest listSourceLocationsRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of source locations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSourceLocationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSourceLocationsRequest#builder()}
     * </p>
     *
     * @param listSourceLocationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSourceLocationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSourceLocations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListSourceLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListSourceLocations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSourceLocationsResponse listSourceLocations(
            Consumer<ListSourceLocationsRequest.Builder> listSourceLocationsRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return listSourceLocations(ListSourceLocationsRequest.builder().applyMutation(listSourceLocationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of source locations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSourceLocations(software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListSourceLocationsIterable responses = client.listSourceLocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListSourceLocationsIterable responses = client
     *             .listSourceLocationsPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListSourceLocationsIterable responses = client.listSourceLocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSourceLocations(software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSourceLocationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListSourceLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListSourceLocations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSourceLocationsIterable listSourceLocationsPaginator(ListSourceLocationsRequest listSourceLocationsRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of source locations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSourceLocations(software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListSourceLocationsIterable responses = client.listSourceLocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListSourceLocationsIterable responses = client
     *             .listSourceLocationsPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListSourceLocationsIterable responses = client.listSourceLocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSourceLocations(software.amazon.awssdk.services.mediatailor.model.ListSourceLocationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSourceLocationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSourceLocationsRequest#builder()}
     * </p>
     *
     * @param listSourceLocationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSourceLocationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListSourceLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListSourceLocations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSourceLocationsIterable listSourceLocationsPaginator(
            Consumer<ListSourceLocationsRequest.Builder> listSourceLocationsRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return listSourceLocationsPaginator(ListSourceLocationsRequest.builder().applyMutation(listSourceLocationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the tags assigned to the specified playback configuration resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         One or more parameters in this request aren't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the tags assigned to the specified playback configuration resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         One or more parameters in this request aren't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, MediaTailorException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists all the VOD sources in a source location.
     * </p>
     *
     * @param listVodSourcesRequest
     * @return Result of the ListVodSources operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListVodSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListVodSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVodSourcesResponse listVodSources(ListVodSourcesRequest listVodSourcesRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the VOD sources in a source location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVodSourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListVodSourcesRequest#builder()}
     * </p>
     *
     * @param listVodSourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListVodSourcesRequest.Builder} to create a request.
     * @return Result of the ListVodSources operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListVodSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListVodSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVodSourcesResponse listVodSources(Consumer<ListVodSourcesRequest.Builder> listVodSourcesRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return listVodSources(ListVodSourcesRequest.builder().applyMutation(listVodSourcesRequest).build());
    }

    /**
     * <p>
     * Lists all the VOD sources in a source location.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVodSources(software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListVodSourcesIterable responses = client.listVodSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListVodSourcesIterable responses = client
     *             .listVodSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListVodSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListVodSourcesIterable responses = client.listVodSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVodSources(software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest)} operation.</b>
     * </p>
     *
     * @param listVodSourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListVodSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListVodSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVodSourcesIterable listVodSourcesPaginator(ListVodSourcesRequest listVodSourcesRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the VOD sources in a source location.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVodSources(software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListVodSourcesIterable responses = client.listVodSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediatailor.paginators.ListVodSourcesIterable responses = client
     *             .listVodSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.mediatailor.model.ListVodSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediatailor.paginators.ListVodSourcesIterable responses = client.listVodSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVodSources(software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVodSourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListVodSourcesRequest#builder()}
     * </p>
     *
     * @param listVodSourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListVodSourcesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.ListVodSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/ListVodSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVodSourcesIterable listVodSourcesPaginator(Consumer<ListVodSourcesRequest.Builder> listVodSourcesRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return listVodSourcesPaginator(ListVodSourcesRequest.builder().applyMutation(listVodSourcesRequest).build());
    }

    /**
     * <p>
     * Creates an IAM policy for the channel.
     * </p>
     *
     * @param putChannelPolicyRequest
     * @return Result of the PutChannelPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.PutChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/PutChannelPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutChannelPolicyResponse putChannelPolicy(PutChannelPolicyRequest putChannelPolicyRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an IAM policy for the channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutChannelPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutChannelPolicyRequest#builder()}
     * </p>
     *
     * @param putChannelPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutChannelPolicyRequest.Builder} to create a request.
     * @return Result of the PutChannelPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.PutChannelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/PutChannelPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutChannelPolicyResponse putChannelPolicy(Consumer<PutChannelPolicyRequest.Builder> putChannelPolicyRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return putChannelPolicy(PutChannelPolicyRequest.builder().applyMutation(putChannelPolicyRequest).build());
    }

    /**
     * <p>
     * Adds a new playback configuration to AWS Elemental MediaTailor.
     * </p>
     *
     * @param putPlaybackConfigurationRequest
     * @return Result of the PutPlaybackConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.PutPlaybackConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/PutPlaybackConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutPlaybackConfigurationResponse putPlaybackConfiguration(
            PutPlaybackConfigurationRequest putPlaybackConfigurationRequest) throws AwsServiceException, SdkClientException,
            MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new playback configuration to AWS Elemental MediaTailor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutPlaybackConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link PutPlaybackConfigurationRequest#builder()}
     * </p>
     *
     * @param putPlaybackConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutPlaybackConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the PutPlaybackConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.PutPlaybackConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/PutPlaybackConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutPlaybackConfigurationResponse putPlaybackConfiguration(
            Consumer<PutPlaybackConfigurationRequest.Builder> putPlaybackConfigurationRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return putPlaybackConfiguration(PutPlaybackConfigurationRequest.builder().applyMutation(putPlaybackConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Starts a specific channel.
     * </p>
     *
     * @param startChannelRequest
     * @return Result of the StartChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.StartChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/StartChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default StartChannelResponse startChannel(StartChannelRequest startChannelRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a specific channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartChannelRequest.Builder} avoiding the need to
     * create one manually via {@link StartChannelRequest#builder()}
     * </p>
     *
     * @param startChannelRequest
     *        A {@link Consumer} that will call methods on {@link StartChannelRequest.Builder} to create a request.
     * @return Result of the StartChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.StartChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/StartChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default StartChannelResponse startChannel(Consumer<StartChannelRequest.Builder> startChannelRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return startChannel(StartChannelRequest.builder().applyMutation(startChannelRequest).build());
    }

    /**
     * <p>
     * Stops a specific channel.
     * </p>
     *
     * @param stopChannelRequest
     * @return Result of the StopChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.StopChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/StopChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default StopChannelResponse stopChannel(StopChannelRequest stopChannelRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a specific channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopChannelRequest.Builder} avoiding the need to
     * create one manually via {@link StopChannelRequest#builder()}
     * </p>
     *
     * @param stopChannelRequest
     *        A {@link Consumer} that will call methods on {@link StopChannelRequest.Builder} to create a request.
     * @return Result of the StopChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.StopChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/StopChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default StopChannelResponse stopChannel(Consumer<StopChannelRequest.Builder> stopChannelRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return stopChannel(StopChannelRequest.builder().applyMutation(stopChannelRequest).build());
    }

    /**
     * <p>
     * Adds tags to the specified playback configuration resource. You can specify one or more tags to add.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         One or more parameters in this request aren't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to the specified playback configuration resource. You can specify one or more tags to add.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         One or more parameters in this request aren't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, MediaTailorException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from the specified playback configuration resource. You can specify one or more tags to remove.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         One or more parameters in this request aren't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from the specified playback configuration resource. You can specify one or more tags to remove.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         One or more parameters in this request aren't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, MediaTailorException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing channel.
     * </p>
     *
     * @param updateChannelRequest
     * @return Result of the UpdateChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateChannelResponse updateChannel(UpdateChannelRequest updateChannelRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateChannelRequest#builder()}
     * </p>
     *
     * @param updateChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateChannelRequest.Builder} to create a request.
     * @return Result of the UpdateChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateChannelResponse updateChannel(Consumer<UpdateChannelRequest.Builder> updateChannelRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return updateChannel(UpdateChannelRequest.builder().applyMutation(updateChannelRequest).build());
    }

    /**
     * <p>
     * Updates a source location on a specific channel.
     * </p>
     *
     * @param updateSourceLocationRequest
     * @return Result of the UpdateSourceLocation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.UpdateSourceLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateSourceLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSourceLocationResponse updateSourceLocation(UpdateSourceLocationRequest updateSourceLocationRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a source location on a specific channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSourceLocationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSourceLocationRequest#builder()}
     * </p>
     *
     * @param updateSourceLocationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSourceLocationRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateSourceLocation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.UpdateSourceLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateSourceLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSourceLocationResponse updateSourceLocation(
            Consumer<UpdateSourceLocationRequest.Builder> updateSourceLocationRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        return updateSourceLocation(UpdateSourceLocationRequest.builder().applyMutation(updateSourceLocationRequest).build());
    }

    /**
     * <p>
     * Updates a specific VOD source in a specific source location.
     * </p>
     *
     * @param updateVodSourceRequest
     * @return Result of the UpdateVodSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.UpdateVodSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateVodSource" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateVodSourceResponse updateVodSource(UpdateVodSourceRequest updateVodSourceRequest) throws AwsServiceException,
            SdkClientException, MediaTailorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a specific VOD source in a specific source location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVodSourceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateVodSourceRequest#builder()}
     * </p>
     *
     * @param updateVodSourceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVodSourceRequest.Builder} to create a request.
     * @return Result of the UpdateVodSource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaTailorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaTailorClient.UpdateVodSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/UpdateVodSource" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateVodSourceResponse updateVodSource(Consumer<UpdateVodSourceRequest.Builder> updateVodSourceRequest)
            throws AwsServiceException, SdkClientException, MediaTailorException {
        return updateVodSource(UpdateVodSourceRequest.builder().applyMutation(updateVodSourceRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
