/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The optional configuration for a server that serves segments. Use this if you want the segment delivery server to be
 * different from the source location server. For example, you can configure your source location server to be an
 * origination server, such as MediaPackage, and the segment delivery server to be a content delivery network (CDN),
 * such as CloudFront. If you don't specify a segment delivery server, then the source location server is used.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultSegmentDeliveryConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultSegmentDeliveryConfiguration.Builder, DefaultSegmentDeliveryConfiguration> {
    private static final SdkField<String> BASE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseUrl").getter(getter(DefaultSegmentDeliveryConfiguration::baseUrl)).setter(setter(Builder::baseUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String baseUrl;

    private DefaultSegmentDeliveryConfiguration(BuilderImpl builder) {
        this.baseUrl = builder.baseUrl;
    }

    /**
     * <p>
     * The hostname of the server that will be used to serve segments. This string must include the protocol, such as
     * <b>https://</b>.
     * </p>
     * 
     * @return The hostname of the server that will be used to serve segments. This string must include the protocol,
     *         such as <b>https://</b>.
     */
    public final String baseUrl() {
        return baseUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baseUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultSegmentDeliveryConfiguration)) {
            return false;
        }
        DefaultSegmentDeliveryConfiguration other = (DefaultSegmentDeliveryConfiguration) obj;
        return Objects.equals(baseUrl(), other.baseUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultSegmentDeliveryConfiguration").add("BaseUrl", baseUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaseUrl":
            return Optional.ofNullable(clazz.cast(baseUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultSegmentDeliveryConfiguration, T> g) {
        return obj -> g.apply((DefaultSegmentDeliveryConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultSegmentDeliveryConfiguration> {
        /**
         * <p>
         * The hostname of the server that will be used to serve segments. This string must include the protocol, such
         * as <b>https://</b>.
         * </p>
         * 
         * @param baseUrl
         *        The hostname of the server that will be used to serve segments. This string must include the protocol,
         *        such as <b>https://</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseUrl(String baseUrl);
    }

    static final class BuilderImpl implements Builder {
        private String baseUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultSegmentDeliveryConfiguration model) {
            baseUrl(model.baseUrl);
        }

        public final String getBaseUrl() {
            return baseUrl;
        }

        public final void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        @Override
        @Transient
        public final Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Override
        public DefaultSegmentDeliveryConfiguration build() {
            return new DefaultSegmentDeliveryConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
