/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains settings governing when MediaTailor prefetches ads, and which dynamic variables that
 * MediaTailor includes in the request to the ad decision server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrefetchRetrieval implements SdkPojo, Serializable,
        ToCopyableBuilder<PrefetchRetrieval.Builder, PrefetchRetrieval> {
    private static final SdkField<Map<String, String>> DYNAMIC_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("DynamicVariables")
            .getter(getter(PrefetchRetrieval::dynamicVariables))
            .setter(setter(Builder::dynamicVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime")
            .getter(getter(PrefetchRetrieval::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime")
            .getter(getter(PrefetchRetrieval::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DYNAMIC_VARIABLES_FIELD,
            END_TIME_FIELD, START_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> dynamicVariables;

    private final Instant endTime;

    private final Instant startTime;

    private PrefetchRetrieval(BuilderImpl builder) {
        this.dynamicVariables = builder.dynamicVariables;
        this.endTime = builder.endTime;
        this.startTime = builder.startTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the DynamicVariables property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDynamicVariables() {
        return dynamicVariables != null && !(dynamicVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The dynamic variables to use for substitution during prefetch requests to the ad decision server (ADS).
     * </p>
     * <p>
     * You intially configure <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables.html">dynamic
     * variables</a> for the ADS URL when you set up your playback configuration. When you specify DynamicVariables for
     * prefetch retrieval, MediaTailor includes the dynamic variables in the request to the ADS.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDynamicVariables} method.
     * </p>
     * 
     * @return The dynamic variables to use for substitution during prefetch requests to the ad decision server
     *         (ADS).</p>
     *         <p>
     *         You intially configure <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables.html">dynamic
     *         variables</a> for the ADS URL when you set up your playback configuration. When you specify
     *         DynamicVariables for prefetch retrieval, MediaTailor includes the dynamic variables in the request to the
     *         ADS.
     */
    public final Map<String, String> dynamicVariables() {
        return dynamicVariables;
    }

    /**
     * <p>
     * The time when prefetch retrieval ends for the ad break. Prefetching will be attempted for manifest requests that
     * occur at or before this time.
     * </p>
     * 
     * @return The time when prefetch retrieval ends for the ad break. Prefetching will be attempted for manifest
     *         requests that occur at or before this time.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The time when prefetch retrievals can start for this break. Ad prefetching will be attempted for manifest
     * requests that occur at or after this time. Defaults to the current time. If not specified, the prefetch retrieval
     * starts as soon as possible.
     * </p>
     * 
     * @return The time when prefetch retrievals can start for this break. Ad prefetching will be attempted for manifest
     *         requests that occur at or after this time. Defaults to the current time. If not specified, the prefetch
     *         retrieval starts as soon as possible.
     */
    public final Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDynamicVariables() ? dynamicVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrefetchRetrieval)) {
            return false;
        }
        PrefetchRetrieval other = (PrefetchRetrieval) obj;
        return hasDynamicVariables() == other.hasDynamicVariables()
                && Objects.equals(dynamicVariables(), other.dynamicVariables()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrefetchRetrieval").add("DynamicVariables", hasDynamicVariables() ? dynamicVariables() : null)
                .add("EndTime", endTime()).add("StartTime", startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DynamicVariables":
            return Optional.ofNullable(clazz.cast(dynamicVariables()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PrefetchRetrieval, T> g) {
        return obj -> g.apply((PrefetchRetrieval) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrefetchRetrieval> {
        /**
         * <p>
         * The dynamic variables to use for substitution during prefetch requests to the ad decision server (ADS).
         * </p>
         * <p>
         * You intially configure <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables.html">dynamic
         * variables</a> for the ADS URL when you set up your playback configuration. When you specify DynamicVariables
         * for prefetch retrieval, MediaTailor includes the dynamic variables in the request to the ADS.
         * </p>
         * 
         * @param dynamicVariables
         *        The dynamic variables to use for substitution during prefetch requests to the ad decision server
         *        (ADS).</p>
         *        <p>
         *        You intially configure <a
         *        href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables.html">dynamic variables</a> for the
         *        ADS URL when you set up your playback configuration. When you specify DynamicVariables for prefetch
         *        retrieval, MediaTailor includes the dynamic variables in the request to the ADS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamicVariables(Map<String, String> dynamicVariables);

        /**
         * <p>
         * The time when prefetch retrieval ends for the ad break. Prefetching will be attempted for manifest requests
         * that occur at or before this time.
         * </p>
         * 
         * @param endTime
         *        The time when prefetch retrieval ends for the ad break. Prefetching will be attempted for manifest
         *        requests that occur at or before this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The time when prefetch retrievals can start for this break. Ad prefetching will be attempted for manifest
         * requests that occur at or after this time. Defaults to the current time. If not specified, the prefetch
         * retrieval starts as soon as possible.
         * </p>
         * 
         * @param startTime
         *        The time when prefetch retrievals can start for this break. Ad prefetching will be attempted for
         *        manifest requests that occur at or after this time. Defaults to the current time. If not specified,
         *        the prefetch retrieval starts as soon as possible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> dynamicVariables = DefaultSdkAutoConstructMap.getInstance();

        private Instant endTime;

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PrefetchRetrieval model) {
            dynamicVariables(model.dynamicVariables);
            endTime(model.endTime);
            startTime(model.startTime);
        }

        public final Map<String, String> getDynamicVariables() {
            if (dynamicVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return dynamicVariables;
        }

        public final void setDynamicVariables(Map<String, String> dynamicVariables) {
            this.dynamicVariables = ___mapOf__stringCopier.copy(dynamicVariables);
        }

        @Override
        @Transient
        public final Builder dynamicVariables(Map<String, String> dynamicVariables) {
            this.dynamicVariables = ___mapOf__stringCopier.copy(dynamicVariables);
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public PrefetchRetrieval build() {
            return new PrefetchRetrieval(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
