/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ___listOfPrefetchScheduleCopier {
    static List<PrefetchSchedule> copy(Collection<? extends PrefetchSchedule> __listOfPrefetchScheduleParam) {
        List<PrefetchSchedule> list;
        if (__listOfPrefetchScheduleParam == null || __listOfPrefetchScheduleParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<PrefetchSchedule> modifiableList = new ArrayList<>();
            __listOfPrefetchScheduleParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<PrefetchSchedule> copyFromBuilder(Collection<? extends PrefetchSchedule.Builder> __listOfPrefetchScheduleParam) {
        List<PrefetchSchedule> list;
        if (__listOfPrefetchScheduleParam == null || __listOfPrefetchScheduleParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<PrefetchSchedule> modifiableList = new ArrayList<>();
            __listOfPrefetchScheduleParam.forEach(entry -> {
                PrefetchSchedule member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<PrefetchSchedule.Builder> copyToBuilder(Collection<? extends PrefetchSchedule> __listOfPrefetchScheduleParam) {
        List<PrefetchSchedule.Builder> list;
        if (__listOfPrefetchScheduleParam == null || __listOfPrefetchScheduleParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<PrefetchSchedule.Builder> modifiableList = new ArrayList<>();
            __listOfPrefetchScheduleParam.forEach(entry -> {
                PrefetchSchedule.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
