/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medicalimaging.model.SortField;
import software.amazon.awssdk.services.medicalimaging.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Sort
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Sort> {
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortOrder").getter(Sort.getter(Sort::sortOrderAsString)).setter(Sort.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()}).build();
    private static final SdkField<String> SORT_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortField").getter(Sort.getter(Sort::sortFieldAsString)).setter(Sort.setter(Builder::sortField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortField").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SORT_ORDER_FIELD, SORT_FIELD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Sort.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sortOrder;
    private final String sortField;

    private Sort(BuilderImpl builder) {
        this.sortOrder = builder.sortOrder;
        this.sortField = builder.sortField;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final SortField sortField() {
        return SortField.fromValue(this.sortField);
    }

    public final String sortFieldAsString() {
        return this.sortField;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortFieldAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sort)) {
            return false;
        }
        Sort other = (Sort)obj;
        return Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.sortFieldAsString(), other.sortFieldAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Sort").add("SortOrder", (Object)this.sortOrderAsString()).add("SortField", (Object)this.sortFieldAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "sortField": {
                return Optional.ofNullable(clazz.cast(this.sortFieldAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("sortOrder", SORT_ORDER_FIELD);
        map.put("sortField", SORT_FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Sort, T> g) {
        return obj -> g.apply((Sort)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sortOrder;
        private String sortField;

        private BuilderImpl() {
        }

        private BuilderImpl(Sort model) {
            this.sortOrder(model.sortOrder);
            this.sortField(model.sortField);
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getSortField() {
            return this.sortField;
        }

        public final void setSortField(String sortField) {
            this.sortField = sortField;
        }

        @Override
        public final Builder sortField(String sortField) {
            this.sortField = sortField;
            return this;
        }

        @Override
        public final Builder sortField(SortField sortField) {
            this.sortField(sortField == null ? null : sortField.toString());
            return this;
        }

        public Sort build() {
            return new Sort(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Sort> {
        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder sortField(String var1);

        public Builder sortField(SortField var1);
    }
}

