/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.medicalimaging.DefaultMedicalImagingClientBuilder;
import software.amazon.awssdk.services.medicalimaging.MedicalImagingClientBuilder;
import software.amazon.awssdk.services.medicalimaging.MedicalImagingServiceClientConfiguration;
import software.amazon.awssdk.services.medicalimaging.model.AccessDeniedException;
import software.amazon.awssdk.services.medicalimaging.model.ConflictException;
import software.amazon.awssdk.services.medicalimaging.model.CopyImageSetRequest;
import software.amazon.awssdk.services.medicalimaging.model.CopyImageSetResponse;
import software.amazon.awssdk.services.medicalimaging.model.CreateDatastoreRequest;
import software.amazon.awssdk.services.medicalimaging.model.CreateDatastoreResponse;
import software.amazon.awssdk.services.medicalimaging.model.DeleteDatastoreRequest;
import software.amazon.awssdk.services.medicalimaging.model.DeleteDatastoreResponse;
import software.amazon.awssdk.services.medicalimaging.model.DeleteImageSetRequest;
import software.amazon.awssdk.services.medicalimaging.model.DeleteImageSetResponse;
import software.amazon.awssdk.services.medicalimaging.model.GetDatastoreRequest;
import software.amazon.awssdk.services.medicalimaging.model.GetDatastoreResponse;
import software.amazon.awssdk.services.medicalimaging.model.GetDicomImportJobRequest;
import software.amazon.awssdk.services.medicalimaging.model.GetDicomImportJobResponse;
import software.amazon.awssdk.services.medicalimaging.model.GetImageFrameRequest;
import software.amazon.awssdk.services.medicalimaging.model.GetImageFrameResponse;
import software.amazon.awssdk.services.medicalimaging.model.GetImageSetMetadataRequest;
import software.amazon.awssdk.services.medicalimaging.model.GetImageSetMetadataResponse;
import software.amazon.awssdk.services.medicalimaging.model.GetImageSetRequest;
import software.amazon.awssdk.services.medicalimaging.model.GetImageSetResponse;
import software.amazon.awssdk.services.medicalimaging.model.InternalServerException;
import software.amazon.awssdk.services.medicalimaging.model.ListDatastoresRequest;
import software.amazon.awssdk.services.medicalimaging.model.ListDatastoresResponse;
import software.amazon.awssdk.services.medicalimaging.model.ListDicomImportJobsRequest;
import software.amazon.awssdk.services.medicalimaging.model.ListDicomImportJobsResponse;
import software.amazon.awssdk.services.medicalimaging.model.ListImageSetVersionsRequest;
import software.amazon.awssdk.services.medicalimaging.model.ListImageSetVersionsResponse;
import software.amazon.awssdk.services.medicalimaging.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.medicalimaging.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.medicalimaging.model.MedicalImagingException;
import software.amazon.awssdk.services.medicalimaging.model.ResourceNotFoundException;
import software.amazon.awssdk.services.medicalimaging.model.SearchImageSetsRequest;
import software.amazon.awssdk.services.medicalimaging.model.SearchImageSetsResponse;
import software.amazon.awssdk.services.medicalimaging.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.medicalimaging.model.StartDicomImportJobRequest;
import software.amazon.awssdk.services.medicalimaging.model.StartDicomImportJobResponse;
import software.amazon.awssdk.services.medicalimaging.model.TagResourceRequest;
import software.amazon.awssdk.services.medicalimaging.model.TagResourceResponse;
import software.amazon.awssdk.services.medicalimaging.model.ThrottlingException;
import software.amazon.awssdk.services.medicalimaging.model.UntagResourceRequest;
import software.amazon.awssdk.services.medicalimaging.model.UntagResourceResponse;
import software.amazon.awssdk.services.medicalimaging.model.UpdateImageSetMetadataRequest;
import software.amazon.awssdk.services.medicalimaging.model.UpdateImageSetMetadataResponse;
import software.amazon.awssdk.services.medicalimaging.model.ValidationException;
import software.amazon.awssdk.services.medicalimaging.paginators.ListDICOMImportJobsIterable;
import software.amazon.awssdk.services.medicalimaging.paginators.ListDatastoresIterable;
import software.amazon.awssdk.services.medicalimaging.paginators.ListImageSetVersionsIterable;
import software.amazon.awssdk.services.medicalimaging.paginators.SearchImageSetsIterable;

@SdkPublicApi
@ThreadSafe
public interface MedicalImagingClient
extends AwsClient {
    public static final String SERVICE_NAME = "medical-imaging";
    public static final String SERVICE_METADATA_ID = "medical-imaging";

    default public CopyImageSetResponse copyImageSet(CopyImageSetRequest copyImageSetRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, MedicalImagingException {
        throw new UnsupportedOperationException();
    }

    default public CopyImageSetResponse copyImageSet(Consumer<CopyImageSetRequest.Builder> copyImageSetRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.copyImageSet((CopyImageSetRequest)((Object)((CopyImageSetRequest.Builder)CopyImageSetRequest.builder().applyMutation(copyImageSetRequest)).build()));
    }

    default public CreateDatastoreResponse createDatastore(CreateDatastoreRequest createDatastoreRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, MedicalImagingException {
        throw new UnsupportedOperationException();
    }

    default public CreateDatastoreResponse createDatastore(Consumer<CreateDatastoreRequest.Builder> createDatastoreRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.createDatastore((CreateDatastoreRequest)((Object)((CreateDatastoreRequest.Builder)CreateDatastoreRequest.builder().applyMutation(createDatastoreRequest)).build()));
    }

    default public DeleteDatastoreResponse deleteDatastore(DeleteDatastoreRequest deleteDatastoreRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        throw new UnsupportedOperationException();
    }

    default public DeleteDatastoreResponse deleteDatastore(Consumer<DeleteDatastoreRequest.Builder> deleteDatastoreRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.deleteDatastore((DeleteDatastoreRequest)((Object)((DeleteDatastoreRequest.Builder)DeleteDatastoreRequest.builder().applyMutation(deleteDatastoreRequest)).build()));
    }

    default public DeleteImageSetResponse deleteImageSet(DeleteImageSetRequest deleteImageSetRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        throw new UnsupportedOperationException();
    }

    default public DeleteImageSetResponse deleteImageSet(Consumer<DeleteImageSetRequest.Builder> deleteImageSetRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.deleteImageSet((DeleteImageSetRequest)((Object)((DeleteImageSetRequest.Builder)DeleteImageSetRequest.builder().applyMutation(deleteImageSetRequest)).build()));
    }

    default public GetDicomImportJobResponse getDICOMImportJob(GetDicomImportJobRequest getDicomImportJobRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        throw new UnsupportedOperationException();
    }

    default public GetDicomImportJobResponse getDICOMImportJob(Consumer<GetDicomImportJobRequest.Builder> getDicomImportJobRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.getDICOMImportJob((GetDicomImportJobRequest)((Object)((GetDicomImportJobRequest.Builder)GetDicomImportJobRequest.builder().applyMutation(getDicomImportJobRequest)).build()));
    }

    default public GetDatastoreResponse getDatastore(GetDatastoreRequest getDatastoreRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        throw new UnsupportedOperationException();
    }

    default public GetDatastoreResponse getDatastore(Consumer<GetDatastoreRequest.Builder> getDatastoreRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.getDatastore((GetDatastoreRequest)((Object)((GetDatastoreRequest.Builder)GetDatastoreRequest.builder().applyMutation(getDatastoreRequest)).build()));
    }

    default public <ReturnT> ReturnT getImageFrame(GetImageFrameRequest getImageFrameRequest, ResponseTransformer<GetImageFrameResponse, ReturnT> responseTransformer) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> ReturnT getImageFrame(Consumer<GetImageFrameRequest.Builder> getImageFrameRequest, ResponseTransformer<GetImageFrameResponse, ReturnT> responseTransformer) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.getImageFrame((GetImageFrameRequest)((Object)((GetImageFrameRequest.Builder)GetImageFrameRequest.builder().applyMutation(getImageFrameRequest)).build()), responseTransformer);
    }

    default public GetImageFrameResponse getImageFrame(GetImageFrameRequest getImageFrameRequest, Path destinationPath) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return (GetImageFrameResponse)((Object)this.getImageFrame(getImageFrameRequest, ResponseTransformer.toFile((Path)destinationPath)));
    }

    default public GetImageFrameResponse getImageFrame(Consumer<GetImageFrameRequest.Builder> getImageFrameRequest, Path destinationPath) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.getImageFrame((GetImageFrameRequest)((Object)((GetImageFrameRequest.Builder)GetImageFrameRequest.builder().applyMutation(getImageFrameRequest)).build()), destinationPath);
    }

    default public ResponseInputStream<GetImageFrameResponse> getImageFrame(GetImageFrameRequest getImageFrameRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return (ResponseInputStream)this.getImageFrame(getImageFrameRequest, ResponseTransformer.toInputStream());
    }

    default public ResponseInputStream<GetImageFrameResponse> getImageFrame(Consumer<GetImageFrameRequest.Builder> getImageFrameRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.getImageFrame((GetImageFrameRequest)((Object)((GetImageFrameRequest.Builder)GetImageFrameRequest.builder().applyMutation(getImageFrameRequest)).build()));
    }

    default public ResponseBytes<GetImageFrameResponse> getImageFrameAsBytes(GetImageFrameRequest getImageFrameRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return (ResponseBytes)this.getImageFrame(getImageFrameRequest, ResponseTransformer.toBytes());
    }

    default public ResponseBytes<GetImageFrameResponse> getImageFrameAsBytes(Consumer<GetImageFrameRequest.Builder> getImageFrameRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.getImageFrameAsBytes((GetImageFrameRequest)((Object)((GetImageFrameRequest.Builder)GetImageFrameRequest.builder().applyMutation(getImageFrameRequest)).build()));
    }

    default public GetImageSetResponse getImageSet(GetImageSetRequest getImageSetRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        throw new UnsupportedOperationException();
    }

    default public GetImageSetResponse getImageSet(Consumer<GetImageSetRequest.Builder> getImageSetRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.getImageSet((GetImageSetRequest)((Object)((GetImageSetRequest.Builder)GetImageSetRequest.builder().applyMutation(getImageSetRequest)).build()));
    }

    default public <ReturnT> ReturnT getImageSetMetadata(GetImageSetMetadataRequest getImageSetMetadataRequest, ResponseTransformer<GetImageSetMetadataResponse, ReturnT> responseTransformer) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> ReturnT getImageSetMetadata(Consumer<GetImageSetMetadataRequest.Builder> getImageSetMetadataRequest, ResponseTransformer<GetImageSetMetadataResponse, ReturnT> responseTransformer) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.getImageSetMetadata((GetImageSetMetadataRequest)((Object)((GetImageSetMetadataRequest.Builder)GetImageSetMetadataRequest.builder().applyMutation(getImageSetMetadataRequest)).build()), responseTransformer);
    }

    default public GetImageSetMetadataResponse getImageSetMetadata(GetImageSetMetadataRequest getImageSetMetadataRequest, Path destinationPath) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return (GetImageSetMetadataResponse)((Object)this.getImageSetMetadata(getImageSetMetadataRequest, ResponseTransformer.toFile((Path)destinationPath)));
    }

    default public GetImageSetMetadataResponse getImageSetMetadata(Consumer<GetImageSetMetadataRequest.Builder> getImageSetMetadataRequest, Path destinationPath) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.getImageSetMetadata((GetImageSetMetadataRequest)((Object)((GetImageSetMetadataRequest.Builder)GetImageSetMetadataRequest.builder().applyMutation(getImageSetMetadataRequest)).build()), destinationPath);
    }

    default public ResponseInputStream<GetImageSetMetadataResponse> getImageSetMetadata(GetImageSetMetadataRequest getImageSetMetadataRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return (ResponseInputStream)this.getImageSetMetadata(getImageSetMetadataRequest, ResponseTransformer.toInputStream());
    }

    default public ResponseInputStream<GetImageSetMetadataResponse> getImageSetMetadata(Consumer<GetImageSetMetadataRequest.Builder> getImageSetMetadataRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.getImageSetMetadata((GetImageSetMetadataRequest)((Object)((GetImageSetMetadataRequest.Builder)GetImageSetMetadataRequest.builder().applyMutation(getImageSetMetadataRequest)).build()));
    }

    default public ResponseBytes<GetImageSetMetadataResponse> getImageSetMetadataAsBytes(GetImageSetMetadataRequest getImageSetMetadataRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return (ResponseBytes)this.getImageSetMetadata(getImageSetMetadataRequest, ResponseTransformer.toBytes());
    }

    default public ResponseBytes<GetImageSetMetadataResponse> getImageSetMetadataAsBytes(Consumer<GetImageSetMetadataRequest.Builder> getImageSetMetadataRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.getImageSetMetadataAsBytes((GetImageSetMetadataRequest)((Object)((GetImageSetMetadataRequest.Builder)GetImageSetMetadataRequest.builder().applyMutation(getImageSetMetadataRequest)).build()));
    }

    default public ListDicomImportJobsResponse listDICOMImportJobs(ListDicomImportJobsRequest listDicomImportJobsRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        throw new UnsupportedOperationException();
    }

    default public ListDicomImportJobsResponse listDICOMImportJobs(Consumer<ListDicomImportJobsRequest.Builder> listDicomImportJobsRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.listDICOMImportJobs((ListDicomImportJobsRequest)((Object)((ListDicomImportJobsRequest.Builder)ListDicomImportJobsRequest.builder().applyMutation(listDicomImportJobsRequest)).build()));
    }

    default public ListDICOMImportJobsIterable listDICOMImportJobsPaginator(ListDicomImportJobsRequest listDicomImportJobsRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return new ListDICOMImportJobsIterable(this, listDicomImportJobsRequest);
    }

    default public ListDICOMImportJobsIterable listDICOMImportJobsPaginator(Consumer<ListDicomImportJobsRequest.Builder> listDicomImportJobsRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.listDICOMImportJobsPaginator((ListDicomImportJobsRequest)((Object)((ListDicomImportJobsRequest.Builder)ListDicomImportJobsRequest.builder().applyMutation(listDicomImportJobsRequest)).build()));
    }

    default public ListDatastoresResponse listDatastores(ListDatastoresRequest listDatastoresRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, MedicalImagingException {
        throw new UnsupportedOperationException();
    }

    default public ListDatastoresResponse listDatastores(Consumer<ListDatastoresRequest.Builder> listDatastoresRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.listDatastores((ListDatastoresRequest)((Object)((ListDatastoresRequest.Builder)ListDatastoresRequest.builder().applyMutation(listDatastoresRequest)).build()));
    }

    default public ListDatastoresIterable listDatastoresPaginator(ListDatastoresRequest listDatastoresRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, MedicalImagingException {
        return new ListDatastoresIterable(this, listDatastoresRequest);
    }

    default public ListDatastoresIterable listDatastoresPaginator(Consumer<ListDatastoresRequest.Builder> listDatastoresRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.listDatastoresPaginator((ListDatastoresRequest)((Object)((ListDatastoresRequest.Builder)ListDatastoresRequest.builder().applyMutation(listDatastoresRequest)).build()));
    }

    default public ListImageSetVersionsResponse listImageSetVersions(ListImageSetVersionsRequest listImageSetVersionsRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        throw new UnsupportedOperationException();
    }

    default public ListImageSetVersionsResponse listImageSetVersions(Consumer<ListImageSetVersionsRequest.Builder> listImageSetVersionsRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.listImageSetVersions((ListImageSetVersionsRequest)((Object)((ListImageSetVersionsRequest.Builder)ListImageSetVersionsRequest.builder().applyMutation(listImageSetVersionsRequest)).build()));
    }

    default public ListImageSetVersionsIterable listImageSetVersionsPaginator(ListImageSetVersionsRequest listImageSetVersionsRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return new ListImageSetVersionsIterable(this, listImageSetVersionsRequest);
    }

    default public ListImageSetVersionsIterable listImageSetVersionsPaginator(Consumer<ListImageSetVersionsRequest.Builder> listImageSetVersionsRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.listImageSetVersionsPaginator((ListImageSetVersionsRequest)((Object)((ListImageSetVersionsRequest.Builder)ListImageSetVersionsRequest.builder().applyMutation(listImageSetVersionsRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public SearchImageSetsResponse searchImageSets(SearchImageSetsRequest searchImageSetsRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        throw new UnsupportedOperationException();
    }

    default public SearchImageSetsResponse searchImageSets(Consumer<SearchImageSetsRequest.Builder> searchImageSetsRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.searchImageSets((SearchImageSetsRequest)((Object)((SearchImageSetsRequest.Builder)SearchImageSetsRequest.builder().applyMutation(searchImageSetsRequest)).build()));
    }

    default public SearchImageSetsIterable searchImageSetsPaginator(SearchImageSetsRequest searchImageSetsRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return new SearchImageSetsIterable(this, searchImageSetsRequest);
    }

    default public SearchImageSetsIterable searchImageSetsPaginator(Consumer<SearchImageSetsRequest.Builder> searchImageSetsRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.searchImageSetsPaginator((SearchImageSetsRequest)((Object)((SearchImageSetsRequest.Builder)SearchImageSetsRequest.builder().applyMutation(searchImageSetsRequest)).build()));
    }

    default public StartDicomImportJobResponse startDICOMImportJob(StartDicomImportJobRequest startDicomImportJobRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, MedicalImagingException {
        throw new UnsupportedOperationException();
    }

    default public StartDicomImportJobResponse startDICOMImportJob(Consumer<StartDicomImportJobRequest.Builder> startDicomImportJobRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.startDICOMImportJob((StartDicomImportJobRequest)((Object)((StartDicomImportJobRequest.Builder)StartDicomImportJobRequest.builder().applyMutation(startDicomImportJobRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateImageSetMetadataResponse updateImageSetMetadata(UpdateImageSetMetadataRequest updateImageSetMetadataRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, MedicalImagingException {
        throw new UnsupportedOperationException();
    }

    default public UpdateImageSetMetadataResponse updateImageSetMetadata(Consumer<UpdateImageSetMetadataRequest.Builder> updateImageSetMetadataRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, MedicalImagingException {
        return this.updateImageSetMetadata((UpdateImageSetMetadataRequest)((Object)((UpdateImageSetMetadataRequest.Builder)UpdateImageSetMetadataRequest.builder().applyMutation(updateImageSetMetadataRequest)).build()));
    }

    public static MedicalImagingClient create() {
        return (MedicalImagingClient)MedicalImagingClient.builder().build();
    }

    public static MedicalImagingClientBuilder builder() {
        return new DefaultMedicalImagingClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"medical-imaging");
    }

    default public MedicalImagingServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

