/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medicalimaging.model.DICOMImportJobSummariesCopier;
import software.amazon.awssdk.services.medicalimaging.model.DICOMImportJobSummary;
import software.amazon.awssdk.services.medicalimaging.model.MedicalImagingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDicomImportJobsResponse
extends MedicalImagingResponse
implements ToCopyableBuilder<Builder, ListDicomImportJobsResponse> {
    private static final SdkField<List<DICOMImportJobSummary>> JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("jobSummaries").getter(ListDicomImportJobsResponse.getter(ListDicomImportJobsResponse::jobSummaries)).setter(ListDicomImportJobsResponse.setter(Builder::jobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DICOMImportJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDicomImportJobsResponse.getter(ListDicomImportJobsResponse::nextToken)).setter(ListDicomImportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDicomImportJobsResponse.memberNameToFieldInitializer();
    private final List<DICOMImportJobSummary> jobSummaries;
    private final String nextToken;

    private ListDicomImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobSummaries = builder.jobSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasJobSummaries() {
        return this.jobSummaries != null && !(this.jobSummaries instanceof SdkAutoConstructList);
    }

    public final List<DICOMImportJobSummary> jobSummaries() {
        return this.jobSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobSummaries() ? this.jobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDicomImportJobsResponse)) {
            return false;
        }
        ListDicomImportJobsResponse other = (ListDicomImportJobsResponse)((Object)obj);
        return this.hasJobSummaries() == other.hasJobSummaries() && Objects.equals(this.jobSummaries(), other.jobSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDicomImportJobsResponse").add("JobSummaries", this.hasJobSummaries() ? this.jobSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobSummaries": {
                return Optional.ofNullable(clazz.cast(this.jobSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobSummaries", JOB_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDicomImportJobsResponse, T> g) {
        return obj -> g.apply((ListDicomImportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MedicalImagingResponse.BuilderImpl
    implements Builder {
        private List<DICOMImportJobSummary> jobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDicomImportJobsResponse model) {
            super(model);
            this.jobSummaries(model.jobSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<DICOMImportJobSummary.Builder> getJobSummaries() {
            List<DICOMImportJobSummary.Builder> result = DICOMImportJobSummariesCopier.copyToBuilder(this.jobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobSummaries(Collection<DICOMImportJobSummary.BuilderImpl> jobSummaries) {
            this.jobSummaries = DICOMImportJobSummariesCopier.copyFromBuilder(jobSummaries);
        }

        @Override
        public final Builder jobSummaries(Collection<DICOMImportJobSummary> jobSummaries) {
            this.jobSummaries = DICOMImportJobSummariesCopier.copy(jobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobSummaries(DICOMImportJobSummary ... jobSummaries) {
            this.jobSummaries(Arrays.asList(jobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobSummaries(Consumer<DICOMImportJobSummary.Builder> ... jobSummaries) {
            this.jobSummaries(Stream.of(jobSummaries).map(c -> (DICOMImportJobSummary)((DICOMImportJobSummary.Builder)DICOMImportJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDicomImportJobsResponse build() {
            return new ListDicomImportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MedicalImagingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDicomImportJobsResponse> {
        public Builder jobSummaries(Collection<DICOMImportJobSummary> var1);

        public Builder jobSummaries(DICOMImportJobSummary ... var1);

        public Builder jobSummaries(Consumer<DICOMImportJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

