/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterRequest;
import software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterResponse;
import software.amazon.awssdk.services.memorydb.model.CopySnapshotRequest;
import software.amazon.awssdk.services.memorydb.model.CopySnapshotResponse;
import software.amazon.awssdk.services.memorydb.model.CreateAclRequest;
import software.amazon.awssdk.services.memorydb.model.CreateAclResponse;
import software.amazon.awssdk.services.memorydb.model.CreateClusterRequest;
import software.amazon.awssdk.services.memorydb.model.CreateClusterResponse;
import software.amazon.awssdk.services.memorydb.model.CreateParameterGroupRequest;
import software.amazon.awssdk.services.memorydb.model.CreateParameterGroupResponse;
import software.amazon.awssdk.services.memorydb.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.memorydb.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupRequest;
import software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupResponse;
import software.amazon.awssdk.services.memorydb.model.CreateUserRequest;
import software.amazon.awssdk.services.memorydb.model.CreateUserResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteAclRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteAclResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteClusterRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteClusterResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteSubnetGroupRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteSubnetGroupResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteUserRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteUserResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeAcLsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeClustersResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeEventsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeEventsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeParametersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeParametersResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeUsersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeUsersResponse;
import software.amazon.awssdk.services.memorydb.model.FailoverShardRequest;
import software.amazon.awssdk.services.memorydb.model.FailoverShardResponse;
import software.amazon.awssdk.services.memorydb.model.ListAllowedNodeTypeUpdatesRequest;
import software.amazon.awssdk.services.memorydb.model.ListAllowedNodeTypeUpdatesResponse;
import software.amazon.awssdk.services.memorydb.model.ListTagsRequest;
import software.amazon.awssdk.services.memorydb.model.ListTagsResponse;
import software.amazon.awssdk.services.memorydb.model.ResetParameterGroupRequest;
import software.amazon.awssdk.services.memorydb.model.ResetParameterGroupResponse;
import software.amazon.awssdk.services.memorydb.model.TagResourceRequest;
import software.amazon.awssdk.services.memorydb.model.TagResourceResponse;
import software.amazon.awssdk.services.memorydb.model.UntagResourceRequest;
import software.amazon.awssdk.services.memorydb.model.UntagResourceResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateAclRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateAclResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateClusterRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateClusterResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateUserRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateUserResponse;

/**
 * Service client for accessing Amazon MemoryDB asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * MemoryDB for Redis is a fully managed, Redis-compatible, in-memory database that delivers ultra-fast performance and
 * Multi-AZ durability for modern applications built using microservices architectures. MemoryDB stores the entire
 * database in-memory, enabling low latency and high throughput data access. It is compatible with Redis, a popular open
 * source data store, enabling you to leverage Redis’ flexible and friendly data structures, APIs, and commands.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MemoryDbAsyncClient extends SdkClient {
    String SERVICE_NAME = "memorydb";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "memory-db";

    /**
     * Create a {@link MemoryDbAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MemoryDbAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MemoryDbAsyncClient}.
     */
    static MemoryDbAsyncClientBuilder builder() {
        return new DefaultMemoryDbAsyncClientBuilder();
    }

    /**
     * <p>
     * Apply the service update to a list of clusters supplied. For more information on service updates and applying
     * them, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/managing-updates.html#applying-updates">Applying the
     * service updates</a>.
     * </p>
     *
     * @param batchUpdateClusterRequest
     * @return A Java Future containing the result of the BatchUpdateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUpdateNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.BatchUpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/BatchUpdateCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchUpdateClusterResponse> batchUpdateCluster(BatchUpdateClusterRequest batchUpdateClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Apply the service update to a list of clusters supplied. For more information on service updates and applying
     * them, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/managing-updates.html#applying-updates">Applying the
     * service updates</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateClusterRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdateClusterRequest#builder()}
     * </p>
     *
     * @param batchUpdateClusterRequest
     *        A {@link Consumer} that will call methods on {@link BatchUpdateClusterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchUpdateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUpdateNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.BatchUpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/BatchUpdateCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchUpdateClusterResponse> batchUpdateCluster(
            Consumer<BatchUpdateClusterRequest.Builder> batchUpdateClusterRequest) {
        return batchUpdateCluster(BatchUpdateClusterRequest.builder().applyMutation(batchUpdateClusterRequest).build());
    }

    /**
     * <p>
     * Makes a copy of an existing snapshot.
     * </p>
     *
     * @param copySnapshotRequest
     * @return A Java Future containing the result of the CopySnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotAlreadyExistsException</li>
     *         <li>SnapshotNotFoundException</li>
     *         <li>SnapshotQuotaExceededException</li>
     *         <li>InvalidSnapshotStateException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>TagQuotaPerResourceExceededException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.CopySnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopySnapshotResponse> copySnapshot(CopySnapshotRequest copySnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Makes a copy of an existing snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopySnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link CopySnapshotRequest#builder()}
     * </p>
     *
     * @param copySnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CopySnapshotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CopySnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotAlreadyExistsException</li>
     *         <li>SnapshotNotFoundException</li>
     *         <li>SnapshotQuotaExceededException</li>
     *         <li>InvalidSnapshotStateException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>TagQuotaPerResourceExceededException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.CopySnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopySnapshotResponse> copySnapshot(Consumer<CopySnapshotRequest.Builder> copySnapshotRequest) {
        return copySnapshot(CopySnapshotRequest.builder().applyMutation(copySnapshotRequest).build());
    }

    /**
     * <p>
     * Creates an Access Control List. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access
     * Contol Lists (ACLs)</a>.
     * </p>
     *
     * @param createAclRequest
     * @return A Java Future containing the result of the CreateACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserNotFoundException</li>
     *         <li>DuplicateUserNameException</li>
     *         <li>AclAlreadyExistsException</li>
     *         <li>DefaultUserRequiredException</li>
     *         <li>AclQuotaExceededException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>TagQuotaPerResourceExceededException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.CreateACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAclResponse> createACL(CreateAclRequest createAclRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Access Control List. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access
     * Contol Lists (ACLs)</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAclRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAclRequest#builder()}
     * </p>
     *
     * @param createAclRequest
     *        A {@link Consumer} that will call methods on {@link CreateACLRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserNotFoundException</li>
     *         <li>DuplicateUserNameException</li>
     *         <li>AclAlreadyExistsException</li>
     *         <li>DefaultUserRequiredException</li>
     *         <li>AclQuotaExceededException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>TagQuotaPerResourceExceededException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.CreateACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAclResponse> createACL(Consumer<CreateAclRequest.Builder> createAclRequest) {
        return createACL(CreateAclRequest.builder().applyMutation(createAclRequest).build());
    }

    /**
     * <p>
     * Creates a cluster. All nodes in the cluster run the same protocol-compliant engine software.
     * </p>
     *
     * @param createClusterRequest
     * @return A Java Future containing the result of the CreateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterAlreadyExistsException</li>
     *         <li>SubnetGroupNotFoundException</li>
     *         <li>ClusterQuotaForCustomerExceededException</li>
     *         <li>NodeQuotaForClusterExceededException</li>
     *         <li>NodeQuotaForCustomerExceededException</li>
     *         <li>ParameterGroupNotFoundException</li>
     *         <li>InsufficientClusterCapacityException</li>
     *         <li>InvalidVpcNetworkStateException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>ShardsPerClusterQuotaExceededException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>InvalidCredentialsException</li>
     *         <li>TagQuotaPerResourceExceededException</li>
     *         <li>AclNotFoundException</li>
     *         <li>InvalidAclStateException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateClusterResponse> createCluster(CreateClusterRequest createClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a cluster. All nodes in the cluster run the same protocol-compliant engine software.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateClusterRequest#builder()}
     * </p>
     *
     * @param createClusterRequest
     *        A {@link Consumer} that will call methods on {@link CreateClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterAlreadyExistsException</li>
     *         <li>SubnetGroupNotFoundException</li>
     *         <li>ClusterQuotaForCustomerExceededException</li>
     *         <li>NodeQuotaForClusterExceededException</li>
     *         <li>NodeQuotaForCustomerExceededException</li>
     *         <li>ParameterGroupNotFoundException</li>
     *         <li>InsufficientClusterCapacityException</li>
     *         <li>InvalidVpcNetworkStateException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>ShardsPerClusterQuotaExceededException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>InvalidCredentialsException</li>
     *         <li>TagQuotaPerResourceExceededException</li>
     *         <li>AclNotFoundException</li>
     *         <li>InvalidAclStateException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateClusterResponse> createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest) {
        return createCluster(CreateClusterRequest.builder().applyMutation(createClusterRequest).build());
    }

    /**
     * <p>
     * Creates a new MemoryDB parameter group. A parameter group is a collection of parameters and their values that are
     * applied to all of the nodes in any cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/parametergroups.html">Configuring engine parameters
     * using parameter groups</a>.
     * </p>
     *
     * @param createParameterGroupRequest
     * @return A Java Future containing the result of the CreateParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ParameterGroupQuotaExceededException</li>
     *         <li>ParameterGroupAlreadyExistsException</li>
     *         <li>InvalidParameterGroupStateException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>TagQuotaPerResourceExceededException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.CreateParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateParameterGroupResponse> createParameterGroup(
            CreateParameterGroupRequest createParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new MemoryDB parameter group. A parameter group is a collection of parameters and their values that are
     * applied to all of the nodes in any cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/parametergroups.html">Configuring engine parameters
     * using parameter groups</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateParameterGroupRequest#builder()}
     * </p>
     *
     * @param createParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateParameterGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ParameterGroupQuotaExceededException</li>
     *         <li>ParameterGroupAlreadyExistsException</li>
     *         <li>InvalidParameterGroupStateException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>TagQuotaPerResourceExceededException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.CreateParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateParameterGroupResponse> createParameterGroup(
            Consumer<CreateParameterGroupRequest.Builder> createParameterGroupRequest) {
        return createParameterGroup(CreateParameterGroupRequest.builder().applyMutation(createParameterGroupRequest).build());
    }

    /**
     * <p>
     * Creates a copy of an entire cluster at a specific moment in time.
     * </p>
     *
     * @param createSnapshotRequest
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotAlreadyExistsException</li>
     *         <li>ClusterNotFoundException</li>
     *         <li>InvalidClusterStateException</li>
     *         <li>SnapshotQuotaExceededException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>TagQuotaPerResourceExceededException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a copy of an entire cluster at a specific moment in time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSnapshotRequest#builder()}
     * </p>
     *
     * @param createSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateSnapshotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotAlreadyExistsException</li>
     *         <li>ClusterNotFoundException</li>
     *         <li>InvalidClusterStateException</li>
     *         <li>SnapshotQuotaExceededException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>TagQuotaPerResourceExceededException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSnapshotResponse> createSnapshot(Consumer<CreateSnapshotRequest.Builder> createSnapshotRequest) {
        return createSnapshot(CreateSnapshotRequest.builder().applyMutation(createSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a subnet group. A subnet group is a collection of subnets (typically private) that you can designate for
     * your clusters running in an Amazon Virtual Private Cloud (VPC) environment. When you create a cluster in an
     * Amazon VPC, you must specify a subnet group. MemoryDB uses that subnet group to choose a subnet and IP addresses
     * within that subnet to associate with your nodes. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/subnetgroups.html">Subnets and subnet groups</a>.
     * </p>
     *
     * @param createSubnetGroupRequest
     * @return A Java Future containing the result of the CreateSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubnetGroupAlreadyExistsException</li>
     *         <li>SubnetGroupQuotaExceededException</li>
     *         <li>SubnetQuotaExceededException</li>
     *         <li>InvalidSubnetException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>SubnetNotAllowedException</li>
     *         <li>TagQuotaPerResourceExceededException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.CreateSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSubnetGroupResponse> createSubnetGroup(CreateSubnetGroupRequest createSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a subnet group. A subnet group is a collection of subnets (typically private) that you can designate for
     * your clusters running in an Amazon Virtual Private Cloud (VPC) environment. When you create a cluster in an
     * Amazon VPC, you must specify a subnet group. MemoryDB uses that subnet group to choose a subnet and IP addresses
     * within that subnet to associate with your nodes. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/subnetgroups.html">Subnets and subnet groups</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubnetGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateSubnetGroupRequest#builder()}
     * </p>
     *
     * @param createSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateSubnetGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubnetGroupAlreadyExistsException</li>
     *         <li>SubnetGroupQuotaExceededException</li>
     *         <li>SubnetQuotaExceededException</li>
     *         <li>InvalidSubnetException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>SubnetNotAllowedException</li>
     *         <li>TagQuotaPerResourceExceededException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.CreateSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSubnetGroupResponse> createSubnetGroup(
            Consumer<CreateSubnetGroupRequest.Builder> createSubnetGroupRequest) {
        return createSubnetGroup(CreateSubnetGroupRequest.builder().applyMutation(createSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Creates a MemoryDB user. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access
     * Contol Lists (ACLs)</a>.
     * </p>
     *
     * @param createUserRequest
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserAlreadyExistsException</li>
     *         <li>UserQuotaExceededException</li>
     *         <li>DuplicateUserNameException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>TagQuotaPerResourceExceededException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a MemoryDB user. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access
     * Contol Lists (ACLs)</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserAlreadyExistsException</li>
     *         <li>UserQuotaExceededException</li>
     *         <li>DuplicateUserNameException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>TagQuotaPerResourceExceededException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(Consumer<CreateUserRequest.Builder> createUserRequest) {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Deletes an Access Control List. The ACL must first be disassociated from the cluster before it can be deleted.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access
     * Contol Lists (ACLs)</a>.
     * </p>
     *
     * @param deleteAclRequest
     * @return A Java Future containing the result of the DeleteACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AclNotFoundException</li>
     *         <li>InvalidAclStateException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DeleteACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAclResponse> deleteACL(DeleteAclRequest deleteAclRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Access Control List. The ACL must first be disassociated from the cluster before it can be deleted.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access
     * Contol Lists (ACLs)</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAclRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAclRequest#builder()}
     * </p>
     *
     * @param deleteAclRequest
     *        A {@link Consumer} that will call methods on {@link DeleteACLRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AclNotFoundException</li>
     *         <li>InvalidAclStateException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DeleteACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAclResponse> deleteACL(Consumer<DeleteAclRequest.Builder> deleteAclRequest) {
        return deleteACL(DeleteAclRequest.builder().applyMutation(deleteAclRequest).build());
    }

    /**
     * <p>
     * Deletes a cluster. It also deletes all associated nodes and node endpoints
     * </p>
     *
     * @param deleteClusterRequest
     * @return A Java Future containing the result of the DeleteCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException</li>
     *         <li>InvalidClusterStateException</li>
     *         <li>SnapshotAlreadyExistsException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteClusterResponse> deleteCluster(DeleteClusterRequest deleteClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a cluster. It also deletes all associated nodes and node endpoints
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteClusterRequest#builder()}
     * </p>
     *
     * @param deleteClusterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException</li>
     *         <li>InvalidClusterStateException</li>
     *         <li>SnapshotAlreadyExistsException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteClusterResponse> deleteCluster(Consumer<DeleteClusterRequest.Builder> deleteClusterRequest) {
        return deleteCluster(DeleteClusterRequest.builder().applyMutation(deleteClusterRequest).build());
    }

    /**
     * <p>
     * Deletes the specified parameter group. You cannot delete a parameter group if it is associated with any clusters.
     * You cannot delete the default parameter groups in your account.
     * </p>
     *
     * @param deleteParameterGroupRequest
     * @return A Java Future containing the result of the DeleteParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterGroupStateException</li>
     *         <li>ParameterGroupNotFoundException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DeleteParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteParameterGroupResponse> deleteParameterGroup(
            DeleteParameterGroupRequest deleteParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified parameter group. You cannot delete a parameter group if it is associated with any clusters.
     * You cannot delete the default parameter groups in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteParameterGroupRequest#builder()}
     * </p>
     *
     * @param deleteParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteParameterGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterGroupStateException</li>
     *         <li>ParameterGroupNotFoundException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DeleteParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteParameterGroupResponse> deleteParameterGroup(
            Consumer<DeleteParameterGroupRequest.Builder> deleteParameterGroupRequest) {
        return deleteParameterGroup(DeleteParameterGroupRequest.builder().applyMutation(deleteParameterGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an existing snapshot. When you receive a successful response from this operation, MemoryDB immediately
     * begins deleting the snapshot; you cannot cancel or revert this operation.
     * </p>
     *
     * @param deleteSnapshotRequest
     * @return A Java Future containing the result of the DeleteSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotNotFoundException</li>
     *         <li>InvalidSnapshotStateException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing snapshot. When you receive a successful response from this operation, MemoryDB immediately
     * begins deleting the snapshot; you cannot cancel or revert this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSnapshotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotNotFoundException</li>
     *         <li>InvalidSnapshotStateException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(Consumer<DeleteSnapshotRequest.Builder> deleteSnapshotRequest) {
        return deleteSnapshot(DeleteSnapshotRequest.builder().applyMutation(deleteSnapshotRequest).build());
    }

    /**
     * <p>
     * Deletes a subnet group. You cannot delete a default subnet group or one that is associated with any clusters.
     * </p>
     *
     * @param deleteSubnetGroupRequest
     * @return A Java Future containing the result of the DeleteSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubnetGroupInUseException</li>
     *         <li>SubnetGroupNotFoundException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DeleteSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSubnetGroupResponse> deleteSubnetGroup(DeleteSubnetGroupRequest deleteSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a subnet group. You cannot delete a default subnet group or one that is associated with any clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubnetGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteSubnetGroupRequest#builder()}
     * </p>
     *
     * @param deleteSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSubnetGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubnetGroupInUseException</li>
     *         <li>SubnetGroupNotFoundException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DeleteSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSubnetGroupResponse> deleteSubnetGroup(
            Consumer<DeleteSubnetGroupRequest.Builder> deleteSubnetGroupRequest) {
        return deleteSubnetGroup(DeleteSubnetGroupRequest.builder().applyMutation(deleteSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a user. The user will be removed from all ACLs and in turn removed from all clusters.
     * </p>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidUserStateException</li>
     *         <li>UserNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user. The user will be removed from all ACLs and in turn removed from all clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidUserStateException</li>
     *         <li>UserNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Returns a list of ACLs
     * </p>
     *
     * @param describeAcLsRequest
     * @return A Java Future containing the result of the DescribeACLs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AclNotFoundException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DescribeACLs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeACLs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAcLsResponse> describeACLs(DescribeAcLsRequest describeAcLsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of ACLs
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAcLsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAcLsRequest#builder()}
     * </p>
     *
     * @param describeAcLsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeACLsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeACLs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AclNotFoundException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DescribeACLs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeACLs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAcLsResponse> describeACLs(Consumer<DescribeAcLsRequest.Builder> describeAcLsRequest) {
        return describeACLs(DescribeAcLsRequest.builder().applyMutation(describeAcLsRequest).build());
    }

    /**
     * <p>
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific
     * cluster if a cluster name is supplied.
     * </p>
     *
     * @param describeClustersRequest
     * @return A Java Future containing the result of the DescribeClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DescribeClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeClustersResponse> describeClusters(DescribeClustersRequest describeClustersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific
     * cluster if a cluster name is supplied.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClustersRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeClustersRequest#builder()}
     * </p>
     *
     * @param describeClustersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClustersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DescribeClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeClustersResponse> describeClusters(
            Consumer<DescribeClustersRequest.Builder> describeClustersRequest) {
        return describeClusters(DescribeClustersRequest.builder().applyMutation(describeClustersRequest).build());
    }

    /**
     * <p>
     * Returns a list of the available Redis engine versions.
     * </p>
     *
     * @param describeEngineVersionsRequest
     * @return A Java Future containing the result of the DescribeEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DescribeEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEngineVersionsResponse> describeEngineVersions(
            DescribeEngineVersionsRequest describeEngineVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available Redis engine versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEngineVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEngineVersionsRequest#builder()}
     * </p>
     *
     * @param describeEngineVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEngineVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DescribeEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEngineVersionsResponse> describeEngineVersions(
            Consumer<DescribeEngineVersionsRequest.Builder> describeEngineVersionsRequest) {
        return describeEngineVersions(DescribeEngineVersionsRequest.builder().applyMutation(describeEngineVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns events related to clusters, security groups, and parameter groups. You can obtain events specific to a
     * particular cluster, security group, or parameter group by providing the name as a parameter. By default, only the
     * events occurring within the last hour are returned; however, you can retrieve up to 14 days' worth of events if
     * necessary.
     * </p>
     *
     * @param describeEventsRequest
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns events related to clusters, security groups, and parameter groups. You can obtain events specific to a
     * particular cluster, security group, or parameter group by providing the name as a parameter. By default, only the
     * events occurring within the last hour are returned; however, you can retrieve up to 14 days' worth of events if
     * necessary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents(Consumer<DescribeEventsRequest.Builder> describeEventsRequest) {
        return describeEvents(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns a list of parameter group descriptions. If a parameter group name is specified, the list contains only
     * the descriptions for that group.
     * </p>
     *
     * @param describeParameterGroupsRequest
     * @return A Java Future containing the result of the DescribeParameterGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ParameterGroupNotFoundException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DescribeParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeParameterGroupsResponse> describeParameterGroups(
            DescribeParameterGroupsRequest describeParameterGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of parameter group descriptions. If a parameter group name is specified, the list contains only
     * the descriptions for that group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeParameterGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeParameterGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeParameterGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeParameterGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ParameterGroupNotFoundException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DescribeParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeParameterGroupsResponse> describeParameterGroups(
            Consumer<DescribeParameterGroupsRequest.Builder> describeParameterGroupsRequest) {
        return describeParameterGroups(DescribeParameterGroupsRequest.builder().applyMutation(describeParameterGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular parameter group.
     * </p>
     *
     * @param describeParametersRequest
     * @return A Java Future containing the result of the DescribeParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ParameterGroupNotFoundException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeParameters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeParametersResponse> describeParameters(DescribeParametersRequest describeParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeParametersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeParametersRequest#builder()}
     * </p>
     *
     * @param describeParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeParametersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ParameterGroupNotFoundException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeParameters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeParametersResponse> describeParameters(
            Consumer<DescribeParametersRequest.Builder> describeParametersRequest) {
        return describeParameters(DescribeParametersRequest.builder().applyMutation(describeParametersRequest).build());
    }

    /**
     * <p>
     * Returns details of the service updates
     * </p>
     *
     * @param describeServiceUpdatesRequest
     * @return A Java Future containing the result of the DescribeServiceUpdates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DescribeServiceUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeServiceUpdates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeServiceUpdatesResponse> describeServiceUpdates(
            DescribeServiceUpdatesRequest describeServiceUpdatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details of the service updates
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeServiceUpdatesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeServiceUpdatesRequest#builder()}
     * </p>
     *
     * @param describeServiceUpdatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeServiceUpdatesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeServiceUpdates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DescribeServiceUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeServiceUpdates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeServiceUpdatesResponse> describeServiceUpdates(
            Consumer<DescribeServiceUpdatesRequest.Builder> describeServiceUpdatesRequest) {
        return describeServiceUpdates(DescribeServiceUpdatesRequest.builder().applyMutation(describeServiceUpdatesRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about cluster snapshots. By default, DescribeSnapshots lists all of your snapshots; it can
     * optionally describe a single snapshot, or just the snapshots associated with a particular cluster.
     * </p>
     *
     * @param describeSnapshotsRequest
     * @return A Java Future containing the result of the DescribeSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotNotFoundException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeSnapshotsResponse> describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about cluster snapshots. By default, DescribeSnapshots lists all of your snapshots; it can
     * optionally describe a single snapshot, or just the snapshots associated with a particular cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSnapshotsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSnapshotsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotNotFoundException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeSnapshotsResponse> describeSnapshots(
            Consumer<DescribeSnapshotsRequest.Builder> describeSnapshotsRequest) {
        return describeSnapshots(DescribeSnapshotsRequest.builder().applyMutation(describeSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns a list of subnet group descriptions. If a subnet group name is specified, the list contains only the
     * description of that group.
     * </p>
     *
     * @param describeSubnetGroupsRequest
     * @return A Java Future containing the result of the DescribeSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubnetGroupNotFoundException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DescribeSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeSubnetGroupsResponse> describeSubnetGroups(
            DescribeSubnetGroupsRequest describeSubnetGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of subnet group descriptions. If a subnet group name is specified, the list contains only the
     * description of that group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSubnetGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSubnetGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubnetGroupNotFoundException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DescribeSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeSubnetGroupsResponse> describeSubnetGroups(
            Consumer<DescribeSubnetGroupsRequest.Builder> describeSubnetGroupsRequest) {
        return describeSubnetGroups(DescribeSubnetGroupsRequest.builder().applyMutation(describeSubnetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of users.
     * </p>
     *
     * @param describeUsersRequest
     * @return A Java Future containing the result of the DescribeUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserNotFoundException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeUsersResponse> describeUsers(DescribeUsersRequest describeUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUsersRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUsersRequest#builder()}
     * </p>
     *
     * @param describeUsersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUsersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserNotFoundException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeUsersResponse> describeUsers(Consumer<DescribeUsersRequest.Builder> describeUsersRequest) {
        return describeUsers(DescribeUsersRequest.builder().applyMutation(describeUsersRequest).build());
    }

    /**
     * <p>
     * Used to failover a shard
     * </p>
     *
     * @param failoverShardRequest
     * @return A Java Future containing the result of the FailoverShard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApiCallRateForCustomerExceededException</li>
     *         <li>InvalidClusterStateException</li>
     *         <li>ShardNotFoundException</li>
     *         <li>ClusterNotFoundException</li>
     *         <li>TestFailoverNotAvailableException</li>
     *         <li>InvalidKmsKeyException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.FailoverShard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/FailoverShard" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<FailoverShardResponse> failoverShard(FailoverShardRequest failoverShardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to failover a shard
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FailoverShardRequest.Builder} avoiding the need to
     * create one manually via {@link FailoverShardRequest#builder()}
     * </p>
     *
     * @param failoverShardRequest
     *        A {@link Consumer} that will call methods on {@link FailoverShardRequest.Builder} to create a request.
     * @return A Java Future containing the result of the FailoverShard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApiCallRateForCustomerExceededException</li>
     *         <li>InvalidClusterStateException</li>
     *         <li>ShardNotFoundException</li>
     *         <li>ClusterNotFoundException</li>
     *         <li>TestFailoverNotAvailableException</li>
     *         <li>InvalidKmsKeyException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.FailoverShard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/FailoverShard" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<FailoverShardResponse> failoverShard(Consumer<FailoverShardRequest.Builder> failoverShardRequest) {
        return failoverShard(FailoverShardRequest.builder().applyMutation(failoverShardRequest).build());
    }

    /**
     * <p>
     * Lists all available node types that you can scale to from your cluster's current node type. When you use the
     * UpdateCluster operation to scale your cluster, the value of the NodeType parameter must be one of the node types
     * returned by this operation.
     * </p>
     *
     * @param listAllowedNodeTypeUpdatesRequest
     * @return A Java Future containing the result of the ListAllowedNodeTypeUpdates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.ListAllowedNodeTypeUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/ListAllowedNodeTypeUpdates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAllowedNodeTypeUpdatesResponse> listAllowedNodeTypeUpdates(
            ListAllowedNodeTypeUpdatesRequest listAllowedNodeTypeUpdatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all available node types that you can scale to from your cluster's current node type. When you use the
     * UpdateCluster operation to scale your cluster, the value of the NodeType parameter must be one of the node types
     * returned by this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAllowedNodeTypeUpdatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAllowedNodeTypeUpdatesRequest#builder()}
     * </p>
     *
     * @param listAllowedNodeTypeUpdatesRequest
     *        A {@link Consumer} that will call methods on {@link ListAllowedNodeTypeUpdatesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAllowedNodeTypeUpdates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.ListAllowedNodeTypeUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/ListAllowedNodeTypeUpdates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAllowedNodeTypeUpdatesResponse> listAllowedNodeTypeUpdates(
            Consumer<ListAllowedNodeTypeUpdatesRequest.Builder> listAllowedNodeTypeUpdatesRequest) {
        return listAllowedNodeTypeUpdates(ListAllowedNodeTypeUpdatesRequest.builder()
                .applyMutation(listAllowedNodeTypeUpdatesRequest).build());
    }

    /**
     * <p>
     * Lists all tags currently on a named resource. A tag is a key-value pair where the key and value are
     * case-sensitive. You can use tags to categorize and track your MemoryDB resources. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/Tagging-Resources.html">Tagging your MemoryDB
     * resources</a>
     * </p>
     *
     * @param listTagsRequest
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException</li>
     *         <li>InvalidClusterStateException</li>
     *         <li>ParameterGroupNotFoundException</li>
     *         <li>SubnetGroupNotFoundException</li>
     *         <li>SnapshotNotFoundException</li>
     *         <li>InvalidArnException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>UserNotFoundException</li>
     *         <li>AclNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags currently on a named resource. A tag is a key-value pair where the key and value are
     * case-sensitive. You can use tags to categorize and track your MemoryDB resources. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/Tagging-Resources.html">Tagging your MemoryDB
     * resources</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException</li>
     *         <li>InvalidClusterStateException</li>
     *         <li>ParameterGroupNotFoundException</li>
     *         <li>SubnetGroupNotFoundException</li>
     *         <li>SnapshotNotFoundException</li>
     *         <li>InvalidArnException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>UserNotFoundException</li>
     *         <li>AclNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsResponse> listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Modifies the parameters of a parameter group to the engine or system default value. You can reset specific
     * parameters by submitting a list of parameter names. To reset the entire parameter group, specify the
     * AllParameters and ParameterGroupName parameters.
     * </p>
     *
     * @param resetParameterGroupRequest
     * @return A Java Future containing the result of the ResetParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterGroupStateException</li>
     *         <li>ParameterGroupNotFoundException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.ResetParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/ResetParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ResetParameterGroupResponse> resetParameterGroup(
            ResetParameterGroupRequest resetParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the parameters of a parameter group to the engine or system default value. You can reset specific
     * parameters by submitting a list of parameter names. To reset the entire parameter group, specify the
     * AllParameters and ParameterGroupName parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link ResetParameterGroupRequest#builder()}
     * </p>
     *
     * @param resetParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link ResetParameterGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ResetParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterGroupStateException</li>
     *         <li>ParameterGroupNotFoundException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.ResetParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/ResetParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ResetParameterGroupResponse> resetParameterGroup(
            Consumer<ResetParameterGroupRequest.Builder> resetParameterGroupRequest) {
        return resetParameterGroup(ResetParameterGroupRequest.builder().applyMutation(resetParameterGroupRequest).build());
    }

    /**
     * <p>
     * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track
     * all your MemoryDB resources. When you add or remove tags on clusters, those actions will be replicated to all
     * nodes in the cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/iam.resourcelevelpermissions.html">Resource-level
     * permissions</a>.
     * </p>
     * <p>
     * For example, you can use cost-allocation tags to your MemoryDB resources, Amazon generates a cost allocation
     * report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply
     * tags that represent business categories (such as cost centers, application names, or owners) to organize your
     * costs across multiple services. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/tagging.html">Using Cost Allocation Tags</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException</li>
     *         <li>ParameterGroupNotFoundException</li>
     *         <li>SubnetGroupNotFoundException</li>
     *         <li>InvalidClusterStateException</li>
     *         <li>SnapshotNotFoundException</li>
     *         <li>UserNotFoundException</li>
     *         <li>AclNotFoundException</li>
     *         <li>TagQuotaPerResourceExceededException</li>
     *         <li>InvalidArnException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track
     * all your MemoryDB resources. When you add or remove tags on clusters, those actions will be replicated to all
     * nodes in the cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/iam.resourcelevelpermissions.html">Resource-level
     * permissions</a>.
     * </p>
     * <p>
     * For example, you can use cost-allocation tags to your MemoryDB resources, Amazon generates a cost allocation
     * report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply
     * tags that represent business categories (such as cost centers, application names, or owners) to organize your
     * costs across multiple services. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/tagging.html">Using Cost Allocation Tags</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException</li>
     *         <li>ParameterGroupNotFoundException</li>
     *         <li>SubnetGroupNotFoundException</li>
     *         <li>InvalidClusterStateException</li>
     *         <li>SnapshotNotFoundException</li>
     *         <li>UserNotFoundException</li>
     *         <li>AclNotFoundException</li>
     *         <li>TagQuotaPerResourceExceededException</li>
     *         <li>InvalidArnException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Use this operation to remove tags on a resource
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException</li>
     *         <li>InvalidClusterStateException</li>
     *         <li>ParameterGroupNotFoundException</li>
     *         <li>SubnetGroupNotFoundException</li>
     *         <li>SnapshotNotFoundException</li>
     *         <li>InvalidArnException</li>
     *         <li>TagNotFoundException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>UserNotFoundException</li>
     *         <li>AclNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to remove tags on a resource
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException</li>
     *         <li>InvalidClusterStateException</li>
     *         <li>ParameterGroupNotFoundException</li>
     *         <li>SubnetGroupNotFoundException</li>
     *         <li>SnapshotNotFoundException</li>
     *         <li>InvalidArnException</li>
     *         <li>TagNotFoundException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>UserNotFoundException</li>
     *         <li>AclNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Changes the list of users that belong to the Access Control List.
     * </p>
     *
     * @param updateAclRequest
     * @return A Java Future containing the result of the UpdateACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AclNotFoundException</li>
     *         <li>UserNotFoundException</li>
     *         <li>DuplicateUserNameException</li>
     *         <li>DefaultUserRequiredException</li>
     *         <li>InvalidAclStateException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.UpdateACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAclResponse> updateACL(UpdateAclRequest updateAclRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the list of users that belong to the Access Control List.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAclRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAclRequest#builder()}
     * </p>
     *
     * @param updateAclRequest
     *        A {@link Consumer} that will call methods on {@link UpdateACLRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AclNotFoundException</li>
     *         <li>UserNotFoundException</li>
     *         <li>DuplicateUserNameException</li>
     *         <li>DefaultUserRequiredException</li>
     *         <li>InvalidAclStateException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.UpdateACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAclResponse> updateACL(Consumer<UpdateAclRequest.Builder> updateAclRequest) {
        return updateACL(UpdateAclRequest.builder().applyMutation(updateAclRequest).build());
    }

    /**
     * <p>
     * Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration
     * settings by specifying the settings and the new values.
     * </p>
     *
     * @param updateClusterRequest
     * @return A Java Future containing the result of the UpdateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException</li>
     *         <li>InvalidClusterStateException</li>
     *         <li>InvalidNodeStateException</li>
     *         <li>ParameterGroupNotFoundException</li>
     *         <li>InvalidVpcNetworkStateException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidKmsKeyException</li>
     *         <li>NodeQuotaForClusterExceededException</li>
     *         <li>ClusterQuotaForCustomerExceededException</li>
     *         <li>ShardsPerClusterQuotaExceededException</li>
     *         <li>NodeQuotaForCustomerExceededException</li>
     *         <li>NoOperationException</li>
     *         <li>InvalidAclStateException</li>
     *         <li>AclNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.UpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateClusterResponse> updateCluster(UpdateClusterRequest updateClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration
     * settings by specifying the settings and the new values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateClusterRequest#builder()}
     * </p>
     *
     * @param updateClusterRequest
     *        A {@link Consumer} that will call methods on {@link UpdateClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException</li>
     *         <li>InvalidClusterStateException</li>
     *         <li>InvalidNodeStateException</li>
     *         <li>ParameterGroupNotFoundException</li>
     *         <li>InvalidVpcNetworkStateException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidKmsKeyException</li>
     *         <li>NodeQuotaForClusterExceededException</li>
     *         <li>ClusterQuotaForCustomerExceededException</li>
     *         <li>ShardsPerClusterQuotaExceededException</li>
     *         <li>NodeQuotaForCustomerExceededException</li>
     *         <li>NoOperationException</li>
     *         <li>InvalidAclStateException</li>
     *         <li>AclNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.UpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateClusterResponse> updateCluster(Consumer<UpdateClusterRequest.Builder> updateClusterRequest) {
        return updateCluster(UpdateClusterRequest.builder().applyMutation(updateClusterRequest).build());
    }

    /**
     * <p>
     * Updates the parameters of a parameter group. You can modify up to 20 parameters in a single request by submitting
     * a list parameter name and value pairs.
     * </p>
     *
     * @param updateParameterGroupRequest
     * @return A Java Future containing the result of the UpdateParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ParameterGroupNotFoundException</li>
     *         <li>InvalidParameterGroupStateException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.UpdateParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateParameterGroupResponse> updateParameterGroup(
            UpdateParameterGroupRequest updateParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the parameters of a parameter group. You can modify up to 20 parameters in a single request by submitting
     * a list parameter name and value pairs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateParameterGroupRequest#builder()}
     * </p>
     *
     * @param updateParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateParameterGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ParameterGroupNotFoundException</li>
     *         <li>InvalidParameterGroupStateException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.UpdateParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateParameterGroupResponse> updateParameterGroup(
            Consumer<UpdateParameterGroupRequest.Builder> updateParameterGroupRequest) {
        return updateParameterGroup(UpdateParameterGroupRequest.builder().applyMutation(updateParameterGroupRequest).build());
    }

    /**
     * <p>
     * Updates a subnet group. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/ubnetGroups.Modifying.html">Updating a subnet
     * group</a>
     * </p>
     *
     * @param updateSubnetGroupRequest
     * @return A Java Future containing the result of the UpdateSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubnetGroupNotFoundException</li>
     *         <li>SubnetQuotaExceededException</li>
     *         <li>SubnetInUseException</li>
     *         <li>InvalidSubnetException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>SubnetNotAllowedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.UpdateSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSubnetGroupResponse> updateSubnetGroup(UpdateSubnetGroupRequest updateSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a subnet group. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/ubnetGroups.Modifying.html">Updating a subnet
     * group</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSubnetGroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateSubnetGroupRequest#builder()}
     * </p>
     *
     * @param updateSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSubnetGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubnetGroupNotFoundException</li>
     *         <li>SubnetQuotaExceededException</li>
     *         <li>SubnetInUseException</li>
     *         <li>InvalidSubnetException</li>
     *         <li>ServiceLinkedRoleNotFoundException</li>
     *         <li>SubnetNotAllowedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.UpdateSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSubnetGroupResponse> updateSubnetGroup(
            Consumer<UpdateSubnetGroupRequest.Builder> updateSubnetGroupRequest) {
        return updateSubnetGroup(UpdateSubnetGroupRequest.builder().applyMutation(updateSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Changes user password(s) and/or access string.
     * </p>
     *
     * @param updateUserRequest
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserNotFoundException</li>
     *         <li>InvalidUserStateException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(UpdateUserRequest updateUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes user password(s) and/or access string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUserRequest#builder()}
     * </p>
     *
     * @param updateUserRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserNotFoundException</li>
     *         <li>InvalidUserStateException</li>
     *         <li>InvalidParameterValueException</li>
     *         <li>InvalidParameterCombinationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MemoryDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MemoryDbAsyncClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(Consumer<UpdateUserRequest.Builder> updateUserRequest) {
        return updateUser(UpdateUserRequest.builder().applyMutation(updateUserRequest).build());
    }
}
