/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.memorydb.MemoryDbAsyncClient;
import software.amazon.awssdk.services.memorydb.internal.UserAgentUtils;
import software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsResponse;
import software.amazon.awssdk.services.memorydb.model.ParameterGroup;

public class DescribeParameterGroupsPublisher
implements SdkPublisher<DescribeParameterGroupsResponse> {
    private final MemoryDbAsyncClient client;
    private final DescribeParameterGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeParameterGroupsPublisher(MemoryDbAsyncClient client, DescribeParameterGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeParameterGroupsPublisher(MemoryDbAsyncClient client, DescribeParameterGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeParameterGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeParameterGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ParameterGroup> parameterGroups() {
        Function<DescribeParameterGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.parameterGroups() != null) {
                return response.parameterGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeParameterGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeParameterGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeParameterGroupsResponse> {
        private DescribeParameterGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeParameterGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeParameterGroupsResponse> nextPage(DescribeParameterGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeParameterGroupsPublisher.this.client.describeParameterGroups(DescribeParameterGroupsPublisher.this.firstRequest);
            }
            return DescribeParameterGroupsPublisher.this.client.describeParameterGroups((DescribeParameterGroupsRequest)((Object)DescribeParameterGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

