/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.ACLsUpdateStatus;
import software.amazon.awssdk.services.memorydb.model.PendingModifiedServiceUpdate;
import software.amazon.awssdk.services.memorydb.model.PendingModifiedServiceUpdateListCopier;
import software.amazon.awssdk.services.memorydb.model.ReshardingStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterPendingUpdates
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterPendingUpdates> {
    private static final SdkField<ReshardingStatus> RESHARDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Resharding").getter(ClusterPendingUpdates.getter(ClusterPendingUpdates::resharding)).setter(ClusterPendingUpdates.setter(Builder::resharding)).constructor(ReshardingStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resharding").build()}).build();
    private static final SdkField<ACLsUpdateStatus> AC_LS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ACLs").getter(ClusterPendingUpdates.getter(ClusterPendingUpdates::acLs)).setter(ClusterPendingUpdates.setter(Builder::acLs)).constructor(ACLsUpdateStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ACLs").build()}).build();
    private static final SdkField<List<PendingModifiedServiceUpdate>> SERVICE_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceUpdates").getter(ClusterPendingUpdates.getter(ClusterPendingUpdates::serviceUpdates)).setter(ClusterPendingUpdates.setter(Builder::serviceUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PendingModifiedServiceUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESHARDING_FIELD, AC_LS_FIELD, SERVICE_UPDATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterPendingUpdates.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ReshardingStatus resharding;
    private final ACLsUpdateStatus acLs;
    private final List<PendingModifiedServiceUpdate> serviceUpdates;

    private ClusterPendingUpdates(BuilderImpl builder) {
        this.resharding = builder.resharding;
        this.acLs = builder.acLs;
        this.serviceUpdates = builder.serviceUpdates;
    }

    public final ReshardingStatus resharding() {
        return this.resharding;
    }

    public final ACLsUpdateStatus acLs() {
        return this.acLs;
    }

    public final boolean hasServiceUpdates() {
        return this.serviceUpdates != null && !(this.serviceUpdates instanceof SdkAutoConstructList);
    }

    public final List<PendingModifiedServiceUpdate> serviceUpdates() {
        return this.serviceUpdates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resharding());
        hashCode = 31 * hashCode + Objects.hashCode(this.acLs());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceUpdates() ? this.serviceUpdates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterPendingUpdates)) {
            return false;
        }
        ClusterPendingUpdates other = (ClusterPendingUpdates)obj;
        return Objects.equals(this.resharding(), other.resharding()) && Objects.equals(this.acLs(), other.acLs()) && this.hasServiceUpdates() == other.hasServiceUpdates() && Objects.equals(this.serviceUpdates(), other.serviceUpdates());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterPendingUpdates").add("Resharding", (Object)this.resharding()).add("ACLs", (Object)this.acLs()).add("ServiceUpdates", this.hasServiceUpdates() ? this.serviceUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Resharding": {
                return Optional.ofNullable(clazz.cast(this.resharding()));
            }
            case "ACLs": {
                return Optional.ofNullable(clazz.cast(this.acLs()));
            }
            case "ServiceUpdates": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Resharding", RESHARDING_FIELD);
        map.put("ACLs", AC_LS_FIELD);
        map.put("ServiceUpdates", SERVICE_UPDATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterPendingUpdates, T> g) {
        return obj -> g.apply((ClusterPendingUpdates)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ReshardingStatus resharding;
        private ACLsUpdateStatus acLs;
        private List<PendingModifiedServiceUpdate> serviceUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterPendingUpdates model) {
            this.resharding(model.resharding);
            this.acLs(model.acLs);
            this.serviceUpdates(model.serviceUpdates);
        }

        public final ReshardingStatus.Builder getResharding() {
            return this.resharding != null ? this.resharding.toBuilder() : null;
        }

        public final void setResharding(ReshardingStatus.BuilderImpl resharding) {
            this.resharding = resharding != null ? resharding.build() : null;
        }

        @Override
        public final Builder resharding(ReshardingStatus resharding) {
            this.resharding = resharding;
            return this;
        }

        public final ACLsUpdateStatus.Builder getAcLs() {
            return this.acLs != null ? this.acLs.toBuilder() : null;
        }

        public final void setAcLs(ACLsUpdateStatus.BuilderImpl acLs) {
            this.acLs = acLs != null ? acLs.build() : null;
        }

        @Override
        public final Builder acLs(ACLsUpdateStatus acLs) {
            this.acLs = acLs;
            return this;
        }

        public final List<PendingModifiedServiceUpdate.Builder> getServiceUpdates() {
            List<PendingModifiedServiceUpdate.Builder> result = PendingModifiedServiceUpdateListCopier.copyToBuilder(this.serviceUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceUpdates(Collection<PendingModifiedServiceUpdate.BuilderImpl> serviceUpdates) {
            this.serviceUpdates = PendingModifiedServiceUpdateListCopier.copyFromBuilder(serviceUpdates);
        }

        @Override
        public final Builder serviceUpdates(Collection<PendingModifiedServiceUpdate> serviceUpdates) {
            this.serviceUpdates = PendingModifiedServiceUpdateListCopier.copy(serviceUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceUpdates(PendingModifiedServiceUpdate ... serviceUpdates) {
            this.serviceUpdates(Arrays.asList(serviceUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceUpdates(Consumer<PendingModifiedServiceUpdate.Builder> ... serviceUpdates) {
            this.serviceUpdates(Stream.of(serviceUpdates).map(c -> (PendingModifiedServiceUpdate)((PendingModifiedServiceUpdate.Builder)PendingModifiedServiceUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ClusterPendingUpdates build() {
            return new ClusterPendingUpdates(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterPendingUpdates> {
        public Builder resharding(ReshardingStatus var1);

        default public Builder resharding(Consumer<ReshardingStatus.Builder> resharding) {
            return this.resharding((ReshardingStatus)((ReshardingStatus.Builder)ReshardingStatus.builder().applyMutation(resharding)).build());
        }

        public Builder acLs(ACLsUpdateStatus var1);

        default public Builder acLs(Consumer<ACLsUpdateStatus.Builder> acLs) {
            return this.acLs((ACLsUpdateStatus)((ACLsUpdateStatus.Builder)ACLsUpdateStatus.builder().applyMutation(acLs)).build());
        }

        public Builder serviceUpdates(Collection<PendingModifiedServiceUpdate> var1);

        public Builder serviceUpdates(PendingModifiedServiceUpdate ... var1);

        public Builder serviceUpdates(Consumer<PendingModifiedServiceUpdate.Builder> ... var1);
    }
}

