/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.RecurringCharge;
import software.amazon.awssdk.services.memorydb.model.RecurringChargeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedNodesOffering
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedNodesOffering> {
    private static final SdkField<String> RESERVED_NODES_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedNodesOfferingId").getter(ReservedNodesOffering.getter(ReservedNodesOffering::reservedNodesOfferingId)).setter(ReservedNodesOffering.setter(Builder::reservedNodesOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodesOfferingId").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeType").getter(ReservedNodesOffering.getter(ReservedNodesOffering::nodeType)).setter(ReservedNodesOffering.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Duration").getter(ReservedNodesOffering.getter(ReservedNodesOffering::duration)).setter(ReservedNodesOffering.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("FixedPrice").getter(ReservedNodesOffering.getter(ReservedNodesOffering::fixedPrice)).setter(ReservedNodesOffering.setter(Builder::fixedPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice").build()}).build();
    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingType").getter(ReservedNodesOffering.getter(ReservedNodesOffering::offeringType)).setter(ReservedNodesOffering.setter(Builder::offeringType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType").build()}).build();
    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecurringCharges").getter(ReservedNodesOffering.getter(ReservedNodesOffering::recurringCharges)).setter(ReservedNodesOffering.setter(Builder::recurringCharges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecurringCharge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_NODES_OFFERING_ID_FIELD, NODE_TYPE_FIELD, DURATION_FIELD, FIXED_PRICE_FIELD, OFFERING_TYPE_FIELD, RECURRING_CHARGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReservedNodesOffering.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String reservedNodesOfferingId;
    private final String nodeType;
    private final Integer duration;
    private final Double fixedPrice;
    private final String offeringType;
    private final List<RecurringCharge> recurringCharges;

    private ReservedNodesOffering(BuilderImpl builder) {
        this.reservedNodesOfferingId = builder.reservedNodesOfferingId;
        this.nodeType = builder.nodeType;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.offeringType = builder.offeringType;
        this.recurringCharges = builder.recurringCharges;
    }

    public final String reservedNodesOfferingId() {
        return this.reservedNodesOfferingId;
    }

    public final String nodeType() {
        return this.nodeType;
    }

    public final Integer duration() {
        return this.duration;
    }

    public final Double fixedPrice() {
        return this.fixedPrice;
    }

    public final String offeringType() {
        return this.offeringType;
    }

    public final boolean hasRecurringCharges() {
        return this.recurringCharges != null && !(this.recurringCharges instanceof SdkAutoConstructList);
    }

    public final List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedNodesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecurringCharges() ? this.recurringCharges() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedNodesOffering)) {
            return false;
        }
        ReservedNodesOffering other = (ReservedNodesOffering)obj;
        return Objects.equals(this.reservedNodesOfferingId(), other.reservedNodesOfferingId()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.fixedPrice(), other.fixedPrice()) && Objects.equals(this.offeringType(), other.offeringType()) && this.hasRecurringCharges() == other.hasRecurringCharges() && Objects.equals(this.recurringCharges(), other.recurringCharges());
    }

    public final String toString() {
        return ToString.builder((String)"ReservedNodesOffering").add("ReservedNodesOfferingId", (Object)this.reservedNodesOfferingId()).add("NodeType", (Object)this.nodeType()).add("Duration", (Object)this.duration()).add("FixedPrice", (Object)this.fixedPrice()).add("OfferingType", (Object)this.offeringType()).add("RecurringCharges", this.hasRecurringCharges() ? this.recurringCharges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedNodesOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedNodesOfferingId()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "FixedPrice": {
                return Optional.ofNullable(clazz.cast(this.fixedPrice()));
            }
            case "OfferingType": {
                return Optional.ofNullable(clazz.cast(this.offeringType()));
            }
            case "RecurringCharges": {
                return Optional.ofNullable(clazz.cast(this.recurringCharges()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReservedNodesOfferingId", RESERVED_NODES_OFFERING_ID_FIELD);
        map.put("NodeType", NODE_TYPE_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("FixedPrice", FIXED_PRICE_FIELD);
        map.put("OfferingType", OFFERING_TYPE_FIELD);
        map.put("RecurringCharges", RECURRING_CHARGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservedNodesOffering, T> g) {
        return obj -> g.apply((ReservedNodesOffering)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reservedNodesOfferingId;
        private String nodeType;
        private Integer duration;
        private Double fixedPrice;
        private String offeringType;
        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedNodesOffering model) {
            this.reservedNodesOfferingId(model.reservedNodesOfferingId);
            this.nodeType(model.nodeType);
            this.duration(model.duration);
            this.fixedPrice(model.fixedPrice);
            this.offeringType(model.offeringType);
            this.recurringCharges(model.recurringCharges);
        }

        public final String getReservedNodesOfferingId() {
            return this.reservedNodesOfferingId;
        }

        public final void setReservedNodesOfferingId(String reservedNodesOfferingId) {
            this.reservedNodesOfferingId = reservedNodesOfferingId;
        }

        @Override
        public final Builder reservedNodesOfferingId(String reservedNodesOfferingId) {
            this.reservedNodesOfferingId = reservedNodesOfferingId;
            return this;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Double getFixedPrice() {
            return this.fixedPrice;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        public final List<RecurringCharge.Builder> getRecurringCharges() {
            List<RecurringCharge.Builder> result = RecurringChargeListCopier.copyToBuilder(this.recurringCharges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copyFromBuilder(recurringCharges);
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder> ... recurringCharges) {
            this.recurringCharges(Stream.of(recurringCharges).map(c -> (RecurringCharge)((RecurringCharge.Builder)RecurringCharge.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ReservedNodesOffering build() {
            return new ReservedNodesOffering(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedNodesOffering> {
        public Builder reservedNodesOfferingId(String var1);

        public Builder nodeType(String var1);

        public Builder duration(Integer var1);

        public Builder fixedPrice(Double var1);

        public Builder offeringType(String var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);

        public Builder recurringCharges(Consumer<RecurringCharge.Builder> ... var1);
    }
}

