/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.memorydb.MemoryDbClient;
import software.amazon.awssdk.services.memorydb.MemoryDbServiceClientConfiguration;
import software.amazon.awssdk.services.memorydb.internal.MemoryDbServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.memorydb.model.AclAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.AclNotFoundException;
import software.amazon.awssdk.services.memorydb.model.AclQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.ApiCallRateForCustomerExceededException;
import software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterRequest;
import software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterResponse;
import software.amazon.awssdk.services.memorydb.model.ClusterAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.ClusterNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ClusterQuotaForCustomerExceededException;
import software.amazon.awssdk.services.memorydb.model.CopySnapshotRequest;
import software.amazon.awssdk.services.memorydb.model.CopySnapshotResponse;
import software.amazon.awssdk.services.memorydb.model.CreateAclRequest;
import software.amazon.awssdk.services.memorydb.model.CreateAclResponse;
import software.amazon.awssdk.services.memorydb.model.CreateClusterRequest;
import software.amazon.awssdk.services.memorydb.model.CreateClusterResponse;
import software.amazon.awssdk.services.memorydb.model.CreateMultiRegionClusterRequest;
import software.amazon.awssdk.services.memorydb.model.CreateMultiRegionClusterResponse;
import software.amazon.awssdk.services.memorydb.model.CreateParameterGroupRequest;
import software.amazon.awssdk.services.memorydb.model.CreateParameterGroupResponse;
import software.amazon.awssdk.services.memorydb.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.memorydb.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupRequest;
import software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupResponse;
import software.amazon.awssdk.services.memorydb.model.CreateUserRequest;
import software.amazon.awssdk.services.memorydb.model.CreateUserResponse;
import software.amazon.awssdk.services.memorydb.model.DefaultUserRequiredException;
import software.amazon.awssdk.services.memorydb.model.DeleteAclRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteAclResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteClusterRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteClusterResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteMultiRegionClusterRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteMultiRegionClusterResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteSubnetGroupRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteSubnetGroupResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteUserRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteUserResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeAcLsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeClustersResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeEventsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeEventsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeMultiRegionClustersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeMultiRegionClustersResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeMultiRegionParameterGroupsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeMultiRegionParameterGroupsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeMultiRegionParametersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeMultiRegionParametersResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeParametersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeParametersResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeUsersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeUsersResponse;
import software.amazon.awssdk.services.memorydb.model.DuplicateUserNameException;
import software.amazon.awssdk.services.memorydb.model.FailoverShardRequest;
import software.amazon.awssdk.services.memorydb.model.FailoverShardResponse;
import software.amazon.awssdk.services.memorydb.model.InsufficientClusterCapacityException;
import software.amazon.awssdk.services.memorydb.model.InvalidAclStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidArnException;
import software.amazon.awssdk.services.memorydb.model.InvalidClusterStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidCredentialsException;
import software.amazon.awssdk.services.memorydb.model.InvalidKmsKeyException;
import software.amazon.awssdk.services.memorydb.model.InvalidMultiRegionClusterStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidNodeStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.memorydb.model.InvalidParameterGroupStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidParameterValueException;
import software.amazon.awssdk.services.memorydb.model.InvalidSnapshotStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidSubnetException;
import software.amazon.awssdk.services.memorydb.model.InvalidUserStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.memorydb.model.ListAllowedMultiRegionClusterUpdatesRequest;
import software.amazon.awssdk.services.memorydb.model.ListAllowedMultiRegionClusterUpdatesResponse;
import software.amazon.awssdk.services.memorydb.model.ListAllowedNodeTypeUpdatesRequest;
import software.amazon.awssdk.services.memorydb.model.ListAllowedNodeTypeUpdatesResponse;
import software.amazon.awssdk.services.memorydb.model.ListTagsRequest;
import software.amazon.awssdk.services.memorydb.model.ListTagsResponse;
import software.amazon.awssdk.services.memorydb.model.MemoryDbException;
import software.amazon.awssdk.services.memorydb.model.MultiRegionClusterAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.MultiRegionClusterNotFoundException;
import software.amazon.awssdk.services.memorydb.model.MultiRegionParameterGroupNotFoundException;
import software.amazon.awssdk.services.memorydb.model.NoOperationException;
import software.amazon.awssdk.services.memorydb.model.NodeQuotaForClusterExceededException;
import software.amazon.awssdk.services.memorydb.model.NodeQuotaForCustomerExceededException;
import software.amazon.awssdk.services.memorydb.model.ParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.ParameterGroupNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.PurchaseReservedNodesOfferingRequest;
import software.amazon.awssdk.services.memorydb.model.PurchaseReservedNodesOfferingResponse;
import software.amazon.awssdk.services.memorydb.model.ReservedNodeAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.ReservedNodeNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ReservedNodeQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.ReservedNodesOfferingNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ResetParameterGroupRequest;
import software.amazon.awssdk.services.memorydb.model.ResetParameterGroupResponse;
import software.amazon.awssdk.services.memorydb.model.ServiceLinkedRoleNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ServiceUpdateNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ShardNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ShardsPerClusterQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.SnapshotAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.SnapshotNotFoundException;
import software.amazon.awssdk.services.memorydb.model.SnapshotQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.SubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.SubnetGroupInUseException;
import software.amazon.awssdk.services.memorydb.model.SubnetGroupNotFoundException;
import software.amazon.awssdk.services.memorydb.model.SubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.SubnetInUseException;
import software.amazon.awssdk.services.memorydb.model.SubnetNotAllowedException;
import software.amazon.awssdk.services.memorydb.model.SubnetQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.TagNotFoundException;
import software.amazon.awssdk.services.memorydb.model.TagQuotaPerResourceExceededException;
import software.amazon.awssdk.services.memorydb.model.TagResourceRequest;
import software.amazon.awssdk.services.memorydb.model.TagResourceResponse;
import software.amazon.awssdk.services.memorydb.model.TestFailoverNotAvailableException;
import software.amazon.awssdk.services.memorydb.model.UntagResourceRequest;
import software.amazon.awssdk.services.memorydb.model.UntagResourceResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateAclRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateAclResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateClusterRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateClusterResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateMultiRegionClusterRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateMultiRegionClusterResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateUserRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateUserResponse;
import software.amazon.awssdk.services.memorydb.model.UserAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.UserNotFoundException;
import software.amazon.awssdk.services.memorydb.model.UserQuotaExceededException;
import software.amazon.awssdk.services.memorydb.transform.BatchUpdateClusterRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CopySnapshotRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CreateAclRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CreateMultiRegionClusterRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CreateParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CreateSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DeleteAclRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DeleteMultiRegionClusterRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DeleteParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DeleteSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeAcLsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeClustersRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeMultiRegionClustersRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeMultiRegionParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeMultiRegionParametersRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeParametersRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeReservedNodesOfferingsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeReservedNodesRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeServiceUpdatesRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeUsersRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.FailoverShardRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.ListAllowedMultiRegionClusterUpdatesRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.ListAllowedNodeTypeUpdatesRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.PurchaseReservedNodesOfferingRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.ResetParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.UpdateAclRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.UpdateClusterRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.UpdateMultiRegionClusterRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.UpdateParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.UpdateSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultMemoryDbClient
implements MemoryDbClient {
    private static final Logger log = Logger.loggerFor(DefaultMemoryDbClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMemoryDbClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"MemoryDB#2.40.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchUpdateClusterResponse batchUpdateCluster(BatchUpdateClusterRequest batchUpdateClusterRequest) throws ServiceUpdateNotFoundException, InvalidParameterValueException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchUpdateClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchUpdateClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, batchUpdateClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchUpdateCluster");
            BatchUpdateClusterResponse batchUpdateClusterResponse = (BatchUpdateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchUpdateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchUpdateClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchUpdateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchUpdateClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$batchUpdateCluster$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CopySnapshotResponse copySnapshot(CopySnapshotRequest copySnapshotRequest) throws SnapshotAlreadyExistsException, SnapshotNotFoundException, SnapshotQuotaExceededException, InvalidSnapshotStateException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, TagQuotaPerResourceExceededException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CopySnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)copySnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, copySnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopySnapshot");
            CopySnapshotResponse copySnapshotResponse = (CopySnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopySnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)copySnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CopySnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return copySnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$copySnapshot$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAclResponse createACL(CreateAclRequest createAclRequest) throws UserNotFoundException, DuplicateUserNameException, AclAlreadyExistsException, DefaultUserRequiredException, AclQuotaExceededException, InvalidParameterValueException, TagQuotaPerResourceExceededException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAclResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, createAclRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateACL");
            CreateAclResponse createAclResponse = (CreateAclResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateACL").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAclRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAclRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAclResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$createACL$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws ClusterAlreadyExistsException, SubnetGroupNotFoundException, ClusterQuotaForCustomerExceededException, NodeQuotaForClusterExceededException, NodeQuotaForCustomerExceededException, ParameterGroupNotFoundException, InsufficientClusterCapacityException, InvalidVpcNetworkStateException, ServiceLinkedRoleNotFoundException, ShardsPerClusterQuotaExceededException, InvalidParameterValueException, InvalidParameterCombinationException, InvalidCredentialsException, TagQuotaPerResourceExceededException, AclNotFoundException, InvalidAclStateException, MultiRegionClusterNotFoundException, InvalidMultiRegionClusterStateException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, createClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCluster");
            CreateClusterResponse createClusterResponse = (CreateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$createCluster$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMultiRegionClusterResponse createMultiRegionCluster(CreateMultiRegionClusterRequest createMultiRegionClusterRequest) throws MultiRegionClusterAlreadyExistsException, InvalidParameterCombinationException, InvalidParameterValueException, MultiRegionParameterGroupNotFoundException, ClusterQuotaForCustomerExceededException, TagQuotaPerResourceExceededException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMultiRegionClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createMultiRegionClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, createMultiRegionClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMultiRegionCluster");
            CreateMultiRegionClusterResponse createMultiRegionClusterResponse = (CreateMultiRegionClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMultiRegionCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createMultiRegionClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMultiRegionClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMultiRegionClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$createMultiRegionCluster$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateParameterGroupResponse createParameterGroup(CreateParameterGroupRequest createParameterGroupRequest) throws ParameterGroupQuotaExceededException, ParameterGroupAlreadyExistsException, InvalidParameterGroupStateException, ServiceLinkedRoleNotFoundException, TagQuotaPerResourceExceededException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateParameterGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createParameterGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, createParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateParameterGroup");
            CreateParameterGroupResponse createParameterGroupResponse = (CreateParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateParameterGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateParameterGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$createParameterGroup$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSnapshotResponse createSnapshot(CreateSnapshotRequest createSnapshotRequest) throws SnapshotAlreadyExistsException, ClusterNotFoundException, InvalidClusterStateException, SnapshotQuotaExceededException, ServiceLinkedRoleNotFoundException, InvalidParameterCombinationException, InvalidParameterValueException, TagQuotaPerResourceExceededException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, createSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSnapshot");
            CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$createSnapshot$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSubnetGroupResponse createSubnetGroup(CreateSubnetGroupRequest createSubnetGroupRequest) throws SubnetGroupAlreadyExistsException, SubnetGroupQuotaExceededException, SubnetQuotaExceededException, InvalidSubnetException, ServiceLinkedRoleNotFoundException, SubnetNotAllowedException, TagQuotaPerResourceExceededException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSubnetGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSubnetGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, createSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSubnetGroup");
            CreateSubnetGroupResponse createSubnetGroupResponse = (CreateSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSubnetGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createSubnetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSubnetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSubnetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$createSubnetGroup$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateUserResponse createUser(CreateUserRequest createUserRequest) throws UserAlreadyExistsException, UserQuotaExceededException, DuplicateUserNameException, InvalidParameterValueException, InvalidParameterCombinationException, TagQuotaPerResourceExceededException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, createUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUser");
            CreateUserResponse createUserResponse = (CreateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$createUser$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAclResponse deleteACL(DeleteAclRequest deleteAclRequest) throws AclNotFoundException, InvalidAclStateException, InvalidParameterValueException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAclResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, deleteAclRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteACL");
            DeleteAclResponse deleteAclResponse = (DeleteAclResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteACL").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAclRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAclRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAclResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$deleteACL$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws ClusterNotFoundException, InvalidClusterStateException, SnapshotAlreadyExistsException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, deleteClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCluster");
            DeleteClusterResponse deleteClusterResponse = (DeleteClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$deleteCluster$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMultiRegionClusterResponse deleteMultiRegionCluster(DeleteMultiRegionClusterRequest deleteMultiRegionClusterRequest) throws MultiRegionClusterNotFoundException, InvalidMultiRegionClusterStateException, InvalidParameterValueException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMultiRegionClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteMultiRegionClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, deleteMultiRegionClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMultiRegionCluster");
            DeleteMultiRegionClusterResponse deleteMultiRegionClusterResponse = (DeleteMultiRegionClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMultiRegionCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteMultiRegionClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMultiRegionClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMultiRegionClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$deleteMultiRegionCluster$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteParameterGroupResponse deleteParameterGroup(DeleteParameterGroupRequest deleteParameterGroupRequest) throws InvalidParameterGroupStateException, ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteParameterGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteParameterGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, deleteParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteParameterGroup");
            DeleteParameterGroupResponse deleteParameterGroupResponse = (DeleteParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteParameterGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteParameterGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$deleteParameterGroup$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSnapshotResponse deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) throws SnapshotNotFoundException, InvalidSnapshotStateException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, deleteSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSnapshot");
            DeleteSnapshotResponse deleteSnapshotResponse = (DeleteSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$deleteSnapshot$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSubnetGroupResponse deleteSubnetGroup(DeleteSubnetGroupRequest deleteSubnetGroupRequest) throws SubnetGroupInUseException, SubnetGroupNotFoundException, ServiceLinkedRoleNotFoundException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSubnetGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSubnetGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, deleteSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSubnetGroup");
            DeleteSubnetGroupResponse deleteSubnetGroupResponse = (DeleteSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSubnetGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteSubnetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSubnetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSubnetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$deleteSubnetGroup$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws InvalidUserStateException, UserNotFoundException, InvalidParameterValueException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, deleteUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteUser");
            DeleteUserResponse deleteUserResponse = (DeleteUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$deleteUser$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAcLsResponse describeACLs(DescribeAcLsRequest describeAcLsRequest) throws AclNotFoundException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAcLsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAcLsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, describeAcLsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeACLs");
            DescribeAcLsResponse describeAcLsResponse = (DescribeAcLsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeACLs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAcLsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAcLsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAcLsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$describeACLs$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeClustersResponse describeClusters(DescribeClustersRequest describeClustersRequest) throws ClusterNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeClustersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClustersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, describeClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusters");
            DescribeClustersResponse describeClustersResponse = (DescribeClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeClustersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeClustersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeClustersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$describeClusters$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEngineVersionsResponse describeEngineVersions(DescribeEngineVersionsRequest describeEngineVersionsRequest) throws ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEngineVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEngineVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, describeEngineVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEngineVersions");
            DescribeEngineVersionsResponse describeEngineVersionsResponse = (DescribeEngineVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEngineVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeEngineVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEngineVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEngineVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$describeEngineVersions$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, describeEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEvents");
            DescribeEventsResponse describeEventsResponse = (DescribeEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$describeEvents$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMultiRegionClustersResponse describeMultiRegionClusters(DescribeMultiRegionClustersRequest describeMultiRegionClustersRequest) throws ClusterNotFoundException, InvalidParameterCombinationException, InvalidParameterValueException, MultiRegionClusterNotFoundException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMultiRegionClustersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMultiRegionClustersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, describeMultiRegionClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMultiRegionClusters");
            DescribeMultiRegionClustersResponse describeMultiRegionClustersResponse = (DescribeMultiRegionClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMultiRegionClusters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeMultiRegionClustersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMultiRegionClustersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMultiRegionClustersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$describeMultiRegionClusters$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMultiRegionParameterGroupsResponse describeMultiRegionParameterGroups(DescribeMultiRegionParameterGroupsRequest describeMultiRegionParameterGroupsRequest) throws MultiRegionParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMultiRegionParameterGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMultiRegionParameterGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, describeMultiRegionParameterGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMultiRegionParameterGroups");
            DescribeMultiRegionParameterGroupsResponse describeMultiRegionParameterGroupsResponse = (DescribeMultiRegionParameterGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMultiRegionParameterGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeMultiRegionParameterGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMultiRegionParameterGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMultiRegionParameterGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$describeMultiRegionParameterGroups$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMultiRegionParametersResponse describeMultiRegionParameters(DescribeMultiRegionParametersRequest describeMultiRegionParametersRequest) throws MultiRegionParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMultiRegionParametersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMultiRegionParametersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, describeMultiRegionParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMultiRegionParameters");
            DescribeMultiRegionParametersResponse describeMultiRegionParametersResponse = (DescribeMultiRegionParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMultiRegionParameters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeMultiRegionParametersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMultiRegionParametersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMultiRegionParametersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$describeMultiRegionParameters$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeParameterGroupsResponse describeParameterGroups(DescribeParameterGroupsRequest describeParameterGroupsRequest) throws ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeParameterGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeParameterGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, describeParameterGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeParameterGroups");
            DescribeParameterGroupsResponse describeParameterGroupsResponse = (DescribeParameterGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeParameterGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeParameterGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeParameterGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeParameterGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$describeParameterGroups$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeParametersResponse describeParameters(DescribeParametersRequest describeParametersRequest) throws ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeParametersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeParametersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, describeParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeParameters");
            DescribeParametersResponse describeParametersResponse = (DescribeParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeParameters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeParametersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeParametersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeParametersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$describeParameters$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReservedNodesResponse describeReservedNodes(DescribeReservedNodesRequest describeReservedNodesRequest) throws ReservedNodeNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReservedNodesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReservedNodesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, describeReservedNodesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReservedNodes");
            DescribeReservedNodesResponse describeReservedNodesResponse = (DescribeReservedNodesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservedNodes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeReservedNodesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReservedNodesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReservedNodesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$describeReservedNodes$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReservedNodesOfferingsResponse describeReservedNodesOfferings(DescribeReservedNodesOfferingsRequest describeReservedNodesOfferingsRequest) throws ReservedNodesOfferingNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReservedNodesOfferingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReservedNodesOfferingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, describeReservedNodesOfferingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReservedNodesOfferings");
            DescribeReservedNodesOfferingsResponse describeReservedNodesOfferingsResponse = (DescribeReservedNodesOfferingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservedNodesOfferings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeReservedNodesOfferingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReservedNodesOfferingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReservedNodesOfferingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$describeReservedNodesOfferings$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeServiceUpdatesResponse describeServiceUpdates(DescribeServiceUpdatesRequest describeServiceUpdatesRequest) throws InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeServiceUpdatesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeServiceUpdatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, describeServiceUpdatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeServiceUpdates");
            DescribeServiceUpdatesResponse describeServiceUpdatesResponse = (DescribeServiceUpdatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeServiceUpdates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeServiceUpdatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeServiceUpdatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeServiceUpdatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$describeServiceUpdates$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSnapshotsResponse describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) throws SnapshotNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSnapshotsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSnapshotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, describeSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSnapshots");
            DescribeSnapshotsResponse describeSnapshotsResponse = (DescribeSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSnapshots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeSnapshotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSnapshotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$describeSnapshots$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSubnetGroupsResponse describeSubnetGroups(DescribeSubnetGroupsRequest describeSubnetGroupsRequest) throws SubnetGroupNotFoundException, ServiceLinkedRoleNotFoundException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSubnetGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSubnetGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, describeSubnetGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSubnetGroups");
            DescribeSubnetGroupsResponse describeSubnetGroupsResponse = (DescribeSubnetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSubnetGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeSubnetGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSubnetGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSubnetGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$describeSubnetGroups$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeUsersResponse describeUsers(DescribeUsersRequest describeUsersRequest) throws UserNotFoundException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeUsersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, describeUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeUsers");
            DescribeUsersResponse describeUsersResponse = (DescribeUsersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUsers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeUsersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeUsersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$describeUsers$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FailoverShardResponse failoverShard(FailoverShardRequest failoverShardRequest) throws ApiCallRateForCustomerExceededException, InvalidClusterStateException, ShardNotFoundException, ClusterNotFoundException, TestFailoverNotAvailableException, InvalidKmsKeyException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, FailoverShardResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)failoverShardRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, failoverShardRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"FailoverShard");
            FailoverShardResponse failoverShardResponse = (FailoverShardResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("FailoverShard").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)failoverShardRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new FailoverShardRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return failoverShardResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$failoverShard$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAllowedMultiRegionClusterUpdatesResponse listAllowedMultiRegionClusterUpdates(ListAllowedMultiRegionClusterUpdatesRequest listAllowedMultiRegionClusterUpdatesRequest) throws MultiRegionClusterNotFoundException, InvalidParameterCombinationException, InvalidParameterValueException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAllowedMultiRegionClusterUpdatesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAllowedMultiRegionClusterUpdatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, listAllowedMultiRegionClusterUpdatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAllowedMultiRegionClusterUpdates");
            ListAllowedMultiRegionClusterUpdatesResponse listAllowedMultiRegionClusterUpdatesResponse = (ListAllowedMultiRegionClusterUpdatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAllowedMultiRegionClusterUpdates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAllowedMultiRegionClusterUpdatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAllowedMultiRegionClusterUpdatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAllowedMultiRegionClusterUpdatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$listAllowedMultiRegionClusterUpdates$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAllowedNodeTypeUpdatesResponse listAllowedNodeTypeUpdates(ListAllowedNodeTypeUpdatesRequest listAllowedNodeTypeUpdatesRequest) throws ClusterNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterCombinationException, InvalidParameterValueException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAllowedNodeTypeUpdatesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAllowedNodeTypeUpdatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, listAllowedNodeTypeUpdatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAllowedNodeTypeUpdates");
            ListAllowedNodeTypeUpdatesResponse listAllowedNodeTypeUpdatesResponse = (ListAllowedNodeTypeUpdatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAllowedNodeTypeUpdates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAllowedNodeTypeUpdatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAllowedNodeTypeUpdatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAllowedNodeTypeUpdatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$listAllowedNodeTypeUpdates$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws ClusterNotFoundException, InvalidClusterStateException, ParameterGroupNotFoundException, SubnetGroupNotFoundException, SnapshotNotFoundException, InvalidArnException, ServiceLinkedRoleNotFoundException, UserNotFoundException, AclNotFoundException, MultiRegionClusterNotFoundException, MultiRegionParameterGroupNotFoundException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, listTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTags");
            ListTagsResponse listTagsResponse = (ListTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$listTags$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PurchaseReservedNodesOfferingResponse purchaseReservedNodesOffering(PurchaseReservedNodesOfferingRequest purchaseReservedNodesOfferingRequest) throws ReservedNodesOfferingNotFoundException, ReservedNodeAlreadyExistsException, ReservedNodeQuotaExceededException, ServiceLinkedRoleNotFoundException, TagQuotaPerResourceExceededException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PurchaseReservedNodesOfferingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)purchaseReservedNodesOfferingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, purchaseReservedNodesOfferingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PurchaseReservedNodesOffering");
            PurchaseReservedNodesOfferingResponse purchaseReservedNodesOfferingResponse = (PurchaseReservedNodesOfferingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PurchaseReservedNodesOffering").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)purchaseReservedNodesOfferingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PurchaseReservedNodesOfferingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return purchaseReservedNodesOfferingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$purchaseReservedNodesOffering$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResetParameterGroupResponse resetParameterGroup(ResetParameterGroupRequest resetParameterGroupRequest) throws InvalidParameterGroupStateException, ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResetParameterGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resetParameterGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, resetParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetParameterGroup");
            ResetParameterGroupResponse resetParameterGroupResponse = (ResetParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetParameterGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)resetParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ResetParameterGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return resetParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$resetParameterGroup$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ClusterNotFoundException, ParameterGroupNotFoundException, SubnetGroupNotFoundException, InvalidClusterStateException, SnapshotNotFoundException, UserNotFoundException, AclNotFoundException, MultiRegionClusterNotFoundException, MultiRegionParameterGroupNotFoundException, TagQuotaPerResourceExceededException, InvalidArnException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$tagResource$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ClusterNotFoundException, InvalidClusterStateException, ParameterGroupNotFoundException, SubnetGroupNotFoundException, SnapshotNotFoundException, InvalidArnException, TagNotFoundException, ServiceLinkedRoleNotFoundException, UserNotFoundException, AclNotFoundException, InvalidParameterValueException, MultiRegionClusterNotFoundException, MultiRegionParameterGroupNotFoundException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$untagResource$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAclResponse updateACL(UpdateAclRequest updateAclRequest) throws AclNotFoundException, UserNotFoundException, DuplicateUserNameException, DefaultUserRequiredException, InvalidAclStateException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAclResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, updateAclRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateACL");
            UpdateAclResponse updateAclResponse = (UpdateAclResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateACL").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateAclRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAclRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAclResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$updateACL$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateClusterResponse updateCluster(UpdateClusterRequest updateClusterRequest) throws ClusterNotFoundException, InvalidClusterStateException, InvalidNodeStateException, ParameterGroupNotFoundException, InvalidVpcNetworkStateException, ServiceLinkedRoleNotFoundException, InvalidKmsKeyException, NodeQuotaForClusterExceededException, ClusterQuotaForCustomerExceededException, ShardsPerClusterQuotaExceededException, NodeQuotaForCustomerExceededException, NoOperationException, InvalidAclStateException, AclNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, updateClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCluster");
            UpdateClusterResponse updateClusterResponse = (UpdateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$updateCluster$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateMultiRegionClusterResponse updateMultiRegionCluster(UpdateMultiRegionClusterRequest updateMultiRegionClusterRequest) throws MultiRegionClusterNotFoundException, MultiRegionParameterGroupNotFoundException, InvalidMultiRegionClusterStateException, InvalidParameterCombinationException, InvalidParameterValueException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMultiRegionClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateMultiRegionClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, updateMultiRegionClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateMultiRegionCluster");
            UpdateMultiRegionClusterResponse updateMultiRegionClusterResponse = (UpdateMultiRegionClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateMultiRegionCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateMultiRegionClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateMultiRegionClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateMultiRegionClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$updateMultiRegionCluster$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateParameterGroupResponse updateParameterGroup(UpdateParameterGroupRequest updateParameterGroupRequest) throws ParameterGroupNotFoundException, InvalidParameterGroupStateException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateParameterGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateParameterGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, updateParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateParameterGroup");
            UpdateParameterGroupResponse updateParameterGroupResponse = (UpdateParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateParameterGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateParameterGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$updateParameterGroup$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSubnetGroupResponse updateSubnetGroup(UpdateSubnetGroupRequest updateSubnetGroupRequest) throws SubnetGroupNotFoundException, SubnetQuotaExceededException, SubnetInUseException, InvalidSubnetException, ServiceLinkedRoleNotFoundException, SubnetNotAllowedException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSubnetGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSubnetGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, updateSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSubnetGroup");
            UpdateSubnetGroupResponse updateSubnetGroupResponse = (UpdateSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSubnetGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateSubnetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSubnetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSubnetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$updateSubnetGroup$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws UserNotFoundException, InvalidUserStateException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "SubnetGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                }
                case "ParameterGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                }
                case "SubnetInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                }
                case "InvalidARNFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "TestFailoverNotAvailableFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                }
                case "ACLQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                }
                case "InvalidKMSKeyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                }
                case "DuplicateUserNameFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                }
                case "SubnetNotAllowedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                }
                case "InvalidVPCNetworkStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                }
                case "InvalidParameterGroupStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                }
                case "ParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                }
                case "ServiceLinkedRoleNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                }
                case "ParameterGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                }
                case "UserNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                }
                case "ClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                }
                case "MultiRegionClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "InvalidClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                }
                case "MultiRegionClusterNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                }
                case "SubnetGroupInUseFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "ClusterAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                }
                case "NoOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                }
                case "ShardNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                }
                case "ACLNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                }
                case "SubnetGroupQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                }
                case "ReservedNodesOfferingNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "SnapshotAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                }
                case "SnapshotQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                }
                case "DefaultUserRequired": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                }
                case "NodeQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                }
                case "UserAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                }
                case "InvalidACLStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                }
                case "TagNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                }
                case "ClusterQuotaForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                }
                case "APICallRateForCustomerExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                }
                case "NodeQuotaForClusterExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                }
                case "ServiceUpdateNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                }
                case "SubnetQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                }
                case "ReservedNodeQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                }
                case "InvalidSnapshotStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                }
                case "InvalidNodeStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                }
                case "ShardsPerClusterQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                }
                case "ReservedNodeAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                }
                case "ReservedNodeNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidUserStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                }
                case "SnapshotNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                }
                case "MultiRegionParameterGroupNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                }
                case "ACLAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                }
                case "InsufficientClusterCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                }
                case "UserQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                }
                case "TagQuotaPerResourceExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                }
                case "InvalidMultiRegionClusterStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                }
                case "SubnetGroupAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbClient.resolveMetricPublishers(clientConfiguration, updateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateUser");
            UpdateUserResponse updateUserResponse = (UpdateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbClient.lambda$updateUser$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "memorydb";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        MemoryDbServiceClientConfigurationBuilder serviceConfigBuilder = new MemoryDbServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(MemoryDbException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final MemoryDbServiceClientConfiguration serviceClientConfiguration() {
        return new MemoryDbServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateUser$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSubnetGroup$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateParameterGroup$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateMultiRegionCluster$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCluster$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateACL$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resetParameterGroup$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$purchaseReservedNodesOffering$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTags$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAllowedNodeTypeUpdates$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAllowedMultiRegionClusterUpdates$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$failoverShard$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeUsers$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSubnetGroups$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSnapshots$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeServiceUpdates$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReservedNodesOfferings$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReservedNodes$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeParameters$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeParameterGroups$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMultiRegionParameters$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMultiRegionParameterGroups$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMultiRegionClusters$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEvents$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEngineVersions$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeClusters$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeACLs$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteUser$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSubnetGroup$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSnapshot$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteParameterGroup$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMultiRegionCluster$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCluster$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteACL$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createUser$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSubnetGroup$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSnapshot$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createParameterGroup$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMultiRegionCluster$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCluster$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createACL$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$copySnapshot$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchUpdateCluster$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

