/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.auth.scheme;

import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.services.memorydb.auth.scheme.MemoryDbAuthSchemeParams;
import software.amazon.awssdk.services.memorydb.auth.scheme.internal.DefaultMemoryDbAuthSchemeProvider;
import software.amazon.awssdk.services.memorydb.auth.scheme.internal.PreferredMemoryDbAuthSchemeProvider;

@SdkPublicApi
public interface MemoryDbAuthSchemeProvider
extends AuthSchemeProvider {
    public List<AuthSchemeOption> resolveAuthScheme(MemoryDbAuthSchemeParams var1);

    default public List<AuthSchemeOption> resolveAuthScheme(Consumer<MemoryDbAuthSchemeParams.Builder> consumer) {
        MemoryDbAuthSchemeParams.Builder builder = MemoryDbAuthSchemeParams.builder();
        consumer.accept(builder);
        return this.resolveAuthScheme(builder.build());
    }

    public static MemoryDbAuthSchemeProvider defaultProvider() {
        return DefaultMemoryDbAuthSchemeProvider.create();
    }

    public static MemoryDbAuthSchemeProvider defaultProvider(List<String> authSchemePreference) {
        return new PreferredMemoryDbAuthSchemeProvider(MemoryDbAuthSchemeProvider.defaultProvider(), authSchemePreference);
    }
}

