/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mgn.model.MgnResponse;
import software.amazon.awssdk.services.mgn.model.TagsMapCopier;
import software.amazon.awssdk.services.mgn.model.WaveAggregatedStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWaveResponse
extends MgnResponse
implements ToCopyableBuilder<Builder, CreateWaveResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateWaveResponse.getter(CreateWaveResponse::arn)).setter(CreateWaveResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creationDateTime").getter(CreateWaveResponse.getter(CreateWaveResponse::creationDateTime)).setter(CreateWaveResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateWaveResponse.getter(CreateWaveResponse::description)).setter(CreateWaveResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> IS_ARCHIVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isArchived").getter(CreateWaveResponse.getter(CreateWaveResponse::isArchived)).setter(CreateWaveResponse.setter(Builder::isArchived)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isArchived").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastModifiedDateTime").getter(CreateWaveResponse.getter(CreateWaveResponse::lastModifiedDateTime)).setter(CreateWaveResponse.setter(Builder::lastModifiedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDateTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateWaveResponse.getter(CreateWaveResponse::name)).setter(CreateWaveResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateWaveResponse.getter(CreateWaveResponse::tags)).setter(CreateWaveResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<WaveAggregatedStatus> WAVE_AGGREGATED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("waveAggregatedStatus").getter(CreateWaveResponse.getter(CreateWaveResponse::waveAggregatedStatus)).setter(CreateWaveResponse.setter(Builder::waveAggregatedStatus)).constructor(WaveAggregatedStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waveAggregatedStatus").build()}).build();
    private static final SdkField<String> WAVE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("waveID").getter(CreateWaveResponse.getter(CreateWaveResponse::waveID)).setter(CreateWaveResponse.setter(Builder::waveID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waveID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_DATE_TIME_FIELD, DESCRIPTION_FIELD, IS_ARCHIVED_FIELD, LAST_MODIFIED_DATE_TIME_FIELD, NAME_FIELD, TAGS_FIELD, WAVE_AGGREGATED_STATUS_FIELD, WAVE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateWaveResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String creationDateTime;
    private final String description;
    private final Boolean isArchived;
    private final String lastModifiedDateTime;
    private final String name;
    private final Map<String, String> tags;
    private final WaveAggregatedStatus waveAggregatedStatus;
    private final String waveID;

    private CreateWaveResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationDateTime = builder.creationDateTime;
        this.description = builder.description;
        this.isArchived = builder.isArchived;
        this.lastModifiedDateTime = builder.lastModifiedDateTime;
        this.name = builder.name;
        this.tags = builder.tags;
        this.waveAggregatedStatus = builder.waveAggregatedStatus;
        this.waveID = builder.waveID;
    }

    public final String arn() {
        return this.arn;
    }

    public final String creationDateTime() {
        return this.creationDateTime;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean isArchived() {
        return this.isArchived;
    }

    public final String lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final WaveAggregatedStatus waveAggregatedStatus() {
        return this.waveAggregatedStatus;
    }

    public final String waveID() {
        return this.waveID;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.isArchived());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.waveAggregatedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.waveID());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWaveResponse)) {
            return false;
        }
        CreateWaveResponse other = (CreateWaveResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.isArchived(), other.isArchived()) && Objects.equals(this.lastModifiedDateTime(), other.lastModifiedDateTime()) && Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.waveAggregatedStatus(), other.waveAggregatedStatus()) && Objects.equals(this.waveID(), other.waveID());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWaveResponse").add("Arn", (Object)this.arn()).add("CreationDateTime", (Object)this.creationDateTime()).add("Description", (Object)this.description()).add("IsArchived", (Object)this.isArchived()).add("LastModifiedDateTime", (Object)this.lastModifiedDateTime()).add("Name", (Object)this.name()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("WaveAggregatedStatus", (Object)this.waveAggregatedStatus()).add("WaveID", (Object)this.waveID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "isArchived": {
                return Optional.ofNullable(clazz.cast(this.isArchived()));
            }
            case "lastModifiedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDateTime()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "waveAggregatedStatus": {
                return Optional.ofNullable(clazz.cast(this.waveAggregatedStatus()));
            }
            case "waveID": {
                return Optional.ofNullable(clazz.cast(this.waveID()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("isArchived", IS_ARCHIVED_FIELD);
        map.put("lastModifiedDateTime", LAST_MODIFIED_DATE_TIME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("waveAggregatedStatus", WAVE_AGGREGATED_STATUS_FIELD);
        map.put("waveID", WAVE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWaveResponse, T> g) {
        return obj -> g.apply((CreateWaveResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MgnResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String creationDateTime;
        private String description;
        private Boolean isArchived;
        private String lastModifiedDateTime;
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private WaveAggregatedStatus waveAggregatedStatus;
        private String waveID;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWaveResponse model) {
            super(model);
            this.arn(model.arn);
            this.creationDateTime(model.creationDateTime);
            this.description(model.description);
            this.isArchived(model.isArchived);
            this.lastModifiedDateTime(model.lastModifiedDateTime);
            this.name(model.name);
            this.tags(model.tags);
            this.waveAggregatedStatus(model.waveAggregatedStatus);
            this.waveID(model.waveID);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIsArchived() {
            return this.isArchived;
        }

        public final void setIsArchived(Boolean isArchived) {
            this.isArchived = isArchived;
        }

        @Override
        public final Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public final String getLastModifiedDateTime() {
            return this.lastModifiedDateTime;
        }

        public final void setLastModifiedDateTime(String lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
        }

        @Override
        public final Builder lastModifiedDateTime(String lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final WaveAggregatedStatus.Builder getWaveAggregatedStatus() {
            return this.waveAggregatedStatus != null ? this.waveAggregatedStatus.toBuilder() : null;
        }

        public final void setWaveAggregatedStatus(WaveAggregatedStatus.BuilderImpl waveAggregatedStatus) {
            this.waveAggregatedStatus = waveAggregatedStatus != null ? waveAggregatedStatus.build() : null;
        }

        @Override
        public final Builder waveAggregatedStatus(WaveAggregatedStatus waveAggregatedStatus) {
            this.waveAggregatedStatus = waveAggregatedStatus;
            return this;
        }

        public final String getWaveID() {
            return this.waveID;
        }

        public final void setWaveID(String waveID) {
            this.waveID = waveID;
        }

        @Override
        public final Builder waveID(String waveID) {
            this.waveID = waveID;
            return this;
        }

        @Override
        public CreateWaveResponse build() {
            return new CreateWaveResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MgnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWaveResponse> {
        public Builder arn(String var1);

        public Builder creationDateTime(String var1);

        public Builder description(String var1);

        public Builder isArchived(Boolean var1);

        public Builder lastModifiedDateTime(String var1);

        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder waveAggregatedStatus(WaveAggregatedStatus var1);

        default public Builder waveAggregatedStatus(Consumer<WaveAggregatedStatus.Builder> waveAggregatedStatus) {
            return this.waveAggregatedStatus((WaveAggregatedStatus)((WaveAggregatedStatus.Builder)WaveAggregatedStatus.builder().applyMutation(waveAggregatedStatus)).build());
        }

        public Builder waveID(String var1);
    }
}

