/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mgn.model.SsmDocumentExternalParametersCopier;
import software.amazon.awssdk.services.mgn.model.SsmDocumentParametersCopier;
import software.amazon.awssdk.services.mgn.model.SsmExternalParameter;
import software.amazon.awssdk.services.mgn.model.SsmParameterStoreParameter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SsmDocument
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SsmDocument> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionName").getter(SsmDocument.getter(SsmDocument::actionName)).setter(SsmDocument.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()}).build();
    private static final SdkField<Map<String, SsmExternalParameter>> EXTERNAL_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("externalParameters").getter(SsmDocument.getter(SsmDocument::externalParameters)).setter(SsmDocument.setter(Builder::externalParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SsmExternalParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> MUST_SUCCEED_FOR_CUTOVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("mustSucceedForCutover").getter(SsmDocument.getter(SsmDocument::mustSucceedForCutover)).setter(SsmDocument.setter(Builder::mustSucceedForCutover)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mustSucceedForCutover").build()}).build();
    private static final SdkField<Map<String, List<SsmParameterStoreParameter>>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(SsmDocument.getter(SsmDocument::parameters)).setter(SsmDocument.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SsmParameterStoreParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> SSM_DOCUMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ssmDocumentName").getter(SsmDocument.getter(SsmDocument::ssmDocumentName)).setter(SsmDocument.setter(Builder::ssmDocumentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmDocumentName").build()}).build();
    private static final SdkField<Integer> TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutSeconds").getter(SsmDocument.getter(SsmDocument::timeoutSeconds)).setter(SsmDocument.setter(Builder::timeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD, EXTERNAL_PARAMETERS_FIELD, MUST_SUCCEED_FOR_CUTOVER_FIELD, PARAMETERS_FIELD, SSM_DOCUMENT_NAME_FIELD, TIMEOUT_SECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SsmDocument.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String actionName;
    private final Map<String, SsmExternalParameter> externalParameters;
    private final Boolean mustSucceedForCutover;
    private final Map<String, List<SsmParameterStoreParameter>> parameters;
    private final String ssmDocumentName;
    private final Integer timeoutSeconds;

    private SsmDocument(BuilderImpl builder) {
        this.actionName = builder.actionName;
        this.externalParameters = builder.externalParameters;
        this.mustSucceedForCutover = builder.mustSucceedForCutover;
        this.parameters = builder.parameters;
        this.ssmDocumentName = builder.ssmDocumentName;
        this.timeoutSeconds = builder.timeoutSeconds;
    }

    public final String actionName() {
        return this.actionName;
    }

    public final boolean hasExternalParameters() {
        return this.externalParameters != null && !(this.externalParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, SsmExternalParameter> externalParameters() {
        return this.externalParameters;
    }

    public final Boolean mustSucceedForCutover() {
        return this.mustSucceedForCutover;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<SsmParameterStoreParameter>> parameters() {
        return this.parameters;
    }

    public final String ssmDocumentName() {
        return this.ssmDocumentName;
    }

    public final Integer timeoutSeconds() {
        return this.timeoutSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExternalParameters() ? this.externalParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.mustSucceedForCutover());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ssmDocumentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SsmDocument)) {
            return false;
        }
        SsmDocument other = (SsmDocument)obj;
        return Objects.equals(this.actionName(), other.actionName()) && this.hasExternalParameters() == other.hasExternalParameters() && Objects.equals(this.externalParameters(), other.externalParameters()) && Objects.equals(this.mustSucceedForCutover(), other.mustSucceedForCutover()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.ssmDocumentName(), other.ssmDocumentName()) && Objects.equals(this.timeoutSeconds(), other.timeoutSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"SsmDocument").add("ActionName", (Object)this.actionName()).add("ExternalParameters", this.hasExternalParameters() ? this.externalParameters() : null).add("MustSucceedForCutover", (Object)this.mustSucceedForCutover()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("SsmDocumentName", (Object)this.ssmDocumentName()).add("TimeoutSeconds", (Object)this.timeoutSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "externalParameters": {
                return Optional.ofNullable(clazz.cast(this.externalParameters()));
            }
            case "mustSucceedForCutover": {
                return Optional.ofNullable(clazz.cast(this.mustSucceedForCutover()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "ssmDocumentName": {
                return Optional.ofNullable(clazz.cast(this.ssmDocumentName()));
            }
            case "timeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeoutSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actionName", ACTION_NAME_FIELD);
        map.put("externalParameters", EXTERNAL_PARAMETERS_FIELD);
        map.put("mustSucceedForCutover", MUST_SUCCEED_FOR_CUTOVER_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("ssmDocumentName", SSM_DOCUMENT_NAME_FIELD);
        map.put("timeoutSeconds", TIMEOUT_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SsmDocument, T> g) {
        return obj -> g.apply((SsmDocument)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionName;
        private Map<String, SsmExternalParameter> externalParameters = DefaultSdkAutoConstructMap.getInstance();
        private Boolean mustSucceedForCutover;
        private Map<String, List<SsmParameterStoreParameter>> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String ssmDocumentName;
        private Integer timeoutSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(SsmDocument model) {
            this.actionName(model.actionName);
            this.externalParameters(model.externalParameters);
            this.mustSucceedForCutover(model.mustSucceedForCutover);
            this.parameters(model.parameters);
            this.ssmDocumentName(model.ssmDocumentName);
            this.timeoutSeconds(model.timeoutSeconds);
        }

        public final String getActionName() {
            return this.actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final Map<String, SsmExternalParameter.Builder> getExternalParameters() {
            Map<String, SsmExternalParameter.Builder> result = SsmDocumentExternalParametersCopier.copyToBuilder(this.externalParameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setExternalParameters(Map<String, SsmExternalParameter.BuilderImpl> externalParameters) {
            this.externalParameters = SsmDocumentExternalParametersCopier.copyFromBuilder(externalParameters);
        }

        @Override
        public final Builder externalParameters(Map<String, SsmExternalParameter> externalParameters) {
            this.externalParameters = SsmDocumentExternalParametersCopier.copy(externalParameters);
            return this;
        }

        public final Boolean getMustSucceedForCutover() {
            return this.mustSucceedForCutover;
        }

        public final void setMustSucceedForCutover(Boolean mustSucceedForCutover) {
            this.mustSucceedForCutover = mustSucceedForCutover;
        }

        @Override
        public final Builder mustSucceedForCutover(Boolean mustSucceedForCutover) {
            this.mustSucceedForCutover = mustSucceedForCutover;
            return this;
        }

        public final Map<String, List<SsmParameterStoreParameter.Builder>> getParameters() {
            Map<String, List<SsmParameterStoreParameter.Builder>> result = SsmDocumentParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, ? extends Collection<SsmParameterStoreParameter.BuilderImpl>> parameters) {
            this.parameters = SsmDocumentParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<SsmParameterStoreParameter>> parameters) {
            this.parameters = SsmDocumentParametersCopier.copy(parameters);
            return this;
        }

        public final String getSsmDocumentName() {
            return this.ssmDocumentName;
        }

        public final void setSsmDocumentName(String ssmDocumentName) {
            this.ssmDocumentName = ssmDocumentName;
        }

        @Override
        public final Builder ssmDocumentName(String ssmDocumentName) {
            this.ssmDocumentName = ssmDocumentName;
            return this;
        }

        public final Integer getTimeoutSeconds() {
            return this.timeoutSeconds;
        }

        public final void setTimeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        @Override
        public final Builder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public SsmDocument build() {
            return new SsmDocument(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SsmDocument> {
        public Builder actionName(String var1);

        public Builder externalParameters(Map<String, SsmExternalParameter> var1);

        public Builder mustSucceedForCutover(Boolean var1);

        public Builder parameters(Map<String, ? extends Collection<SsmParameterStoreParameter>> var1);

        public Builder ssmDocumentName(String var1);

        public Builder timeoutSeconds(Integer var1);
    }
}

