/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Disk
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Disk> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceName").getter(Disk.getter(Disk::deviceName)).setter(Disk.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceName").build()}).build();
    private static final SdkField<Long> BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("bytes").getter(Disk.getter(Disk::bytes)).setter(Disk.setter(Builder::bytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD, BYTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Disk.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String deviceName;
    private final Long bytes;

    private Disk(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.bytes = builder.bytes;
    }

    public final String deviceName() {
        return this.deviceName;
    }

    public final Long bytes() {
        return this.bytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Disk)) {
            return false;
        }
        Disk other = (Disk)obj;
        return Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.bytes(), other.bytes());
    }

    public final String toString() {
        return ToString.builder((String)"Disk").add("DeviceName", (Object)this.deviceName()).add("Bytes", (Object)this.bytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "bytes": {
                return Optional.ofNullable(clazz.cast(this.bytes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("deviceName", DEVICE_NAME_FIELD);
        map.put("bytes", BYTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Disk, T> g) {
        return obj -> g.apply((Disk)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceName;
        private Long bytes;

        private BuilderImpl() {
        }

        private BuilderImpl(Disk model) {
            this.deviceName(model.deviceName);
            this.bytes(model.bytes);
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final Long getBytes() {
            return this.bytes;
        }

        public final void setBytes(Long bytes) {
            this.bytes = bytes;
        }

        @Override
        public final Builder bytes(Long bytes) {
            this.bytes = bytes;
            return this;
        }

        public Disk build() {
            return new Disk(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Disk> {
        public Builder deviceName(String var1);

        public Builder bytes(Long var1);
    }
}

