/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mgn.model.InternetProtocol;
import software.amazon.awssdk.services.mgn.model.MgnResponse;
import software.amazon.awssdk.services.mgn.model.ReplicationConfigurationDataPlaneRouting;
import software.amazon.awssdk.services.mgn.model.ReplicationConfigurationDefaultLargeStagingDiskType;
import software.amazon.awssdk.services.mgn.model.ReplicationConfigurationEbsEncryption;
import software.amazon.awssdk.services.mgn.model.ReplicationConfigurationReplicatedDisk;
import software.amazon.awssdk.services.mgn.model.ReplicationConfigurationReplicatedDisksCopier;
import software.amazon.awssdk.services.mgn.model.ReplicationServersSecurityGroupsIDsCopier;
import software.amazon.awssdk.services.mgn.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateReplicationConfigurationResponse
extends MgnResponse
implements ToCopyableBuilder<Builder, UpdateReplicationConfigurationResponse> {
    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceServerID").getter(UpdateReplicationConfigurationResponse.getter(UpdateReplicationConfigurationResponse::sourceServerID)).setter(UpdateReplicationConfigurationResponse.setter(Builder::sourceServerID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateReplicationConfigurationResponse.getter(UpdateReplicationConfigurationResponse::name)).setter(UpdateReplicationConfigurationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STAGING_AREA_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stagingAreaSubnetId").getter(UpdateReplicationConfigurationResponse.getter(UpdateReplicationConfigurationResponse::stagingAreaSubnetId)).setter(UpdateReplicationConfigurationResponse.setter(Builder::stagingAreaSubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stagingAreaSubnetId").build()}).build();
    private static final SdkField<Boolean> ASSOCIATE_DEFAULT_SECURITY_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("associateDefaultSecurityGroup").getter(UpdateReplicationConfigurationResponse.getter(UpdateReplicationConfigurationResponse::associateDefaultSecurityGroup)).setter(UpdateReplicationConfigurationResponse.setter(Builder::associateDefaultSecurityGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associateDefaultSecurityGroup").build()}).build();
    private static final SdkField<List<String>> REPLICATION_SERVERS_SECURITY_GROUPS_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("replicationServersSecurityGroupsIDs").getter(UpdateReplicationConfigurationResponse.getter(UpdateReplicationConfigurationResponse::replicationServersSecurityGroupsIDs)).setter(UpdateReplicationConfigurationResponse.setter(Builder::replicationServersSecurityGroupsIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationServersSecurityGroupsIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REPLICATION_SERVER_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicationServerInstanceType").getter(UpdateReplicationConfigurationResponse.getter(UpdateReplicationConfigurationResponse::replicationServerInstanceType)).setter(UpdateReplicationConfigurationResponse.setter(Builder::replicationServerInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationServerInstanceType").build()}).build();
    private static final SdkField<Boolean> USE_DEDICATED_REPLICATION_SERVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("useDedicatedReplicationServer").getter(UpdateReplicationConfigurationResponse.getter(UpdateReplicationConfigurationResponse::useDedicatedReplicationServer)).setter(UpdateReplicationConfigurationResponse.setter(Builder::useDedicatedReplicationServer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useDedicatedReplicationServer").build()}).build();
    private static final SdkField<String> DEFAULT_LARGE_STAGING_DISK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultLargeStagingDiskType").getter(UpdateReplicationConfigurationResponse.getter(UpdateReplicationConfigurationResponse::defaultLargeStagingDiskTypeAsString)).setter(UpdateReplicationConfigurationResponse.setter(Builder::defaultLargeStagingDiskType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultLargeStagingDiskType").build()}).build();
    private static final SdkField<List<ReplicationConfigurationReplicatedDisk>> REPLICATED_DISKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("replicatedDisks").getter(UpdateReplicationConfigurationResponse.getter(UpdateReplicationConfigurationResponse::replicatedDisks)).setter(UpdateReplicationConfigurationResponse.setter(Builder::replicatedDisks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatedDisks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationConfigurationReplicatedDisk::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EBS_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ebsEncryption").getter(UpdateReplicationConfigurationResponse.getter(UpdateReplicationConfigurationResponse::ebsEncryptionAsString)).setter(UpdateReplicationConfigurationResponse.setter(Builder::ebsEncryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsEncryption").build()}).build();
    private static final SdkField<String> EBS_ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ebsEncryptionKeyArn").getter(UpdateReplicationConfigurationResponse.getter(UpdateReplicationConfigurationResponse::ebsEncryptionKeyArn)).setter(UpdateReplicationConfigurationResponse.setter(Builder::ebsEncryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsEncryptionKeyArn").build()}).build();
    private static final SdkField<Long> BANDWIDTH_THROTTLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("bandwidthThrottling").getter(UpdateReplicationConfigurationResponse.getter(UpdateReplicationConfigurationResponse::bandwidthThrottling)).setter(UpdateReplicationConfigurationResponse.setter(Builder::bandwidthThrottling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidthThrottling").build()}).build();
    private static final SdkField<String> DATA_PLANE_ROUTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataPlaneRouting").getter(UpdateReplicationConfigurationResponse.getter(UpdateReplicationConfigurationResponse::dataPlaneRoutingAsString)).setter(UpdateReplicationConfigurationResponse.setter(Builder::dataPlaneRouting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPlaneRouting").build()}).build();
    private static final SdkField<Boolean> CREATE_PUBLIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("createPublicIP").getter(UpdateReplicationConfigurationResponse.getter(UpdateReplicationConfigurationResponse::createPublicIP)).setter(UpdateReplicationConfigurationResponse.setter(Builder::createPublicIP)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createPublicIP").build()}).build();
    private static final SdkField<Map<String, String>> STAGING_AREA_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("stagingAreaTags").getter(UpdateReplicationConfigurationResponse.getter(UpdateReplicationConfigurationResponse::stagingAreaTags)).setter(UpdateReplicationConfigurationResponse.setter(Builder::stagingAreaTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stagingAreaTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> USE_FIPS_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("useFipsEndpoint").getter(UpdateReplicationConfigurationResponse.getter(UpdateReplicationConfigurationResponse::useFipsEndpoint)).setter(UpdateReplicationConfigurationResponse.setter(Builder::useFipsEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useFipsEndpoint").build()}).build();
    private static final SdkField<String> INTERNET_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("internetProtocol").getter(UpdateReplicationConfigurationResponse.getter(UpdateReplicationConfigurationResponse::internetProtocolAsString)).setter(UpdateReplicationConfigurationResponse.setter(Builder::internetProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("internetProtocol").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_SERVER_ID_FIELD, NAME_FIELD, STAGING_AREA_SUBNET_ID_FIELD, ASSOCIATE_DEFAULT_SECURITY_GROUP_FIELD, REPLICATION_SERVERS_SECURITY_GROUPS_I_DS_FIELD, REPLICATION_SERVER_INSTANCE_TYPE_FIELD, USE_DEDICATED_REPLICATION_SERVER_FIELD, DEFAULT_LARGE_STAGING_DISK_TYPE_FIELD, REPLICATED_DISKS_FIELD, EBS_ENCRYPTION_FIELD, EBS_ENCRYPTION_KEY_ARN_FIELD, BANDWIDTH_THROTTLING_FIELD, DATA_PLANE_ROUTING_FIELD, CREATE_PUBLIC_IP_FIELD, STAGING_AREA_TAGS_FIELD, USE_FIPS_ENDPOINT_FIELD, INTERNET_PROTOCOL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateReplicationConfigurationResponse.memberNameToFieldInitializer();
    private final String sourceServerID;
    private final String name;
    private final String stagingAreaSubnetId;
    private final Boolean associateDefaultSecurityGroup;
    private final List<String> replicationServersSecurityGroupsIDs;
    private final String replicationServerInstanceType;
    private final Boolean useDedicatedReplicationServer;
    private final String defaultLargeStagingDiskType;
    private final List<ReplicationConfigurationReplicatedDisk> replicatedDisks;
    private final String ebsEncryption;
    private final String ebsEncryptionKeyArn;
    private final Long bandwidthThrottling;
    private final String dataPlaneRouting;
    private final Boolean createPublicIP;
    private final Map<String, String> stagingAreaTags;
    private final Boolean useFipsEndpoint;
    private final String internetProtocol;

    private UpdateReplicationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.sourceServerID = builder.sourceServerID;
        this.name = builder.name;
        this.stagingAreaSubnetId = builder.stagingAreaSubnetId;
        this.associateDefaultSecurityGroup = builder.associateDefaultSecurityGroup;
        this.replicationServersSecurityGroupsIDs = builder.replicationServersSecurityGroupsIDs;
        this.replicationServerInstanceType = builder.replicationServerInstanceType;
        this.useDedicatedReplicationServer = builder.useDedicatedReplicationServer;
        this.defaultLargeStagingDiskType = builder.defaultLargeStagingDiskType;
        this.replicatedDisks = builder.replicatedDisks;
        this.ebsEncryption = builder.ebsEncryption;
        this.ebsEncryptionKeyArn = builder.ebsEncryptionKeyArn;
        this.bandwidthThrottling = builder.bandwidthThrottling;
        this.dataPlaneRouting = builder.dataPlaneRouting;
        this.createPublicIP = builder.createPublicIP;
        this.stagingAreaTags = builder.stagingAreaTags;
        this.useFipsEndpoint = builder.useFipsEndpoint;
        this.internetProtocol = builder.internetProtocol;
    }

    public final String sourceServerID() {
        return this.sourceServerID;
    }

    public final String name() {
        return this.name;
    }

    public final String stagingAreaSubnetId() {
        return this.stagingAreaSubnetId;
    }

    public final Boolean associateDefaultSecurityGroup() {
        return this.associateDefaultSecurityGroup;
    }

    public final boolean hasReplicationServersSecurityGroupsIDs() {
        return this.replicationServersSecurityGroupsIDs != null && !(this.replicationServersSecurityGroupsIDs instanceof SdkAutoConstructList);
    }

    public final List<String> replicationServersSecurityGroupsIDs() {
        return this.replicationServersSecurityGroupsIDs;
    }

    public final String replicationServerInstanceType() {
        return this.replicationServerInstanceType;
    }

    public final Boolean useDedicatedReplicationServer() {
        return this.useDedicatedReplicationServer;
    }

    public final ReplicationConfigurationDefaultLargeStagingDiskType defaultLargeStagingDiskType() {
        return ReplicationConfigurationDefaultLargeStagingDiskType.fromValue(this.defaultLargeStagingDiskType);
    }

    public final String defaultLargeStagingDiskTypeAsString() {
        return this.defaultLargeStagingDiskType;
    }

    public final boolean hasReplicatedDisks() {
        return this.replicatedDisks != null && !(this.replicatedDisks instanceof SdkAutoConstructList);
    }

    public final List<ReplicationConfigurationReplicatedDisk> replicatedDisks() {
        return this.replicatedDisks;
    }

    public final ReplicationConfigurationEbsEncryption ebsEncryption() {
        return ReplicationConfigurationEbsEncryption.fromValue(this.ebsEncryption);
    }

    public final String ebsEncryptionAsString() {
        return this.ebsEncryption;
    }

    public final String ebsEncryptionKeyArn() {
        return this.ebsEncryptionKeyArn;
    }

    public final Long bandwidthThrottling() {
        return this.bandwidthThrottling;
    }

    public final ReplicationConfigurationDataPlaneRouting dataPlaneRouting() {
        return ReplicationConfigurationDataPlaneRouting.fromValue(this.dataPlaneRouting);
    }

    public final String dataPlaneRoutingAsString() {
        return this.dataPlaneRouting;
    }

    public final Boolean createPublicIP() {
        return this.createPublicIP;
    }

    public final boolean hasStagingAreaTags() {
        return this.stagingAreaTags != null && !(this.stagingAreaTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> stagingAreaTags() {
        return this.stagingAreaTags;
    }

    public final Boolean useFipsEndpoint() {
        return this.useFipsEndpoint;
    }

    public final InternetProtocol internetProtocol() {
        return InternetProtocol.fromValue(this.internetProtocol);
    }

    public final String internetProtocolAsString() {
        return this.internetProtocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stagingAreaSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associateDefaultSecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationServersSecurityGroupsIDs() ? this.replicationServersSecurityGroupsIDs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationServerInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.useDedicatedReplicationServer());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultLargeStagingDiskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicatedDisks() ? this.replicatedDisks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsEncryptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidthThrottling());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPlaneRoutingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createPublicIP());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStagingAreaTags() ? this.stagingAreaTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.useFipsEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.internetProtocolAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReplicationConfigurationResponse)) {
            return false;
        }
        UpdateReplicationConfigurationResponse other = (UpdateReplicationConfigurationResponse)((Object)obj);
        return Objects.equals(this.sourceServerID(), other.sourceServerID()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.stagingAreaSubnetId(), other.stagingAreaSubnetId()) && Objects.equals(this.associateDefaultSecurityGroup(), other.associateDefaultSecurityGroup()) && this.hasReplicationServersSecurityGroupsIDs() == other.hasReplicationServersSecurityGroupsIDs() && Objects.equals(this.replicationServersSecurityGroupsIDs(), other.replicationServersSecurityGroupsIDs()) && Objects.equals(this.replicationServerInstanceType(), other.replicationServerInstanceType()) && Objects.equals(this.useDedicatedReplicationServer(), other.useDedicatedReplicationServer()) && Objects.equals(this.defaultLargeStagingDiskTypeAsString(), other.defaultLargeStagingDiskTypeAsString()) && this.hasReplicatedDisks() == other.hasReplicatedDisks() && Objects.equals(this.replicatedDisks(), other.replicatedDisks()) && Objects.equals(this.ebsEncryptionAsString(), other.ebsEncryptionAsString()) && Objects.equals(this.ebsEncryptionKeyArn(), other.ebsEncryptionKeyArn()) && Objects.equals(this.bandwidthThrottling(), other.bandwidthThrottling()) && Objects.equals(this.dataPlaneRoutingAsString(), other.dataPlaneRoutingAsString()) && Objects.equals(this.createPublicIP(), other.createPublicIP()) && this.hasStagingAreaTags() == other.hasStagingAreaTags() && Objects.equals(this.stagingAreaTags(), other.stagingAreaTags()) && Objects.equals(this.useFipsEndpoint(), other.useFipsEndpoint()) && Objects.equals(this.internetProtocolAsString(), other.internetProtocolAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateReplicationConfigurationResponse").add("SourceServerID", (Object)this.sourceServerID()).add("Name", (Object)this.name()).add("StagingAreaSubnetId", (Object)this.stagingAreaSubnetId()).add("AssociateDefaultSecurityGroup", (Object)this.associateDefaultSecurityGroup()).add("ReplicationServersSecurityGroupsIDs", this.hasReplicationServersSecurityGroupsIDs() ? this.replicationServersSecurityGroupsIDs() : null).add("ReplicationServerInstanceType", (Object)this.replicationServerInstanceType()).add("UseDedicatedReplicationServer", (Object)this.useDedicatedReplicationServer()).add("DefaultLargeStagingDiskType", (Object)this.defaultLargeStagingDiskTypeAsString()).add("ReplicatedDisks", this.hasReplicatedDisks() ? this.replicatedDisks() : null).add("EbsEncryption", (Object)this.ebsEncryptionAsString()).add("EbsEncryptionKeyArn", (Object)this.ebsEncryptionKeyArn()).add("BandwidthThrottling", (Object)this.bandwidthThrottling()).add("DataPlaneRouting", (Object)this.dataPlaneRoutingAsString()).add("CreatePublicIP", (Object)this.createPublicIP()).add("StagingAreaTags", (Object)(this.stagingAreaTags() == null ? null : "*** Sensitive Data Redacted ***")).add("UseFipsEndpoint", (Object)this.useFipsEndpoint()).add("InternetProtocol", (Object)this.internetProtocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceServerID": {
                return Optional.ofNullable(clazz.cast(this.sourceServerID()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "stagingAreaSubnetId": {
                return Optional.ofNullable(clazz.cast(this.stagingAreaSubnetId()));
            }
            case "associateDefaultSecurityGroup": {
                return Optional.ofNullable(clazz.cast(this.associateDefaultSecurityGroup()));
            }
            case "replicationServersSecurityGroupsIDs": {
                return Optional.ofNullable(clazz.cast(this.replicationServersSecurityGroupsIDs()));
            }
            case "replicationServerInstanceType": {
                return Optional.ofNullable(clazz.cast(this.replicationServerInstanceType()));
            }
            case "useDedicatedReplicationServer": {
                return Optional.ofNullable(clazz.cast(this.useDedicatedReplicationServer()));
            }
            case "defaultLargeStagingDiskType": {
                return Optional.ofNullable(clazz.cast(this.defaultLargeStagingDiskTypeAsString()));
            }
            case "replicatedDisks": {
                return Optional.ofNullable(clazz.cast(this.replicatedDisks()));
            }
            case "ebsEncryption": {
                return Optional.ofNullable(clazz.cast(this.ebsEncryptionAsString()));
            }
            case "ebsEncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.ebsEncryptionKeyArn()));
            }
            case "bandwidthThrottling": {
                return Optional.ofNullable(clazz.cast(this.bandwidthThrottling()));
            }
            case "dataPlaneRouting": {
                return Optional.ofNullable(clazz.cast(this.dataPlaneRoutingAsString()));
            }
            case "createPublicIP": {
                return Optional.ofNullable(clazz.cast(this.createPublicIP()));
            }
            case "stagingAreaTags": {
                return Optional.ofNullable(clazz.cast(this.stagingAreaTags()));
            }
            case "useFipsEndpoint": {
                return Optional.ofNullable(clazz.cast(this.useFipsEndpoint()));
            }
            case "internetProtocol": {
                return Optional.ofNullable(clazz.cast(this.internetProtocolAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceServerID", SOURCE_SERVER_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("stagingAreaSubnetId", STAGING_AREA_SUBNET_ID_FIELD);
        map.put("associateDefaultSecurityGroup", ASSOCIATE_DEFAULT_SECURITY_GROUP_FIELD);
        map.put("replicationServersSecurityGroupsIDs", REPLICATION_SERVERS_SECURITY_GROUPS_I_DS_FIELD);
        map.put("replicationServerInstanceType", REPLICATION_SERVER_INSTANCE_TYPE_FIELD);
        map.put("useDedicatedReplicationServer", USE_DEDICATED_REPLICATION_SERVER_FIELD);
        map.put("defaultLargeStagingDiskType", DEFAULT_LARGE_STAGING_DISK_TYPE_FIELD);
        map.put("replicatedDisks", REPLICATED_DISKS_FIELD);
        map.put("ebsEncryption", EBS_ENCRYPTION_FIELD);
        map.put("ebsEncryptionKeyArn", EBS_ENCRYPTION_KEY_ARN_FIELD);
        map.put("bandwidthThrottling", BANDWIDTH_THROTTLING_FIELD);
        map.put("dataPlaneRouting", DATA_PLANE_ROUTING_FIELD);
        map.put("createPublicIP", CREATE_PUBLIC_IP_FIELD);
        map.put("stagingAreaTags", STAGING_AREA_TAGS_FIELD);
        map.put("useFipsEndpoint", USE_FIPS_ENDPOINT_FIELD);
        map.put("internetProtocol", INTERNET_PROTOCOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateReplicationConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateReplicationConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MgnResponse.BuilderImpl
    implements Builder {
        private String sourceServerID;
        private String name;
        private String stagingAreaSubnetId;
        private Boolean associateDefaultSecurityGroup;
        private List<String> replicationServersSecurityGroupsIDs = DefaultSdkAutoConstructList.getInstance();
        private String replicationServerInstanceType;
        private Boolean useDedicatedReplicationServer;
        private String defaultLargeStagingDiskType;
        private List<ReplicationConfigurationReplicatedDisk> replicatedDisks = DefaultSdkAutoConstructList.getInstance();
        private String ebsEncryption;
        private String ebsEncryptionKeyArn;
        private Long bandwidthThrottling;
        private String dataPlaneRouting;
        private Boolean createPublicIP;
        private Map<String, String> stagingAreaTags = DefaultSdkAutoConstructMap.getInstance();
        private Boolean useFipsEndpoint;
        private String internetProtocol;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReplicationConfigurationResponse model) {
            super(model);
            this.sourceServerID(model.sourceServerID);
            this.name(model.name);
            this.stagingAreaSubnetId(model.stagingAreaSubnetId);
            this.associateDefaultSecurityGroup(model.associateDefaultSecurityGroup);
            this.replicationServersSecurityGroupsIDs(model.replicationServersSecurityGroupsIDs);
            this.replicationServerInstanceType(model.replicationServerInstanceType);
            this.useDedicatedReplicationServer(model.useDedicatedReplicationServer);
            this.defaultLargeStagingDiskType(model.defaultLargeStagingDiskType);
            this.replicatedDisks(model.replicatedDisks);
            this.ebsEncryption(model.ebsEncryption);
            this.ebsEncryptionKeyArn(model.ebsEncryptionKeyArn);
            this.bandwidthThrottling(model.bandwidthThrottling);
            this.dataPlaneRouting(model.dataPlaneRouting);
            this.createPublicIP(model.createPublicIP);
            this.stagingAreaTags(model.stagingAreaTags);
            this.useFipsEndpoint(model.useFipsEndpoint);
            this.internetProtocol(model.internetProtocol);
        }

        public final String getSourceServerID() {
            return this.sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStagingAreaSubnetId() {
            return this.stagingAreaSubnetId;
        }

        public final void setStagingAreaSubnetId(String stagingAreaSubnetId) {
            this.stagingAreaSubnetId = stagingAreaSubnetId;
        }

        @Override
        public final Builder stagingAreaSubnetId(String stagingAreaSubnetId) {
            this.stagingAreaSubnetId = stagingAreaSubnetId;
            return this;
        }

        public final Boolean getAssociateDefaultSecurityGroup() {
            return this.associateDefaultSecurityGroup;
        }

        public final void setAssociateDefaultSecurityGroup(Boolean associateDefaultSecurityGroup) {
            this.associateDefaultSecurityGroup = associateDefaultSecurityGroup;
        }

        @Override
        public final Builder associateDefaultSecurityGroup(Boolean associateDefaultSecurityGroup) {
            this.associateDefaultSecurityGroup = associateDefaultSecurityGroup;
            return this;
        }

        public final Collection<String> getReplicationServersSecurityGroupsIDs() {
            if (this.replicationServersSecurityGroupsIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicationServersSecurityGroupsIDs;
        }

        public final void setReplicationServersSecurityGroupsIDs(Collection<String> replicationServersSecurityGroupsIDs) {
            this.replicationServersSecurityGroupsIDs = ReplicationServersSecurityGroupsIDsCopier.copy(replicationServersSecurityGroupsIDs);
        }

        @Override
        public final Builder replicationServersSecurityGroupsIDs(Collection<String> replicationServersSecurityGroupsIDs) {
            this.replicationServersSecurityGroupsIDs = ReplicationServersSecurityGroupsIDsCopier.copy(replicationServersSecurityGroupsIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationServersSecurityGroupsIDs(String ... replicationServersSecurityGroupsIDs) {
            this.replicationServersSecurityGroupsIDs(Arrays.asList(replicationServersSecurityGroupsIDs));
            return this;
        }

        public final String getReplicationServerInstanceType() {
            return this.replicationServerInstanceType;
        }

        public final void setReplicationServerInstanceType(String replicationServerInstanceType) {
            this.replicationServerInstanceType = replicationServerInstanceType;
        }

        @Override
        public final Builder replicationServerInstanceType(String replicationServerInstanceType) {
            this.replicationServerInstanceType = replicationServerInstanceType;
            return this;
        }

        public final Boolean getUseDedicatedReplicationServer() {
            return this.useDedicatedReplicationServer;
        }

        public final void setUseDedicatedReplicationServer(Boolean useDedicatedReplicationServer) {
            this.useDedicatedReplicationServer = useDedicatedReplicationServer;
        }

        @Override
        public final Builder useDedicatedReplicationServer(Boolean useDedicatedReplicationServer) {
            this.useDedicatedReplicationServer = useDedicatedReplicationServer;
            return this;
        }

        public final String getDefaultLargeStagingDiskType() {
            return this.defaultLargeStagingDiskType;
        }

        public final void setDefaultLargeStagingDiskType(String defaultLargeStagingDiskType) {
            this.defaultLargeStagingDiskType = defaultLargeStagingDiskType;
        }

        @Override
        public final Builder defaultLargeStagingDiskType(String defaultLargeStagingDiskType) {
            this.defaultLargeStagingDiskType = defaultLargeStagingDiskType;
            return this;
        }

        @Override
        public final Builder defaultLargeStagingDiskType(ReplicationConfigurationDefaultLargeStagingDiskType defaultLargeStagingDiskType) {
            this.defaultLargeStagingDiskType(defaultLargeStagingDiskType == null ? null : defaultLargeStagingDiskType.toString());
            return this;
        }

        public final List<ReplicationConfigurationReplicatedDisk.Builder> getReplicatedDisks() {
            List<ReplicationConfigurationReplicatedDisk.Builder> result = ReplicationConfigurationReplicatedDisksCopier.copyToBuilder(this.replicatedDisks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicatedDisks(Collection<ReplicationConfigurationReplicatedDisk.BuilderImpl> replicatedDisks) {
            this.replicatedDisks = ReplicationConfigurationReplicatedDisksCopier.copyFromBuilder(replicatedDisks);
        }

        @Override
        public final Builder replicatedDisks(Collection<ReplicationConfigurationReplicatedDisk> replicatedDisks) {
            this.replicatedDisks = ReplicationConfigurationReplicatedDisksCopier.copy(replicatedDisks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicatedDisks(ReplicationConfigurationReplicatedDisk ... replicatedDisks) {
            this.replicatedDisks(Arrays.asList(replicatedDisks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicatedDisks(Consumer<ReplicationConfigurationReplicatedDisk.Builder> ... replicatedDisks) {
            this.replicatedDisks(Stream.of(replicatedDisks).map(c -> (ReplicationConfigurationReplicatedDisk)((ReplicationConfigurationReplicatedDisk.Builder)ReplicationConfigurationReplicatedDisk.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEbsEncryption() {
            return this.ebsEncryption;
        }

        public final void setEbsEncryption(String ebsEncryption) {
            this.ebsEncryption = ebsEncryption;
        }

        @Override
        public final Builder ebsEncryption(String ebsEncryption) {
            this.ebsEncryption = ebsEncryption;
            return this;
        }

        @Override
        public final Builder ebsEncryption(ReplicationConfigurationEbsEncryption ebsEncryption) {
            this.ebsEncryption(ebsEncryption == null ? null : ebsEncryption.toString());
            return this;
        }

        public final String getEbsEncryptionKeyArn() {
            return this.ebsEncryptionKeyArn;
        }

        public final void setEbsEncryptionKeyArn(String ebsEncryptionKeyArn) {
            this.ebsEncryptionKeyArn = ebsEncryptionKeyArn;
        }

        @Override
        public final Builder ebsEncryptionKeyArn(String ebsEncryptionKeyArn) {
            this.ebsEncryptionKeyArn = ebsEncryptionKeyArn;
            return this;
        }

        public final Long getBandwidthThrottling() {
            return this.bandwidthThrottling;
        }

        public final void setBandwidthThrottling(Long bandwidthThrottling) {
            this.bandwidthThrottling = bandwidthThrottling;
        }

        @Override
        public final Builder bandwidthThrottling(Long bandwidthThrottling) {
            this.bandwidthThrottling = bandwidthThrottling;
            return this;
        }

        public final String getDataPlaneRouting() {
            return this.dataPlaneRouting;
        }

        public final void setDataPlaneRouting(String dataPlaneRouting) {
            this.dataPlaneRouting = dataPlaneRouting;
        }

        @Override
        public final Builder dataPlaneRouting(String dataPlaneRouting) {
            this.dataPlaneRouting = dataPlaneRouting;
            return this;
        }

        @Override
        public final Builder dataPlaneRouting(ReplicationConfigurationDataPlaneRouting dataPlaneRouting) {
            this.dataPlaneRouting(dataPlaneRouting == null ? null : dataPlaneRouting.toString());
            return this;
        }

        public final Boolean getCreatePublicIP() {
            return this.createPublicIP;
        }

        public final void setCreatePublicIP(Boolean createPublicIP) {
            this.createPublicIP = createPublicIP;
        }

        @Override
        public final Builder createPublicIP(Boolean createPublicIP) {
            this.createPublicIP = createPublicIP;
            return this;
        }

        public final Map<String, String> getStagingAreaTags() {
            if (this.stagingAreaTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.stagingAreaTags;
        }

        public final void setStagingAreaTags(Map<String, String> stagingAreaTags) {
            this.stagingAreaTags = TagsMapCopier.copy(stagingAreaTags);
        }

        @Override
        public final Builder stagingAreaTags(Map<String, String> stagingAreaTags) {
            this.stagingAreaTags = TagsMapCopier.copy(stagingAreaTags);
            return this;
        }

        public final Boolean getUseFipsEndpoint() {
            return this.useFipsEndpoint;
        }

        public final void setUseFipsEndpoint(Boolean useFipsEndpoint) {
            this.useFipsEndpoint = useFipsEndpoint;
        }

        @Override
        public final Builder useFipsEndpoint(Boolean useFipsEndpoint) {
            this.useFipsEndpoint = useFipsEndpoint;
            return this;
        }

        public final String getInternetProtocol() {
            return this.internetProtocol;
        }

        public final void setInternetProtocol(String internetProtocol) {
            this.internetProtocol = internetProtocol;
        }

        @Override
        public final Builder internetProtocol(String internetProtocol) {
            this.internetProtocol = internetProtocol;
            return this;
        }

        @Override
        public final Builder internetProtocol(InternetProtocol internetProtocol) {
            this.internetProtocol(internetProtocol == null ? null : internetProtocol.toString());
            return this;
        }

        @Override
        public UpdateReplicationConfigurationResponse build() {
            return new UpdateReplicationConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MgnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateReplicationConfigurationResponse> {
        public Builder sourceServerID(String var1);

        public Builder name(String var1);

        public Builder stagingAreaSubnetId(String var1);

        public Builder associateDefaultSecurityGroup(Boolean var1);

        public Builder replicationServersSecurityGroupsIDs(Collection<String> var1);

        public Builder replicationServersSecurityGroupsIDs(String ... var1);

        public Builder replicationServerInstanceType(String var1);

        public Builder useDedicatedReplicationServer(Boolean var1);

        public Builder defaultLargeStagingDiskType(String var1);

        public Builder defaultLargeStagingDiskType(ReplicationConfigurationDefaultLargeStagingDiskType var1);

        public Builder replicatedDisks(Collection<ReplicationConfigurationReplicatedDisk> var1);

        public Builder replicatedDisks(ReplicationConfigurationReplicatedDisk ... var1);

        public Builder replicatedDisks(Consumer<ReplicationConfigurationReplicatedDisk.Builder> ... var1);

        public Builder ebsEncryption(String var1);

        public Builder ebsEncryption(ReplicationConfigurationEbsEncryption var1);

        public Builder ebsEncryptionKeyArn(String var1);

        public Builder bandwidthThrottling(Long var1);

        public Builder dataPlaneRouting(String var1);

        public Builder dataPlaneRouting(ReplicationConfigurationDataPlaneRouting var1);

        public Builder createPublicIP(Boolean var1);

        public Builder stagingAreaTags(Map<String, String> var1);

        public Builder useFipsEndpoint(Boolean var1);

        public Builder internetProtocol(String var1);

        public Builder internetProtocol(InternetProtocol var1);
    }
}

