/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentState;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.MigrationHubRefactorSpacesResponse;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.NetworkFabricType;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEnvironmentResponse
extends MigrationHubRefactorSpacesResponse
implements ToCopyableBuilder<Builder, CreateEnvironmentResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::arn)).setter(CreateEnvironmentResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::createdTime)).setter(CreateEnvironmentResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::description)).setter(CreateEnvironmentResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentId").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::environmentId)).setter(CreateEnvironmentResponse.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::lastUpdatedTime)).setter(CreateEnvironmentResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::name)).setter(CreateEnvironmentResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> NETWORK_FABRIC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkFabricType").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::networkFabricTypeAsString)).setter(CreateEnvironmentResponse.setter(Builder::networkFabricType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFabricType").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccountId").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::ownerAccountId)).setter(CreateEnvironmentResponse.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::stateAsString)).setter(CreateEnvironmentResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::tags)).setter(CreateEnvironmentResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_TIME_FIELD, DESCRIPTION_FIELD, ENVIRONMENT_ID_FIELD, LAST_UPDATED_TIME_FIELD, NAME_FIELD, NETWORK_FABRIC_TYPE_FIELD, OWNER_ACCOUNT_ID_FIELD, STATE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateEnvironmentResponse.memberNameToFieldInitializer();
    private final String arn;
    private final Instant createdTime;
    private final String description;
    private final String environmentId;
    private final Instant lastUpdatedTime;
    private final String name;
    private final String networkFabricType;
    private final String ownerAccountId;
    private final String state;
    private final Map<String, String> tags;

    private CreateEnvironmentResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.description = builder.description;
        this.environmentId = builder.environmentId;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.name = builder.name;
        this.networkFabricType = builder.networkFabricType;
        this.ownerAccountId = builder.ownerAccountId;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String description() {
        return this.description;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String name() {
        return this.name;
    }

    public final NetworkFabricType networkFabricType() {
        return NetworkFabricType.fromValue(this.networkFabricType);
    }

    public final String networkFabricTypeAsString() {
        return this.networkFabricType;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public final EnvironmentState state() {
        return EnvironmentState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkFabricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentResponse)) {
            return false;
        }
        CreateEnvironmentResponse other = (CreateEnvironmentResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.networkFabricTypeAsString(), other.networkFabricTypeAsString()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEnvironmentResponse").add("Arn", (Object)this.arn()).add("CreatedTime", (Object)this.createdTime()).add("Description", (Object)this.description()).add("EnvironmentId", (Object)this.environmentId()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("Name", (Object)this.name()).add("NetworkFabricType", (Object)this.networkFabricTypeAsString()).add("OwnerAccountId", (Object)this.ownerAccountId()).add("State", (Object)this.stateAsString()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NetworkFabricType": {
                return Optional.ofNullable(clazz.cast(this.networkFabricTypeAsString()));
            }
            case "OwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EnvironmentId", ENVIRONMENT_ID_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("NetworkFabricType", NETWORK_FABRIC_TYPE_FIELD);
        map.put("OwnerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentResponse, T> g) {
        return obj -> g.apply((CreateEnvironmentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubRefactorSpacesResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdTime;
        private String description;
        private String environmentId;
        private Instant lastUpdatedTime;
        private String name;
        private String networkFabricType;
        private String ownerAccountId;
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentResponse model) {
            super(model);
            this.arn(model.arn);
            this.createdTime(model.createdTime);
            this.description(model.description);
            this.environmentId(model.environmentId);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.name(model.name);
            this.networkFabricType(model.networkFabricType);
            this.ownerAccountId(model.ownerAccountId);
            this.state(model.state);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNetworkFabricType() {
            return this.networkFabricType;
        }

        public final void setNetworkFabricType(String networkFabricType) {
            this.networkFabricType = networkFabricType;
        }

        @Override
        public final Builder networkFabricType(String networkFabricType) {
            this.networkFabricType = networkFabricType;
            return this;
        }

        @Override
        public final Builder networkFabricType(NetworkFabricType networkFabricType) {
            this.networkFabricType(networkFabricType == null ? null : networkFabricType.toString());
            return this;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EnvironmentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public CreateEnvironmentResponse build() {
            return new CreateEnvironmentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MigrationHubRefactorSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEnvironmentResponse> {
        public Builder arn(String var1);

        public Builder createdTime(Instant var1);

        public Builder description(String var1);

        public Builder environmentId(String var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder name(String var1);

        public Builder networkFabricType(String var1);

        public Builder networkFabricType(NetworkFabricType var1);

        public Builder ownerAccountId(String var1);

        public Builder state(String var1);

        public Builder state(EnvironmentState var1);

        public Builder tags(Map<String, String> var1);
    }
}

