/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.MigrationHubRefactorSpacesResponse;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteSummariesCopier;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRoutesResponse
extends MigrationHubRefactorSpacesResponse
implements ToCopyableBuilder<Builder, ListRoutesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRoutesResponse.getter(ListRoutesResponse::nextToken)).setter(ListRoutesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<RouteSummary>> ROUTE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouteSummaryList").getter(ListRoutesResponse.getter(ListRoutesResponse::routeSummaryList)).setter(ListRoutesResponse.setter(Builder::routeSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ROUTE_SUMMARY_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRoutesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<RouteSummary> routeSummaryList;

    private ListRoutesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.routeSummaryList = builder.routeSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRouteSummaryList() {
        return this.routeSummaryList != null && !(this.routeSummaryList instanceof SdkAutoConstructList);
    }

    public final List<RouteSummary> routeSummaryList() {
        return this.routeSummaryList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouteSummaryList() ? this.routeSummaryList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoutesResponse)) {
            return false;
        }
        ListRoutesResponse other = (ListRoutesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRouteSummaryList() == other.hasRouteSummaryList() && Objects.equals(this.routeSummaryList(), other.routeSummaryList());
    }

    public final String toString() {
        return ToString.builder((String)"ListRoutesResponse").add("NextToken", (Object)this.nextToken()).add("RouteSummaryList", this.hasRouteSummaryList() ? this.routeSummaryList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RouteSummaryList": {
                return Optional.ofNullable(clazz.cast(this.routeSummaryList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("RouteSummaryList", ROUTE_SUMMARY_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRoutesResponse, T> g) {
        return obj -> g.apply((ListRoutesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubRefactorSpacesResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RouteSummary> routeSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoutesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.routeSummaryList(model.routeSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RouteSummary.Builder> getRouteSummaryList() {
            List<RouteSummary.Builder> result = RouteSummariesCopier.copyToBuilder(this.routeSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteSummaryList(Collection<RouteSummary.BuilderImpl> routeSummaryList) {
            this.routeSummaryList = RouteSummariesCopier.copyFromBuilder(routeSummaryList);
        }

        @Override
        public final Builder routeSummaryList(Collection<RouteSummary> routeSummaryList) {
            this.routeSummaryList = RouteSummariesCopier.copy(routeSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeSummaryList(RouteSummary ... routeSummaryList) {
            this.routeSummaryList(Arrays.asList(routeSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeSummaryList(Consumer<RouteSummary.Builder> ... routeSummaryList) {
            this.routeSummaryList(Stream.of(routeSummaryList).map(c -> (RouteSummary)((RouteSummary.Builder)RouteSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRoutesResponse build() {
            return new ListRoutesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MigrationHubRefactorSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRoutesResponse> {
        public Builder nextToken(String var1);

        public Builder routeSummaryList(Collection<RouteSummary> var1);

        public Builder routeSummaryList(RouteSummary ... var1);

        public Builder routeSummaryList(Consumer<RouteSummary.Builder> ... var1);
    }
}

