/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ErrorCode {
    INVALID_RESOURCE_STATE("INVALID_RESOURCE_STATE"),
    RESOURCE_LIMIT_EXCEEDED("RESOURCE_LIMIT_EXCEEDED"),
    RESOURCE_CREATION_FAILURE("RESOURCE_CREATION_FAILURE"),
    RESOURCE_UPDATE_FAILURE("RESOURCE_UPDATE_FAILURE"),
    SERVICE_ENDPOINT_HEALTH_CHECK_FAILURE("SERVICE_ENDPOINT_HEALTH_CHECK_FAILURE"),
    RESOURCE_DELETION_FAILURE("RESOURCE_DELETION_FAILURE"),
    RESOURCE_RETRIEVAL_FAILURE("RESOURCE_RETRIEVAL_FAILURE"),
    RESOURCE_IN_USE("RESOURCE_IN_USE"),
    RESOURCE_NOT_FOUND("RESOURCE_NOT_FOUND"),
    STATE_TRANSITION_FAILURE("STATE_TRANSITION_FAILURE"),
    REQUEST_LIMIT_EXCEEDED("REQUEST_LIMIT_EXCEEDED"),
    NOT_AUTHORIZED("NOT_AUTHORIZED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ErrorCode> VALUE_MAP;
    private final String value;

    private ErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ErrorCode> knownValues() {
        EnumSet<ErrorCode> knownValues = EnumSet.allOf(ErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ErrorCode.class, ErrorCode::toString);
    }
}

