/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RuntimeAnalysisStatus {
    ANALYSIS_TO_BE_SCHEDULED("ANALYSIS_TO_BE_SCHEDULED"),
    ANALYSIS_STARTED("ANALYSIS_STARTED"),
    ANALYSIS_SUCCESS("ANALYSIS_SUCCESS"),
    ANALYSIS_FAILED("ANALYSIS_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RuntimeAnalysisStatus> VALUE_MAP;
    private final String value;

    private RuntimeAnalysisStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RuntimeAnalysisStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RuntimeAnalysisStatus> knownValues() {
        EnumSet<RuntimeAnalysisStatus> knownValues = EnumSet.allOf(RuntimeAnalysisStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RuntimeAnalysisStatus.class, RuntimeAnalysisStatus::toString);
    }
}

