/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mpa.model.ApprovalStrategy;
import software.amazon.awssdk.services.mpa.model.ApprovalTeamRequestApprover;
import software.amazon.awssdk.services.mpa.model.ApprovalTeamRequestApproversCopier;
import software.amazon.awssdk.services.mpa.model.MpaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApprovalTeamRequest
extends MpaRequest
implements ToCopyableBuilder<Builder, UpdateApprovalTeamRequest> {
    private static final SdkField<ApprovalStrategy> APPROVAL_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApprovalStrategy").getter(UpdateApprovalTeamRequest.getter(UpdateApprovalTeamRequest::approvalStrategy)).setter(UpdateApprovalTeamRequest.setter(Builder::approvalStrategy)).constructor(ApprovalStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalStrategy").build()}).build();
    private static final SdkField<List<ApprovalTeamRequestApprover>> APPROVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Approvers").getter(UpdateApprovalTeamRequest.getter(UpdateApprovalTeamRequest::approvers)).setter(UpdateApprovalTeamRequest.setter(Builder::approvers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Approvers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApprovalTeamRequestApprover::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateApprovalTeamRequest.getter(UpdateApprovalTeamRequest::description)).setter(UpdateApprovalTeamRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateApprovalTeamRequest.getter(UpdateApprovalTeamRequest::arn)).setter(UpdateApprovalTeamRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROVAL_STRATEGY_FIELD, APPROVERS_FIELD, DESCRIPTION_FIELD, ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateApprovalTeamRequest.memberNameToFieldInitializer();
    private final ApprovalStrategy approvalStrategy;
    private final List<ApprovalTeamRequestApprover> approvers;
    private final String description;
    private final String arn;

    private UpdateApprovalTeamRequest(BuilderImpl builder) {
        super(builder);
        this.approvalStrategy = builder.approvalStrategy;
        this.approvers = builder.approvers;
        this.description = builder.description;
        this.arn = builder.arn;
    }

    public final ApprovalStrategy approvalStrategy() {
        return this.approvalStrategy;
    }

    public final boolean hasApprovers() {
        return this.approvers != null && !(this.approvers instanceof SdkAutoConstructList);
    }

    public final List<ApprovalTeamRequestApprover> approvers() {
        return this.approvers;
    }

    public final String description() {
        return this.description;
    }

    public final String arn() {
        return this.arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApprovers() ? this.approvers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApprovalTeamRequest)) {
            return false;
        }
        UpdateApprovalTeamRequest other = (UpdateApprovalTeamRequest)((Object)obj);
        return Objects.equals(this.approvalStrategy(), other.approvalStrategy()) && this.hasApprovers() == other.hasApprovers() && Objects.equals(this.approvers(), other.approvers()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateApprovalTeamRequest").add("ApprovalStrategy", (Object)this.approvalStrategy()).add("Approvers", this.hasApprovers() ? this.approvers() : null).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApprovalStrategy": {
                return Optional.ofNullable(clazz.cast(this.approvalStrategy()));
            }
            case "Approvers": {
                return Optional.ofNullable(clazz.cast(this.approvers()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApprovalStrategy", APPROVAL_STRATEGY_FIELD);
        map.put("Approvers", APPROVERS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Arn", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApprovalTeamRequest, T> g) {
        return obj -> g.apply((UpdateApprovalTeamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MpaRequest.BuilderImpl
    implements Builder {
        private ApprovalStrategy approvalStrategy;
        private List<ApprovalTeamRequestApprover> approvers = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApprovalTeamRequest model) {
            super(model);
            this.approvalStrategy(model.approvalStrategy);
            this.approvers(model.approvers);
            this.description(model.description);
            this.arn(model.arn);
        }

        public final ApprovalStrategy.Builder getApprovalStrategy() {
            return this.approvalStrategy != null ? this.approvalStrategy.toBuilder() : null;
        }

        public final void setApprovalStrategy(ApprovalStrategy.BuilderImpl approvalStrategy) {
            this.approvalStrategy = approvalStrategy != null ? approvalStrategy.build() : null;
        }

        @Override
        public final Builder approvalStrategy(ApprovalStrategy approvalStrategy) {
            this.approvalStrategy = approvalStrategy;
            return this;
        }

        public final List<ApprovalTeamRequestApprover.Builder> getApprovers() {
            List<ApprovalTeamRequestApprover.Builder> result = ApprovalTeamRequestApproversCopier.copyToBuilder(this.approvers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApprovers(Collection<ApprovalTeamRequestApprover.BuilderImpl> approvers) {
            this.approvers = ApprovalTeamRequestApproversCopier.copyFromBuilder(approvers);
        }

        @Override
        public final Builder approvers(Collection<ApprovalTeamRequestApprover> approvers) {
            this.approvers = ApprovalTeamRequestApproversCopier.copy(approvers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvers(ApprovalTeamRequestApprover ... approvers) {
            this.approvers(Arrays.asList(approvers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvers(Consumer<ApprovalTeamRequestApprover.Builder> ... approvers) {
            this.approvers(Stream.of(approvers).map(c -> (ApprovalTeamRequestApprover)((ApprovalTeamRequestApprover.Builder)ApprovalTeamRequestApprover.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApprovalTeamRequest build() {
            return new UpdateApprovalTeamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MpaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApprovalTeamRequest> {
        public Builder approvalStrategy(ApprovalStrategy var1);

        default public Builder approvalStrategy(Consumer<ApprovalStrategy.Builder> approvalStrategy) {
            return this.approvalStrategy((ApprovalStrategy)((ApprovalStrategy.Builder)ApprovalStrategy.builder().applyMutation(approvalStrategy)).build());
        }

        public Builder approvers(Collection<ApprovalTeamRequestApprover> var1);

        public Builder approvers(ApprovalTeamRequestApprover ... var1);

        public Builder approvers(Consumer<ApprovalTeamRequestApprover.Builder> ... var1);

        public Builder description(String var1);

        public Builder arn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

