/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mpa.model.IdentitySourceType;
import software.amazon.awssdk.services.mpa.model.MpaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIdentitySourceResponse
extends MpaResponse
implements ToCopyableBuilder<Builder, CreateIdentitySourceResponse> {
    private static final SdkField<String> IDENTITY_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentitySourceType").getter(CreateIdentitySourceResponse.getter(CreateIdentitySourceResponse::identitySourceTypeAsString)).setter(CreateIdentitySourceResponse.setter(Builder::identitySourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentitySourceType").build()}).build();
    private static final SdkField<String> IDENTITY_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentitySourceArn").getter(CreateIdentitySourceResponse.getter(CreateIdentitySourceResponse::identitySourceArn)).setter(CreateIdentitySourceResponse.setter(Builder::identitySourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentitySourceArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(CreateIdentitySourceResponse.getter(CreateIdentitySourceResponse::creationTime)).setter(CreateIdentitySourceResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_SOURCE_TYPE_FIELD, IDENTITY_SOURCE_ARN_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateIdentitySourceResponse.memberNameToFieldInitializer();
    private final String identitySourceType;
    private final String identitySourceArn;
    private final Instant creationTime;

    private CreateIdentitySourceResponse(BuilderImpl builder) {
        super(builder);
        this.identitySourceType = builder.identitySourceType;
        this.identitySourceArn = builder.identitySourceArn;
        this.creationTime = builder.creationTime;
    }

    public final IdentitySourceType identitySourceType() {
        return IdentitySourceType.fromValue(this.identitySourceType);
    }

    public final String identitySourceTypeAsString() {
        return this.identitySourceType;
    }

    public final String identitySourceArn() {
        return this.identitySourceArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identitySourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identitySourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIdentitySourceResponse)) {
            return false;
        }
        CreateIdentitySourceResponse other = (CreateIdentitySourceResponse)((Object)obj);
        return Objects.equals(this.identitySourceTypeAsString(), other.identitySourceTypeAsString()) && Objects.equals(this.identitySourceArn(), other.identitySourceArn()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIdentitySourceResponse").add("IdentitySourceType", (Object)this.identitySourceTypeAsString()).add("IdentitySourceArn", (Object)this.identitySourceArn()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentitySourceType": {
                return Optional.ofNullable(clazz.cast(this.identitySourceTypeAsString()));
            }
            case "IdentitySourceArn": {
                return Optional.ofNullable(clazz.cast(this.identitySourceArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IdentitySourceType", IDENTITY_SOURCE_TYPE_FIELD);
        map.put("IdentitySourceArn", IDENTITY_SOURCE_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIdentitySourceResponse, T> g) {
        return obj -> g.apply((CreateIdentitySourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MpaResponse.BuilderImpl
    implements Builder {
        private String identitySourceType;
        private String identitySourceArn;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIdentitySourceResponse model) {
            super(model);
            this.identitySourceType(model.identitySourceType);
            this.identitySourceArn(model.identitySourceArn);
            this.creationTime(model.creationTime);
        }

        public final String getIdentitySourceType() {
            return this.identitySourceType;
        }

        public final void setIdentitySourceType(String identitySourceType) {
            this.identitySourceType = identitySourceType;
        }

        @Override
        public final Builder identitySourceType(String identitySourceType) {
            this.identitySourceType = identitySourceType;
            return this;
        }

        @Override
        public final Builder identitySourceType(IdentitySourceType identitySourceType) {
            this.identitySourceType(identitySourceType == null ? null : identitySourceType.toString());
            return this;
        }

        public final String getIdentitySourceArn() {
            return this.identitySourceArn;
        }

        public final void setIdentitySourceArn(String identitySourceArn) {
            this.identitySourceArn = identitySourceArn;
        }

        @Override
        public final Builder identitySourceArn(String identitySourceArn) {
            this.identitySourceArn = identitySourceArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public CreateIdentitySourceResponse build() {
            return new CreateIdentitySourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MpaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIdentitySourceResponse> {
        public Builder identitySourceType(String var1);

        public Builder identitySourceType(IdentitySourceType var1);

        public Builder identitySourceArn(String var1);

        public Builder creationTime(Instant var1);
    }
}

