/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mq.model.MqRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationRevisionRequest
extends MqRequest
implements ToCopyableBuilder<Builder, DescribeConfigurationRevisionRequest> {
    private static final SdkField<String> CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationId").getter(DescribeConfigurationRevisionRequest.getter(DescribeConfigurationRevisionRequest::configurationId)).setter(DescribeConfigurationRevisionRequest.setter(Builder::configurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("configuration-id").build()}).build();
    private static final SdkField<String> CONFIGURATION_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationRevision").getter(DescribeConfigurationRevisionRequest.getter(DescribeConfigurationRevisionRequest::configurationRevision)).setter(DescribeConfigurationRevisionRequest.setter(Builder::configurationRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("configuration-revision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_ID_FIELD, CONFIGURATION_REVISION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeConfigurationRevisionRequest.memberNameToFieldInitializer();
    private final String configurationId;
    private final String configurationRevision;

    private DescribeConfigurationRevisionRequest(BuilderImpl builder) {
        super(builder);
        this.configurationId = builder.configurationId;
        this.configurationRevision = builder.configurationRevision;
    }

    public final String configurationId() {
        return this.configurationId;
    }

    public final String configurationRevision() {
        return this.configurationRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationRevision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationRevisionRequest)) {
            return false;
        }
        DescribeConfigurationRevisionRequest other = (DescribeConfigurationRevisionRequest)((Object)obj);
        return Objects.equals(this.configurationId(), other.configurationId()) && Objects.equals(this.configurationRevision(), other.configurationRevision());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConfigurationRevisionRequest").add("ConfigurationId", (Object)this.configurationId()).add("ConfigurationRevision", (Object)this.configurationRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.configurationId()));
            }
            case "ConfigurationRevision": {
                return Optional.ofNullable(clazz.cast(this.configurationRevision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("configuration-id", CONFIGURATION_ID_FIELD);
        map.put("configuration-revision", CONFIGURATION_REVISION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationRevisionRequest, T> g) {
        return obj -> g.apply((DescribeConfigurationRevisionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MqRequest.BuilderImpl
    implements Builder {
        private String configurationId;
        private String configurationRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationRevisionRequest model) {
            super(model);
            this.configurationId(model.configurationId);
            this.configurationRevision(model.configurationRevision);
        }

        public final String getConfigurationId() {
            return this.configurationId;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        @Override
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public final String getConfigurationRevision() {
            return this.configurationRevision;
        }

        public final void setConfigurationRevision(String configurationRevision) {
            this.configurationRevision = configurationRevision;
        }

        @Override
        public final Builder configurationRevision(String configurationRevision) {
            this.configurationRevision = configurationRevision;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationRevisionRequest build() {
            return new DescribeConfigurationRevisionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MqRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConfigurationRevisionRequest> {
        public Builder configurationId(String var1);

        public Builder configurationRevision(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

