/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQualificationTypesRequest
extends MTurkRequest
implements ToCopyableBuilder<Builder, ListQualificationTypesRequest> {
    private static final SdkField<String> QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Query").getter(ListQualificationTypesRequest.getter(ListQualificationTypesRequest::query)).setter(ListQualificationTypesRequest.setter(Builder::query)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Query").build()}).build();
    private static final SdkField<Boolean> MUST_BE_REQUESTABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MustBeRequestable").getter(ListQualificationTypesRequest.getter(ListQualificationTypesRequest::mustBeRequestable)).setter(ListQualificationTypesRequest.setter(Builder::mustBeRequestable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MustBeRequestable").build()}).build();
    private static final SdkField<Boolean> MUST_BE_OWNED_BY_CALLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MustBeOwnedByCaller").getter(ListQualificationTypesRequest.getter(ListQualificationTypesRequest::mustBeOwnedByCaller)).setter(ListQualificationTypesRequest.setter(Builder::mustBeOwnedByCaller)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MustBeOwnedByCaller").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListQualificationTypesRequest.getter(ListQualificationTypesRequest::nextToken)).setter(ListQualificationTypesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListQualificationTypesRequest.getter(ListQualificationTypesRequest::maxResults)).setter(ListQualificationTypesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_FIELD, MUST_BE_REQUESTABLE_FIELD, MUST_BE_OWNED_BY_CALLER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListQualificationTypesRequest.memberNameToFieldInitializer();
    private final String query;
    private final Boolean mustBeRequestable;
    private final Boolean mustBeOwnedByCaller;
    private final String nextToken;
    private final Integer maxResults;

    private ListQualificationTypesRequest(BuilderImpl builder) {
        super(builder);
        this.query = builder.query;
        this.mustBeRequestable = builder.mustBeRequestable;
        this.mustBeOwnedByCaller = builder.mustBeOwnedByCaller;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String query() {
        return this.query;
    }

    public final Boolean mustBeRequestable() {
        return this.mustBeRequestable;
    }

    public final Boolean mustBeOwnedByCaller() {
        return this.mustBeOwnedByCaller;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.query());
        hashCode = 31 * hashCode + Objects.hashCode(this.mustBeRequestable());
        hashCode = 31 * hashCode + Objects.hashCode(this.mustBeOwnedByCaller());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQualificationTypesRequest)) {
            return false;
        }
        ListQualificationTypesRequest other = (ListQualificationTypesRequest)((Object)obj);
        return Objects.equals(this.query(), other.query()) && Objects.equals(this.mustBeRequestable(), other.mustBeRequestable()) && Objects.equals(this.mustBeOwnedByCaller(), other.mustBeOwnedByCaller()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListQualificationTypesRequest").add("Query", (Object)this.query()).add("MustBeRequestable", (Object)this.mustBeRequestable()).add("MustBeOwnedByCaller", (Object)this.mustBeOwnedByCaller()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Query": {
                return Optional.ofNullable(clazz.cast(this.query()));
            }
            case "MustBeRequestable": {
                return Optional.ofNullable(clazz.cast(this.mustBeRequestable()));
            }
            case "MustBeOwnedByCaller": {
                return Optional.ofNullable(clazz.cast(this.mustBeOwnedByCaller()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Query", QUERY_FIELD);
        map.put("MustBeRequestable", MUST_BE_REQUESTABLE_FIELD);
        map.put("MustBeOwnedByCaller", MUST_BE_OWNED_BY_CALLER_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListQualificationTypesRequest, T> g) {
        return obj -> g.apply((ListQualificationTypesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkRequest.BuilderImpl
    implements Builder {
        private String query;
        private Boolean mustBeRequestable;
        private Boolean mustBeOwnedByCaller;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQualificationTypesRequest model) {
            super(model);
            this.query(model.query);
            this.mustBeRequestable(model.mustBeRequestable);
            this.mustBeOwnedByCaller(model.mustBeOwnedByCaller);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getQuery() {
            return this.query;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final Boolean getMustBeRequestable() {
            return this.mustBeRequestable;
        }

        public final void setMustBeRequestable(Boolean mustBeRequestable) {
            this.mustBeRequestable = mustBeRequestable;
        }

        @Override
        public final Builder mustBeRequestable(Boolean mustBeRequestable) {
            this.mustBeRequestable = mustBeRequestable;
            return this;
        }

        public final Boolean getMustBeOwnedByCaller() {
            return this.mustBeOwnedByCaller;
        }

        public final void setMustBeOwnedByCaller(Boolean mustBeOwnedByCaller) {
            this.mustBeOwnedByCaller = mustBeOwnedByCaller;
        }

        @Override
        public final Builder mustBeOwnedByCaller(Boolean mustBeOwnedByCaller) {
            this.mustBeOwnedByCaller = mustBeOwnedByCaller;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListQualificationTypesRequest build() {
            return new ListQualificationTypesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MTurkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQualificationTypesRequest> {
        public Builder query(String var1);

        public Builder mustBeRequestable(Boolean var1);

        public Builder mustBeOwnedByCaller(Boolean var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

