/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaa.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <b>Internal only</b>. Collects Apache Airflow metrics. To learn more about the metrics published to Amazon
 * CloudWatch, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/cw-metrics.html">Amazon MWAA performance
 * metrics in Amazon CloudWatch</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricDatum implements SdkPojo, Serializable, ToCopyableBuilder<MetricDatum.Builder, MetricDatum> {
    private static final SdkField<List<Dimension>> DIMENSIONS_FIELD = SdkField
            .<List<Dimension>> builder(MarshallingType.LIST)
            .memberName("Dimensions")
            .getter(getter(MetricDatum::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Dimension> builder(MarshallingType.SDK_POJO)
                                            .constructor(Dimension::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(MetricDatum::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<StatisticSet> STATISTIC_VALUES_FIELD = SdkField
            .<StatisticSet> builder(MarshallingType.SDK_POJO).memberName("StatisticValues")
            .getter(getter(MetricDatum::statisticValues)).setter(setter(Builder::statisticValues))
            .constructor(StatisticSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticValues").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(MetricDatum::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(MetricDatum::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Value")
            .getter(getter(MetricDatum::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD,
            METRIC_NAME_FIELD, STATISTIC_VALUES_FIELD, TIMESTAMP_FIELD, UNIT_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Dimension> dimensions;

    private final String metricName;

    private final StatisticSet statisticValues;

    private final Instant timestamp;

    private final String unit;

    private final Double value;

    private MetricDatum(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.metricName = builder.metricName;
        this.statisticValues = builder.statisticValues;
        this.timestamp = builder.timestamp;
        this.unit = builder.unit;
        this.value = builder.value;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dimensions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDimensions() {
        return dimensions != null && !(dimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * <b>Internal only</b>. The dimensions associated with the metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensions} method.
     * </p>
     * 
     * @return <b>Internal only</b>. The dimensions associated with the metric.
     */
    public final List<Dimension> dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * <b>Internal only</b>. The name of the metric.
     * </p>
     * 
     * @return <b>Internal only</b>. The name of the metric.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * <b>Internal only</b>. The statistical values for the metric.
     * </p>
     * 
     * @return <b>Internal only</b>. The statistical values for the metric.
     */
    public final StatisticSet statisticValues() {
        return statisticValues;
    }

    /**
     * <p>
     * <b>Internal only</b>. The time the metric data was received.
     * </p>
     * 
     * @return <b>Internal only</b>. The time the metric data was received.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * <b>Internal only</b>. The unit used to store the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link Unit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return <b>Internal only</b>. The unit used to store the metric.
     * @see Unit
     */
    public final Unit unit() {
        return Unit.fromValue(unit);
    }

    /**
     * <p>
     * <b>Internal only</b>. The unit used to store the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link Unit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return <b>Internal only</b>. The unit used to store the metric.
     * @see Unit
     */
    public final String unitAsString() {
        return unit;
    }

    /**
     * <p>
     * <b>Internal only</b>. The value for the metric.
     * </p>
     * 
     * @return <b>Internal only</b>. The value for the metric.
     */
    public final Double value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensions() ? dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(statisticValues());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDatum)) {
            return false;
        }
        MetricDatum other = (MetricDatum) obj;
        return hasDimensions() == other.hasDimensions() && Objects.equals(dimensions(), other.dimensions())
                && Objects.equals(metricName(), other.metricName()) && Objects.equals(statisticValues(), other.statisticValues())
                && Objects.equals(timestamp(), other.timestamp()) && Objects.equals(unitAsString(), other.unitAsString())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricDatum").add("Dimensions", hasDimensions() ? dimensions() : null)
                .add("MetricName", metricName()).add("StatisticValues", statisticValues()).add("Timestamp", timestamp())
                .add("Unit", unitAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "StatisticValues":
            return Optional.ofNullable(clazz.cast(statisticValues()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricDatum, T> g) {
        return obj -> g.apply((MetricDatum) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricDatum> {
        /**
         * <p>
         * <b>Internal only</b>. The dimensions associated with the metric.
         * </p>
         * 
         * @param dimensions
         *        <b>Internal only</b>. The dimensions associated with the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Collection<Dimension> dimensions);

        /**
         * <p>
         * <b>Internal only</b>. The dimensions associated with the metric.
         * </p>
         * 
         * @param dimensions
         *        <b>Internal only</b>. The dimensions associated with the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Dimension... dimensions);

        /**
         * <p>
         * <b>Internal only</b>. The dimensions associated with the metric.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Dimension>.Builder} avoiding the need to
         * create one manually via {@link List<Dimension>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Dimension>.Builder#build()} is called immediately and its
         * result is passed to {@link #dimensions(List<Dimension>)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on {@link List<Dimension>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(List<Dimension>)
         */
        Builder dimensions(Consumer<Dimension.Builder>... dimensions);

        /**
         * <p>
         * <b>Internal only</b>. The name of the metric.
         * </p>
         * 
         * @param metricName
         *        <b>Internal only</b>. The name of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * <b>Internal only</b>. The statistical values for the metric.
         * </p>
         * 
         * @param statisticValues
         *        <b>Internal only</b>. The statistical values for the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticValues(StatisticSet statisticValues);

        /**
         * <p>
         * <b>Internal only</b>. The statistical values for the metric.
         * </p>
         * This is a convenience that creates an instance of the {@link StatisticSet.Builder} avoiding the need to
         * create one manually via {@link StatisticSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link StatisticSet.Builder#build()} is called immediately and its
         * result is passed to {@link #statisticValues(StatisticSet)}.
         * 
         * @param statisticValues
         *        a consumer that will call methods on {@link StatisticSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statisticValues(StatisticSet)
         */
        default Builder statisticValues(Consumer<StatisticSet.Builder> statisticValues) {
            return statisticValues(StatisticSet.builder().applyMutation(statisticValues).build());
        }

        /**
         * <p>
         * <b>Internal only</b>. The time the metric data was received.
         * </p>
         * 
         * @param timestamp
         *        <b>Internal only</b>. The time the metric data was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * <b>Internal only</b>. The unit used to store the metric.
         * </p>
         * 
         * @param unit
         *        <b>Internal only</b>. The unit used to store the metric.
         * @see Unit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Unit
         */
        Builder unit(String unit);

        /**
         * <p>
         * <b>Internal only</b>. The unit used to store the metric.
         * </p>
         * 
         * @param unit
         *        <b>Internal only</b>. The unit used to store the metric.
         * @see Unit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Unit
         */
        Builder unit(Unit unit);

        /**
         * <p>
         * <b>Internal only</b>. The value for the metric.
         * </p>
         * 
         * @param value
         *        <b>Internal only</b>. The value for the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);
    }

    static final class BuilderImpl implements Builder {
        private List<Dimension> dimensions = DefaultSdkAutoConstructList.getInstance();

        private String metricName;

        private StatisticSet statisticValues;

        private Instant timestamp;

        private String unit;

        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDatum model) {
            dimensions(model.dimensions);
            metricName(model.metricName);
            statisticValues(model.statisticValues);
            timestamp(model.timestamp);
            unit(model.unit);
            value(model.value);
        }

        public final List<Dimension.Builder> getDimensions() {
            List<Dimension.Builder> result = DimensionsCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionsCopier.copyFromBuilder(dimensions);
        }

        @Override
        @Transient
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dimensions(Dimension... dimensions) {
            dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dimensions(Consumer<Dimension.Builder>... dimensions) {
            dimensions(Stream.of(dimensions).map(c -> Dimension.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        @Transient
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final StatisticSet.Builder getStatisticValues() {
            return statisticValues != null ? statisticValues.toBuilder() : null;
        }

        public final void setStatisticValues(StatisticSet.BuilderImpl statisticValues) {
            this.statisticValues = statisticValues != null ? statisticValues.build() : null;
        }

        @Override
        @Transient
        public final Builder statisticValues(StatisticSet statisticValues) {
            this.statisticValues = statisticValues;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        @Transient
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        @Transient
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        @Transient
        public final Builder unit(Unit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        @Transient
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        @Override
        public MetricDatum build() {
            return new MetricDatum(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
