/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaa.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mwaa.model.MetricDataCopier;
import software.amazon.awssdk.services.mwaa.model.MetricDatum;
import software.amazon.awssdk.services.mwaa.model.MwaaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublishMetricsRequest
extends MwaaRequest
implements ToCopyableBuilder<Builder, PublishMetricsRequest> {
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentName").getter(PublishMetricsRequest.getter(PublishMetricsRequest::environmentName)).setter(PublishMetricsRequest.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("EnvironmentName").build()}).build();
    private static final SdkField<List<MetricDatum>> METRIC_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricData").getter(PublishMetricsRequest.getter(PublishMetricsRequest::metricData)).setter(PublishMetricsRequest.setter(Builder::metricData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDatum::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_NAME_FIELD, METRIC_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PublishMetricsRequest.memberNameToFieldInitializer();
    private final String environmentName;
    private final List<MetricDatum> metricData;

    private PublishMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.environmentName = builder.environmentName;
        this.metricData = builder.metricData;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final boolean hasMetricData() {
        return this.metricData != null && !(this.metricData instanceof SdkAutoConstructList);
    }

    public final List<MetricDatum> metricData() {
        return this.metricData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricData() ? this.metricData() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishMetricsRequest)) {
            return false;
        }
        PublishMetricsRequest other = (PublishMetricsRequest)((Object)obj);
        return Objects.equals(this.environmentName(), other.environmentName()) && this.hasMetricData() == other.hasMetricData() && Objects.equals(this.metricData(), other.metricData());
    }

    public final String toString() {
        return ToString.builder((String)"PublishMetricsRequest").add("EnvironmentName", (Object)this.environmentName()).add("MetricData", this.hasMetricData() ? this.metricData() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "MetricData": {
                return Optional.ofNullable(clazz.cast(this.metricData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EnvironmentName", ENVIRONMENT_NAME_FIELD);
        map.put("MetricData", METRIC_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PublishMetricsRequest, T> g) {
        return obj -> g.apply((PublishMetricsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MwaaRequest.BuilderImpl
    implements Builder {
        private String environmentName;
        private List<MetricDatum> metricData = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PublishMetricsRequest model) {
            super(model);
            this.environmentName(model.environmentName);
            this.metricData(model.metricData);
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final List<MetricDatum.Builder> getMetricData() {
            List<MetricDatum.Builder> result = MetricDataCopier.copyToBuilder(this.metricData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricData(Collection<MetricDatum.BuilderImpl> metricData) {
            this.metricData = MetricDataCopier.copyFromBuilder(metricData);
        }

        @Override
        public final Builder metricData(Collection<MetricDatum> metricData) {
            this.metricData = MetricDataCopier.copy(metricData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(MetricDatum ... metricData) {
            this.metricData(Arrays.asList(metricData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(Consumer<MetricDatum.Builder> ... metricData) {
            this.metricData(Stream.of(metricData).map(c -> (MetricDatum)((MetricDatum.Builder)MetricDatum.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PublishMetricsRequest build() {
            return new PublishMetricsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MwaaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PublishMetricsRequest> {
        public Builder environmentName(String var1);

        public Builder metricData(Collection<MetricDatum> var1);

        public Builder metricData(MetricDatum ... var1);

        public Builder metricData(Consumer<MetricDatum.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

