/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunegraph.model.Format;
import software.amazon.awssdk.services.neptunegraph.model.ImportOptions;
import software.amazon.awssdk.services.neptunegraph.model.ImportTaskStatus;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.ParquetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartImportTaskResponse
extends NeptuneGraphResponse
implements ToCopyableBuilder<Builder, StartImportTaskResponse> {
    private static final SdkField<String> GRAPH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("graphId").getter(StartImportTaskResponse.getter(StartImportTaskResponse::graphId)).setter(StartImportTaskResponse.setter(Builder::graphId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphId").build()}).build();
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(StartImportTaskResponse.getter(StartImportTaskResponse::taskId)).setter(StartImportTaskResponse.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(StartImportTaskResponse.getter(StartImportTaskResponse::source)).setter(StartImportTaskResponse.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(StartImportTaskResponse.getter(StartImportTaskResponse::formatAsString)).setter(StartImportTaskResponse.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> PARQUET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parquetType").getter(StartImportTaskResponse.getter(StartImportTaskResponse::parquetTypeAsString)).setter(StartImportTaskResponse.setter(Builder::parquetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parquetType").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(StartImportTaskResponse.getter(StartImportTaskResponse::roleArn)).setter(StartImportTaskResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(StartImportTaskResponse.getter(StartImportTaskResponse::statusAsString)).setter(StartImportTaskResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<ImportOptions> IMPORT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("importOptions").getter(StartImportTaskResponse.getter(StartImportTaskResponse::importOptions)).setter(StartImportTaskResponse.setter(Builder::importOptions)).constructor(ImportOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_ID_FIELD, TASK_ID_FIELD, SOURCE_FIELD, FORMAT_FIELD, PARQUET_TYPE_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, IMPORT_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartImportTaskResponse.memberNameToFieldInitializer();
    private final String graphId;
    private final String taskId;
    private final String source;
    private final String format;
    private final String parquetType;
    private final String roleArn;
    private final String status;
    private final ImportOptions importOptions;

    private StartImportTaskResponse(BuilderImpl builder) {
        super(builder);
        this.graphId = builder.graphId;
        this.taskId = builder.taskId;
        this.source = builder.source;
        this.format = builder.format;
        this.parquetType = builder.parquetType;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.importOptions = builder.importOptions;
    }

    public final String graphId() {
        return this.graphId;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final String source() {
        return this.source;
    }

    public final Format format() {
        return Format.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final ParquetType parquetType() {
        return ParquetType.fromValue(this.parquetType);
    }

    public final String parquetTypeAsString() {
        return this.parquetType;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ImportTaskStatus status() {
        return ImportTaskStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ImportOptions importOptions() {
        return this.importOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.graphId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parquetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.importOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportTaskResponse)) {
            return false;
        }
        StartImportTaskResponse other = (StartImportTaskResponse)((Object)obj);
        return Objects.equals(this.graphId(), other.graphId()) && Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.parquetTypeAsString(), other.parquetTypeAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.importOptions(), other.importOptions());
    }

    public final String toString() {
        return ToString.builder((String)"StartImportTaskResponse").add("GraphId", (Object)this.graphId()).add("TaskId", (Object)this.taskId()).add("Source", (Object)this.source()).add("Format", (Object)this.formatAsString()).add("ParquetType", (Object)this.parquetTypeAsString()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.statusAsString()).add("ImportOptions", (Object)this.importOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "graphId": {
                return Optional.ofNullable(clazz.cast(this.graphId()));
            }
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "parquetType": {
                return Optional.ofNullable(clazz.cast(this.parquetTypeAsString()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "importOptions": {
                return Optional.ofNullable(clazz.cast(this.importOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("graphId", GRAPH_ID_FIELD);
        map.put("taskId", TASK_ID_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("parquetType", PARQUET_TYPE_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("importOptions", IMPORT_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartImportTaskResponse, T> g) {
        return obj -> g.apply((StartImportTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneGraphResponse.BuilderImpl
    implements Builder {
        private String graphId;
        private String taskId;
        private String source;
        private String format;
        private String parquetType;
        private String roleArn;
        private String status;
        private ImportOptions importOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportTaskResponse model) {
            super(model);
            this.graphId(model.graphId);
            this.taskId(model.taskId);
            this.source(model.source);
            this.format(model.format);
            this.parquetType(model.parquetType);
            this.roleArn(model.roleArn);
            this.status(model.status);
            this.importOptions(model.importOptions);
        }

        public final String getGraphId() {
            return this.graphId;
        }

        public final void setGraphId(String graphId) {
            this.graphId = graphId;
        }

        @Override
        public final Builder graphId(String graphId) {
            this.graphId = graphId;
            return this;
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getParquetType() {
            return this.parquetType;
        }

        public final void setParquetType(String parquetType) {
            this.parquetType = parquetType;
        }

        @Override
        public final Builder parquetType(String parquetType) {
            this.parquetType = parquetType;
            return this;
        }

        @Override
        public final Builder parquetType(ParquetType parquetType) {
            this.parquetType(parquetType == null ? null : parquetType.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ImportTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ImportOptions.Builder getImportOptions() {
            return this.importOptions != null ? this.importOptions.toBuilder() : null;
        }

        public final void setImportOptions(ImportOptions.BuilderImpl importOptions) {
            this.importOptions = importOptions != null ? importOptions.build() : null;
        }

        @Override
        public final Builder importOptions(ImportOptions importOptions) {
            this.importOptions = importOptions;
            return this;
        }

        @Override
        public StartImportTaskResponse build() {
            return new StartImportTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptuneGraphResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartImportTaskResponse> {
        public Builder graphId(String var1);

        public Builder taskId(String var1);

        public Builder source(String var1);

        public Builder format(String var1);

        public Builder format(Format var1);

        public Builder parquetType(String var1);

        public Builder parquetType(ParquetType var1);

        public Builder roleArn(String var1);

        public Builder status(String var1);

        public Builder status(ImportTaskStatus var1);

        public Builder importOptions(ImportOptions var1);

        default public Builder importOptions(Consumer<ImportOptions.Builder> importOptions) {
            return this.importOptions((ImportOptions)((ImportOptions.Builder)ImportOptions.builder().applyMutation(importOptions)).build());
        }
    }
}

