/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.IdentifiedType;
import software.amazon.awssdk.services.networkfirewall.model.RuleIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalysisResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalysisResult> {
    private static final SdkField<List<String>> IDENTIFIED_RULE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IdentifiedRuleIds").getter(AnalysisResult.getter(AnalysisResult::identifiedRuleIds)).setter(AnalysisResult.setter(Builder::identifiedRuleIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifiedRuleIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IDENTIFIED_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentifiedType").getter(AnalysisResult.getter(AnalysisResult::identifiedTypeAsString)).setter(AnalysisResult.setter(Builder::identifiedType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifiedType").build()}).build();
    private static final SdkField<String> ANALYSIS_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisDetail").getter(AnalysisResult.getter(AnalysisResult::analysisDetail)).setter(AnalysisResult.setter(Builder::analysisDetail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisDetail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIED_RULE_IDS_FIELD, IDENTIFIED_TYPE_FIELD, ANALYSIS_DETAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnalysisResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> identifiedRuleIds;
    private final String identifiedType;
    private final String analysisDetail;

    private AnalysisResult(BuilderImpl builder) {
        this.identifiedRuleIds = builder.identifiedRuleIds;
        this.identifiedType = builder.identifiedType;
        this.analysisDetail = builder.analysisDetail;
    }

    public final boolean hasIdentifiedRuleIds() {
        return this.identifiedRuleIds != null && !(this.identifiedRuleIds instanceof SdkAutoConstructList);
    }

    public final List<String> identifiedRuleIds() {
        return this.identifiedRuleIds;
    }

    public final IdentifiedType identifiedType() {
        return IdentifiedType.fromValue(this.identifiedType);
    }

    public final String identifiedTypeAsString() {
        return this.identifiedType;
    }

    public final String analysisDetail() {
        return this.analysisDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentifiedRuleIds() ? this.identifiedRuleIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.identifiedTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisDetail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisResult)) {
            return false;
        }
        AnalysisResult other = (AnalysisResult)obj;
        return this.hasIdentifiedRuleIds() == other.hasIdentifiedRuleIds() && Objects.equals(this.identifiedRuleIds(), other.identifiedRuleIds()) && Objects.equals(this.identifiedTypeAsString(), other.identifiedTypeAsString()) && Objects.equals(this.analysisDetail(), other.analysisDetail());
    }

    public final String toString() {
        return ToString.builder((String)"AnalysisResult").add("IdentifiedRuleIds", this.hasIdentifiedRuleIds() ? this.identifiedRuleIds() : null).add("IdentifiedType", (Object)this.identifiedTypeAsString()).add("AnalysisDetail", (Object)this.analysisDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentifiedRuleIds": {
                return Optional.ofNullable(clazz.cast(this.identifiedRuleIds()));
            }
            case "IdentifiedType": {
                return Optional.ofNullable(clazz.cast(this.identifiedTypeAsString()));
            }
            case "AnalysisDetail": {
                return Optional.ofNullable(clazz.cast(this.analysisDetail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IdentifiedRuleIds", IDENTIFIED_RULE_IDS_FIELD);
        map.put("IdentifiedType", IDENTIFIED_TYPE_FIELD);
        map.put("AnalysisDetail", ANALYSIS_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisResult, T> g) {
        return obj -> g.apply((AnalysisResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> identifiedRuleIds = DefaultSdkAutoConstructList.getInstance();
        private String identifiedType;
        private String analysisDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisResult model) {
            this.identifiedRuleIds(model.identifiedRuleIds);
            this.identifiedType(model.identifiedType);
            this.analysisDetail(model.analysisDetail);
        }

        public final Collection<String> getIdentifiedRuleIds() {
            if (this.identifiedRuleIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.identifiedRuleIds;
        }

        public final void setIdentifiedRuleIds(Collection<String> identifiedRuleIds) {
            this.identifiedRuleIds = RuleIdListCopier.copy(identifiedRuleIds);
        }

        @Override
        public final Builder identifiedRuleIds(Collection<String> identifiedRuleIds) {
            this.identifiedRuleIds = RuleIdListCopier.copy(identifiedRuleIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifiedRuleIds(String ... identifiedRuleIds) {
            this.identifiedRuleIds(Arrays.asList(identifiedRuleIds));
            return this;
        }

        public final String getIdentifiedType() {
            return this.identifiedType;
        }

        public final void setIdentifiedType(String identifiedType) {
            this.identifiedType = identifiedType;
        }

        @Override
        public final Builder identifiedType(String identifiedType) {
            this.identifiedType = identifiedType;
            return this;
        }

        @Override
        public final Builder identifiedType(IdentifiedType identifiedType) {
            this.identifiedType(identifiedType == null ? null : identifiedType.toString());
            return this;
        }

        public final String getAnalysisDetail() {
            return this.analysisDetail;
        }

        public final void setAnalysisDetail(String analysisDetail) {
            this.analysisDetail = analysisDetail;
        }

        @Override
        public final Builder analysisDetail(String analysisDetail) {
            this.analysisDetail = analysisDetail;
            return this;
        }

        public AnalysisResult build() {
            return new AnalysisResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalysisResult> {
        public Builder identifiedRuleIds(Collection<String> var1);

        public Builder identifiedRuleIds(String ... var1);

        public Builder identifiedType(String var1);

        public Builder identifiedType(IdentifiedType var1);

        public Builder analysisDetail(String var1);
    }
}

