/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.FlowOperationMetadata;
import software.amazon.awssdk.services.networkfirewall.model.FlowOperationsCopier;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFlowOperationsResponse
extends NetworkFirewallResponse
implements ToCopyableBuilder<Builder, ListFlowOperationsResponse> {
    private static final SdkField<List<FlowOperationMetadata>> FLOW_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FlowOperations").getter(ListFlowOperationsResponse.getter(ListFlowOperationsResponse::flowOperations)).setter(ListFlowOperationsResponse.setter(Builder::flowOperations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowOperationMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFlowOperationsResponse.getter(ListFlowOperationsResponse::nextToken)).setter(ListFlowOperationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_OPERATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFlowOperationsResponse.memberNameToFieldInitializer();
    private final List<FlowOperationMetadata> flowOperations;
    private final String nextToken;

    private ListFlowOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.flowOperations = builder.flowOperations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFlowOperations() {
        return this.flowOperations != null && !(this.flowOperations instanceof SdkAutoConstructList);
    }

    public final List<FlowOperationMetadata> flowOperations() {
        return this.flowOperations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFlowOperations() ? this.flowOperations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFlowOperationsResponse)) {
            return false;
        }
        ListFlowOperationsResponse other = (ListFlowOperationsResponse)((Object)obj);
        return this.hasFlowOperations() == other.hasFlowOperations() && Objects.equals(this.flowOperations(), other.flowOperations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFlowOperationsResponse").add("FlowOperations", this.hasFlowOperations() ? this.flowOperations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowOperations": {
                return Optional.ofNullable(clazz.cast(this.flowOperations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FlowOperations", FLOW_OPERATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFlowOperationsResponse, T> g) {
        return obj -> g.apply((ListFlowOperationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallResponse.BuilderImpl
    implements Builder {
        private List<FlowOperationMetadata> flowOperations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFlowOperationsResponse model) {
            super(model);
            this.flowOperations(model.flowOperations);
            this.nextToken(model.nextToken);
        }

        public final List<FlowOperationMetadata.Builder> getFlowOperations() {
            List<FlowOperationMetadata.Builder> result = FlowOperationsCopier.copyToBuilder(this.flowOperations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFlowOperations(Collection<FlowOperationMetadata.BuilderImpl> flowOperations) {
            this.flowOperations = FlowOperationsCopier.copyFromBuilder(flowOperations);
        }

        @Override
        public final Builder flowOperations(Collection<FlowOperationMetadata> flowOperations) {
            this.flowOperations = FlowOperationsCopier.copy(flowOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowOperations(FlowOperationMetadata ... flowOperations) {
            this.flowOperations(Arrays.asList(flowOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowOperations(Consumer<FlowOperationMetadata.Builder> ... flowOperations) {
            this.flowOperations(Stream.of(flowOperations).map(c -> (FlowOperationMetadata)((FlowOperationMetadata.Builder)FlowOperationMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFlowOperationsResponse build() {
            return new ListFlowOperationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkFirewallResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFlowOperationsResponse> {
        public Builder flowOperations(Collection<FlowOperationMetadata> var1);

        public Builder flowOperations(FlowOperationMetadata ... var1);

        public Builder flowOperations(Consumer<FlowOperationMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

