/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallClient;
import software.amazon.awssdk.services.networkfirewall.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkfirewall.model.AnalysisReport;
import software.amazon.awssdk.services.networkfirewall.model.ListAnalysisReportsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListAnalysisReportsResponse;

public class ListAnalysisReportsIterable
implements SdkIterable<ListAnalysisReportsResponse> {
    private final NetworkFirewallClient client;
    private final ListAnalysisReportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAnalysisReportsIterable(NetworkFirewallClient client, ListAnalysisReportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAnalysisReportsResponseFetcher();
    }

    public Iterator<ListAnalysisReportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AnalysisReport> analysisReports() {
        Function<ListAnalysisReportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.analysisReports() != null) {
                return response.analysisReports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAnalysisReportsResponseFetcher
    implements SyncPageFetcher<ListAnalysisReportsResponse> {
        private ListAnalysisReportsResponseFetcher() {
        }

        public boolean hasNextPage(ListAnalysisReportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAnalysisReportsResponse nextPage(ListAnalysisReportsResponse previousPage) {
            if (previousPage == null) {
                return ListAnalysisReportsIterable.this.client.listAnalysisReports(ListAnalysisReportsIterable.this.firstRequest);
            }
            return ListAnalysisReportsIterable.this.client.listAnalysisReports((ListAnalysisReportsRequest)((Object)ListAnalysisReportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

