/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFlowOperationResultsRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, ListFlowOperationResultsRequest> {
    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallArn").getter(ListFlowOperationResultsRequest.getter(ListFlowOperationResultsRequest::firewallArn)).setter(ListFlowOperationResultsRequest.setter(Builder::firewallArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()}).build();
    private static final SdkField<String> FLOW_OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowOperationId").getter(ListFlowOperationResultsRequest.getter(ListFlowOperationResultsRequest::flowOperationId)).setter(ListFlowOperationResultsRequest.setter(Builder::flowOperationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperationId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFlowOperationResultsRequest.getter(ListFlowOperationResultsRequest::nextToken)).setter(ListFlowOperationResultsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListFlowOperationResultsRequest.getter(ListFlowOperationResultsRequest::maxResults)).setter(ListFlowOperationResultsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(ListFlowOperationResultsRequest.getter(ListFlowOperationResultsRequest::availabilityZone)).setter(ListFlowOperationResultsRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_ARN_FIELD, FLOW_OPERATION_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, AVAILABILITY_ZONE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFlowOperationResultsRequest.memberNameToFieldInitializer();
    private final String firewallArn;
    private final String flowOperationId;
    private final String nextToken;
    private final Integer maxResults;
    private final String availabilityZone;

    private ListFlowOperationResultsRequest(BuilderImpl builder) {
        super(builder);
        this.firewallArn = builder.firewallArn;
        this.flowOperationId = builder.flowOperationId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.availabilityZone = builder.availabilityZone;
    }

    public final String firewallArn() {
        return this.firewallArn;
    }

    public final String flowOperationId() {
        return this.flowOperationId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFlowOperationResultsRequest)) {
            return false;
        }
        ListFlowOperationResultsRequest other = (ListFlowOperationResultsRequest)((Object)obj);
        return Objects.equals(this.firewallArn(), other.firewallArn()) && Objects.equals(this.flowOperationId(), other.flowOperationId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.availabilityZone(), other.availabilityZone());
    }

    public final String toString() {
        return ToString.builder((String)"ListFlowOperationResultsRequest").add("FirewallArn", (Object)this.firewallArn()).add("FlowOperationId", (Object)this.flowOperationId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("AvailabilityZone", (Object)this.availabilityZone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallArn": {
                return Optional.ofNullable(clazz.cast(this.firewallArn()));
            }
            case "FlowOperationId": {
                return Optional.ofNullable(clazz.cast(this.flowOperationId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FirewallArn", FIREWALL_ARN_FIELD);
        map.put("FlowOperationId", FLOW_OPERATION_ID_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFlowOperationResultsRequest, T> g) {
        return obj -> g.apply((ListFlowOperationResultsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String firewallArn;
        private String flowOperationId;
        private String nextToken;
        private Integer maxResults;
        private String availabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFlowOperationResultsRequest model) {
            super(model);
            this.firewallArn(model.firewallArn);
            this.flowOperationId(model.flowOperationId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.availabilityZone(model.availabilityZone);
        }

        public final String getFirewallArn() {
            return this.firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final String getFlowOperationId() {
            return this.flowOperationId;
        }

        public final void setFlowOperationId(String flowOperationId) {
            this.flowOperationId = flowOperationId;
        }

        @Override
        public final Builder flowOperationId(String flowOperationId) {
            this.flowOperationId = flowOperationId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFlowOperationResultsRequest build() {
            return new ListFlowOperationResultsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFlowOperationResultsRequest> {
        public Builder firewallArn(String var1);

        public Builder flowOperationId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder availabilityZone(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

