/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LogDestinationType {
    S3("S3"),
    CLOUD_WATCH_LOGS("CloudWatchLogs"),
    KINESIS_DATA_FIREHOSE("KinesisDataFirehose"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LogDestinationType> VALUE_MAP;
    private final String value;

    private LogDestinationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LogDestinationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LogDestinationType> knownValues() {
        EnumSet<LogDestinationType> knownValues = EnumSet.allOf(LogDestinationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LogDestinationType.class, LogDestinationType::toString);
    }
}

