/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.EnabledAnalysisType;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAnalysisReportRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, StartAnalysisReportRequest> {
    private static final SdkField<String> FIREWALL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallName").getter(StartAnalysisReportRequest.getter(StartAnalysisReportRequest::firewallName)).setter(StartAnalysisReportRequest.setter(Builder::firewallName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallName").build()}).build();
    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallArn").getter(StartAnalysisReportRequest.getter(StartAnalysisReportRequest::firewallArn)).setter(StartAnalysisReportRequest.setter(Builder::firewallArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()}).build();
    private static final SdkField<String> ANALYSIS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisType").getter(StartAnalysisReportRequest.getter(StartAnalysisReportRequest::analysisTypeAsString)).setter(StartAnalysisReportRequest.setter(Builder::analysisType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_NAME_FIELD, FIREWALL_ARN_FIELD, ANALYSIS_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartAnalysisReportRequest.memberNameToFieldInitializer();
    private final String firewallName;
    private final String firewallArn;
    private final String analysisType;

    private StartAnalysisReportRequest(BuilderImpl builder) {
        super(builder);
        this.firewallName = builder.firewallName;
        this.firewallArn = builder.firewallArn;
        this.analysisType = builder.analysisType;
    }

    public final String firewallName() {
        return this.firewallName;
    }

    public final String firewallArn() {
        return this.firewallArn;
    }

    public final EnabledAnalysisType analysisType() {
        return EnabledAnalysisType.fromValue(this.analysisType);
    }

    public final String analysisTypeAsString() {
        return this.analysisType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallName());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAnalysisReportRequest)) {
            return false;
        }
        StartAnalysisReportRequest other = (StartAnalysisReportRequest)((Object)obj);
        return Objects.equals(this.firewallName(), other.firewallName()) && Objects.equals(this.firewallArn(), other.firewallArn()) && Objects.equals(this.analysisTypeAsString(), other.analysisTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartAnalysisReportRequest").add("FirewallName", (Object)this.firewallName()).add("FirewallArn", (Object)this.firewallArn()).add("AnalysisType", (Object)this.analysisTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallName": {
                return Optional.ofNullable(clazz.cast(this.firewallName()));
            }
            case "FirewallArn": {
                return Optional.ofNullable(clazz.cast(this.firewallArn()));
            }
            case "AnalysisType": {
                return Optional.ofNullable(clazz.cast(this.analysisTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("FirewallName", FIREWALL_NAME_FIELD);
        map.put("FirewallArn", FIREWALL_ARN_FIELD);
        map.put("AnalysisType", ANALYSIS_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartAnalysisReportRequest, T> g) {
        return obj -> g.apply((StartAnalysisReportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String firewallName;
        private String firewallArn;
        private String analysisType;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAnalysisReportRequest model) {
            super(model);
            this.firewallName(model.firewallName);
            this.firewallArn(model.firewallArn);
            this.analysisType(model.analysisType);
        }

        public final String getFirewallName() {
            return this.firewallName;
        }

        public final void setFirewallName(String firewallName) {
            this.firewallName = firewallName;
        }

        @Override
        public final Builder firewallName(String firewallName) {
            this.firewallName = firewallName;
            return this;
        }

        public final String getFirewallArn() {
            return this.firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final String getAnalysisType() {
            return this.analysisType;
        }

        public final void setAnalysisType(String analysisType) {
            this.analysisType = analysisType;
        }

        @Override
        public final Builder analysisType(String analysisType) {
            this.analysisType = analysisType;
            return this;
        }

        @Override
        public final Builder analysisType(EnabledAnalysisType analysisType) {
            this.analysisType(analysisType == null ? null : analysisType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAnalysisReportRequest build() {
            return new StartAnalysisReportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAnalysisReportRequest> {
        public Builder firewallName(String var1);

        public Builder firewallArn(String var1);

        public Builder analysisType(String var1);

        public Builder analysisType(EnabledAnalysisType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

